/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.mapeditor.map.tool.Automaton;
import org.orbisgis.mapeditor.map.tool.DrawingException;
import org.orbisgis.mapeditor.map.tool.FinishedAutomatonException;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.InsertionTool;
import org.orbisgis.mapeditor.map.tools.ToolUtilities;
import org.orbisgis.mapeditor.map.tools.generated.Polygon;

public abstract class AbstractPolygonTool
extends Polygon
implements InsertionTool {
    private GeometryFactory gf = new GeometryFactory();
    private List<Coordinate> points = new ArrayList<Coordinate>();

    @Override
    public void transitionTo_Standby(MapContext vc, ToolManager tm) throws FinishedAutomatonException, TransitionException {
        this.points.clear();
    }

    @Override
    public void transitionTo_Point(MapContext vc, ToolManager tm) throws FinishedAutomatonException, TransitionException {
        this.points.add(this.newCoordinate(tm.getValues()[0], tm.getValues()[1], vc));
    }

    @Override
    public void transitionTo_Done(MapContext vc, ToolManager tm) throws FinishedAutomatonException, TransitionException {
        this.points = ToolUtilities.removeDuplicated(this.points);
        if (this.points.size() < 3) {
            throw new TransitionException(this.i18n.tr("Polygons must have more than two points"));
        }
        ArrayList<Coordinate> tempPoints = new ArrayList<Coordinate>(this.points);
        double firstX = this.points.get((int)0).x;
        double firstY = this.points.get((int)0).y;
        tempPoints.add(this.newCoordinate(firstX, firstY, vc));
        Coordinate[] polygonCoordinates = tempPoints.toArray(new Coordinate[tempPoints.size()]);
        com.vividsolutions.jts.geom.Polygon pol = this.gf.createPolygon(this.gf.createLinearRing(polygonCoordinates), new LinearRing[0]);
        if (!pol.isValid()) {
            throw new TransitionException(this.i18n.tr("Invalid polygon"));
        }
        this.polygonDone(pol, vc, tm);
        this.transition(Automaton.Code.INIT);
    }

    private Coordinate newCoordinate(double x, double y, MapContext mapContext) {
        return new Coordinate(x, y, this.getInitialZ(mapContext));
    }

    @Override
    public double getInitialZ(MapContext mapContext) {
        return 0.0;
    }

    protected abstract void polygonDone(com.vividsolutions.jts.geom.Polygon var1, MapContext var2, ToolManager var3) throws TransitionException;

    @Override
    public void transitionTo_Cancel(MapContext vc, ToolManager tm) throws FinishedAutomatonException, TransitionException {
    }

    @Override
    public void drawIn_Standby(Graphics g, MapContext vc, ToolManager tm) throws DrawingException {
    }

    @Override
    public void drawIn_Point(Graphics g, MapContext vc, ToolManager tm) throws DrawingException {
        Geometry geom = this.getCurrentPolygon(vc, tm);
        if (geom != null) {
            tm.addGeomToDraw(geom);
            if (!geom.isValid()) {
                throw new DrawingException(this.i18n.tr("Invalid polygon"));
            }
        }
    }

    protected Geometry getCurrentPolygon(MapContext vc, ToolManager tm) {
        com.vividsolutions.jts.geom.Polygon geom;
        if (this.points.size() >= 2) {
            ArrayList<Coordinate> tempPoints = new ArrayList<Coordinate>(this.points);
            Point2D current = tm.getLastRealMousePosition();
            tempPoints.add(this.newCoordinate(current.getX(), current.getY(), vc));
            tempPoints.add(this.newCoordinate(((Coordinate)tempPoints.get((int)0)).x, ((Coordinate)tempPoints.get((int)0)).y, vc));
            geom = this.gf.createPolygon(this.gf.createLinearRing(tempPoints.toArray(new Coordinate[tempPoints.size()])), new LinearRing[0]);
        } else if (this.points.size() >= 1) {
            ArrayList<Coordinate> tempPoints = new ArrayList<Coordinate>(this.points);
            Point2D current = tm.getLastRealMousePosition();
            tempPoints.add(this.newCoordinate(current.getX(), current.getY(), vc));
            tempPoints.add(this.newCoordinate(((Coordinate)tempPoints.get((int)0)).x, ((Coordinate)tempPoints.get((int)0)).y, vc));
            geom = this.gf.createLineString(tempPoints.toArray(new Coordinate[tempPoints.size()]));
        } else {
            geom = null;
        }
        return geom;
    }

    @Override
    public void drawIn_Done(Graphics g, MapContext vc, ToolManager tm) throws DrawingException {
    }

    @Override
    public void drawIn_Cancel(Graphics g, MapContext vc, ToolManager tm) throws DrawingException {
    }
}

