/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.coremap.ui.editors.map.tool.Rectangle2DDouble;
import org.orbisgis.mapeditor.map.tool.Automaton;
import org.orbisgis.mapeditor.map.tool.FinishedAutomatonException;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.generated.ZoomIn;

public abstract class AbstractRectangleTool
extends ZoomIn {
    private static final Color FILL_COLOR = new Color(255, 204, 51, 50);
    private static final Color BORDER_COLOR = new Color(255, 204, 51);
    protected double[] firstPoint;

    @Override
    public void transitionTo_RectangleDone(MapContext vc, ToolManager tm) throws TransitionException, FinishedAutomatonException {
        double[] v = tm.getValues();
        double minx = Math.min(this.firstPoint[0], v[0]);
        double miny = Math.min(this.firstPoint[1], v[1]);
        Rectangle2D rect = new Rectangle2D.Double(minx, miny, Math.abs(v[0] - this.firstPoint[0]), Math.abs(v[1] - this.firstPoint[1]));
        double tolerance = tm.getTolerance();
        double maxx = rect.getMaxX();
        double maxy = rect.getMaxY();
        if (maxx - minx < tolerance && maxy - miny < tolerance) {
            double centerX = rect.getCenterX();
            double centerY = rect.getCenterY();
            rect = this.buildRectangleOnPoint(tm, centerX, centerY);
            this.rectangleDone(rect, true, vc, tm);
        } else {
            this.rectangleDone(rect, false, vc, tm);
        }
        this.transition(Automaton.Code.INIT);
    }

    protected Rectangle2D buildRectangleOnPoint(ToolManager tm, double x, double y) {
        double tolerance = tm.getTolerance();
        double minx = x - tolerance;
        double miny = y - tolerance;
        double maxx = x + tolerance;
        double maxy = y + tolerance;
        return new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny);
    }

    protected abstract void rectangleDone(Rectangle2D var1, boolean var2, MapContext var3, ToolManager var4) throws TransitionException;

    @Override
    public void transitionTo_Standby(MapContext vc, ToolManager tm) throws TransitionException {
    }

    @Override
    public void transitionTo_OnePointLeft(MapContext vc, ToolManager tm) throws TransitionException {
        this.firstPoint = tm.getValues();
    }

    @Override
    public void transitionTo_Cancel(MapContext vc, ToolManager tm) throws TransitionException {
    }

    @Override
    public void drawIn_Standby(Graphics g, MapContext vc, ToolManager tm) {
    }

    @Override
    public void drawIn_OnePointLeft(Graphics g, MapContext vc, ToolManager tm) {
        Point p = tm.getMapTransform().fromMapPoint((Point2D)new Point2D.Double(this.firstPoint[0], this.firstPoint[1]));
        int minx = Math.min(p.x, tm.getLastMouseX());
        int miny = Math.min(p.y, tm.getLastMouseY());
        int width = Math.abs(p.x - tm.getLastMouseX());
        int height = Math.abs(p.y - tm.getLastMouseY());
        Rectangle2DDouble shape = new Rectangle2DDouble((double)minx, (double)miny, (double)width, (double)height);
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(FILL_COLOR);
        g2.fill((Shape)shape);
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        g2.setColor(BORDER_COLOR);
        g2.draw((Shape)shape);
    }

    @Override
    public void drawIn_RectangleDone(Graphics g, MapContext vc, ToolManager tm) {
    }

    @Override
    public void drawIn_Cancel(Graphics g, MapContext vc, ToolManager tm) {
    }

    @Override
    public Point getHotSpotOffset() {
        return new Point(0, 0);
    }
}

