/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingWorker;
import org.h2gis.utilities.SFSUtilities;
import org.h2gis.utilities.TableLocation;
import org.orbisgis.corejdbc.DataManager;
import org.orbisgis.corejdbc.ReadTable;
import org.orbisgis.corejdbc.common.LongUnion;
import org.orbisgis.coremap.layerModel.ILayer;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.coremap.ui.editors.map.tool.Rectangle2DDouble;
import org.orbisgis.mapeditor.map.tool.Automaton;
import org.orbisgis.mapeditor.map.tool.CannotChangeGeometryException;
import org.orbisgis.mapeditor.map.tool.DrawingException;
import org.orbisgis.mapeditor.map.tool.FinishedAutomatonException;
import org.orbisgis.mapeditor.map.tool.Handler;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.ToolUtilities;
import org.orbisgis.mapeditor.map.tools.generated.Selection;

public abstract class AbstractSelectionTool
extends Selection {
    private static final Color FILL_COLOR = new Color(255, 204, 51, 50);
    private static final Color SELECTED_COLOR = new Color(125, 100, 25);
    private Rectangle2DDouble rect = new Rectangle2DDouble();
    protected ArrayList<Handler> selected = new ArrayList();

    @Override
    public void transitionTo_Standby(MapContext vc, ToolManager tm) throws TransitionException {
        if (ToolUtilities.activeSelectionGreaterThan(vc, 0)) {
            this.setStatus(Automaton.Status.SELECTION);
        }
    }

    @Override
    public void transitionTo_OnePoint(MapContext mc, ToolManager tm) throws TransitionException, FinishedAutomatonException {
        this.transition(Automaton.Code.NO_SELECTION);
        this.rect.setRect(tm.getValues()[0], tm.getValues()[1], 0.0, 0.0);
    }

    protected abstract ILayer getLayer(MapContext var1);

    @Override
    public void transitionTo_OnePointLeft(MapContext vc, ToolManager tm) throws TransitionException {
    }

    @Override
    public void transitionTo_TwoPoints(MapContext mc, ToolManager tm) throws TransitionException, FinishedAutomatonException {
        boolean intersects = true;
        if (this.rect.getMinX() < tm.getValues()[0]) {
            intersects = false;
        }
        this.rect.add(tm.getValues()[0], tm.getValues()[1]);
        Geometry selectionRect = this.rect.getEnvelope(ToolManager.toolsGeometryFactory);
        for (ILayer iLayer : this.getAvailableLayers(mc, selectionRect.getEnvelopeInternal())) {
            SelectionWorker selectionWorker = new SelectionWorker(this, selectionRect, mc, tm, (tm.getMouseModifiers() & 0x80) == 128, intersects, iLayer);
            selectionWorker.execute();
        }
    }

    @Override
    public void transitionTo_Selection(MapContext vc, ToolManager tm) throws TransitionException {
        this.rect = new Rectangle2DDouble();
    }

    @Override
    public void transitionTo_PointWithSelection(MapContext mc, ToolManager tm) throws TransitionException, FinishedAutomatonException {
        Point2D.Double p = new Point2D.Double(tm.getValues()[0], tm.getValues()[1]);
        HashSet<Long> geom = new HashSet<Long>();
        ArrayList<Handler> handlers = tm.getCurrentHandlers();
        this.selected.clear();
        for (Handler handler : handlers) {
            if (geom.contains(handler.getGeometryPK()) || !(p.distance(handler.getPoint()) < tm.getTolerance())) continue;
            try {
                if (!ToolUtilities.isActiveLayerEditable(mc)) {
                    throw new TransitionException(this.i18n.tr("Cannot modify the theme"));
                }
            }
            catch (SQLException ex) {
                throw new TransitionException(ex.getLocalizedMessage(), ex);
            }
            this.selected.add(handler);
            geom.add(handler.getGeometryPK());
        }
        if (this.selected.isEmpty()) {
            this.transition(Automaton.Code.OUT_HANDLER);
            this.rect.setRect(tm.getValues()[0], tm.getValues()[1], 0.0, 0.0);
        } else {
            this.transition(Automaton.Code.IN_HANDLER);
        }
    }

    @Override
    public void transitionTo_Movement(MapContext vc, ToolManager tm) throws TransitionException {
    }

    @Override
    public void transitionTo_MakeMove(MapContext mc, ToolManager tm) throws TransitionException, FinishedAutomatonException {
        for (Handler handler : this.selected) {
            try {
                Geometry g = handler.moveTo(tm.getValues()[0], tm.getValues()[1]);
            }
            catch (CannotChangeGeometryException e1) {
                throw new TransitionException(e1);
            }
        }
        this.transition(Automaton.Code.EMPTY);
    }

    @Override
    public void drawIn_Standby(Graphics g, MapContext vc, ToolManager tm) throws DrawingException {
    }

    @Override
    public void drawIn_OnePoint(Graphics g, MapContext vc, ToolManager tm) {
    }

    @Override
    public void drawIn_OnePointLeft(Graphics g, MapContext vc, ToolManager tm) {
        Point p = tm.getMapTransform().fromMapPoint((Point2D)new Point2D.Double(this.rect.getX(), this.rect.getY()));
        int minx = Math.min(p.x, tm.getLastMouseX());
        int miny = Math.min(p.y, tm.getLastMouseY());
        int width = Math.abs(p.x - tm.getLastMouseX());
        int height = Math.abs(p.y - tm.getLastMouseY());
        Color fillColor = FILL_COLOR;
        if (tm.getLastMouseX() < p.x) {
            ((Graphics2D)g).setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{10.0f, 3.0f}, 0.0f));
        } else {
            ((Graphics2D)g).setStroke(new BasicStroke());
        }
        Rectangle2DDouble shape = new Rectangle2DDouble((double)minx, (double)miny, (double)width, (double)height);
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(fillColor);
        g2.fill((Shape)shape);
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        g2.setColor(SELECTED_COLOR);
        g2.draw((Shape)shape);
    }

    @Override
    public void drawIn_TwoPoints(Graphics g, MapContext vc, ToolManager tm) {
    }

    @Override
    public void drawIn_Selection(Graphics g, MapContext vc, ToolManager tm) {
    }

    @Override
    public void drawIn_PointWithSelection(Graphics g, MapContext vc, ToolManager tm) {
    }

    @Override
    public void drawIn_Movement(Graphics g, MapContext vc, ToolManager tm) throws DrawingException {
        Point2D p = tm.getLastRealMousePosition();
        try {
            for (Handler handler : this.selected) {
                Geometry geom = handler.moveTo(p.getX(), p.getY());
                tm.addGeomToDraw(geom);
            }
        }
        catch (CannotChangeGeometryException e) {
            throw new DrawingException(this.i18n.tr("Cannot move {0}", (Object)e.getMessage()));
        }
    }

    @Override
    public void drawIn_MakeMove(Graphics g, MapContext vc, ToolManager tm) {
    }

    public ILayer[] getAvailableLayers(MapContext mapContext, Envelope envelope) {
        HashSet<ILayer> availableLayers = new HashSet<ILayer>();
        if (mapContext != null) {
            for (ILayer iLayer : mapContext.getSelectedLayers()) {
                if (!iLayer.isVisible() || iLayer.getTableReference().isEmpty() || !iLayer.getEnvelope().intersects(envelope)) continue;
                availableLayers.add(iLayer);
            }
            for (ILayer iLayer : mapContext.getSelectedStyles()) {
                ILayer layer = iLayer.getLayer();
                if (!layer.isVisible() || layer.getTableReference().isEmpty()) continue;
                availableLayers.add(layer);
            }
        }
        return availableLayers.toArray(new ILayer[availableLayers.size()]);
    }

    private static class SelectionWorker
    extends SwingWorker<Set<Long>, Set<Long>> {
        AbstractSelectionTool automaton;
        Geometry selectionRect;
        MapContext mc;
        ToolManager tm;
        boolean controlDown;
        boolean intersects;
        ILayer activeLayer;

        private SelectionWorker(AbstractSelectionTool automaton, Geometry selectionRect, MapContext mc, ToolManager tm, boolean controlDown, boolean intersects, ILayer activeLayer) {
            this.automaton = automaton;
            this.selectionRect = selectionRect;
            this.mc = mc;
            this.tm = tm;
            this.controlDown = controlDown;
            this.intersects = intersects;
            this.activeLayer = activeLayer;
        }

        @Override
        protected Set<Long> doInBackground() throws Exception {
            Set newSelection;
            try (Connection connection = SFSUtilities.wrapConnection((Connection)this.activeLayer.getDataManager().getDataSource().getConnection());){
                String geomFieldName = (String)SFSUtilities.getGeometryFields((Connection)connection, (TableLocation)TableLocation.parse((String)this.activeLayer.getTableReference())).get(0);
                newSelection = ReadTable.getTablePkByEnvelope((DataManager)this.mc.getDataManager(), (String)this.activeLayer.getTableReference(), (String)geomFieldName, (Geometry)this.selectionRect, (!this.intersects ? 1 : 0) != 0);
            }
            catch (SQLException e) {
                this.automaton.transition(Automaton.Code.NO_SELECTION);
                throw new TransitionException(e);
            }
            return newSelection;
        }

        @Override
        protected void done() {
            try {
                if (this.controlDown) {
                    LongUnion newSel = new LongUnion((Collection)this.activeLayer.getSelection());
                    Iterator i$ = ((Set)this.get()).iterator();
                    while (i$.hasNext()) {
                        long el = (Long)i$.next();
                        if (newSel.remove((Object)el)) continue;
                        newSel.add(Long.valueOf(el));
                    }
                    this.activeLayer.setSelection((Set)newSel);
                } else {
                    this.activeLayer.setSelection((Set)this.get());
                }
                if (this.activeLayer.getSelection().isEmpty()) {
                    this.automaton.transition(Automaton.Code.NO_SELECTION);
                } else {
                    this.automaton.transition(Automaton.Code.SELECTION);
                }
            }
            catch (Exception ex) {
                try {
                    this.automaton.transition(Automaton.Code.NO_SELECTION);
                }
                catch (FinishedAutomatonException | TransitionException exception) {
                    // empty catch block
                }
                this.automaton.logger.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
    }
}

