/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.Observable;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.tool.Automaton;
import org.orbisgis.mapeditor.map.tool.DrawingException;
import org.orbisgis.mapeditor.map.tool.FinishedAutomatonException;
import org.orbisgis.mapeditor.map.tool.NoSuchTransitionException;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.ToolUtilities;
import org.orbisgis.mapeditor.map.tools.generated.AbstractAutomaton;

public class CompassTool
extends AbstractAutomaton {
    private static Logger GUILOGGER = Logger.getLogger((String)("gui." + CompassTool.class));
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###.###");
    private static final double DRAW_RADIUS_PERCENT_SIZE = 0.3;
    private static final double DRAW_CIRCLE_SUBDIVISION_ANGLE = 10.0;
    private Coordinate c1;
    private Coordinate c2;
    private Coordinate c3;
    private GeometryFactory gf = new GeometryFactory();

    private void showAngle() {
        GUILOGGER.info((Object)this.i18n.tr("Angle : {0}", (Object)this.getFormatedAngle(this.c1, this.c2, this.c3)));
    }

    private double getAngle(Coordinate c1, Coordinate c2, Coordinate c3) {
        double angle1 = this.getAngleWithXAxis(c2, c1);
        double angle2 = this.getAngleWithXAxis(c2, c3);
        if (angle2 < angle1) {
            angle2 += Math.PI * 2;
        }
        return angle2 - angle1;
    }

    private String getFormatedAngle(Coordinate c1, Coordinate c2, Coordinate c3) {
        return DECIMAL_FORMAT.format(Angle.toDegrees((double)this.getAngle(c1, c2, c3))) + "\u00ba";
    }

    @Override
    public void transition(Automaton.Code code) throws NoSuchTransitionException, TransitionException, FinishedAutomatonException {
        if (Automaton.Code.ESC == code) {
            this.status = Automaton.Status.CANCEL;
            if (this.isFinished(this.status)) {
                throw new FinishedAutomatonException();
            }
        }
        switch (this.status) {
            case STANDBY: {
                if (Automaton.Code.PRESS != code) break;
                Automaton.Status preStatus = this.status;
                try {
                    this.status = Automaton.Status.ONE_POINT;
                    this.transitionTo_OnePoint(this.tm);
                    if (this.isFinished(this.status)) {
                        throw new FinishedAutomatonException();
                    }
                    break;
                }
                catch (TransitionException e) {
                    this.status = preStatus;
                    throw e;
                }
            }
            case ONE_POINT: {
                if (Automaton.Code.PRESS != code) break;
                Automaton.Status preStatus = this.status;
                try {
                    this.status = Automaton.Status.TWO_POINTS;
                    this.transitionTo_TwoPoints(this.tm);
                    if (this.isFinished(this.status)) {
                        throw new FinishedAutomatonException();
                    }
                    break;
                }
                catch (TransitionException e) {
                    this.status = preStatus;
                    throw e;
                }
            }
            case TWO_POINTS: {
                if (Automaton.Code.PRESS != code) break;
                Automaton.Status preStatus = this.status;
                try {
                    this.status = Automaton.Status.THREE_POINTS;
                    this.transitionTo_ThreePoints(this.tm);
                    if (this.isFinished(this.status)) {
                        throw new FinishedAutomatonException();
                    }
                    break;
                }
                catch (TransitionException e) {
                    this.status = preStatus;
                    throw e;
                }
            }
            case THREE_POINTS: {
                if (Automaton.Code.PRESS == code) {
                    Automaton.Status preStatus = this.status;
                    try {
                        this.status = Automaton.Status.THREE_POINTS;
                        this.transitionTo_ThreePoints(this.tm);
                        if (this.isFinished(this.status)) {
                            throw new FinishedAutomatonException();
                        }
                    }
                    catch (TransitionException e) {
                        this.status = preStatus;
                        throw e;
                    }
                }
            }
            default: {
                throw new NoSuchTransitionException(code.toString());
            }
        }
    }

    private double getAngleWithXAxis(Coordinate origin, Coordinate destination) {
        LineSegment s1 = new LineSegment(origin, destination);
        double angle = s1.angle();
        if (angle < 0.0) {
            angle = Math.PI * 2 + angle;
        }
        return angle;
    }

    @Override
    public boolean isEnabled(MapContext vc, ToolManager tm) {
        return ToolUtilities.layerCountGreaterThan(vc, 0);
    }

    @Override
    public boolean isVisible(MapContext vc, ToolManager tm) {
        return true;
    }

    private void drawIn_OnePoint(ToolManager tm) throws DrawingException {
        tm.addGeomToDraw((Geometry)this.gf.createLineString(new Coordinate[]{this.c1, this.getCurrentCoordinateInDraw(tm)}));
    }

    private Coordinate getCurrentCoordinateInDraw(ToolManager tm) {
        return new Coordinate(tm.getLastRealMousePosition().getX(), tm.getLastRealMousePosition().getY());
    }

    private void drawIn_ThreePoints(ToolManager tm) throws DrawingException {
        Coordinate currentCoord = this.getCurrentCoordinateInDraw(tm);
        tm.addGeomToDraw((Geometry)this.gf.createLineString(new Coordinate[]{this.c2, this.c3, currentCoord}));
        tm.addTextToDraw(this.getFormatedAngle(this.c2, this.c3, currentCoord) + "");
        this.drawSemiCircle(tm, this.c2, this.c3, currentCoord);
    }

    private void drawIn_TwoPoints(ToolManager tm) throws DrawingException {
        Coordinate currentCoord = this.getCurrentCoordinateInDraw(tm);
        tm.addGeomToDraw((Geometry)this.gf.createLineString(new Coordinate[]{this.c1, this.c2, currentCoord}));
        tm.addTextToDraw(this.getFormatedAngle(this.c1, this.c2, currentCoord) + "");
        this.drawSemiCircle(tm, this.c1, this.c2, currentCoord);
    }

    private void drawSemiCircle(ToolManager tm, Coordinate c1, Coordinate c2, Coordinate c3) {
        double radius = c2.distance(c1) * 0.3;
        LinkedList<Coordinate> coordinates = new LinkedList<Coordinate>();
        double angle1 = this.getAngleWithXAxis(c2, c1);
        double angle2 = this.getAngleWithXAxis(c2, c3);
        if (angle2 < angle1) {
            angle2 += Math.PI * 2;
        }
        for (double i = angle1; i < angle2; i += 10.0) {
            double x = c2.x + Math.cos(i) * radius;
            double y = c2.y + Math.sin(i) * radius;
            coordinates.add(new Coordinate(x, y));
        }
        double x = c2.x + Math.cos(angle2) * radius;
        double y = c2.y + Math.sin(angle2) * radius;
        coordinates.add(new Coordinate(x, y));
        if (coordinates.size() > 1) {
            LineString semiCircle = this.gf.createLineString(coordinates.toArray(new Coordinate[coordinates.size()]));
            tm.addGeomToDraw((Geometry)semiCircle);
        }
    }

    private void transitionTo_OnePoint(ToolManager tm) throws FinishedAutomatonException, TransitionException {
        this.c1 = new Coordinate(tm.getValues()[0], tm.getValues()[1]);
    }

    @Override
    protected void transitionTo_Standby(MapContext mc, ToolManager tm) throws FinishedAutomatonException, TransitionException {
    }

    private void transitionTo_ThreePoints(ToolManager tm) throws FinishedAutomatonException, TransitionException {
        Coordinate newCoord = new Coordinate(tm.getValues()[0], tm.getValues()[1]);
        if (this.c3 == null) {
            this.c3 = newCoord;
        } else {
            this.c1 = this.c2;
            this.c2 = this.c3;
            this.c3 = newCoord;
        }
        this.showAngle();
    }

    private void transitionTo_TwoPoints(ToolManager tm) throws FinishedAutomatonException, TransitionException {
        this.c2 = new Coordinate(tm.getValues()[0], tm.getValues()[1]);
    }

    @Override
    public ImageIcon getImageIcon() {
        return MapEditorIcons.getIcon("mesureangle");
    }

    @Override
    public String getName() {
        return this.i18n.tr("Mesure angle");
    }

    @Override
    public String getTooltip() {
        return this.i18n.tr("This tool mesure the angle");
    }

    @Override
    public void update(Observable o, Object o1) {
    }

    @Override
    public String[] getTransitionLabels() {
        return new String[]{this.i18n.tr("Cancel")};
    }

    @Override
    public Automaton.Code[] getTransitionCodes() {
        return new Automaton.Code[]{Automaton.Code.ESC};
    }

    @Override
    public boolean isFinished(Automaton.Status status) {
        switch (status) {
            case STANDBY: 
            case ONE_POINT: 
            case TWO_POINTS: 
            case THREE_POINTS: {
                return false;
            }
            case CANCEL: {
                return true;
            }
        }
        throw new RuntimeException("Invalid status: " + (Object)((Object)status));
    }

    @Override
    public void draw(Graphics g) throws DrawingException {
        switch (this.status) {
            case ONE_POINT: {
                this.drawIn_OnePoint(this.tm);
                break;
            }
            case TWO_POINTS: {
                this.drawIn_TwoPoints(this.tm);
                break;
            }
            case THREE_POINTS: {
                this.drawIn_ThreePoints(this.tm);
            }
        }
    }

    @Override
    public String getMessage() {
        switch (this.status) {
            case STANDBY: 
            case ONE_POINT: 
            case TWO_POINTS: 
            case THREE_POINTS: 
            case CANCEL: {
                return "";
            }
        }
        throw new RuntimeException();
    }

    @Override
    public void toolFinished(MapContext mc, ToolManager tm) throws NoSuchTransitionException, TransitionException, FinishedAutomatonException {
    }
}

