/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.util.Observable;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.h2gis.utilities.TableLocation;
import org.orbisgis.coremap.layerModel.ILayer;
import org.orbisgis.coremap.layerModel.LayerException;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.coremap.renderer.se.CompositeSymbolizer;
import org.orbisgis.coremap.renderer.se.LineSymbolizer;
import org.orbisgis.coremap.renderer.se.Rule;
import org.orbisgis.coremap.renderer.se.Style;
import org.orbisgis.coremap.renderer.se.Symbolizer;
import org.orbisgis.coremap.renderer.se.fill.SolidFill;
import org.orbisgis.coremap.renderer.se.parameter.color.ColorLiteral;
import org.orbisgis.coremap.renderer.se.parameter.color.ColorParameter;
import org.orbisgis.coremap.renderer.se.parameter.real.RealLiteral;
import org.orbisgis.coremap.renderer.se.parameter.real.RealParameter;
import org.orbisgis.coremap.renderer.se.stroke.PenStroke;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.AbstractPolygonTool;

public class FencePolygonTool
extends AbstractPolygonTool {
    private static Logger UILOGGER = Logger.getLogger((String)("gui." + FencePolygonTool.class));
    private ILayer layer;
    private static final String FENCE_LAYER_NAME = "fence";

    @Override
    public void update(Observable o, Object arg) {
    }

    @Override
    protected void polygonDone(Polygon g, MapContext vc, ToolManager tm) throws TransitionException {
        try {
            if (null != this.layer) {
                vc.getLayerModel().remove(this.layer);
            }
            this.layer = this.createFenceLayer((Geometry)g);
            Style fenceStyle = new Style(this.layer, false);
            CompositeSymbolizer symbolizer = new CompositeSymbolizer();
            LineSymbolizer symb = new LineSymbolizer();
            PenStroke ps = (PenStroke)symb.getStroke();
            ((SolidFill)ps.getFill()).setColor((ColorParameter)new ColorLiteral(Color.ORANGE));
            ps.setWidth((RealParameter)new RealLiteral(1.0));
            symbolizer.addSymbolizer((Symbolizer)symb);
            Rule r = new Rule();
            r.setCompositeSymbolizer(symbolizer);
            fenceStyle.addRule(r);
            this.layer.addStyle(fenceStyle);
            vc.getLayerModel().insertLayer(this.layer, 0);
        }
        catch (LayerException e) {
            UILOGGER.error((Object)this.i18n.tr("Cannot use fence tool"), (Throwable)e);
        }
    }

    @Override
    public boolean isEnabled(MapContext vc, ToolManager tm) {
        return vc.getLayerModel().getLayerCount() > 0;
    }

    @Override
    public boolean isVisible(MapContext vc, ToolManager tm) {
        return true;
    }

    private String getFenceLayerName(boolean isH2) {
        return TableLocation.parse((String)FENCE_LAYER_NAME, (Boolean)isH2).toString(isH2);
    }

    /*
     * Exception decompiling
     */
    private ILayer createFenceLayer(Geometry g) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getName() {
        return this.i18n.tr("Draw a fence");
    }

    @Override
    public String getTooltip() {
        return this.i18n.tr("Draw a fence");
    }

    @Override
    public ImageIcon getImageIcon() {
        return MapEditorIcons.getIcon("shape_polygon_edit");
    }
}

