/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Observable;
import javax.sql.DataSource;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.h2gis.utilities.SFSUtilities;
import org.h2gis.utilities.TableLocation;
import org.orbisgis.core.Services;
import org.orbisgis.corejdbc.ReadTable;
import org.orbisgis.coremap.layerModel.ILayer;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.AbstractRectangleTool;
import org.orbisgis.progress.ProgressMonitor;
import org.orbisgis.view.background.BackgroundJob;
import org.orbisgis.view.background.BackgroundManager;
import org.orbisgis.view.background.DefaultJobId;
import org.orbisgis.view.background.JobId;

public class InfoTool
extends AbstractRectangleTool {
    private static Logger UILOGGER = Logger.getLogger((String)("gui." + InfoTool.class));
    private static Logger POPUPLOGGER = Logger.getLogger((String)("popup." + InfoTool.class));
    private static final int MAX_PRINTED_ROWS = 100;
    private static final int MAX_FIELD_LENGTH = 512;
    private static final int POPUP_MAX_LENGTH = 200;

    @Override
    public void update(Observable o, Object arg) {
    }

    @Override
    protected void rectangleDone(Rectangle2D rect, boolean smallerThanTolerance, MapContext vc, ToolManager tm) throws TransitionException {
        ILayer layer = vc.getSelectedLayers()[0];
        double minx = rect.getMinX();
        double miny = rect.getMinY();
        double maxx = rect.getMaxX();
        double maxy = rect.getMaxY();
        BackgroundManager bm = (BackgroundManager)Services.getService(BackgroundManager.class);
        bm.backgroundOperation((JobId)new DefaultJobId("org.orbisgis.jobs.InfoTool"), (BackgroundJob)new PopulateViewJob(new Envelope(minx, maxx, miny, maxy), vc.getDataManager().getDataSource(), layer));
    }

    @Override
    public boolean isEnabled(MapContext vc, ToolManager tm) {
        if (vc.getSelectedLayers().length == 1 && !vc.getSelectedLayers()[0].getTableReference().isEmpty()) {
            return vc.getSelectedLayers()[0].isVisible();
        }
        return false;
    }

    @Override
    public boolean isVisible(MapContext vc, ToolManager tm) {
        return true;
    }

    @Override
    public String getTooltip() {
        return this.i18n.tr("Get feature attributes");
    }

    @Override
    public String getName() {
        return this.i18n.tr("Get feature attributes");
    }

    @Override
    public ImageIcon getImageIcon() {
        return MapEditorIcons.getIcon("information");
    }

    private static class EnvelopeFilter
    implements ReadTable.ResultSetFilter {
        private Geometry envelope;
        private String geomFieldName = "";

        private EnvelopeFilter(Envelope envelope) {
            GeometryFactory factory = new GeometryFactory();
            this.envelope = factory.toGeometry(envelope);
        }

        public boolean printRow(ResultSet rs) throws SQLException {
            Object geomObj;
            List geomFields;
            if (this.geomFieldName.isEmpty() && !(geomFields = SFSUtilities.getGeometryFields((ResultSet)rs)).isEmpty()) {
                this.geomFieldName = (String)geomFields.get(0);
            }
            return (geomObj = rs.getObject(this.geomFieldName)) instanceof Geometry && ((Geometry)geomObj).intersects(this.envelope);
        }
    }

    private static class PopulateViewJob
    implements BackgroundJob {
        private final Envelope envelope;
        private final DataSource sds;
        private final ILayer layer;

        private PopulateViewJob(Envelope envelope, DataSource sds, ILayer layer) {
            this.envelope = envelope;
            this.sds = sds;
            this.layer = layer;
        }

        public String getTaskName() {
            return "Getting info";
        }

        public void run(ProgressMonitor pm) {
            GeometryFactory geometryFactory = new GeometryFactory();
            Geometry envGeom = geometryFactory.toGeometry(this.envelope);
            TableLocation tableLocation = TableLocation.parse((String)this.layer.getTableReference());
            try (Connection connection = this.layer.getDataManager().getDataSource().getConnection();){
                try (PreparedStatement pst = SFSUtilities.prepareInformationSchemaStatement((Connection)connection, (String)tableLocation.getCatalog(), (String)tableLocation.getSchema(), (String)tableLocation.getTable(), (String)"PUBLIC.GEOMETRY_COLUMNS", (String)"");
                     ResultSet rs = pst.executeQuery();){
                    int srid;
                    if (rs.next() && (srid = rs.getInt("srid")) > 0) {
                        envGeom.setSRID(srid);
                    }
                }
                List geomFields = SFSUtilities.getGeometryFields((Connection)connection, (TableLocation)tableLocation);
                if (geomFields.isEmpty()) {
                    return;
                }
                try (PreparedStatement pst = connection.prepareStatement("SELECT * FROM " + this.layer.getTableReference() + " WHERE " + TableLocation.quoteIdentifier((String)((String)geomFields.get(0))) + " && ?");){
                    pst.setObject(1, envGeom);
                    try (ResultSet rs = pst.executeQuery();){
                        String lines = ReadTable.resultSetToString((ResultSet)rs, (int)512, (int)100, (boolean)false, (boolean)false, (ReadTable.ResultSetFilter)new EnvelopeFilter(this.envelope));
                        UILOGGER.info((Object)lines);
                        if (lines.length() <= 200) {
                            POPUPLOGGER.info((Object)lines);
                        }
                    }
                }
            }
            catch (SQLException ex) {
                UILOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
    }
}

