/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.util.Observable;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.tool.DrawingException;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.AbstractLineTool;

public class MesureLineTool
extends AbstractLineTool {
    protected static Logger GUI_LOGGER = Logger.getLogger((String)("gui." + MesureLineTool.class));

    @Override
    public void update(Observable o, Object arg) {
    }

    @Override
    public boolean isEnabled(MapContext vc, ToolManager tm) {
        return vc.getLayerModel().getLayerCount() > 0;
    }

    @Override
    public boolean isVisible(MapContext vc, ToolManager tm) {
        return true;
    }

    @Override
    protected void lineDone(LineString ls, MapContext vc, ToolManager tm) throws TransitionException {
        GUI_LOGGER.info((Object)this.i18n.tr("Distance : {0}", (Object)this.getLength((Geometry)ls)));
    }

    private String getLength(Geometry ls) {
        return new DecimalFormat("0.000").format(ls.getLength());
    }

    @Override
    public void drawIn_Point(Graphics g, MapContext vc, ToolManager tm) throws DrawingException {
        super.drawIn_Point(g, vc, tm);
        LineString geom = this.getCurrentLineString(vc, tm);
        tm.addTextToDraw(this.getLength((Geometry)geom) + "");
    }

    @Override
    public ImageIcon getImageIcon() {
        return MapEditorIcons.getIcon("mesurelength");
    }

    @Override
    public String getTooltip() {
        return this.i18n.tr("This tool mesure the length on the map");
    }

    @Override
    public String getName() {
        return this.i18n.tr("Mesure length");
    }
}

