/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.util.Observable;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.tool.DrawingException;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.AbstractPolygonTool;

public class MesurePolygonTool
extends AbstractPolygonTool {
    protected static Logger GUI_LOGGER = Logger.getLogger((String)("gui." + MesurePolygonTool.class));

    @Override
    public void update(Observable o, Object arg) {
    }

    @Override
    protected void polygonDone(Polygon g, MapContext vc, ToolManager tm) throws TransitionException {
        GUI_LOGGER.info((Object)this.i18n.tr("Area : {0} Perimeter : {1}", (Object)this.getArea((Geometry)g), (Object)this.getPerimeter((Geometry)g)));
    }

    private String getPerimeter(Geometry g) {
        return new DecimalFormat("0.000").format(g.getLength());
    }

    private String getArea(Geometry g) {
        return new DecimalFormat("0.000").format(g.getArea());
    }

    @Override
    public boolean isEnabled(MapContext vc, ToolManager tm) {
        return vc.getLayerModel().getLayerCount() > 0;
    }

    @Override
    public boolean isVisible(MapContext vc, ToolManager tm) {
        return true;
    }

    @Override
    public void drawIn_Point(Graphics g, MapContext vc, ToolManager tm) throws DrawingException {
        super.drawIn_Point(g, vc, tm);
        Geometry geom = this.getCurrentPolygon(vc, tm);
        tm.addTextToDraw("Area: " + this.getArea(geom));
        tm.addTextToDraw("Perimeter: " + this.getPerimeter(geom));
    }

    @Override
    public ImageIcon getImageIcon() {
        return MapEditorIcons.getIcon("mesurearea");
    }

    @Override
    public String getName() {
        return this.i18n.tr("Mesure area");
    }

    @Override
    public String getTooltip() {
        return this.i18n.tr("This tool mesure the area");
    }
}

