/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.tool.Automaton;
import org.orbisgis.mapeditor.map.tool.FinishedAutomatonException;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.AbstractDragTool;
import org.orbisgis.mapeditor.map.tools.ToolUtilities;

public class PanTool
extends AbstractDragTool {
    @Override
    public ImageIcon getImageIcon() {
        return MapEditorIcons.getIcon("pan");
    }

    @Override
    public void transitionTo_MouseReleased(MapContext vc, ToolManager tm) throws TransitionException, FinishedAutomatonException {
        double[] v = tm.getValues();
        double[] firstPoint = this.getFirstPoint();
        double dx = firstPoint[0] - v[0];
        double dy = firstPoint[1] - v[1];
        Envelope extent = tm.getMapTransform().getExtent();
        if (extent != null) {
            tm.getMapTransform().setExtent(new Envelope(extent.getMinX() + dx, extent.getMaxX() + dx, extent.getMinY() + dy, extent.getMaxY() + dy));
        }
        this.transition(Automaton.Code.FINISHED);
    }

    @Override
    public void drawIn_MouseDown(Graphics g, MapContext vc, ToolManager tm) {
        double[] firstPoint = this.getFirstPoint();
        Point p = tm.getMapTransform().fromMapPoint((Point2D)new Point2D.Double(firstPoint[0], firstPoint[1]));
        int height = tm.getMapTransform().getHeight();
        int width = tm.getMapTransform().getWidth();
        g.clearRect(0, 0, width, height);
        g.drawImage(tm.getMapTransform().getImage(), tm.getLastMouseX() - p.x, tm.getLastMouseY() - p.y, null);
    }

    @Override
    public boolean isEnabled(MapContext vc, ToolManager tm) {
        return ToolUtilities.layerCountGreaterThan(vc, 0);
    }

    @Override
    public String getName() {
        return this.i18n.tr("Pan");
    }

    @Override
    public String getTooltip() {
        return this.i18n.tr("The Pan Tool");
    }

    @Override
    public ImageIcon getCursor() {
        return MapEditorIcons.getIcon("pan");
    }
}

