/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools;

import com.vividsolutions.jts.geom.Point;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Observable;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.AbstractPointTool;

public class PickCoordinatesPointTool
extends AbstractPointTool {
    protected static Logger GUI_LOGGER = Logger.getLogger((String)("gui." + PickCoordinatesPointTool.class));

    @Override
    protected void pointDone(Point point, MapContext mc, ToolManager tm) throws TransitionException {
        Graphics g = tm.getComponent().getGraphics();
        if (g != null && g instanceof Graphics2D) {
            GUI_LOGGER.info((Object)this.i18n.tr("Coordinate : {0}", (Object)point.toText()));
        }
    }

    @Override
    public String getName() {
        return this.i18n.tr("Pick a point");
    }

    @Override
    public String getTooltip() {
        return this.i18n.tr("Pick a point");
    }

    @Override
    public ImageIcon getImageIcon() {
        return MapEditorIcons.getIcon("coordinate_capture");
    }

    @Override
    public boolean isEnabled(MapContext vc, ToolManager tm) {
        return vc.getLayerModel().getLayerCount() > 0;
    }

    @Override
    public boolean isVisible(MapContext vc, ToolManager tm) {
        return this.isEnabled(vc, tm);
    }

    @Override
    public void update(Observable o, Object o1) {
    }
}

