/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools;

import com.vividsolutions.jts.geom.Coordinate;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.SFSUtilities;
import org.h2gis.utilities.TableLocation;
import org.orbisgis.coremap.layerModel.ILayer;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.mapeditor.map.tool.Automaton;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.PanTool;
import org.orbisgis.mapeditor.map.tools.ZoomInTool;
import org.orbisgis.mapeditor.map.tools.ZoomOutTool;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.sif.UIPanel;
import org.orbisgis.view.components.sif.AskValidValue;

public class ToolUtilities {
    private static final Logger LOGGER = Logger.getLogger(ToolUtilities.class);

    /*
     * Exception decompiling
     */
    public static double getActiveLayerInitialZ(Connection connection, MapContext mapContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 19[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object[] populateNotNullFields(DataSource sds, String tableReference, Object[] row) throws SQLException, TransitionException {
        Object[] ret = new Object[row.length];
        TableLocation table = TableLocation.parse((String)tableReference);
        try (Connection connection = sds.getConnection();
             ResultSet rs = connection.getMetaData().getColumns(table.getCatalog(), table.getSchema(), table.getTable(), null);){
            while (rs.next()) {
                boolean refuseNull = "NO".equals(rs.getString("IS_NULLABLE"));
                boolean isAutoIncrement = "YES".equals(rs.getString("IS_AUTOINCREMENT"));
                int columnId = rs.getInt("ORDINAL_POSITION") - 1;
                if (refuseNull && !isAutoIncrement) {
                    AskValidValue av = new AskValidValue(sds, tableReference, rs.getString("COLUMN_NAME"));
                    if (!UIFactory.showDialog((UIPanel)av)) throw new TransitionException("Insertion cancelled");
                    try {
                        ret[columnId] = av.getUserValue();
                        continue;
                    }
                    catch (ParseException e) {
                        throw new TransitionException("Cannot parse user value");
                    }
                }
                ret[columnId] = row[columnId];
            }
            return ret;
        }
    }

    public static List<Coordinate> removeDuplicated(List<Coordinate> points) {
        if (points.isEmpty()) {
            return points;
        }
        ArrayList<Coordinate> ret = new ArrayList<Coordinate>();
        for (int i = 0; i < points.size() - 1; ++i) {
            if (points.get(i).equals((Object)points.get(i + 1))) continue;
            ret.add(points.get(i));
        }
        ret.add(points.get(points.size() - 1));
        return ret;
    }

    public static boolean isActiveLayerEditable(MapContext vc) throws SQLException {
        ILayer activeLayer = vc.getActiveLayer();
        if (activeLayer == null) {
            return false;
        }
        String table = activeLayer.getTableReference();
        if (table != null && !table.isEmpty()) {
            try (Connection connection = vc.getDataManager().getDataSource().getConnection();){
                int pk = JDBCUtilities.getIntegerPrimaryKey((Connection)connection, (String)activeLayer.getTableReference());
                boolean bl = pk > 0;
                return bl;
            }
        }
        return false;
    }

    public static boolean isActiveLayerVisible(MapContext vc) {
        ILayer activeLayer = vc.getActiveLayer();
        return activeLayer != null && activeLayer.isVisible();
    }

    public static boolean isSelectionGreaterOrEqualsThan(MapContext vc, int i) {
        ILayer activeLayer = vc.getActiveLayer();
        return activeLayer != null && activeLayer.getSelection().size() >= i;
    }

    public static boolean isSelectionEqualsTo(MapContext vc, int i) {
        ILayer activeLayer = vc.getActiveLayer();
        return activeLayer != null && activeLayer.getSelection().size() == i;
    }

    public static boolean activeSelectionGreaterThan(MapContext vc, int i) {
        ILayer activeLayer = vc.getActiveLayer();
        return activeLayer != null && activeLayer.getSelection().size() >= i;
    }

    public static boolean geometryTypeIs(Connection connection, MapContext vc, int ... geometryTypes) {
        ILayer activeLayer = vc.getActiveLayer();
        if (activeLayer != null && geometryTypes.length > 0) {
            try {
                String table = activeLayer.getTableReference();
                if (!table.isEmpty()) {
                    TableLocation tableLocation = TableLocation.parse((String)activeLayer.getTableReference());
                    int tableGeoType = SFSUtilities.getGeometryType((Connection)connection, (TableLocation)tableLocation, (String)"");
                    return tableGeoType == geometryTypes[0] || tableGeoType == 0;
                }
            }
            catch (SQLException ex) {
                LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return false;
    }

    public static boolean layerCountGreaterThan(MapContext vc, int i) {
        return vc != null && vc.getLayerModel() != null && vc.getLayerModel().getLayersRecursively().length > i;
    }

    public static boolean isRestrictedPopup(Automaton currentTool) {
        if (currentTool instanceof ZoomInTool) {
            return true;
        }
        if (currentTool instanceof ZoomOutTool) {
            return true;
        }
        return currentTool instanceof PanTool;
    }
}

