/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import javax.swing.ImageIcon;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.AbstractRectangleTool;
import org.orbisgis.mapeditor.map.tools.ToolUtilities;

public class ZoomInTool
extends AbstractRectangleTool {
    @Override
    public void update(Observable o, Object arg) {
    }

    @Override
    protected void rectangleDone(Rectangle2D rect, boolean smallerThanTolerance, MapContext vc, ToolManager tm) throws TransitionException {
        tm.getMapTransform().setExtent(new Envelope(rect.getMinX(), rect.getMaxX(), rect.getMinY(), rect.getMaxY()));
    }

    @Override
    protected Rectangle2D buildRectangleOnPoint(ToolManager toolManager, double x, double y) {
        Envelope extent = toolManager.getMapTransform().getExtent();
        double width = extent.getWidth() / 2.0;
        double height = extent.getHeight() / 2.0;
        double minx = x - width / 2.0;
        double miny = y - height / 2.0;
        return new Rectangle2D.Double(minx, miny, width, height);
    }

    @Override
    public Point getHotSpotOffset() {
        return new Point(5, 5);
    }

    @Override
    public boolean isEnabled(MapContext vc, ToolManager tm) {
        return ToolUtilities.layerCountGreaterThan(vc, 0);
    }

    @Override
    public boolean isVisible(MapContext vc, ToolManager tm) {
        return true;
    }

    @Override
    public ImageIcon getImageIcon() {
        return MapEditorIcons.getIcon("zoom_in");
    }

    @Override
    public ImageIcon getCursor() {
        return MapEditorIcons.getIcon("zoom_in");
    }

    @Override
    public String getName() {
        return this.i18n.tr("Zoom in");
    }

    @Override
    public String getTooltip() {
        return this.i18n.tr("Click on the map to zoom in");
    }
}

