/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Graphics;
import java.util.Observable;
import javax.swing.ImageIcon;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.coremap.map.MapTransform;
import org.orbisgis.mapeditor.map.icons.MapEditorIcons;
import org.orbisgis.mapeditor.map.tool.Automaton;
import org.orbisgis.mapeditor.map.tool.FinishedAutomatonException;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.ToolUtilities;
import org.orbisgis.mapeditor.map.tools.generated.ZoomOut;

public class ZoomOutTool
extends ZoomOut {
    @Override
    public void update(Observable o, Object arg) {
    }

    @Override
    public void transitionTo_Standby(MapContext vc, ToolManager tm) throws TransitionException {
    }

    @Override
    public void transitionTo_Done(MapContext vc, ToolManager tm) throws TransitionException, FinishedAutomatonException {
        MapTransform mapTransform = tm.getMapTransform();
        Envelope extent = mapTransform.getExtent();
        double width = 2.0 * extent.getWidth();
        double height = 2.0 * extent.getHeight();
        double x = tm.getValues()[0];
        double y = tm.getValues()[1];
        Envelope newExtent = new Envelope(x - width / 2.0, x + width / 2.0, y - height / 2.0, y + height / 2.0);
        mapTransform.setExtent(newExtent);
        this.transition(Automaton.Code.INIT);
    }

    @Override
    public void transitionTo_Cancel(MapContext vc, ToolManager tm) throws TransitionException {
    }

    @Override
    public void drawIn_Standby(Graphics g, MapContext vc, ToolManager tm) {
    }

    @Override
    public void drawIn_Done(Graphics g, MapContext vc, ToolManager tm) {
    }

    @Override
    public void drawIn_Cancel(Graphics g, MapContext vc, ToolManager tm) {
    }

    @Override
    public boolean isEnabled(MapContext vc, ToolManager tm) {
        return ToolUtilities.layerCountGreaterThan(vc, 0);
    }

    @Override
    public boolean isVisible(MapContext vc, ToolManager tm) {
        return true;
    }

    @Override
    public ImageIcon getImageIcon() {
        return MapEditorIcons.getIcon("zoom_out");
    }

    @Override
    public String getName() {
        return this.i18n.tr("Zoom out");
    }

    @Override
    public String getTooltip() {
        return this.i18n.tr("This tool zoom out on click");
    }

    @Override
    public ImageIcon getCursor() {
        return MapEditorIcons.getIcon("zoom_out");
    }
}

