/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools.generated;

import java.awt.Graphics;
import java.awt.Point;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.mapeditor.map.tool.Automaton;
import org.orbisgis.mapeditor.map.tool.DrawingException;
import org.orbisgis.mapeditor.map.tool.FinishedAutomatonException;
import org.orbisgis.mapeditor.map.tool.NoSuchTransitionException;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.generated.AbstractAutomaton;

public abstract class Drag
extends AbstractAutomaton {
    @Override
    public String[] getTransitionLabels() {
        return new String[0];
    }

    @Override
    public Automaton.Code[] getTransitionCodes() {
        return new Automaton.Code[0];
    }

    @Override
    public void transition(Automaton.Code code) throws NoSuchTransitionException, TransitionException, FinishedAutomatonException {
        switch (this.status) {
            case STANDBY: {
                if (Automaton.Code.PRESS != code) break;
                Automaton.Status preStatus = this.status;
                try {
                    this.status = Automaton.Status.MOUSE_DOWN;
                    this.transitionTo_MouseDown(this.mc, this.tm);
                    if (this.isFinished(this.status)) {
                        throw new FinishedAutomatonException();
                    }
                    break;
                }
                catch (TransitionException e) {
                    this.status = preStatus;
                    throw e;
                }
            }
            case MOUSE_DOWN: {
                if (Automaton.Code.RELEASE != code) break;
                Automaton.Status preStatus = this.status;
                try {
                    this.status = Automaton.Status.MOUSE_RELEASED;
                    this.transitionTo_MouseReleased(this.mc, this.tm);
                    if (this.isFinished(this.status)) {
                        throw new FinishedAutomatonException();
                    }
                    break;
                }
                catch (TransitionException e) {
                    this.status = preStatus;
                    throw e;
                }
            }
            case MOUSE_RELEASED: {
                if (Automaton.Code.FINISHED != code) break;
                Automaton.Status preStatus = this.status;
                try {
                    this.status = Automaton.Status.STANDBY;
                    this.transitionTo_Standby(this.mc, this.tm);
                    if (this.isFinished(this.status)) {
                        throw new FinishedAutomatonException();
                    }
                    break;
                }
                catch (TransitionException e) {
                    this.status = preStatus;
                    throw e;
                }
            }
            default: {
                throw new NoSuchTransitionException(code.toString());
            }
        }
    }

    @Override
    public boolean isFinished(Automaton.Status status) {
        switch (status) {
            case STANDBY: 
            case MOUSE_DOWN: 
            case MOUSE_RELEASED: {
                return false;
            }
        }
        throw new RuntimeException("Invalid status: " + (Object)((Object)status));
    }

    @Override
    public void draw(Graphics g) throws DrawingException {
        switch (this.status) {
            case STANDBY: {
                this.drawIn_Standby(g, this.mc, this.tm);
                break;
            }
            case MOUSE_DOWN: {
                this.drawIn_MouseDown(g, this.mc, this.tm);
                break;
            }
            case MOUSE_RELEASED: {
                this.drawIn_MouseReleased(g, this.mc, this.tm);
            }
        }
    }

    @Override
    public abstract void transitionTo_Standby(MapContext var1, ToolManager var2) throws FinishedAutomatonException, TransitionException;

    public abstract void drawIn_Standby(Graphics var1, MapContext var2, ToolManager var3) throws DrawingException;

    public abstract void transitionTo_MouseDown(MapContext var1, ToolManager var2) throws FinishedAutomatonException, TransitionException;

    public abstract void drawIn_MouseDown(Graphics var1, MapContext var2, ToolManager var3) throws DrawingException;

    public abstract void transitionTo_MouseReleased(MapContext var1, ToolManager var2) throws FinishedAutomatonException, TransitionException;

    public abstract void drawIn_MouseReleased(Graphics var1, MapContext var2, ToolManager var3) throws DrawingException;

    @Override
    public String getMessage() {
        switch (this.status) {
            case STANDBY: {
                return this.i18n.tr("Select start point");
            }
            case MOUSE_DOWN: {
                return this.i18n.tr("Drag to destination point");
            }
            case MOUSE_RELEASED: {
                return "";
            }
        }
        throw new RuntimeException("Invalid status: " + (Object)((Object)this.status));
    }

    @Override
    public void toolFinished(MapContext vc, ToolManager tm) throws NoSuchTransitionException, TransitionException, FinishedAutomatonException {
    }

    @Override
    public Point getHotSpotOffset() {
        return new Point(8, 8);
    }
}

