/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools.generated;

import java.awt.Graphics;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.mapeditor.map.tool.Automaton;
import org.orbisgis.mapeditor.map.tool.DrawingException;
import org.orbisgis.mapeditor.map.tool.FinishedAutomatonException;
import org.orbisgis.mapeditor.map.tool.NoSuchTransitionException;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.generated.AbstractAutomaton;

public abstract class Selection
extends AbstractAutomaton {
    @Override
    public String[] getTransitionLabels() {
        return new String[0];
    }

    @Override
    public Automaton.Code[] getTransitionCodes() {
        return new Automaton.Code[0];
    }

    @Override
    public void transition(Automaton.Code code) throws NoSuchTransitionException, TransitionException, FinishedAutomatonException {
        if (Automaton.Code.ESC == code) {
            this.status = Automaton.Status.STANDBY;
            this.transitionTo_Standby(this.mc, this.tm);
            if (this.isFinished(this.status)) {
                throw new FinishedAutomatonException();
            }
        }
        block12 : switch (this.status) {
            case STANDBY: {
                if (Automaton.Code.POINT != code) break;
                Automaton.Status preStatus = this.status;
                try {
                    this.status = Automaton.Status.ONE_POINT;
                    this.transitionTo_OnePoint(this.mc, this.tm);
                    if (this.isFinished(this.status)) {
                        throw new FinishedAutomatonException();
                    }
                    break;
                }
                catch (TransitionException e) {
                    this.status = preStatus;
                    throw e;
                }
            }
            case ONE_POINT: {
                switch (code) {
                    case SELECTION: {
                        Automaton.Status preStatus = this.status;
                        try {
                            this.status = Automaton.Status.SELECTION;
                            this.transitionTo_Selection(this.mc, this.tm);
                            if (this.isFinished(this.status)) {
                                throw new FinishedAutomatonException();
                            }
                            break block12;
                        }
                        catch (TransitionException e) {
                            this.status = preStatus;
                            throw e;
                        }
                    }
                    case NO_SELECTION: {
                        Automaton.Status preStatus = this.status;
                        try {
                            this.status = Automaton.Status.ONE_POINT_LEFT;
                            this.transitionTo_OnePointLeft(this.mc, this.tm);
                            if (this.isFinished(this.status)) {
                                throw new FinishedAutomatonException();
                            }
                            break block12;
                        }
                        catch (TransitionException e) {
                            this.status = preStatus;
                            throw e;
                        }
                    }
                    case INIT: {
                        Automaton.Status preStatus = this.status;
                        try {
                            this.status = Automaton.Status.STANDBY;
                            this.transitionTo_Standby(this.mc, this.tm);
                            if (this.isFinished(this.status)) {
                                throw new FinishedAutomatonException();
                            }
                            break block12;
                        }
                        catch (TransitionException e) {
                            this.status = preStatus;
                            throw e;
                        }
                    }
                }
                break;
            }
            case ONE_POINT_LEFT: {
                if (Automaton.Code.POINT != code) break;
                Automaton.Status preStatus = this.status;
                try {
                    this.status = Automaton.Status.TWO_POINTS;
                    this.transitionTo_TwoPoints(this.mc, this.tm);
                    if (this.isFinished(this.status)) {
                        throw new FinishedAutomatonException();
                    }
                    break;
                }
                catch (TransitionException e) {
                    this.status = preStatus;
                    throw e;
                }
            }
            case TWO_POINTS: {
                if (Automaton.Code.SELECTION == code) {
                    Automaton.Status preStatus = this.status;
                    try {
                        this.status = Automaton.Status.SELECTION;
                        this.transitionTo_Selection(this.mc, this.tm);
                        if (this.isFinished(this.status)) {
                            throw new FinishedAutomatonException();
                        }
                        break;
                    }
                    catch (TransitionException e) {
                        this.status = preStatus;
                        throw e;
                    }
                }
                if (Automaton.Code.NO_SELECTION != code) break;
                Automaton.Status preStatus = this.status;
                try {
                    this.status = Automaton.Status.STANDBY;
                    this.transitionTo_Standby(this.mc, this.tm);
                    if (this.isFinished(this.status)) {
                        throw new FinishedAutomatonException();
                    }
                    break;
                }
                catch (TransitionException e) {
                    this.status = preStatus;
                    throw e;
                }
            }
            case SELECTION: {
                if (Automaton.Code.POINT != code) break;
                Automaton.Status preStatus = this.status;
                try {
                    this.status = Automaton.Status.POINT_WITH_SELECTION;
                    this.transitionTo_PointWithSelection(this.mc, this.tm);
                    if (this.isFinished(this.status)) {
                        throw new FinishedAutomatonException();
                    }
                    break;
                }
                catch (TransitionException e) {
                    this.status = preStatus;
                    throw e;
                }
            }
            case POINT_WITH_SELECTION: {
                if (Automaton.Code.IN_HANDLER == code) {
                    Automaton.Status preStatus = this.status;
                    try {
                        this.status = Automaton.Status.MOVEMENT;
                        this.transitionTo_Movement(this.mc, this.tm);
                        if (this.isFinished(this.status)) {
                            throw new FinishedAutomatonException();
                        }
                        break;
                    }
                    catch (TransitionException e) {
                        this.status = preStatus;
                        throw e;
                    }
                }
                if (Automaton.Code.OUT_HANDLER != code) break;
                Automaton.Status preStatus = this.status;
                try {
                    this.status = Automaton.Status.ONE_POINT;
                    this.transitionTo_OnePoint(this.mc, this.tm);
                    if (this.isFinished(this.status)) {
                        throw new FinishedAutomatonException();
                    }
                    break;
                }
                catch (TransitionException e) {
                    this.status = preStatus;
                    throw e;
                }
            }
            case MOVEMENT: {
                if (Automaton.Code.POINT != code) break;
                Automaton.Status preStatus = this.status;
                try {
                    this.status = Automaton.Status.MAKE_MOVE;
                    this.transitionTo_MakeMove(this.mc, this.tm);
                    if (this.isFinished(this.status)) {
                        throw new FinishedAutomatonException();
                    }
                    break;
                }
                catch (TransitionException e) {
                    this.status = preStatus;
                    throw e;
                }
            }
            case MAKE_MOVE: {
                if (Automaton.Code.EMPTY != code) break;
                Automaton.Status preStatus = this.status;
                try {
                    this.status = Automaton.Status.SELECTION;
                    this.transitionTo_Selection(this.mc, this.tm);
                    if (this.isFinished(this.status)) {
                        throw new FinishedAutomatonException();
                    }
                    break;
                }
                catch (TransitionException e) {
                    this.status = preStatus;
                    throw e;
                }
            }
            default: {
                throw new NoSuchTransitionException(code.toString());
            }
        }
    }

    @Override
    public boolean isFinished(Automaton.Status status) {
        switch (status) {
            case STANDBY: 
            case ONE_POINT: 
            case ONE_POINT_LEFT: 
            case TWO_POINTS: 
            case SELECTION: 
            case POINT_WITH_SELECTION: 
            case MOVEMENT: 
            case MAKE_MOVE: {
                return false;
            }
        }
        throw new RuntimeException("Invalid status: " + (Object)((Object)status));
    }

    @Override
    public void draw(Graphics g) throws DrawingException {
        switch (this.status) {
            case STANDBY: {
                this.drawIn_Standby(g, this.mc, this.tm);
                break;
            }
            case ONE_POINT: {
                this.drawIn_OnePoint(g, this.mc, this.tm);
                break;
            }
            case ONE_POINT_LEFT: {
                this.drawIn_OnePointLeft(g, this.mc, this.tm);
                break;
            }
            case TWO_POINTS: {
                this.drawIn_TwoPoints(g, this.mc, this.tm);
                break;
            }
            case SELECTION: {
                this.drawIn_Selection(g, this.mc, this.tm);
                break;
            }
            case POINT_WITH_SELECTION: {
                this.drawIn_PointWithSelection(g, this.mc, this.tm);
                break;
            }
            case MOVEMENT: {
                this.drawIn_Movement(g, this.mc, this.tm);
                break;
            }
            case MAKE_MOVE: {
                this.drawIn_MakeMove(g, this.mc, this.tm);
            }
        }
    }

    @Override
    public abstract void transitionTo_Standby(MapContext var1, ToolManager var2) throws FinishedAutomatonException, TransitionException;

    public abstract void drawIn_Standby(Graphics var1, MapContext var2, ToolManager var3) throws DrawingException;

    public abstract void transitionTo_OnePoint(MapContext var1, ToolManager var2) throws FinishedAutomatonException, TransitionException;

    public abstract void drawIn_OnePoint(Graphics var1, MapContext var2, ToolManager var3) throws DrawingException;

    public abstract void transitionTo_OnePointLeft(MapContext var1, ToolManager var2) throws FinishedAutomatonException, TransitionException;

    public abstract void drawIn_OnePointLeft(Graphics var1, MapContext var2, ToolManager var3) throws DrawingException;

    public abstract void transitionTo_TwoPoints(MapContext var1, ToolManager var2) throws FinishedAutomatonException, TransitionException;

    public abstract void drawIn_TwoPoints(Graphics var1, MapContext var2, ToolManager var3) throws DrawingException;

    public abstract void transitionTo_Selection(MapContext var1, ToolManager var2) throws FinishedAutomatonException, TransitionException;

    public abstract void drawIn_Selection(Graphics var1, MapContext var2, ToolManager var3) throws DrawingException;

    public abstract void transitionTo_PointWithSelection(MapContext var1, ToolManager var2) throws FinishedAutomatonException, TransitionException;

    public abstract void drawIn_PointWithSelection(Graphics var1, MapContext var2, ToolManager var3) throws DrawingException;

    public abstract void transitionTo_Movement(MapContext var1, ToolManager var2) throws FinishedAutomatonException, TransitionException;

    public abstract void drawIn_Movement(Graphics var1, MapContext var2, ToolManager var3) throws DrawingException;

    public abstract void transitionTo_MakeMove(MapContext var1, ToolManager var2) throws FinishedAutomatonException, TransitionException;

    public abstract void drawIn_MakeMove(Graphics var1, MapContext var2, ToolManager var3) throws DrawingException;

    @Override
    public String getMessage() {
        switch (this.status) {
            case STANDBY: {
                return this.i18n.tr("Select a geometry or draw a selection rectangle");
            }
            case ONE_POINT_LEFT: {
                return this.i18n.tr("Select the second point");
            }
            case SELECTION: {
                return this.i18n.tr("Click a handler to move it or select another geometry");
            }
            case MOVEMENT: {
                return this.i18n.tr("Place the handler in its new position");
            }
            case ONE_POINT: 
            case TWO_POINTS: 
            case POINT_WITH_SELECTION: 
            case MAKE_MOVE: {
                return "";
            }
        }
        throw new RuntimeException(this.i18n.tr("Can't find the status of this tool."));
    }

    @Override
    public String getTooltip() {
        return this.i18n.tr("Select a feature");
    }

    @Override
    public void toolFinished(MapContext vc, ToolManager tm) throws NoSuchTransitionException, TransitionException, FinishedAutomatonException {
    }
}

