/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.mapeditor.map.tools.generated;

import java.awt.Graphics;
import org.orbisgis.coremap.layerModel.MapContext;
import org.orbisgis.mapeditor.map.tool.Automaton;
import org.orbisgis.mapeditor.map.tool.DrawingException;
import org.orbisgis.mapeditor.map.tool.FinishedAutomatonException;
import org.orbisgis.mapeditor.map.tool.NoSuchTransitionException;
import org.orbisgis.mapeditor.map.tool.ToolManager;
import org.orbisgis.mapeditor.map.tool.TransitionException;
import org.orbisgis.mapeditor.map.tools.generated.AbstractAutomaton;

public abstract class ZoomOut
extends AbstractAutomaton {
    @Override
    public String[] getTransitionLabels() {
        return new String[0];
    }

    @Override
    public Automaton.Code[] getTransitionCodes() {
        return new Automaton.Code[0];
    }

    @Override
    public void transition(Automaton.Code code) throws NoSuchTransitionException, TransitionException, FinishedAutomatonException {
        if (Automaton.Code.ESC == code) {
            this.status = Automaton.Status.CANCEL;
            this.transitionTo_Cancel(this.mc, this.tm);
            if (this.isFinished(this.status)) {
                throw new FinishedAutomatonException();
            }
        }
        switch (this.status) {
            case STANDBY: {
                if (Automaton.Code.POINT != code) break;
                Automaton.Status preStatus = this.status;
                try {
                    this.status = Automaton.Status.DONE;
                    this.transitionTo_Done(this.mc, this.tm);
                    if (this.isFinished(this.status)) {
                        throw new FinishedAutomatonException();
                    }
                    break;
                }
                catch (TransitionException e) {
                    this.status = preStatus;
                    throw e;
                }
            }
            case DONE: {
                if (Automaton.Code.INIT != code) break;
                Automaton.Status preStatus = this.status;
                try {
                    this.status = Automaton.Status.STANDBY;
                    this.transitionTo_Standby(this.mc, this.tm);
                    if (this.isFinished(this.status)) {
                        throw new FinishedAutomatonException();
                    }
                    break;
                }
                catch (TransitionException e) {
                    this.status = preStatus;
                    throw e;
                }
            }
            default: {
                throw new NoSuchTransitionException(code.toString());
            }
        }
    }

    @Override
    public boolean isFinished(Automaton.Status status) {
        switch (status) {
            case STANDBY: 
            case DONE: {
                return false;
            }
            case CANCEL: {
                return true;
            }
        }
        throw new RuntimeException("Invalid status: " + (Object)((Object)status));
    }

    @Override
    public void draw(Graphics g) throws DrawingException {
        switch (this.status) {
            case STANDBY: {
                this.drawIn_Standby(g, this.mc, this.tm);
                break;
            }
            case DONE: {
                this.drawIn_Done(g, this.mc, this.tm);
                break;
            }
            case CANCEL: {
                this.drawIn_Cancel(g, this.mc, this.tm);
            }
        }
    }

    @Override
    public abstract void transitionTo_Standby(MapContext var1, ToolManager var2) throws FinishedAutomatonException, TransitionException;

    public abstract void drawIn_Standby(Graphics var1, MapContext var2, ToolManager var3) throws DrawingException;

    public abstract void transitionTo_Done(MapContext var1, ToolManager var2) throws FinishedAutomatonException, TransitionException;

    public abstract void drawIn_Done(Graphics var1, MapContext var2, ToolManager var3) throws DrawingException;

    public abstract void transitionTo_Cancel(MapContext var1, ToolManager var2) throws FinishedAutomatonException, TransitionException;

    public abstract void drawIn_Cancel(Graphics var1, MapContext var2, ToolManager var3) throws DrawingException;

    @Override
    public String getMessage() {
        switch (this.status) {
            case STANDBY: {
                return this.i18n.tr("Select the center of the zoom");
            }
            case DONE: 
            case CANCEL: {
                return "";
            }
        }
        throw new RuntimeException("Invalid status: " + (Object)((Object)this.status));
    }

    @Override
    public void toolFinished(MapContext vc, ToolManager tm) throws NoSuchTransitionException, TransitionException, FinishedAutomatonException {
    }
}

