/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.emission.railway.cnossos;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import org.noise_planet.noisemodelling.emission.LineSource;
import org.noise_planet.noisemodelling.emission.railway.Railway;
import org.noise_planet.noisemodelling.emission.railway.cnossos.RailWayCnossosParameters;
import org.noise_planet.noisemodelling.emission.railway.cnossos.RailwayTrackCnossosParameters;
import org.noise_planet.noisemodelling.emission.railway.cnossos.RailwayVehicleCnossosParameters;
import org.noise_planet.noisemodelling.emission.utils.interpLinear;

public class RailwayCnossos
extends Railway {
    private static JsonNode parse(InputStream inputStream) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readTree(inputStream);
        }
        catch (IOException ex) {
            return NullNode.getInstance();
        }
    }

    public static <T> Iterable<T> iteratorToIterable(Iterator<T> iterator) {
        return () -> iterator;
    }

    public Double getWheelRoughness(String typeVehicle, String fileVersion, int lambdaId) {
        int refId = this.getVehicleNode(typeVehicle).get("RefRoughness").intValue();
        return this.getRailWayData().get("Vehicle").get("WheelRoughness").get(String.valueOf(refId)).get("Values").get(lambdaId).doubleValue();
    }

    public Double getContactFilter(String typeVehicle, int lambdaId) {
        int refId = this.getVehicleNode(typeVehicle).get("RefContact").intValue();
        return this.getRailWayData().get("Vehicle").get("ContactFilter").get(String.valueOf(refId)).get("Values").get(lambdaId).doubleValue();
    }

    public Double getTrackRoughness(int trackRoughnessId, int lambdaId) {
        return this.getRailWayData().get("Track").get("RailRoughness").get(String.valueOf(trackRoughnessId)).get("Values").get(lambdaId).doubleValue();
    }

    public double getAxlesPerVeh(String typeVehicle) {
        return this.getVehicleNode(typeVehicle).get("NbAxlePerVeh").doubleValue();
    }

    public int getNbCoach(String typeVehicle) {
        int nbCoach;
        try {
            nbCoach = this.getVehicleData().get(typeVehicle).get("NbCoach").intValue();
        }
        catch (Exception e) {
            nbCoach = 1;
        }
        return nbCoach;
    }

    public double getTractionNoise(String typeVehicle, int runningCondition, String sourceHeightId, String fileVersion, int freqId) {
        int refId = this.getVehicleNode(typeVehicle).get("RefTraction").intValue();
        double tractionSpectre = 0.0;
        String condition = "ConstantSpeed";
        if (refId != 0) {
            switch (runningCondition) {
                case 0: {
                    condition = "ConstantSpeed";
                    break;
                }
                case 1: {
                    condition = "AccelerationSpeed";
                    break;
                }
                case 3: {
                    condition = "DecelerationSpeed";
                    break;
                }
                case 4: {
                    condition = "IdlingSpeed";
                }
            }
            try {
                tractionSpectre = this.getRailWayData().get("Vehicle").get(condition).get(String.valueOf(refId)).get("Values").get(sourceHeightId).get(freqId).doubleValue();
            }
            catch (NullPointerException ex) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Could not find traction spectrum for the following parameters getRailWayData(%d).get(\"Vehicle\").get(%s).get(String.valueOf(%d)).get(\"Values\").get(%s).get(%d)", fileVersion, condition, refId, sourceHeightId, freqId));
            }
        }
        return tractionSpectre;
    }

    public double getAerodynamicNoise(String typeVehicle, String sourceHeightId, String fileVersion, int freqId) {
        int refId = this.getVehicleNode(typeVehicle).get("RefAerodynamic").intValue();
        return this.getRailWayData().get("Vehicle").get("AerodynamicNoise").get(String.valueOf(refId)).get("Values").get(sourceHeightId).get(freqId).doubleValue();
    }

    public Double getBridgeStructural(int bridgeId, int freqId) {
        return this.getRailWayData().get("Track").get("BridgeConstant").get(String.valueOf(bridgeId)).get("Values").get(freqId).doubleValue();
    }

    public Double getTrackTransfer(int trackTransferId, int freqId) {
        return this.getRailWayData().get("Track").get("TrackTransfer").get(String.valueOf(trackTransferId)).get("Spectre").get(freqId).doubleValue();
    }

    public Double getImpactNoise(int impactNoiseId, int freqId) {
        return this.getRailWayData().get("Track").get("ImpactNoise").get(String.valueOf(impactNoiseId)).get("Values").get(freqId).doubleValue();
    }

    public Double getVehTransfer(String typeVehicle, int freqId) {
        int RefTransfer = this.getVehicleNode(typeVehicle).get("RefTransfer").intValue();
        return this.getRailWayData().get("Vehicle").get("Transfer").get(String.valueOf(RefTransfer)).get("Spectre").get(freqId).doubleValue();
    }

    public Double getLRoughness(String typeVehicle, int trackRoughnessId, String vehicleFileVersion, int idLambda) {
        double wheelRoughness = this.getWheelRoughness(typeVehicle, vehicleFileVersion, idLambda);
        double trackRoughness = this.getTrackRoughness(trackRoughnessId, idLambda);
        return 10.0 * Math.log10(Math.pow(10.0, wheelRoughness / 10.0) + Math.pow(10.0, trackRoughness / 10.0));
    }

    private double[] checkNanValue(double[] roughnessLtot) {
        int i;
        int indice_NaN = 0;
        for (i = 0; i < roughnessLtot.length - 2; ++i) {
            if (!Double.isNaN(roughnessLtot[i])) continue;
            ++indice_NaN;
        }
        for (i = 0; i < indice_NaN; ++i) {
            roughnessLtot[i] = roughnessLtot[indice_NaN + 1];
        }
        return roughnessLtot;
    }

    public RailWayCnossosParameters evaluate(RailwayVehicleCnossosParameters vehicleParameters, RailwayTrackCnossosParameters trackParameters) throws IOException {
        String vehicleFileVersion = vehicleParameters.getFileVersion();
        String trackFileVersion = trackParameters.getFileVersion();
        String typeVehicle = vehicleParameters.getTypeVehicle();
        double speedVehicle = vehicleParameters.getSpeedVehicle();
        double vehPerHour = vehicleParameters.getNumberVehicle();
        double axlesPerVeh = this.getAxlesPerVeh(typeVehicle);
        int runningCondition = vehicleParameters.getRunningCondition();
        double speedTrack = trackParameters.getSpeedTrack();
        double speedCommercial = trackParameters.getSpeedCommercial();
        int trackRoughnessId = trackParameters.getRailRoughness();
        int trackTransferId = trackParameters.getTrackTransfer();
        int impactId = trackParameters.getImpactNoise();
        int bridgeId = trackParameters.getBridgeTransfert();
        int curvature = trackParameters.getCurvature();
        double speed = Math.min(speedVehicle, Math.min(speedTrack, speedCommercial));
        boolean isTunnel = trackParameters.getIsTunnel();
        RailWayCnossosParameters railWayParameters = new RailWayCnossosParameters();
        if (isTunnel) {
            return railWayParameters;
        }
        double[] lW = this.getLWRolling(typeVehicle, trackRoughnessId, impactId, curvature, speed, trackTransferId, trackFileVersion, axlesPerVeh);
        railWayParameters.addRailwaySource("ROLLING", new LineSource(lW, 4.0, "ROLLING"));
        lW = this.getLWTraction(typeVehicle, runningCondition, "A", vehicleFileVersion);
        railWayParameters.addRailwaySource("TRACTIONA", new LineSource(lW, 0.05, "TRACTIONA"));
        lW = this.getLWTraction(typeVehicle, runningCondition, "B", vehicleFileVersion);
        railWayParameters.addRailwaySource("TRACTIONB", new LineSource(lW, 4.0, "TRACTIONB"));
        lW = this.getLWAero(typeVehicle, speed, "A", vehicleFileVersion);
        railWayParameters.addRailwaySource("AERODYNAMICA", new LineSource(lW, 0.05, "AERODYNAMICA"));
        lW = this.getLWAero(typeVehicle, speed, "B", vehicleFileVersion);
        railWayParameters.addRailwaySource("AERODYNAMICB", new LineSource(lW, 4.0, "AERODYNAMICB"));
        lW = this.getLWBridge(typeVehicle, trackRoughnessId, impactId, bridgeId, speed, trackFileVersion, axlesPerVeh);
        railWayParameters.addRailwaySource("BRIDGE", new LineSource(lW, 4.0, "BRIDGE"));
        railWayParameters.appendVperHour(vehPerHour * (double)this.getNbCoach(typeVehicle), speed);
        return railWayParameters;
    }

    private double[] getLWTraction(String typeVehicle, int runningCondition, String height, String fileVersion) {
        double[] lWSpectre = new double[24];
        for (int idFreq = 0; idFreq < 24; ++idFreq) {
            lWSpectre[idFreq] = this.getTractionNoise(typeVehicle, runningCondition, height, fileVersion, idFreq);
        }
        return lWSpectre;
    }

    private double[] getLWAero(String typeVehicle, double speed, String height, String fileVersion) {
        double[] lWSpectre = new double[24];
        for (int idFreq = 0; idFreq < 24; ++idFreq) {
            int refId = this.getVehicleNode(typeVehicle).get("RefAerodynamic").intValue();
            if (speed < 200.0 || refId == 0) {
                lWSpectre[idFreq] = -99.0;
                continue;
            }
            lWSpectre[idFreq] = this.getAerodynamicNoise(typeVehicle, height, fileVersion, idFreq);
            double v0Aero = Double.parseDouble(this.getRailWayData().get("Vehicle").get("AerodynamicNoise").get(String.valueOf(refId)).get("V0").asText());
            double alphaAero = Double.parseDouble(this.getRailWayData().get("Vehicle").get("AerodynamicNoise").get(String.valueOf(refId)).get("Alpha").asText());
            lWSpectre[idFreq] = lWSpectre[idFreq] + alphaAero * Math.log10(speed / v0Aero);
        }
        return lWSpectre;
    }

    private double[] getLWRolling(String typeVehicle, int trackRoughnessId, int impactId, int curvature, double speed, int trackTransferId, String trackFileVersion, double axlesPerVeh) {
        double[] trackTransfer = new double[24];
        double[] lWTr = new double[24];
        double[] vehTransfer = new double[24];
        double[] lWVeh = new double[24];
        double[] lW = new double[24];
        double[] roughnessLtot = this.checkNanValue(this.getLWRoughness(typeVehicle, trackRoughnessId, impactId, speed, trackFileVersion));
        for (int idFreq = 0; idFreq < 24; ++idFreq) {
            trackTransfer[idFreq] = this.getTrackTransfer(trackTransferId, idFreq);
            lWTr[idFreq] = roughnessLtot[idFreq] + trackTransfer[idFreq] + 10.0 * Math.log10(axlesPerVeh);
            vehTransfer[idFreq] = this.getVehTransfer(typeVehicle, idFreq);
            lWVeh[idFreq] = roughnessLtot[idFreq] + vehTransfer[idFreq] + 10.0 * Math.log10(axlesPerVeh);
            lW[idFreq] = 10.0 * Math.log10(Math.pow(10.0, lWTr[idFreq] / 10.0) + Math.pow(10.0, lWVeh[idFreq] / 10.0));
            if (curvature == 1) {
                lW[idFreq] = lW[idFreq] + 5.0;
                continue;
            }
            if (curvature == 2) {
                lW[idFreq] = lW[idFreq] + 8.0;
                continue;
            }
            if (curvature != 3) continue;
            lW[idFreq] = lW[idFreq] + 8.0;
        }
        return lW;
    }

    private double[] getLWBridge(String typeVehicle, int trackRoughnessId, int impactId, int bridgeId, double speed, String trackFileVersion, double axlesPerVeh) {
        int idFreq;
        double[] lW = new double[24];
        double[] roughnessLtot = this.checkNanValue(this.getLWRoughness(typeVehicle, trackRoughnessId, impactId, speed, trackFileVersion));
        double[] lWBridge = new double[24];
        for (idFreq = 0; idFreq < 24; ++idFreq) {
            lW[idFreq] = -99.0;
        }
        if (trackFileVersion == "EU" && (bridgeId == 3 || bridgeId == 4)) {
            for (idFreq = 0; idFreq < 24; ++idFreq) {
                lWBridge[idFreq] = this.getBridgeStructural(bridgeId, idFreq);
                lW[idFreq] = roughnessLtot[idFreq] + lWBridge[idFreq] + 10.0 * Math.log10(axlesPerVeh);
            }
        }
        return lW;
    }

    private double[] getLWRoughness(String typeVehicle, int trackRoughnessId, int impactId, double speed, String trackFileVersion) {
        double[] roughnessTotLambda = new double[35];
        double[] roughnessLtot = new double[35];
        double[] contactFilter = new double[35];
        double[] lambdaToFreqLog = new double[35];
        double[] freqMedLog = new double[24];
        double[] Lambda = new double[35];
        double m = 33.0;
        for (int idLambda = 0; idLambda < 35; ++idLambda) {
            Lambda[idLambda] = Math.pow(10.0, m / 10.0);
            lambdaToFreqLog[idLambda] = Math.log10(speed / Lambda[idLambda] * 1000.0 / 3.6);
            roughnessTotLambda[idLambda] = Math.pow(10.0, this.getLRoughness(typeVehicle, trackRoughnessId, trackFileVersion, idLambda) / 10.0);
            contactFilter[idLambda] = this.getContactFilter(typeVehicle, idLambda);
            roughnessLtot[idLambda] = 10.0 * Math.log10(roughnessTotLambda[idLambda]) + contactFilter[idLambda];
            if (impactId != 0) {
                roughnessLtot[idLambda] = 10.0 * Math.log10(Math.pow(10.0, roughnessLtot[idLambda] / 10.0) + Math.pow(10.0, this.getImpactNoise(impactId, idLambda) / 10.0));
            }
            roughnessLtot[idLambda] = Math.pow(10.0, roughnessLtot[idLambda] / 10.0);
            m -= 1.0;
        }
        for (int idFreqMed = 0; idFreqMed < 24; ++idFreqMed) {
            freqMedLog[idFreqMed] = Math.log10(Math.pow(10.0, (17.0 + Double.valueOf(idFreqMed)) / 10.0));
        }
        double[] roughnessLtotFreq = interpLinear.interpLinear(lambdaToFreqLog, roughnessLtot, freqMedLog);
        for (int idRoughnessLtotFreq = 0; idRoughnessLtotFreq < 24; ++idRoughnessLtotFreq) {
            roughnessLtotFreq[idRoughnessLtotFreq] = 10.0 * Math.log10(roughnessLtotFreq[idRoughnessLtotFreq]);
        }
        return roughnessLtotFreq;
    }
}

