/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.emission.railway.schall03;

public class TramwaySchall03 {
    public static final double grass_a_factor = 26.0;
    public static final double rigid_a_factor = 26.0;
    public static final double grass_b_factor = 75.0;
    public static final double rigid_b_factor = 78.0;
    public static final double speed_reference = 40.0;

    private TramwaySchall03() {
    }

    public static double evaluate(double speed, double tw_per_hour, GROUND_TYPE ground_type, boolean has_anti_vibration) {
        double b_factor;
        double a_factor;
        switch (ground_type) {
            case GRASS: {
                a_factor = 26.0;
                b_factor = 75.0;
                break;
            }
            case RIGID: {
                a_factor = 26.0;
                b_factor = 78.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ground type");
            }
        }
        double delta_corr = 0.0;
        if (has_anti_vibration) {
            delta_corr += -2.0;
        }
        return a_factor * Math.log10(speed / 40.0) + b_factor + delta_corr + Math.log10(tw_per_hour);
    }

    public static enum GROUND_TYPE {
        GRASS,
        RIGID;

    }
}

