/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.emission.road.cnossos;

import java.io.IOException;

public class RoadCnossosParameters {
    private double lvPerHour;
    private double mvPerHour;
    private double hgvPerHour;
    private double wavPerHour;
    private double wbvPerHour;
    private int frequency;
    private double temperature;
    private String roadSurface;
    private double tsStud;
    private double qStudRatio;
    private double Junc_dist = 250.0;
    private int Junc_type;
    private double slopePercentage = 0.0;
    private int way = 1;
    private double speedLv;
    private double speedMv;
    private double speedHgv;
    private double speedWav;
    private double speedWbv;
    private int fileVersion = 2;

    public RoadCnossosParameters() {
    }

    public RoadCnossosParameters(double lv_speed, double mv_speed, double hgv_speed, double wav_speed, double wbv_speed, double lvPerHour, double mvPerHour, double hgvPerHour, double wavPerHour, double wbvPerHour, int frequency, double Temperature, String roadSurface, double Ts_stud, double Pm_stud, double Junc_dist, int Junc_type) {
        if (lvPerHour < 0.0) {
            throw new IllegalArgumentException("The flow rate of light vehicles is less than zero on one section.");
        }
        if (mvPerHour < 0.0) {
            throw new IllegalArgumentException("The flow rate of medium vehicles is less than zero on one section.");
        }
        if (hgvPerHour < 0.0) {
            throw new IllegalArgumentException("The flow rate of heavy vehicles is less than zero on one section.");
        }
        if (wavPerHour < 0.0) {
            throw new IllegalArgumentException("The flow rate of 2W(a) vehicles is less than zero on one section.");
        }
        if (wbvPerHour < 0.0) {
            throw new IllegalArgumentException("The flow rate of 2W(b) vehicles is less than zero on one section.");
        }
        if (lv_speed < 0.0) {
            throw new IllegalArgumentException("The speed light vehicles is less than zero on one section.");
        }
        if (mv_speed < 0.0) {
            throw new IllegalArgumentException("The speed of medium vehicles is less than zero on one section.");
        }
        if (hgv_speed < 0.0) {
            throw new IllegalArgumentException("The speed of heavy vehicles is less than zero on one section.");
        }
        if (wav_speed < 0.0) {
            throw new IllegalArgumentException("The speed of 2W(a) vehicles is less than zero on one section.");
        }
        if (wbv_speed < 0.0) {
            throw new IllegalArgumentException("The speed of 2W(b) vehicles is less than zero on one section.");
        }
        if (Ts_stud < 0.0 || Ts_stud > 12.0) {
            throw new IllegalArgumentException("The number of months of snow tire use is impossible for a section (<0 or >12).");
        }
        if (Junc_type < 0 || Junc_type > 2) {
            throw new IllegalArgumentException("Unlnown Junction type for a section.");
        }
        this.lvPerHour = Math.max(0.0, lvPerHour);
        this.mvPerHour = Math.max(0.0, mvPerHour);
        this.hgvPerHour = Math.max(0.0, hgvPerHour);
        this.wavPerHour = Math.max(0.0, wavPerHour);
        this.wbvPerHour = Math.max(0.0, wbvPerHour);
        this.frequency = Math.max(0, frequency);
        this.temperature = Temperature;
        this.roadSurface = roadSurface;
        this.tsStud = Math.max(0.0, Math.min(12.0, Ts_stud));
        this.qStudRatio = Math.max(0.0, Math.min(1.0, Pm_stud));
        this.Junc_dist = Math.max(0.0, Junc_dist);
        this.Junc_type = Math.max(0, Math.min(2, Junc_type));
        this.speedLv = lv_speed;
        this.speedMv = mv_speed;
        this.speedHgv = hgv_speed;
        this.speedWav = wav_speed;
        this.speedWbv = wbv_speed;
    }

    private static double getVPl(double sLv, double speedmax, int type, int subtype) throws IllegalArgumentException {
        switch (type) {
            case 1: {
                return Math.min(sLv, 100.0);
            }
            case 2: {
                switch (subtype) {
                    case 1: {
                        return Math.min(sLv, 90.0);
                    }
                    case 2: {
                        return Math.min(sLv, 90.0);
                    }
                    case 3: {
                        if (speedmax < 80.0) {
                            return Math.min(sLv, 70.0);
                        }
                        return Math.min(sLv, 85.0);
                    }
                }
                break;
            }
            case 3: {
                switch (subtype) {
                    case 1: {
                        return sLv;
                    }
                    case 2: {
                        return sLv;
                    }
                    case 7: {
                        return sLv;
                    }
                }
                break;
            }
            case 4: {
                switch (subtype) {
                    case 1: {
                        return Math.min(sLv, 90.0);
                    }
                    case 2: {
                        return Math.min(sLv, 90.0);
                    }
                    case 3: {
                        if (speedmax < 70.0) {
                            return Math.min(sLv, 60.0);
                        }
                        return Math.min(sLv, 80.0);
                    }
                }
                break;
            }
            case 5: {
                switch (subtype) {
                    case 1: {
                        return Math.min(sLv, 70.0);
                    }
                    case 2: {
                        return Math.min(sLv, 50.0);
                    }
                    case 3: {
                        return Math.min(sLv, 50.0);
                    }
                    case 4: {
                        return Math.min(sLv, 50.0);
                    }
                    case 6: {
                        return Math.min(sLv, 50.0);
                    }
                    case 7: {
                        return Math.min(sLv, 50.0);
                    }
                    case 8: {
                        return Math.min(sLv, 50.0);
                    }
                    case 9: {
                        return Math.min(sLv, 50.0);
                    }
                }
                break;
            }
            case 6: {
                switch (subtype) {
                    case 1: {
                        return Math.min(sLv, 50.0);
                    }
                    case 2: {
                        return Math.min(sLv, 50.0);
                    }
                    case 3: {
                        return Math.min(sLv, 50.0);
                    }
                    case 4: {
                        return Math.min(sLv, 50.0);
                    }
                    case 8: {
                        return Math.min(sLv, 50.0);
                    }
                    case 9: {
                        return Math.min(sLv, 50.0);
                    }
                }
            }
        }
        throw new IllegalArgumentException("Unknown road type, please check (type=" + type + ",subtype=" + subtype + ").");
    }

    public int getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(int fileVersion) {
        this.fileVersion = fileVersion;
    }

    public void setSpeedFromRoadCaracteristics(double speedLoad, double speed_junction, boolean is_queue, double speed_max, int copound_roadtype) {
        int roadtype = copound_roadtype / 10;
        int roadSubType = copound_roadtype - roadtype * 10;
        this.speedLv = speed_junction > 0.0 && is_queue ? speed_junction : (speedLoad > 0.0 ? speedLoad : speed_max);
        this.speedHgv = RoadCnossosParameters.getVPl(this.speedLv, speed_max, roadtype, roadSubType);
        this.speedMv = RoadCnossosParameters.getVPl(this.speedLv, speed_max, roadtype, roadSubType);
        this.speedWav = RoadCnossosParameters.getVPl(this.speedLv, speed_max, roadtype, roadSubType);
        this.speedWbv = RoadCnossosParameters.getVPl(this.speedLv, speed_max, roadtype, roadSubType);
    }

    public void setSlopePercentage_without_limit(double slopePercentage) {
        this.slopePercentage = slopePercentage;
    }

    public double getLvPerHour() {
        return this.lvPerHour;
    }

    public double getMvPerHour() {
        return this.mvPerHour;
    }

    public double getHgvPerHour() {
        return this.hgvPerHour;
    }

    public double getWavPerHour() {
        return this.wavPerHour;
    }

    public double getWbvPerHour() {
        return this.wbvPerHour;
    }

    public double getSlopePercentage() {
        return this.slopePercentage;
    }

    public void setSlopePercentage(double slopePercentage) {
        this.slopePercentage = Math.min(12.0, Math.max(-12.0, slopePercentage));
    }

    public double getWay() {
        return this.way;
    }

    public void setWay(int way) {
        this.way = way;
    }

    public double getSpeedLv() throws IOException {
        if (this.speedLv < 20.0) {
            this.speedLv = 20.0;
        }
        return this.speedLv;
    }

    public double getSpeedMv() throws IOException {
        if (this.speedMv < 20.0) {
            this.speedMv = 20.0;
        }
        return this.speedMv;
    }

    public double getSpeedHgv() throws IOException {
        if (this.speedHgv < 20.0) {
            this.speedHgv = 20.0;
        }
        return this.speedHgv;
    }

    public double getSpeedWav() throws IOException {
        if (this.speedWav < 20.0) {
            this.speedWav = 20.0;
        }
        return this.speedWav;
    }

    public double getSpeedWbv() throws IOException {
        if (this.speedWbv < 20.0) {
            this.speedWbv = 20.0;
        }
        return this.speedWbv;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public String getRoadSurface() {
        return this.roadSurface;
    }

    public void setRoadSurface(String roadSurface) {
        this.roadSurface = roadSurface;
    }

    public double getTsStud() {
        return this.tsStud;
    }

    public double getqStudRatio() {
        return this.qStudRatio;
    }

    public double getJunc_dist() {
        return this.Junc_dist;
    }

    public void setJunc_dist(double junc_dist) {
        this.Junc_dist = junc_dist;
    }

    public int getJunc_type() {
        return this.Junc_type;
    }

    public void setJunc_type(int junc_type) {
        this.Junc_type = junc_type;
    }
}

