/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.emission.road.cnossosvar;

import java.io.IOException;
import java.util.Random;
import org.noise_planet.noisemodelling.emission.road.cnossos.RoadCnossos;
import org.noise_planet.noisemodelling.emission.road.cnossosvar.RoadVehicleCnossosvarParameters;
import org.noise_planet.noisemodelling.emission.utils.Utils;

public class RoadVehicleCnossosvar {
    public static double evaluate(RoadVehicleCnossosvarParameters parameters) throws IOException {
        boolean Stud = parameters.getStud();
        double Junc_dist = parameters.getJunc_dist();
        int Junc_type = parameters.getJunc_type();
        int acc_type = parameters.getAcc_type();
        String veh_type = parameters.getVeh_type();
        int VehId = parameters.getVehId();
        double acceleration = parameters.getAcceleration();
        double speed = parameters.getSpeed();
        int freqParam = parameters.getFrequency();
        double Temperature = parameters.getTemperature();
        String roadSurface = parameters.getRoadSurface();
        int coeffVer = parameters.getFileVersion();
        double RoadLvl = RoadCnossos.getNoiseLvl(RoadCnossos.getCoeff("ar", freqParam, veh_type, coeffVer), RoadCnossos.getCoeff("br", freqParam, veh_type, coeffVer), speed, 70.0);
        switch (veh_type) {
            case "1": {
                RoadLvl += 0.08 * (20.0 - Temperature);
                break;
            }
            case "2": {
                RoadLvl += 0.04 * (20.0 - Temperature);
                break;
            }
            case "3": {
                RoadLvl += 0.04 * (20.0 - Temperature);
                break;
            }
        }
        double coefficientJunctionDistance = Math.max(1.0 - Math.abs(Junc_dist) / 100.0, 0.0);
        RoadLvl += RoadCnossos.getCr(veh_type, Junc_type, coeffVer) * coefficientJunctionDistance;
        if (veh_type.equals("1") && Stud) {
            double speedStud = speed >= 90.0 ? 90.0 : speed;
            speedStud = speedStud <= 50.0 ? 50.0 : speedStud;
            double deltaStud = RoadCnossos.getNoiseLvl(RoadCnossos.getCoeff("a", freqParam, veh_type, coeffVer), RoadCnossos.getCoeff("b", freqParam, veh_type, coeffVer), speedStud, 70.0);
            RoadLvl += Math.pow(10.0, deltaStud / 10.0);
        }
        RoadLvl = speed <= 20.0 ? 0.0 : (RoadLvl += RoadCnossos.getNoiseLvl(RoadCnossos.getA_RoadSurfaceCoeff(freqParam, veh_type, roadSurface, coeffVer), RoadCnossos.getB_RoadSurfaceCoeff(veh_type, roadSurface, coeffVer), speed, 70.0).doubleValue());
        speed = speed <= 20.0 ? 20.0 : speed;
        double MotorLvl = RoadCnossos.getCoeff("ap", freqParam, veh_type, coeffVer) + RoadCnossos.getCoeff("bp", freqParam, veh_type, coeffVer) * (speed - 70.0) / 70.0;
        switch (acc_type) {
            case 1: {
                if (!veh_type.equals("1") && !veh_type.equals("2") && !veh_type.equals("3")) break;
                MotorLvl += RoadCnossos.getCp(veh_type, Junc_type, coeffVer) * coefficientJunctionDistance;
                break;
            }
            case 2: {
                double aMax;
                switch (veh_type) {
                    case "1": {
                        aMax = 2.0;
                        if (acceleration >= -1.0 & freqParam < 250) {
                            MotorLvl += Math.min(acceleration, aMax) * 5.0;
                        }
                        if (acceleration >= -1.0 & freqParam >= 250) {
                            MotorLvl += Math.min(acceleration, aMax) * 2.0;
                        }
                        if (acceleration < -1.0 & freqParam < 250) {
                            MotorLvl += -5.0;
                        }
                        if (!(acceleration < -1.0 & freqParam >= 250)) break;
                        MotorLvl += -2.0;
                        break;
                    }
                    case "2": 
                    case "3": {
                        aMax = 1.0;
                        if (acceleration >= -1.0 & freqParam < 250) {
                            MotorLvl += Math.min(acceleration, aMax) * 7.0;
                        }
                        if (acceleration >= -1.0 & freqParam >= 250) {
                            MotorLvl += Math.min(acceleration, aMax) * 3.0;
                        }
                        if (acceleration < -1.0 & freqParam < 250) {
                            MotorLvl += -7.0;
                        }
                        if (!(acceleration < -1.0 & freqParam >= 250)) break;
                        MotorLvl += -3.0;
                        break;
                    }
                    case "4a": 
                    case "4b": {
                        aMax = 4.0;
                        if (acceleration >= -1.0 & freqParam < 250) {
                            MotorLvl += Math.min(acceleration, aMax) * 5.0;
                        }
                        if (acceleration >= -1.0 & freqParam >= 250) {
                            MotorLvl += Math.min(acceleration, aMax) * 2.0;
                        }
                        if (acceleration < -1.0 & freqParam < 250) {
                            MotorLvl += -5.0;
                        }
                        if (!(acceleration < -1.0 & freqParam >= 250)) break;
                        MotorLvl += -2.0;
                        break;
                    }
                }
                break;
            }
            case 3: {
                double aMax;
                switch (veh_type) {
                    case "1": 
                    case "4a": 
                    case "4b": {
                        aMax = 10.0;
                        if (acceleration >= -1.0 & freqParam < 250) {
                            MotorLvl += Math.min(acceleration, aMax) * 5.0;
                        }
                        if (acceleration >= -1.0 & freqParam >= 250) {
                            MotorLvl += Math.min(acceleration, aMax) * 2.0;
                        }
                        if (acceleration < -1.0 & freqParam < 250) {
                            MotorLvl += -5.0;
                        }
                        if (!(acceleration < -1.0 & freqParam >= 250)) break;
                        MotorLvl += -2.0;
                        break;
                    }
                    case "2": 
                    case "3": {
                        aMax = 10.0;
                        if (acceleration >= -1.0 & freqParam < 250) {
                            MotorLvl += Math.min(acceleration, aMax) * 7.0;
                        }
                        if (acceleration >= -1.0 & freqParam >= 250) {
                            MotorLvl += Math.min(acceleration, aMax) * 3.0;
                        }
                        if (acceleration < -1.0 & freqParam < 250) {
                            MotorLvl += -7.0;
                        }
                        if (!(acceleration < -1.0 & freqParam >= 250)) break;
                        MotorLvl += -3.0;
                        break;
                    }
                }
                break;
            }
        }
        switch (veh_type) {
            case "1": {
                if (parameters.getSlopePercentage() < -6.0) {
                    MotorLvl += (Math.min(12.0, -parameters.getSlopePercentage()) - 6.0) / 1.0;
                    break;
                }
                if (parameters.getSlopePercentage() <= 2.0) {
                    MotorLvl += 0.0;
                    break;
                }
                MotorLvl += speed / 100.0 * ((Math.min(12.0, parameters.getSlopePercentage()) - 2.0) / 1.5);
                break;
            }
            case "2": {
                if (parameters.getSlopePercentage() < -4.0) {
                    MotorLvl += (speed - 20.0) / 100.0 * (Math.min(12.0, -1.0 * parameters.getSlopePercentage()) - 4.0) / 0.7;
                    break;
                }
                if (parameters.getSlopePercentage() <= 0.0) {
                    MotorLvl += 0.0;
                    break;
                }
                MotorLvl += speed / 100.0 * Math.min(12.0, parameters.getSlopePercentage()) / 1.0;
                break;
            }
            case "3": {
                if (parameters.getSlopePercentage() < -4.0) {
                    MotorLvl += (speed - 10.0) / 100.0 * (Math.min(12.0, -1.0 * parameters.getSlopePercentage()) - 4.0) / 0.5;
                    break;
                }
                if (parameters.getSlopePercentage() <= 0.0) {
                    MotorLvl += 0.0;
                    break;
                }
                MotorLvl += speed / 100.0 * Math.min(12.0, parameters.getSlopePercentage()) / 0.8;
                break;
            }
        }
        Random r = new Random(VehId);
        double deltaLwdistrib = 0.115 * Math.pow(parameters.getLwStd(), 2.0);
        return Utils.sumDbValues(RoadLvl, MotorLvl += Math.min(RoadCnossos.getA_RoadSurfaceCoeff(freqParam, veh_type, roadSurface, coeffVer), 0.0)) - deltaLwdistrib + r.nextGaussian() * parameters.getLwStd();
    }
}

