/**
 * NoiseModelling is a library capable of producing noise maps. It can be freely used either for research and education, as well as by experts in a professional use.
 * <p>
 * NoiseModelling is distributed under GPL 3 license. You can read a copy of this License in the file LICENCE provided with this software.
 * <p>
 * Official webpage : http://noise-planet.org/noisemodelling.html
 * Contact: contact@noise-planet.org
 */

package org.noise_planet.noisemodelling.pathfinder.utils.geometry;

import org.noise_planet.noisemodelling.pathfinder.utils.AcousticIndicatorsFunctions;

import static org.noise_planet.noisemodelling.pathfinder.utils.AcousticIndicatorsFunctions.wToDb;

public class GeometricAttenuation {

    /**
     *
     * @param distance
     * @return decibel value
     */
    public static double getADiv(double distance) {
        return  AcousticIndicatorsFunctions.wToDb(4 * Math.PI * Math.max(1, distance * distance));
    }


}
