/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;

public class ThreadPool
extends ThreadPoolExecutor {
    ProgressVisitor progressVisitor = new EmptyProgressVisitor();

    public ThreadPool() {
        super(32, 256, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public ThreadPool(int queueSize) {
        super(32, 256, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)(queueSize < 0 ? new LinkedBlockingQueue() : (queueSize == 0 ? new SynchronousQueue() : new ArrayBlockingQueue(queueSize)))));
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>());
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public void setProgressVisitor(ProgressVisitor progressVisitor) {
        this.progressVisitor = progressVisitor;
    }

    public boolean hasAvaibleQueueSlot() {
        return this.getQueue().size() + this.getActiveCount() < this.getMaximumPoolSize();
    }

    public int getRemainingTasks() {
        return this.getQueue().size() + this.getActiveCount();
    }

    public void executeBlocking(Runnable command) {
        while (this.getQueue().size() + this.getActiveCount() >= this.getMaximumPoolSize() && !this.progressVisitor.isCanceled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        super.execute(command);
    }

    public <T> Future<T> submitBlocking(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> ftask = this.newTaskFor(task);
        this.executeBlocking(ftask);
        return ftask;
    }
}

