/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.path;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.Intersection;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.math.Vector2D;
import org.noise_planet.noisemodelling.pathfinder.path.MirrorReceiver;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ProfileBuilder;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.Wall;

public class MirrorReceiversCompute {
    private static final double DEFAULT_CIRCLE_POINT_ANGLE = 0.1308996938995747;
    STRtree mirrorReceiverTree;
    public static final int DEFAULT_MIRROR_RECEIVER_CAPACITY = 50000;
    private int mirrorReceiverCapacity = 50000;
    private final Coordinate receiverCoordinate;
    private final List<Wall> buildWalls;
    private final double maximumDistanceFromWall;
    private final double maximumPropagationDistance;
    int numberOfImageReceivers = 0;

    public static Polygon createWallReflectionVisibilityCone(Coordinate receiverImage, LineSegment wall, double maximumPropagationDistance, double maximumDistanceFromWall) {
        Vector2D rP1;
        double distanceMin = wall.distance(receiverImage);
        GeometryFactory factory = new GeometryFactory();
        if (distanceMin > maximumPropagationDistance) {
            return factory.createPolygon();
        }
        ArrayList<Coordinate> circleSegmentPoints = new ArrayList<Coordinate>();
        Vector2D rP0 = new Vector2D(receiverImage, wall.p0).normalize();
        double angleSign = rP0.angleTo(rP1 = new Vector2D(receiverImage, wall.p1).normalize()) >= 0.0 ? 1.0 : -1.0;
        int numberOfStep = Math.max(1, (int)(Math.abs(rP0.angleTo(rP1)) / 0.1308996938995747));
        Coordinate lastWallIntersectionPoint = new Coordinate();
        for (int angleStep = 0; angleStep <= numberOfStep; ++angleStep) {
            double wallIntersectionPointDistance;
            Vector2D newPointTranslationVector = rP0.rotate(0.1308996938995747 * angleSign * (double)angleStep);
            if (angleStep == numberOfStep) {
                newPointTranslationVector = rP1;
            } else if (angleStep == 0) {
                newPointTranslationVector = rP0;
            }
            Coordinate newPoint = newPointTranslationVector.translate(receiverImage);
            Coordinate wallIntersectionPoint = Intersection.intersection((Coordinate)wall.p0, (Coordinate)wall.p1, (Coordinate)receiverImage, (Coordinate)newPoint);
            if (wallIntersectionPoint == null || !((wallIntersectionPointDistance = wallIntersectionPoint.distance(receiverImage)) < maximumPropagationDistance)) continue;
            double vectorLength = Math.min(wallIntersectionPointDistance + maximumDistanceFromWall, maximumPropagationDistance);
            newPoint = newPointTranslationVector.multiply(vectorLength).translate(receiverImage);
            if (circleSegmentPoints.isEmpty()) {
                circleSegmentPoints.add(wallIntersectionPoint);
            }
            lastWallIntersectionPoint = wallIntersectionPoint;
            circleSegmentPoints.add(newPoint);
        }
        if (!circleSegmentPoints.isEmpty()) {
            circleSegmentPoints.add(lastWallIntersectionPoint);
            circleSegmentPoints.add((Coordinate)circleSegmentPoints.get(0));
            Coordinate[] conePolygon = circleSegmentPoints.toArray(new Coordinate[0]);
            return factory.createPolygon(conePolygon);
        }
        return factory.createPolygon();
    }

    public MirrorReceiversCompute(List<Wall> buildWalls, Coordinate receiverCoordinates, int reflectionOrder, double maximumPropagationDistance, double maximumDistanceFromWall) {
        GeometryFactory gf = new GeometryFactory();
        this.receiverCoordinate = receiverCoordinates;
        this.buildWalls = buildWalls;
        this.maximumDistanceFromWall = maximumDistanceFromWall;
        this.maximumPropagationDistance = maximumPropagationDistance;
        this.mirrorReceiverTree = new STRtree();
        ArrayList parentsToProcess = new ArrayList();
        for (int currentDepth = 0; currentDepth < reflectionOrder; ++currentDepth) {
            if (currentDepth == 0) {
                parentsToProcess.add(null);
            }
            ArrayList<MirrorReceiver> nextParentsToProcess = new ArrayList<MirrorReceiver>();
            for (MirrorReceiver parent : parentsToProcess) {
                for (Wall wall : buildWalls) {
                    Coordinate receiverImage;
                    if (parent != null && !parent.getImageReceiverVisibilityCone().intersects((Geometry)wall.getLineSegment().toGeometry(new GeometryFactory()))) continue;
                    if (parent != null) {
                        if (wall == parent.getWall()) continue;
                        receiverImage = parent.getReceiverPos();
                    } else {
                        receiverImage = receiverCoordinates;
                    }
                    Coordinate proj = wall.getLineSegment().project(receiverImage);
                    Coordinate rcvMirror = new Coordinate(2.0 * proj.x - receiverImage.x, 2.0 * proj.y - receiverImage.y, receiverImage.z);
                    if (wall.getLineSegment().distance(rcvMirror) > maximumPropagationDistance || wall.getType() == ProfileBuilder.IntersectionType.BUILDING && !MirrorReceiversCompute.wallPointTest(wall.getLineSegment(), receiverImage)) continue;
                    Polygon imageReceiverVisibilityCone = MirrorReceiversCompute.createWallReflectionVisibilityCone(rcvMirror, wall.getLineSegment(), maximumPropagationDistance, maximumDistanceFromWall);
                    MirrorReceiver receiverResultNext = new MirrorReceiver(rcvMirror, parent, wall);
                    receiverResultNext.setImageReceiverVisibilityCone(imageReceiverVisibilityCone);
                    this.mirrorReceiverTree.insert(imageReceiverVisibilityCone.getEnvelopeInternal(), (Object)receiverResultNext.copyWithoutCone());
                    nextParentsToProcess.add(receiverResultNext);
                    ++this.numberOfImageReceivers;
                    if (this.numberOfImageReceivers < this.mirrorReceiverCapacity) continue;
                    return;
                }
            }
            parentsToProcess = nextParentsToProcess;
        }
        this.mirrorReceiverTree.build();
    }

    public static boolean wallPointTest(LineSegment wall1, Coordinate pt) {
        return Orientation.isCCW((Coordinate[])new Coordinate[]{wall1.getCoordinate(0), wall1.getCoordinate(1), pt, wall1.getCoordinate(0)});
    }

    public int getMirrorReceiverCapacity() {
        return this.mirrorReceiverCapacity;
    }

    public void setMirrorReceiverCapacity(int mirrorReceiverCapacity) {
        this.mirrorReceiverCapacity = mirrorReceiverCapacity;
    }

    public void exportVisibility(StringBuilder sb, double maxPropagationDistance, double maxPropagationDistanceFromWall, int t, List<MirrorReceiver> MirrorReceiverList, boolean includeHeader) {
        WKTWriter wktWriter = new WKTWriter();
        GeometryFactory factory = new GeometryFactory();
        if (includeHeader) {
            sb.append("the_geom,type,ref_index,ref_order,wall_id,t\n");
        }
        int refIndex = 0;
        for (MirrorReceiver res : MirrorReceiverList) {
            Polygon visibilityCone = MirrorReceiversCompute.createWallReflectionVisibilityCone(res.getReceiverPos(), res.getWall().getLineSegment(), maxPropagationDistance, maxPropagationDistanceFromWall);
            if (visibilityCone.isEmpty()) continue;
            int refOrder = 1;
            for (MirrorReceiver parent = res.getParentMirror(); parent != null; parent = parent.getParentMirror()) {
                ++refOrder;
            }
            while (res != null) {
                sb.append("\"");
                sb.append(wktWriter.write((Geometry)visibilityCone));
                sb.append("\",0");
                sb.append(",").append(refIndex);
                sb.append(",").append(refOrder);
                sb.append(",").append(res.getWall().getProcessedWallIndex());
                sb.append(",").append(t).append("\n");
                sb.append("\"");
                sb.append(wktWriter.write(factory.createPoint(res.getReceiverPos()).buffer(0.1, 12, 1)));
                sb.append("\",4");
                sb.append(",").append(refIndex);
                sb.append(",").append(refOrder);
                sb.append(",").append(res.getWall().getProcessedWallIndex());
                sb.append(",").append(t).append("\n");
                sb.append("\"");
                sb.append(wktWriter.write(factory.createLineString(new Coordinate[]{res.getWall().p0, res.getWall().p1}).buffer(0.05, 8, 3)));
                sb.append("\",1");
                sb.append(",").append(refIndex);
                sb.append(",").append(refOrder);
                sb.append(",").append(res.getWall().getProcessedWallIndex());
                sb.append(",").append(t).append("\n");
                res = res.getParentMirror();
                if (res != null) {
                    visibilityCone = MirrorReceiversCompute.createWallReflectionVisibilityCone(res.getReceiverPos(), res.getWall().getLineSegment(), maxPropagationDistance, maxPropagationDistanceFromWall);
                }
                --refOrder;
            }
            ++refIndex;
        }
        sb.append("\"");
        sb.append(wktWriter.write(factory.createPoint(this.receiverCoordinate).buffer(0.1, 12, 1)));
        sb.append("\",2");
        sb.append(",").append(t).append("\n");
    }

    public List<MirrorReceiver> findCloseMirrorReceivers(Coordinate sourcePosition) {
        if (Double.isNaN(sourcePosition.z)) {
            throw new IllegalArgumentException("Not supported NaN z value");
        }
        Envelope env = new Envelope(sourcePosition);
        ReceiverImageVisitor receiverImageVisitor = new ReceiverImageVisitor(this.buildWalls, sourcePosition, this.receiverCoordinate, this.maximumDistanceFromWall, this.maximumPropagationDistance);
        this.mirrorReceiverTree.query(env, (ItemVisitor)receiverImageVisitor);
        return receiverImageVisitor.result;
    }

    private static class ReceiverImageVisitor
    implements ItemVisitor {
        List<MirrorReceiver> result = new ArrayList<MirrorReceiver>();
        List<Wall> buildWalls;
        Coordinate source;
        Coordinate receiver;
        LineSegment sourceReceiverSegment;
        double maximumDistanceFromSegment;
        double maximumPropagationDistance;
        int visitedNode = 0;

        public ReceiverImageVisitor(List<Wall> buildWalls, Coordinate source, Coordinate receiver, double maximumDistanceFromSegment, double maximumPropagationDistance) {
            this.buildWalls = buildWalls;
            this.source = source;
            this.receiver = receiver;
            this.sourceReceiverSegment = new LineSegment(source, receiver);
            this.maximumDistanceFromSegment = maximumDistanceFromSegment;
            this.maximumPropagationDistance = maximumPropagationDistance;
        }

        public void visitItem(Object item) {
            ++this.visitedNode;
            MirrorReceiver receiverImage = (MirrorReceiver)item;
            if (receiverImage.getReceiverPos().distance3D(this.source) < this.maximumPropagationDistance) {
                Coordinate reflectionPoint = this.source;
                for (MirrorReceiver currentReceiverImage = receiverImage; currentReceiverImage != null; currentReceiverImage = currentReceiverImage.getParentMirror()) {
                    Wall currentWall = currentReceiverImage.getWall();
                    LineSegment currentWallLineSegment = currentWall.getLineSegment();
                    if (currentWallLineSegment.distance(this.sourceReceiverSegment) > this.maximumDistanceFromSegment) {
                        return;
                    }
                    LineSegment srcMirrRcvLine = new LineSegment(currentReceiverImage.getReceiverPos(), reflectionPoint);
                    RobustLineIntersector li = new RobustLineIntersector();
                    li.computeIntersection(currentWallLineSegment.p0, currentWallLineSegment.p1, srcMirrRcvLine.p0, srcMirrRcvLine.p1);
                    if (!li.hasIntersection()) {
                        return;
                    }
                    reflectionPoint = li.getIntersection(0);
                }
                this.result.add(receiverImage);
            }
        }
    }
}

