/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.profilebuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.Obstruction;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ProfileBuilder;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.Wall;

public class Building
extends Obstruction {
    Polygon poly;
    final double height;
    double minimumZDEM = Double.NaN;
    final boolean zBuildings;
    long primaryKey = -1L;
    List<Wall> walls = new ArrayList<Wall>();

    public Building(Polygon geometry, double height, double g, long pk, boolean zBuildings) {
        this.poly = geometry;
        if (this.poly != null) {
            this.poly.normalize();
        }
        this.height = height;
        this.setG(g);
        this.primaryKey = pk;
        this.zBuildings = zBuildings;
    }

    public void poly2D_3D() {
        Polygon newPoly;
        GeometryFactory f = new GeometryFactory();
        LinearRing shell2D = this.poly.getExteriorRing();
        Coordinate[] newCoordinate = new Coordinate[shell2D.getNumPoints()];
        for (int idCoordinate = 0; idCoordinate < newCoordinate.length; ++idCoordinate) {
            newCoordinate[idCoordinate] = new Coordinate(shell2D.getCoordinateN(idCoordinate).getX(), shell2D.getCoordinateN(idCoordinate).getY(), 0.0);
        }
        LinearRing shell3D = f.createLinearRing(newCoordinate);
        LinearRing[] holes = new LinearRing[this.poly.getNumInteriorRing()];
        for (int idHole = 0; idHole < holes.length; ++idHole) {
            LinearRing lr2D = this.poly.getInteriorRingN(idHole);
            newCoordinate = new Coordinate[lr2D.getNumPoints()];
            for (int idCoordinate = 0; idCoordinate < newCoordinate.length; ++idCoordinate) {
                newCoordinate[idCoordinate] = new Coordinate(lr2D.getCoordinateN(idCoordinate).getX(), lr2D.getCoordinateN(idCoordinate).getY(), 0.0);
            }
            holes[idHole] = f.createLinearRing(newCoordinate);
        }
        this.poly = newPoly = f.createPolygon(shell3D, holes);
    }

    public Building(Polygon poly, double height, List<Double> alphas, long key, boolean zBuildings) {
        this.poly = poly;
        this.poly.normalize();
        this.height = height;
        this.setAlpha(alphas);
        this.primaryKey = key;
        this.zBuildings = zBuildings;
    }

    public double getHeight() {
        return this.height;
    }

    public Polygon getGeometry() {
        return this.poly;
    }

    public long getPrimaryKey() {
        return this.primaryKey;
    }

    public double updateZTopo(ProfileBuilder profileBuilder) {
        Coordinate[] coordinates = this.poly.getBoundary().getCoordinates();
        double minZ = Double.MAX_VALUE;
        AtomicInteger triangleHint = new AtomicInteger(-1);
        for (int i = 0; i < coordinates.length - 1; ++i) {
            minZ = Math.min(minZ, profileBuilder.getZGround(coordinates[i], triangleHint));
        }
        this.minimumZDEM = minZ;
        return this.minimumZDEM;
    }

    public double getZ() {
        if (Double.isNaN(this.minimumZDEM) || Double.isNaN(this.height)) {
            return this.poly.getCoordinate().z;
        }
        return this.minimumZDEM + this.height;
    }

    public void setWalls(List<Wall> walls) {
        this.walls = walls;
    }

    public Collection<? extends Wall> getWalls() {
        return this.walls;
    }
}

