/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.profilebuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.algorithm.CGAlgorithms3D;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.math.Vector2D;
import org.locationtech.jts.math.Vector3D;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.locationtech.jts.triangulate.quadedge.Vertex;
import org.noise_planet.noisemodelling.pathfinder.delaunay.LayerDelaunayError;
import org.noise_planet.noisemodelling.pathfinder.delaunay.LayerTinfour;
import org.noise_planet.noisemodelling.pathfinder.delaunay.Triangle;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.Building;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.BuildingIntersectionPathVisitor;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPoint;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointGroundEffect;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointReceiver;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointSource;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointTopography;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointWall;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutProfile;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ElevationFilter;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.GroundAbsorption;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.Obstruction;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.Wall;
import org.noise_planet.noisemodelling.pathfinder.utils.AcousticIndicatorsFunctions;
import org.noise_planet.noisemodelling.pathfinder.utils.IntegerTuple;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.JTSUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileBuilder {
    public static final double epsilon = 1.0E-7;
    public static final double MILLIMETER = 0.001;
    public static final double LEFT_SIDE = 1.5707963267948966;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileBuilder.class);
    private static final int TREE_NODE_CAPACITY = 5;
    private static final GeometryFactory FACTORY = new GeometryFactory();
    private static final double DELTA = 0.001;
    private boolean isFeedingFinished = false;
    private final Map<Integer, ArrayList<Coordinate>> buildingsWideAnglePoints = new HashMap<Integer, ArrayList<Coordinate>>();
    private int buildingNodeCapacity = 5;
    private int topoNodeCapacity = 5;
    private int groundNodeCapacity = 5;
    private double maxLineLength = 60.0;
    private List<Building> buildings = new ArrayList<Building>();
    private List<Wall> walls = new ArrayList<Wall>();
    private final STRtree buildingTree;
    private STRtree wallTree = new STRtree(5);
    public STRtree rtree;
    private STRtree groundEffectsRtree = new STRtree(5);
    private final List<Coordinate> topoPoints = new ArrayList<Coordinate>();
    private final List<LineString> topoLines = new ArrayList<LineString>();
    private List<Triangle> topoTriangles = new ArrayList<Triangle>();
    private List<Triangle> topoNeighbors = new ArrayList<Triangle>();
    private List<Coordinate> vertices = new ArrayList<Coordinate>();
    private STRtree topoTree;
    private final List<GroundAbsorption> groundAbsorptions = new ArrayList<GroundAbsorption>();
    private final List<Coordinate> receivers = new ArrayList<Coordinate>();
    public final List<Wall> processedWalls = new ArrayList<Wall>();
    private Envelope envelope;
    private boolean zBuildings = false;
    public static final int[] DEFAULT_FREQUENCIES_THIRD_OCTAVE = new int[]{50, 63, 80, 100, 125, 160, 200, 250, 315, 400, 500, 630, 800, 1000, 1250, 1600, 2000, 2500, 3150, 4000, 5000, 6300, 8000, 10000};
    public static final Double[] DEFAULT_FREQUENCIES_EXACT_THIRD_OCTAVE = new Double[]{50.1187234, 63.0957344, 79.4328235, 100.0, 125.892541, 158.489319, 199.526231, 251.188643, 316.227766, 398.107171, 501.187234, 630.957344, 794.328235, 1000.0, 1258.92541, 1584.89319, 1995.26231, 2511.88643, 3162.27766, 3981.07171, 5011.87234, 6309.57344, 7943.28235, 10000.0};
    public static final Double[] DEFAULT_FREQUENCIES_A_WEIGHTING_THIRD_OCTAVE = new Double[]{-30.2, -26.2, -22.5, -19.1, -16.1, -13.4, -10.9, -8.6, -6.6, -4.8, -3.2, -1.9, -0.8, 0.0, 0.6, 1.0, 1.2, 1.3, 1.2, 1.0, 0.5, -0.1, -1.1, -2.5};
    public List<Integer> frequencyArray = Arrays.asList(AcousticIndicatorsFunctions.asOctaveBands(DEFAULT_FREQUENCIES_THIRD_OCTAVE));
    public List<Double> exactFrequencyArray = Arrays.asList(AcousticIndicatorsFunctions.asOctaveBands(DEFAULT_FREQUENCIES_EXACT_THIRD_OCTAVE));
    public List<Double> aWeightingArray = Arrays.asList(AcousticIndicatorsFunctions.asOctaveBands(DEFAULT_FREQUENCIES_A_WEIGHTING_THIRD_OCTAVE));
    public static final double wideAngleTranslationEpsilon = 0.015;

    public ProfileBuilder setzBuildings(boolean zBuildings) {
        this.zBuildings = zBuildings;
        return this;
    }

    public ProfileBuilder() {
        this.buildingTree = new STRtree(this.buildingNodeCapacity);
    }

    public ProfileBuilder(int buildingNodeCapacity, int topoNodeCapacity, int groundNodeCapacity, int maxLineLength) {
        this.buildingNodeCapacity = buildingNodeCapacity;
        this.topoNodeCapacity = topoNodeCapacity;
        this.groundNodeCapacity = groundNodeCapacity;
        this.maxLineLength = maxLineLength;
        this.buildingTree = new STRtree(buildingNodeCapacity);
    }

    public void setFrequencyArray(Collection<Integer> frequencyArray) {
        this.frequencyArray = new ArrayList<Integer>(frequencyArray);
        this.exactFrequencyArray = new ArrayList<Double>();
        this.aWeightingArray = new ArrayList<Double>();
        ProfileBuilder.initializeFrequencyArrayFromReference(this.frequencyArray, this.exactFrequencyArray, this.aWeightingArray);
        for (Wall wall : this.processedWalls) {
            wall.initialize(this.exactFrequencyArray);
        }
        for (Building building : this.buildings) {
            building.initialize(this.exactFrequencyArray);
        }
        for (Wall wall : this.walls) {
            wall.initialize(this.exactFrequencyArray);
        }
    }

    public static void initializeFrequencyArrayFromReference(List<Integer> frequencyArray, List<Double> exactFrequencyArray, List<Double> aWeightingArray) {
        Collections.sort(frequencyArray);
        for (int freq : frequencyArray) {
            int index = Arrays.binarySearch(DEFAULT_FREQUENCIES_THIRD_OCTAVE, freq);
            exactFrequencyArray.add(DEFAULT_FREQUENCIES_EXACT_THIRD_OCTAVE[index]);
            aWeightingArray.add(DEFAULT_FREQUENCIES_A_WEIGHTING_THIRD_OCTAVE[index]);
        }
    }

    public ProfileBuilder addBuilding(Building building) {
        if (building.poly == null || building.poly.isEmpty()) {
            LOGGER.error("Cannot add a building with null or empty geometry.");
        } else {
            if (!this.isFeedingFinished) {
                if (this.envelope == null) {
                    this.envelope = building.poly.getEnvelopeInternal();
                } else {
                    this.envelope.expandToInclude(building.poly.getEnvelopeInternal());
                }
                this.buildings.add(building);
                this.buildingTree.insert(building.poly.getEnvelopeInternal(), (Object)this.buildings.size());
                return this;
            }
            LOGGER.warn("Cannot add building, feeding is finished.");
        }
        return this;
    }

    public ProfileBuilder addBuilding(Geometry geom) {
        return this.addBuilding(geom, -1);
    }

    public ProfileBuilder addBuilding(Coordinate[] coords) {
        return this.addBuilding(coords, -1);
    }

    public ProfileBuilder addBuilding(Geometry geom, double height) {
        return this.addBuilding(geom, height, new ArrayList<Double>());
    }

    public ProfileBuilder addBuilding(Coordinate[] coords, double height) {
        return this.addBuilding(coords, height, -1);
    }

    public ProfileBuilder addBuilding(Geometry geom, int id) {
        return this.addBuilding(geom, Double.NaN, id);
    }

    public ProfileBuilder addBuilding(Coordinate[] coords, int id) {
        return this.addBuilding(coords, Double.NaN, id);
    }

    public ProfileBuilder addBuilding(Geometry geom, double height, int id) {
        return this.addBuilding(geom, height, new ArrayList<Double>(), id);
    }

    public ProfileBuilder addBuilding(Coordinate[] coords, double height, int id) {
        return this.addBuilding(coords, height, new ArrayList<Double>(), id);
    }

    public ProfileBuilder addBuilding(Geometry geom, double height, List<Double> alphas) {
        return this.addBuilding(geom, height, alphas, -1);
    }

    public ProfileBuilder addBuilding(Coordinate[] coords, double height, List<Double> alphas) {
        return this.addBuilding(coords, height, alphas, -1);
    }

    public ProfileBuilder addBuilding(Geometry geom, List<Double> alphas) {
        return this.addBuilding(geom, Double.NaN, alphas, -1);
    }

    public ProfileBuilder addBuilding(Coordinate[] coords, List<Double> alphas) {
        return this.addBuilding(coords, Double.NaN, alphas, -1);
    }

    public ProfileBuilder addBuilding(Geometry geom, List<Double> alphas, int id) {
        return this.addBuilding(geom, Double.NaN, alphas, id);
    }

    public ProfileBuilder addBuilding(Coordinate[] coords, List<Double> alphas, int id) {
        return this.addBuilding(coords, Double.NaN, alphas, id);
    }

    public ProfileBuilder addBuilding(Geometry geom, double height, List<Double> alphas, int id) {
        if (!(geom instanceof Polygon)) {
            LOGGER.error("Building geometry should be Polygon");
            return null;
        }
        Polygon poly = (Polygon)geom;
        this.addBuilding(new Building(poly, height, alphas, (long)id, this.zBuildings));
        return this;
    }

    public ProfileBuilder addBuilding(Coordinate[] coords, double height, List<Double> alphas, int id) {
        Coordinate[] polyCoords;
        int l = coords.length;
        if (!coords[0].equals2D(coords[l - 1])) {
            polyCoords = Arrays.copyOf(coords, l + 1);
            polyCoords[l] = new Coordinate(coords[0]);
        } else {
            polyCoords = coords;
        }
        return this.addBuilding((Geometry)FACTORY.createPolygon(polyCoords), height, alphas, id);
    }

    public ProfileBuilder addWall(LineString geom, double height, int id) {
        return this.addWall(geom, height, new ArrayList<Double>(), id);
    }

    public ProfileBuilder addWall(Coordinate[] coords, double height, int id) {
        return this.addWall(FACTORY.createLineString(coords), height, new ArrayList<Double>(), id);
    }

    public ProfileBuilder addWall(Coordinate[] coords, int id) {
        return this.addWall(FACTORY.createLineString(coords), 0.0, new ArrayList<Double>(), id);
    }

    public ProfileBuilder addWall(Wall wall) {
        this.walls.add(wall);
        this.wallTree.insert(new Envelope(wall.p0, wall.p1), (Object)this.walls.size());
        return this;
    }

    public ProfileBuilder addWall(LineString geom, double height, List<Double> alphas, int id) {
        if (!this.isFeedingFinished) {
            if (this.envelope == null) {
                this.envelope = geom.getEnvelopeInternal();
            } else {
                this.envelope.expandToInclude(geom.getEnvelopeInternal());
            }
            for (int i = 0; i < geom.getNumPoints() - 1; ++i) {
                Wall wall = new Wall(geom.getCoordinateN(i), geom.getCoordinateN(i + 1), id, IntersectionType.BUILDING);
                wall.setHeight(height);
                wall.setAlpha(alphas);
                this.addWall(wall);
            }
            return this;
        }
        LOGGER.warn("Cannot add building, feeding is finished.");
        return null;
    }

    public ProfileBuilder addWall(Coordinate[] coords, double height, List<Double> alphas, int id) {
        return this.addWall(FACTORY.createLineString(coords), height, alphas, id);
    }

    public ProfileBuilder addWall(Coordinate[] coords, List<Double> alphas, int id) {
        return this.addWall(FACTORY.createLineString(coords), 0.0, alphas, id);
    }

    public ProfileBuilder addTopographicPoint(Coordinate point) {
        if (!this.isFeedingFinished) {
            if (Double.isNaN(point.z)) {
                point.setCoordinate(new Coordinate(point.x, point.y, 0.0));
            }
            if (this.envelope == null) {
                this.envelope = new Envelope(point);
            } else {
                this.envelope.expandToInclude(point);
            }
            this.topoPoints.add(point);
        }
        return this;
    }

    public ProfileBuilder addTopographicLine(LineSegment segment) {
        this.addTopographicLine(segment.p0, segment.p1);
        return this;
    }

    public ProfileBuilder addTopographicLine(Coordinate p0, Coordinate p1) {
        this.addTopographicLine(p0.x, p0.y, p0.z, p1.x, p1.y, p1.z);
        return this;
    }

    public ProfileBuilder addTopographicLine(double x0, double y0, double z0, double x1, double y1, double z1) {
        if (!this.isFeedingFinished) {
            LineString lineSegment = FACTORY.createLineString(new Coordinate[]{new Coordinate(x0, y0, z0), new Coordinate(x1, y1, z1)});
            if (this.envelope == null) {
                this.envelope = lineSegment.getEnvelopeInternal();
            } else {
                this.envelope.expandToInclude(lineSegment.getEnvelopeInternal());
            }
            this.topoLines.add(lineSegment);
        }
        return this;
    }

    public ProfileBuilder addTopographicLine(LineString lineSegment) {
        if (!this.isFeedingFinished) {
            if (this.envelope == null) {
                this.envelope = lineSegment.getEnvelopeInternal();
            } else {
                this.envelope.expandToInclude(lineSegment.getEnvelopeInternal());
            }
            this.topoLines.add(lineSegment);
        }
        return this;
    }

    public ProfileBuilder addGroundEffect(Geometry geom, double coefficient) {
        if (!this.isFeedingFinished) {
            if (this.envelope == null) {
                this.envelope = geom.getEnvelopeInternal();
            } else {
                this.envelope.expandToInclude(geom.getEnvelopeInternal());
            }
            this.groundAbsorptions.add(new GroundAbsorption(geom, coefficient));
        }
        return this;
    }

    public ProfileBuilder addGroundEffect(double minX, double maxX, double minY, double maxY, double coefficient) {
        if (!this.isFeedingFinished) {
            Polygon geom = FACTORY.createPolygon(new Coordinate[]{new Coordinate(minX, minY), new Coordinate(minX, maxY), new Coordinate(maxX, maxY), new Coordinate(maxX, minY), new Coordinate(minX, minY)});
            if (this.envelope == null) {
                this.envelope = geom.getEnvelopeInternal();
            } else {
                this.envelope.expandToInclude(geom.getEnvelopeInternal());
            }
            this.groundAbsorptions.add(new GroundAbsorption((Geometry)geom, coefficient));
        }
        return this;
    }

    public List<Wall> getProcessedWalls() {
        return this.processedWalls;
    }

    public List<Building> getBuildings() {
        return this.buildings;
    }

    public int getBuildingCount() {
        return this.buildings.size();
    }

    public Building getBuilding(int id) {
        return this.buildings.get(id);
    }

    public List<Wall> getWalls() {
        return this.walls;
    }

    public int getWallCount() {
        return this.walls.size();
    }

    public Wall getWall(int id) {
        return this.walls.get(id);
    }

    public void clearBuildings() {
        this.buildings.clear();
    }

    public Envelope getMeshEnvelope() {
        return this.envelope;
    }

    public List<Triangle> getTriangles() {
        return this.topoTriangles;
    }

    public List<Coordinate> getVertices() {
        return this.vertices;
    }

    public List<Coordinate> getReceivers() {
        return this.receivers;
    }

    public List<GroundAbsorption> getGroundEffects() {
        return this.groundAbsorptions;
    }

    public ProfileBuilder finishFeeding() {
        int j;
        this.isFeedingFinished = true;
        if (this.topoPoints.size() + this.topoLines.size() > 1) {
            Iterator<Obstruction> layerDelaunay = new LayerTinfour();
            layerDelaunay.setRetrieveNeighbors(true);
            try {
                for (Coordinate topoPoint : this.topoPoints) {
                    layerDelaunay.addVertex(topoPoint);
                }
            }
            catch (LayerDelaunayError e) {
                LOGGER.error("Error while adding topographic points to Delaunay layer.", (Throwable)e);
                return null;
            }
            try {
                for (LineString topoLine : this.topoLines) {
                    layerDelaunay.addLineString(topoLine, -1);
                }
            }
            catch (LayerDelaunayError e) {
                LOGGER.error("Error while adding topographic points to Delaunay layer.", (Throwable)e);
                return null;
            }
            try {
                layerDelaunay.processDelaunay();
            }
            catch (LayerDelaunayError e) {
                LOGGER.error("Error while processing Delaunay.", (Throwable)e);
                return null;
            }
            try {
                this.topoTriangles = layerDelaunay.getTriangles();
                this.topoNeighbors = layerDelaunay.getNeighbors();
            }
            catch (LayerDelaunayError e) {
                LOGGER.error("Error while getting triangles", (Throwable)e);
                return null;
            }
            this.topoTree = new STRtree(this.topoNodeCapacity);
            try {
                this.vertices = layerDelaunay.getVertices();
            }
            catch (LayerDelaunayError e) {
                LOGGER.error("Error while getting vertices", (Throwable)e);
                return null;
            }
            HashSet<IntegerTuple> wallIndex = new HashSet<IntegerTuple>();
            for (int i = 0; i < this.topoTriangles.size(); ++i) {
                Triangle tri = this.topoTriangles.get(i);
                wallIndex.add(new IntegerTuple(tri.getA(), tri.getB(), i));
                wallIndex.add(new IntegerTuple(tri.getB(), tri.getC(), i));
                wallIndex.add(new IntegerTuple(tri.getC(), tri.getA(), i));
                Coordinate vA = this.vertices.get(tri.getA());
                Coordinate vB = this.vertices.get(tri.getB());
                Coordinate vC = this.vertices.get(tri.getC());
                Envelope env = FACTORY.createLineString(new Coordinate[]{vA, vB, vC}).getEnvelopeInternal();
                this.topoTree.insert(env, (Object)i);
            }
            this.topoTree.build();
        }
        if (this.topoTree != null) {
            for (Building b : this.buildings) {
                if (!Double.isNaN(b.poly.getCoordinate().z) && b.poly.getCoordinate().z != 0.0 && this.zBuildings) continue;
                b.poly2D_3D();
                b.poly.apply((CoordinateSequenceFilter)new ElevationFilter.UpdateZ(b.height + b.updateZTopo(this)));
            }
            for (Wall w : this.walls) {
                if (Double.isNaN(w.p0.z) || w.p0.z == 0.0) {
                    w.p0.z = w.height + this.getZGround(w.p0);
                }
                if (!Double.isNaN(w.p1.z) && w.p1.z != 0.0) continue;
                w.p1.z = w.height + this.getZGround(w.p1);
            }
        } else {
            for (Building b : this.buildings) {
                if (b == null || b.poly == null || b.poly.getCoordinate() == null || this.zBuildings && !Double.isNaN(b.poly.getCoordinate().z) && b.poly.getCoordinate().z != 0.0) continue;
                b.poly2D_3D();
                b.poly.apply((CoordinateSequenceFilter)new ElevationFilter.UpdateZ(b.height));
            }
            for (Wall w : this.walls) {
                if (Double.isNaN(w.p0.z) || w.p0.z == 0.0) {
                    w.p0.z = w.height;
                }
                if (!Double.isNaN(w.p1.z) && w.p1.z != 0.0) continue;
                w.p1.z = w.height;
            }
        }
        this.rtree = new STRtree(this.buildingNodeCapacity);
        this.buildingsWideAnglePoints.clear();
        for (j = 0; j < this.buildings.size(); ++j) {
            Building building = this.buildings.get(j);
            this.buildingsWideAnglePoints.put(j + 1, this.getWideAnglePointsOnPolygon(building.poly.getExteriorRing(), 0.0, Math.PI * 2));
            ArrayList<Wall> walls = new ArrayList<Wall>();
            Coordinate[] coords = building.poly.getCoordinates();
            for (int i = 0; i < coords.length - 1; ++i) {
                LineSegment lineSegment = new LineSegment(coords[i], coords[i + 1]);
                Wall w = new Wall(lineSegment, j, IntersectionType.BUILDING).setProcessedWallIndex(this.processedWalls.size());
                walls.add(w);
                w.setPrimaryKey(building.getPrimaryKey());
                w.copyAlphas(building);
                this.processedWalls.add(w);
                this.rtree.insert(lineSegment.toGeometry(FACTORY).getEnvelopeInternal(), (Object)(this.processedWalls.size() - 1));
            }
            building.setWalls(walls);
        }
        for (j = 0; j < this.walls.size(); ++j) {
            Wall wall = this.walls.get(j);
            Coordinate[] coords = new Coordinate[]{wall.p0, wall.p1};
            for (int i = 0; i < coords.length - 1; ++i) {
                LineSegment lineSegment = new LineSegment(coords[i], coords[i + 1]);
                Wall w = new Wall(lineSegment, j, IntersectionType.WALL).setProcessedWallIndex(this.processedWalls.size());
                w.copyAlphas(wall);
                w.setPrimaryKey(wall.primaryKey);
                this.processedWalls.add(w);
                this.rtree.insert(lineSegment.toGeometry(FACTORY).getEnvelopeInternal(), (Object)(this.processedWalls.size() - 1));
            }
        }
        this.buildings = Collections.unmodifiableList(this.buildings);
        this.walls = Collections.unmodifiableList(this.walls);
        this.groundEffectsRtree = new STRtree(5);
        for (j = 0; j < this.groundAbsorptions.size(); ++j) {
            GroundAbsorption effect = this.groundAbsorptions.get(j);
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            if (effect.geom instanceof Polygon) {
                polygons.add((Polygon)effect.geom);
            }
            if (effect.geom instanceof MultiPolygon) {
                MultiPolygon multi = (MultiPolygon)effect.geom;
                for (int i = 0; i < multi.getNumGeometries(); ++i) {
                    polygons.add((Polygon)multi.getGeometryN(i));
                }
            }
            for (Polygon poly : polygons) {
                this.groundEffectsRtree.insert(poly.getEnvelopeInternal(), (Object)j);
                Coordinate[] coords = poly.getCoordinates();
                for (int k = 0; k < coords.length - 1; ++k) {
                    LineSegment line = new LineSegment(coords[k], coords[k + 1]);
                    this.processedWalls.add(new Wall(line, j, IntersectionType.GROUND_EFFECT).setProcessedWallIndex(this.processedWalls.size()));
                    this.rtree.insert(new Envelope(line.p0, line.p1), (Object)(this.processedWalls.size() - 1));
                }
            }
        }
        this.rtree.build();
        this.groundEffectsRtree.build();
        this.setFrequencyArray(this.frequencyArray);
        return this;
    }

    public double getZ(Coordinate reflectionPt) {
        List ids = this.buildingTree.query(new Envelope(reflectionPt));
        if (ids.isEmpty()) {
            return this.getZGround(reflectionPt);
        }
        for (Integer id : ids) {
            Polygon buildingGeometry = this.buildings.get(id - 1).getGeometry();
            if (!buildingGeometry.getEnvelopeInternal().intersects(reflectionPt)) continue;
            return buildingGeometry.getCoordinate().z;
        }
        return this.getZGround(reflectionPt);
    }

    public List<Wall> getWallsIn(Envelope env) {
        ArrayList<Wall> list = new ArrayList<Wall>();
        List indexes = this.rtree.query(env);
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Wall w = this.getProcessedWalls().get(i);
            if (!w.getType().equals((Object)IntersectionType.BUILDING) && !w.getType().equals((Object)IntersectionType.WALL)) continue;
            list.add(w);
        }
        return list;
    }

    public CutProfile getProfile(Coordinate c0, Coordinate c1) {
        return this.getProfile(c0, c1, 0.0, false);
    }

    public static List<LineSegment> splitSegment(Coordinate c0, Coordinate c1, double maxLineLength) {
        ArrayList<LineSegment> lines = new ArrayList<LineSegment>();
        LineSegment fullLine = new LineSegment(c0, c1);
        double l = c0.distance(c1);
        if (l < maxLineLength) {
            lines.add(fullLine);
        } else {
            double frac = maxLineLength / l;
            int i = 0;
            while ((double)i < l / maxLineLength) {
                Coordinate p0 = fullLine.pointAlong((double)i * frac);
                p0.z = c0.z + (c1.z - c0.z) * (double)i * frac;
                Coordinate p1 = fullLine.pointAlong(Math.min((double)(i + 1) * frac, 1.0));
                p1.z = c0.z + (c1.z - c0.z) * Math.min((double)(i + 1) * frac, 1.0);
                lines.add(new LineSegment(p0, p1));
                ++i;
            }
        }
        return lines;
    }

    public CutProfile getProfile(Coordinate sourceCoordinate, Coordinate receiverCoordinate, double defaultGroundAttenuation, boolean stopAtObstacleOverSourceReceiver) {
        CutPointSource sourcePoint = new CutPointSource(sourceCoordinate);
        CutPointReceiver receiverPoint = new CutPointReceiver(receiverCoordinate);
        CutProfile profile = new CutProfile(sourcePoint, receiverPoint);
        int groundAbsorptionIndex = this.getIntersectingGroundAbsorption((Geometry)FACTORY.createPoint(sourceCoordinate));
        if (groundAbsorptionIndex >= 0) {
            sourcePoint.setGroundCoefficient(this.groundAbsorptions.get(groundAbsorptionIndex).getCoefficient());
        } else {
            sourcePoint.setGroundCoefficient(defaultGroundAttenuation);
        }
        if (this.topoTree != null) {
            this.addTopoCutPts(sourceCoordinate, receiverCoordinate, profile, stopAtObstacleOverSourceReceiver);
            if (stopAtObstacleOverSourceReceiver && profile.hasTopographyIntersection) {
                return profile;
            }
        } else {
            profile.getSource().zGround = 0.0;
            profile.getReceiver().zGround = 0.0;
        }
        if (this.rtree != null) {
            LineSegment fullLine = new LineSegment(sourceCoordinate, receiverCoordinate);
            this.addGroundBuildingCutPts(fullLine, profile, stopAtObstacleOverSourceReceiver);
            if (stopAtObstacleOverSourceReceiver && profile.hasBuildingIntersection) {
                return profile;
            }
        }
        double currentCoefficient = sourcePoint.groundCoefficient;
        for (CutPoint cutPoint : profile.cutPoints) {
            if (Double.isNaN(cutPoint.groundCoefficient)) {
                cutPoint.setGroundCoefficient(currentCoefficient);
                continue;
            }
            if (!(cutPoint instanceof CutPointGroundEffect)) continue;
            currentCoefficient = cutPoint.getGroundCoefficient();
        }
        CutPoint previousZGround = sourcePoint;
        int nextPointIndex = 0;
        for (int pointIndex = 1; pointIndex < profile.cutPoints.size() - 1; ++pointIndex) {
            CutPoint cutPoint = profile.cutPoints.get(pointIndex);
            if (Double.isNaN(cutPoint.zGround)) {
                if (nextPointIndex <= pointIndex) {
                    for (int i = pointIndex + 1; i < profile.cutPoints.size(); ++i) {
                        CutPoint nextPoint = profile.cutPoints.get(i);
                        if (Double.isNaN(nextPoint.zGround)) continue;
                        nextPointIndex = i;
                        break;
                    }
                }
                CutPoint nextPoint = profile.cutPoints.get(nextPointIndex);
                cutPoint.zGround = Vertex.interpolateZ((Coordinate)cutPoint.coordinate, (Coordinate)new Coordinate(previousZGround.coordinate.x, previousZGround.coordinate.y, previousZGround.getzGround().doubleValue()), (Coordinate)new Coordinate(nextPoint.coordinate.x, nextPoint.coordinate.y, nextPoint.getzGround().doubleValue()));
                if (!Double.isNaN(cutPoint.coordinate.z) && !(cutPoint instanceof CutPointGroundEffect)) continue;
                cutPoint.coordinate.setZ(cutPoint.zGround);
                continue;
            }
            previousZGround = cutPoint;
        }
        return profile;
    }

    public int getIntersectingGroundAbsorption(Geometry query) {
        if (this.groundEffectsRtree != null) {
            List res = this.groundEffectsRtree.query(query.getEnvelopeInternal());
            for (Object groundEffectAreaIndex : res) {
                if (!(groundEffectAreaIndex instanceof Integer)) continue;
                GroundAbsorption groundAbsorption = this.groundAbsorptions.get((Integer)groundEffectAreaIndex);
                if (!groundAbsorption.geom.intersects(query)) continue;
                return (Integer)groundEffectAreaIndex;
            }
        }
        return -1;
    }

    private boolean processWall(int processedWallIndex, Coordinate intersection, Wall facetLine, LineSegment fullLine, List<CutPoint> newCutPoints, boolean stopAtObstacleOverSourceReceiver, CutProfile profile) {
        CutPointWall cutPointWall = new CutPointWall(processedWallIndex, intersection, facetLine.getLineSegment(), facetLine.getAlphas());
        cutPointWall.intersectionType = CutPointWall.INTERSECTION_TYPE.THIN_WALL_ENTER_EXIT;
        if (facetLine.primaryKey >= 0L) {
            cutPointWall.setPk(facetLine.primaryKey);
        }
        newCutPoints.add(cutPointWall);
        double zRayReceiverSource = Vertex.interpolateZ((Coordinate)intersection, (Coordinate)fullLine.p0, (Coordinate)fullLine.p1);
        if (zRayReceiverSource <= intersection.z) {
            profile.hasBuildingIntersection = true;
            return !stopAtObstacleOverSourceReceiver;
        }
        return true;
    }

    private boolean processBuilding(int processedWallIndex, Coordinate intersection, Wall facetLine, LineSegment fullLine, List<CutPoint> newCutPoints, boolean stopAtObstacleOverSourceReceiver, CutProfile profile) {
        CutPointWall wallCutPoint = new CutPointWall(processedWallIndex, intersection, facetLine.getLineSegment(), facetLine.getAlphas());
        if (facetLine.primaryKey >= 0L) {
            wallCutPoint.setPk(facetLine.primaryKey);
        }
        newCutPoints.add(wallCutPoint);
        double zRayReceiverSource = Vertex.interpolateZ((Coordinate)intersection, (Coordinate)fullLine.p0, (Coordinate)fullLine.p1);
        Vector2D facetVector = Vector2D.create((Coordinate)facetLine.p0, (Coordinate)facetLine.p1);
        Vector2D exteriorVector = facetVector.rotate(1.5707963267948966).normalize().multiply(0.001);
        Coordinate exteriorPoint = exteriorVector.add(Vector2D.create((Coordinate)intersection)).toCoordinate();
        wallCutPoint.intersectionType = exteriorPoint.distance(fullLine.p0) < intersection.distance(fullLine.p0) ? CutPointWall.INTERSECTION_TYPE.BUILDING_ENTER : CutPointWall.INTERSECTION_TYPE.BUILDING_EXIT;
        if (zRayReceiverSource <= intersection.z) {
            profile.hasBuildingIntersection = true;
            return !stopAtObstacleOverSourceReceiver;
        }
        return true;
    }

    private boolean processGroundEffect(int processedWallIndex, Coordinate intersection, Wall facetLine, LineSegment fullLine, List<CutPoint> newCutPoints, boolean stopAtObstacleOverSourceReceiver, CutProfile profile) {
        Vector2D directionAfter = Vector2D.create((Coordinate)fullLine.p0, (Coordinate)fullLine.p1).normalize().multiply(0.001);
        Point afterIntersectionPoint = FACTORY.createPoint(Vector2D.create((Coordinate)intersection).add(directionAfter).toCoordinate());
        GroundAbsorption groundAbsorption = this.groundAbsorptions.get(facetLine.getOriginId());
        if (groundAbsorption.geom.intersects((Geometry)afterIntersectionPoint)) {
            newCutPoints.add(new CutPointGroundEffect(processedWallIndex, intersection, groundAbsorption.getCoefficient()));
        } else {
            int groundSurfaceIndex = this.getIntersectingGroundAbsorption((Geometry)afterIntersectionPoint);
            if (groundSurfaceIndex == -1) {
                newCutPoints.add(new CutPointGroundEffect(-1, intersection, 0.0));
            } else {
                GroundAbsorption nextGroundAbsorption = this.groundAbsorptions.get(groundSurfaceIndex);
                if (!nextGroundAbsorption.geom.touches(groundAbsorption.geom)) {
                    newCutPoints.add(new CutPointGroundEffect(groundSurfaceIndex, afterIntersectionPoint.getCoordinate(), nextGroundAbsorption.getCoefficient()));
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGroundBuildingCutPts(LineSegment fullLine, CutProfile profile, boolean stopAtObstacleOverSourceReceiver) {
        HashSet<Integer> processed = new HashSet<Integer>();
        List<LineSegment> lines = ProfileBuilder.splitSegment(fullLine.p0, fullLine.p1, this.maxLineLength);
        LinkedList<CutPoint> newCutPoints = new LinkedList<CutPoint>();
        try {
            for (int j = 0; !(j >= lines.size() || profile.hasBuildingIntersection && stopAtObstacleOverSourceReceiver); ++j) {
                LineSegment line = lines.get(j);
                for (Object result : this.rtree.query(new Envelope(line.p0, line.p1))) {
                    if (!(result instanceof Integer) || processed.contains((Integer)result)) continue;
                    processed.add((Integer)result);
                    int i = (Integer)result;
                    Wall facetLine = this.processedWalls.get(i);
                    Coordinate intersection = fullLine.intersection(facetLine.ls);
                    if (intersection == null) continue;
                    intersection = new Coordinate(intersection);
                    if (!Double.isNaN(facetLine.p0.z) && !Double.isNaN(facetLine.p1.z)) {
                        intersection.z = Double.compare(facetLine.p0.z, facetLine.p1.z) == 0 ? facetLine.p0.z : Vertex.interpolateZ((Coordinate)intersection, (Coordinate)facetLine.p0, (Coordinate)facetLine.p1);
                    }
                    switch (facetLine.type) {
                        case BUILDING: {
                            if (this.processBuilding(i, intersection, facetLine, fullLine, newCutPoints, stopAtObstacleOverSourceReceiver, profile)) break;
                            return;
                        }
                        case WALL: {
                            if (this.processWall(i, intersection, facetLine, fullLine, newCutPoints, stopAtObstacleOverSourceReceiver, profile)) break;
                            return;
                        }
                        case GROUND_EFFECT: {
                            if (this.processGroundEffect(i, intersection, facetLine, fullLine, newCutPoints, stopAtObstacleOverSourceReceiver, profile)) break;
                            return;
                        }
                    }
                }
            }
        }
        finally {
            profile.insertCutPoint(true, (CutPoint[])newCutPoints.toArray(CutPoint[]::new));
        }
    }

    Coordinate[] getTriangleVertices(int triIndex) {
        Triangle tri = this.topoTriangles.get(triIndex);
        return new Coordinate[]{this.vertices.get(tri.getA()), this.vertices.get(tri.getB()), this.vertices.get(tri.getC())};
    }

    private int getNextTri(int triIndex, LineSegment propagationLine, HashSet<Integer> navigationHistory, Coordinate segmentIntersection) {
        double distline_line;
        Coordinate intersectionTest;
        Coordinate[] closestPoints;
        LineSegment triSegment;
        Triangle tri = this.topoTriangles.get(triIndex);
        Triangle triNeighbors = this.topoNeighbors.get(triIndex);
        int nearestIntersectionSide = -1;
        double nearestIntersectionPtDist = Double.MAX_VALUE;
        Coordinate aTri = this.vertices.get(tri.getA());
        Coordinate bTri = this.vertices.get(tri.getB());
        Coordinate cTri = this.vertices.get(tri.getC());
        int idNeighbor = triNeighbors.get(2);
        if (!navigationHistory.contains(idNeighbor)) {
            triSegment = new LineSegment(aTri, bTri);
            closestPoints = propagationLine.closestPoints(triSegment);
            intersectionTest = null;
            if (closestPoints.length == 2 && closestPoints[0].distance(closestPoints[1]) < 1.0E-7) {
                intersectionTest = new Coordinate(closestPoints[0].x, closestPoints[0].y, Vertex.interpolateZ((Coordinate)closestPoints[0], (Coordinate)triSegment.p0, (Coordinate)triSegment.p1));
            }
            if (intersectionTest != null && (distline_line = propagationLine.p1.distance(intersectionTest)) < nearestIntersectionPtDist) {
                segmentIntersection.setCoordinate(intersectionTest);
                nearestIntersectionPtDist = distline_line;
                nearestIntersectionSide = 2;
            }
        }
        if (!navigationHistory.contains(idNeighbor = triNeighbors.get(0))) {
            triSegment = new LineSegment(bTri, cTri);
            closestPoints = propagationLine.closestPoints(triSegment);
            intersectionTest = null;
            if (closestPoints.length == 2 && closestPoints[0].distance(closestPoints[1]) < 1.0E-7) {
                intersectionTest = new Coordinate(closestPoints[0].x, closestPoints[0].y, Vertex.interpolateZ((Coordinate)closestPoints[0], (Coordinate)triSegment.p0, (Coordinate)triSegment.p1));
            }
            if (intersectionTest != null && (distline_line = propagationLine.p1.distance(intersectionTest)) < nearestIntersectionPtDist) {
                segmentIntersection.setCoordinate(intersectionTest);
                nearestIntersectionPtDist = distline_line;
                nearestIntersectionSide = 0;
            }
        }
        if (!navigationHistory.contains(idNeighbor = triNeighbors.get(1))) {
            triSegment = new LineSegment(cTri, aTri);
            closestPoints = propagationLine.closestPoints(triSegment);
            intersectionTest = null;
            if (closestPoints.length == 2 && closestPoints[0].distance(closestPoints[1]) < 1.0E-7) {
                intersectionTest = new Coordinate(closestPoints[0].x, closestPoints[0].y, Vertex.interpolateZ((Coordinate)closestPoints[0], (Coordinate)triSegment.p0, (Coordinate)triSegment.p1));
            }
            if (intersectionTest != null && (distline_line = propagationLine.p1.distance(intersectionTest)) < nearestIntersectionPtDist) {
                segmentIntersection.setCoordinate(intersectionTest);
                nearestIntersectionSide = 1;
            }
        }
        if (nearestIntersectionSide > -1) {
            return triNeighbors.get(nearestIntersectionSide);
        }
        return -1;
    }

    Coordinate[] getTriangle(int triIndex) {
        Triangle tri = this.topoTriangles.get(triIndex);
        return new Coordinate[]{this.vertices.get(tri.getA()), this.vertices.get(tri.getB()), this.vertices.get(tri.getC())};
    }

    Coordinate[] getClosedTriangle(int triIndex) {
        Triangle tri = this.topoTriangles.get(triIndex);
        return new Coordinate[]{this.vertices.get(tri.getA()), this.vertices.get(tri.getB()), this.vertices.get(tri.getC()), this.vertices.get(tri.getA())};
    }

    public int getTriangleIdByCoordinate(Coordinate pt) {
        Envelope ptEnv = new Envelope(pt);
        ptEnv.expandBy(1.0);
        List res = this.topoTree.query(new Envelope(ptEnv));
        double minDistance = Double.MAX_VALUE;
        int minDistanceTriangle = -1;
        for (Object objInd : res) {
            int triId = (Integer)objInd;
            Coordinate[] tri = this.getTriangle(triId);
            AtomicReference<Double> err = new AtomicReference<Double>(0.0);
            JTSUtility.dotInTri(pt, tri[0], tri[1], tri[2], err);
            if (!(err.get() < minDistance)) continue;
            minDistance = err.get();
            minDistanceTriangle = triId;
        }
        return minDistanceTriangle;
    }

    public void addTopoCutPts(Coordinate p1, Coordinate p2, CutProfile profile, boolean stopAtObstacleOverSourceReceiver) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        boolean freeField = this.fetchTopographicProfile(coordinates, p1, p2, stopAtObstacleOverSourceReceiver);
        if (coordinates.size() < 2) {
            LOGGER.warn(String.format(Locale.ROOT, "Propagation out of the DEM area from %s to %s", p1.toString(), p2.toString()));
            return;
        }
        profile.getSource().zGround = ((Coordinate)coordinates.get((int)0)).z;
        profile.getReceiver().zGround = ((Coordinate)coordinates.get((int)(coordinates.size() - 1))).z;
        profile.hasTopographyIntersection = !freeField;
        ArrayList<CutPointTopography> topographyList = new ArrayList<CutPointTopography>(coordinates.size());
        for (int idPoint = 1; idPoint < coordinates.size() - 1; ++idPoint) {
            Coordinate next;
            Coordinate previous = (Coordinate)coordinates.get(idPoint - 1);
            Coordinate current = (Coordinate)coordinates.get(idPoint);
            if (!(CGAlgorithms3D.distancePointSegment((Coordinate)current, (Coordinate)previous, (Coordinate)(next = (Coordinate)coordinates.get(idPoint + 1))) >= 0.001)) continue;
            topographyList.add(new CutPointTopography(current));
        }
        profile.insertCutPoint(true, (CutPoint[])topographyList.toArray(CutPoint[]::new));
    }

    boolean findClosestTriangleIntersection(LineSegment segment, Coordinate intersection, AtomicInteger intersectionTriangle) {
        Envelope queryEnvelope = new Envelope(segment.p0);
        queryEnvelope.expandToInclude(segment.p1);
        if (queryEnvelope.getHeight() < 1.0 || queryEnvelope.getWidth() < 1.0) {
            queryEnvelope.expandBy(1.0);
        }
        List res = this.topoTree.query(queryEnvelope);
        double minDistance = Double.MAX_VALUE;
        int minDistanceTriangle = -1;
        GeometryFactory factory = new GeometryFactory();
        LineString lineString = factory.createLineString(new Coordinate[]{segment.p0, segment.p1});
        Coordinate intersectionPt = null;
        for (Object objInd : res) {
            Coordinate[] nearestCoordinates;
            int triId = (Integer)objInd;
            Coordinate[] tri = this.getTriangle(triId);
            Polygon triangleGeometry = factory.createPolygon(new Coordinate[]{tri[0], tri[1], tri[2], tri[0]});
            if (!triangleGeometry.intersects((Geometry)lineString)) continue;
            for (Coordinate nearestCoordinate : nearestCoordinates = DistanceOp.nearestPoints((Geometry)triangleGeometry, (Geometry)lineString)) {
                double distance = nearestCoordinate.distance(segment.p0);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                minDistanceTriangle = triId;
                intersectionPt = nearestCoordinate;
            }
        }
        if (minDistanceTriangle != -1) {
            Coordinate[] tri = this.getTriangle(minDistanceTriangle);
            intersectionPt.setZ(Vertex.interpolateZ(intersectionPt, (Coordinate)tri[0], (Coordinate)tri[1], (Coordinate)tri[2]));
            intersection.setCoordinate(intersectionPt);
            intersectionTriangle.set(minDistanceTriangle);
            return true;
        }
        return false;
    }

    public boolean fetchTopographicProfile(List<Coordinate> outputPoints, Coordinate p1, Coordinate p2, boolean stopAtObstacleOverSourceReceiver) {
        Coordinate[] triangleVertex;
        if (this.topoTree == null) {
            return true;
        }
        int curTriP1 = this.getTriangleIdByCoordinate(p1);
        LineSegment propaLine = new LineSegment(p1, p2);
        if (curTriP1 == -1) {
            Coordinate intersectionPt = new Coordinate();
            AtomicInteger minDistanceTriangle = new AtomicInteger();
            if (this.findClosestTriangleIntersection(propaLine, intersectionPt, minDistanceTriangle)) {
                triangleVertex = this.getTriangleVertices(minDistanceTriangle.get());
                outputPoints.add(new Coordinate(p1.x, p1.y, Vertex.interpolateZ((Coordinate)p2, (Coordinate)triangleVertex[0], (Coordinate)triangleVertex[1], (Coordinate)triangleVertex[2])));
                curTriP1 = minDistanceTriangle.get();
            } else {
                return true;
            }
        }
        HashSet<Integer> navigationHistory = new HashSet<Integer>();
        int navigationTri = curTriP1;
        triangleVertex = this.getTriangleVertices(curTriP1);
        outputPoints.add(new Coordinate(p1.x, p1.y, Vertex.interpolateZ((Coordinate)p1, (Coordinate)triangleVertex[0], (Coordinate)triangleVertex[1], (Coordinate)triangleVertex[2])));
        boolean freeField = true;
        while (navigationTri != -1) {
            navigationHistory.add(navigationTri);
            Coordinate intersectionPt = new Coordinate();
            int propaTri = this.getNextTri(navigationTri, propaLine, navigationHistory, intersectionPt);
            if (propaTri == -1) {
                triangleVertex = this.getTriangleVertices(navigationTri);
                outputPoints.add(new Coordinate(p2.x, p2.y, Vertex.interpolateZ((Coordinate)p2, (Coordinate)triangleVertex[0], (Coordinate)triangleVertex[1], (Coordinate)triangleVertex[2])));
            } else if (!Double.isNaN(intersectionPt.z)) {
                outputPoints.add(intersectionPt);
                Coordinate closestPointOnPropagationLine = propaLine.closestPoint(intersectionPt);
                double interpolatedZ = Vertex.interpolateZ((Coordinate)closestPointOnPropagationLine, (Coordinate)propaLine.p0, (Coordinate)propaLine.p1);
                if (interpolatedZ < intersectionPt.z) {
                    freeField = false;
                    if (stopAtObstacleOverSourceReceiver) {
                        return false;
                    }
                }
            }
            navigationTri = propaTri;
        }
        return freeField;
    }

    private double computeNormalsAngle(Vector3D normal1, Vector3D normal2) {
        return Math.acos(normal1.dot(normal2));
    }

    public boolean hasDem() {
        return this.topoTree != null && !this.topoTree.isEmpty();
    }

    public MultiPolygon demAsMultiPolygon() {
        GeometryFactory GF = new GeometryFactory();
        if (!this.topoTriangles.isEmpty()) {
            ArrayList<Polygon> polyTri = new ArrayList<Polygon>(this.topoTriangles.size());
            for (int i = 0; i < this.topoTriangles.size(); ++i) {
                polyTri.add(GF.createPolygon(this.getClosedTriangle(i)));
            }
            return GF.createMultiPolygon((Polygon[])polyTri.toArray(Polygon[]::new));
        }
        return GF.createMultiPolygon();
    }

    public double getZGround(Coordinate coordinate) {
        return this.getZGround(coordinate, new AtomicInteger(-1));
    }

    public double getZGround(Coordinate coordinate, AtomicInteger triangleHint) {
        Coordinate p3;
        Coordinate p2;
        Triangle tri;
        Coordinate p1;
        if (this.topoTree == null) {
            return 0.0;
        }
        int i = triangleHint.get();
        if (i >= 0 && i < this.topoTriangles.size() && !JTSUtility.dotInTri(coordinate, p1 = this.vertices.get((tri = this.topoTriangles.get(i)).getA()), p2 = this.vertices.get(tri.getB()), p3 = this.vertices.get(tri.getC()))) {
            i = -1;
        }
        if (i < 0 && (i = this.getTriangleIdByCoordinate(coordinate)) == -1) {
            return 0.0;
        }
        tri = this.topoTriangles.get(i);
        p1 = this.vertices.get(tri.getA());
        if (JTSUtility.dotInTri(coordinate, p1, p2 = this.vertices.get(tri.getB()), p3 = this.vertices.get(tri.getC()))) {
            triangleHint.set(i);
            return Vertex.interpolateZ((Coordinate)coordinate, (Coordinate)p1, (Coordinate)p2, (Coordinate)p3);
        }
        return 0.0;
    }

    public ArrayList<Coordinate> getPrecomputedWideAnglePoints(int build) {
        return this.buildingsWideAnglePoints.get(build);
    }

    public ArrayList<Coordinate> getWideAnglePointsOnPolygon(LinearRing linearRing, double minAngle, double maxAngle) {
        Coordinate[] ring = (Coordinate[])linearRing.getCoordinates().clone();
        if (!Orientation.isCCW((Coordinate[])ring)) {
            for (int i = 0; i < ring.length / 2; ++i) {
                Coordinate temp = ring[i];
                ring[i] = ring[ring.length - 1 - i];
                ring[ring.length - 1 - i] = temp;
            }
        }
        ArrayList<Coordinate> verticesBuilding = new ArrayList<Coordinate>(ring.length);
        for (int i = 0; i < ring.length - 1; ++i) {
            int i3;
            int i1 = i > 0 ? i - 1 : ring.length - 2;
            double smallestAngle = Angle.angleBetweenOriented((Coordinate)ring[i1], (Coordinate)ring[i], (Coordinate)ring[i3 = i + 1]);
            double openAngle = smallestAngle >= 0.0 ? smallestAngle : Math.PI * 2 + smallestAngle;
            if (!(openAngle > minAngle) || !(openAngle < maxAngle)) continue;
            double midAngle = openAngle / 2.0;
            double midAngleFromZero = Angle.angle((Coordinate)ring[i], (Coordinate)ring[i1]) + midAngle;
            Coordinate offsetPt = new Coordinate(ring[i].x + Math.cos(midAngleFromZero) * 0.015, ring[i].y + Math.sin(midAngleFromZero) * 0.015, ring[i].z + 0.015);
            verticesBuilding.add(offsetPt);
        }
        verticesBuilding.add((Coordinate)verticesBuilding.get(0));
        return verticesBuilding;
    }

    public void getWallsOnPath(Coordinate p1, Coordinate p2, BuildingIntersectionPathVisitor visitor) {
        try {
            List<LineSegment> lines = ProfileBuilder.splitSegment(p1, p2, this.maxLineLength);
            for (LineSegment segment : lines) {
                visitor.setIntersectionLine(segment);
                Envelope pathEnv = new Envelope(segment.p0, segment.p1);
                this.rtree.query(pathEnv, (ItemVisitor)visitor);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static enum IntersectionType {
        BUILDING,
        WALL,
        TOPOGRAPHY,
        GROUND_EFFECT,
        SOURCE,
        RECEIVER,
        REFLECTION,
        V_EDGE_DIFFRACTION;

    }
}

