/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.profilebuilder;

import org.noise_planet.noisemodelling.pathfinder.utils.ComplexNumber;

public class WallAbsorption {
    public static double getWallAlpha(double wallAlpha, double freq_lvl) {
        double value = wallAlpha >= 0.0 && wallAlpha <= 1.0 ? wallAlpha : WallAbsorption.GetWallImpedance(Math.min(20000.0, Math.max(20.0, wallAlpha)), freq_lvl);
        return value;
    }

    public static double GetWallImpedance(double sigma, double freq_l) {
        double s = Math.log(freq_l / sigma);
        double x = 1.0 + 9.08 * Math.exp(-0.75 * s);
        double y = 11.9 * Math.exp(-0.73 * s);
        ComplexNumber Z = new ComplexNumber(x, y);
        return WallAbsorption.GetTrueWallAlpha(Z);
    }

    static double GetTrueWallAlpha(ComplexNumber impedance) {
        ComplexNumber z = ComplexNumber.divide(new ComplexNumber(1.0, 0.0), impedance);
        double x = z.getRe();
        double y = z.getIm();
        double a1 = (x * x - y * y) / y;
        double a2 = y / (x * x + y * y + x);
        double a3 = ((x + 1.0) * (x + 1.0) + y * y) / (x * x + y * y);
        double alpha = 8.0 * x * (1.0 + a1 * Math.atan(a2) - x * Math.log(a3));
        return alpha;
    }
}

