/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.utils.documents;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.cts.CRSFactory;
import org.cts.IllegalCoordinateException;
import org.cts.crs.CRSException;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.crs.GeodeticCRS;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationException;
import org.cts.op.CoordinateOperationFactory;
import org.cts.registry.EPSGRegistry;
import org.cts.registry.Registry;
import org.cts.registry.RegistryManager;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.kml.KMLWriter;
import org.noise_planet.noisemodelling.pathfinder.delaunay.Triangle;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.Building;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPoint;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutProfile;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ProfileBuilder;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.Wall;

public class KMLDocument {
    private final XMLStreamWriter xmlOut;
    private final OutputStream outputStream;
    private Coordinate offset = new Coordinate(0.0, 0.0, 0.0);
    private int wgs84Precision = 7;
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private CoordinateOperation transform = null;
    private TreeMap<Double, Color> colorScale = new TreeMap();

    public KMLDocument(OutputStream outputStream) throws XMLStreamException {
        XMLOutputFactory streamWriterFactory = XMLOutputFactory.newFactory();
        this.outputStream = outputStream;
        this.xmlOut = streamWriterFactory.createXMLStreamWriter(new BufferedOutputStream(outputStream), "UTF-8");
        this.setDefaultColorScale();
    }

    public void setDefaultColorScale() {
        this.colorScale.clear();
        this.colorScale.put(0.0, new Color(130, 166, 173));
        this.colorScale.put(0.1, new Color(160, 186, 191));
        this.colorScale.put(0.2, new Color(184, 214, 209));
        this.colorScale.put(0.3, new Color(206, 228, 204));
        this.colorScale.put(0.4, new Color(226, 242, 191));
        this.colorScale.put(0.5, new Color(243, 198, 131));
        this.colorScale.put(0.6, new Color(232, 126, 77));
        this.colorScale.put(0.7, new Color(205, 70, 62));
        this.colorScale.put(0.8, new Color(161, 26, 77));
        this.colorScale.put(0.9, new Color(117, 8, 92));
        this.colorScale.put(1.0, new Color(67, 10, 74));
    }

    public Map<Double, Color> getColorScale() {
        return new HashMap<Double, Color>(this.colorScale);
    }

    public void setColorScale(Map<Double, Color> colorScale) {
        this.colorScale = new TreeMap<Double, Color>(colorScale);
    }

    public int getWgs84Precision() {
        return this.wgs84Precision;
    }

    public void setWgs84Precision(int wgs84Precision) {
        this.wgs84Precision = wgs84Precision;
    }

    public void setInputCRS(String crs) throws CRSException, CoordinateOperationException {
        CRSFactory cRSFactory = new CRSFactory();
        RegistryManager registryManager = cRSFactory.getRegistryManager();
        registryManager.addRegistry((Registry)new EPSGRegistry());
        CoordinateReferenceSystem crsKML = cRSFactory.getCRS("EPSG:4326");
        CoordinateReferenceSystem crsSource = cRSFactory.getCRS(crs);
        if (crsKML instanceof GeodeticCRS && crsSource instanceof GeodeticCRS) {
            this.transform = (CoordinateOperation)CoordinateOperationFactory.createCoordinateOperations((GeodeticCRS)((GeodeticCRS)crsSource), (GeodeticCRS)((GeodeticCRS)crsKML)).iterator().next();
        }
    }

    public KMLDocument writeHeader() throws XMLStreamException {
        this.xmlOut.writeStartDocument("UTF-8", "1.0");
        this.xmlOut.writeStartElement("kml");
        this.xmlOut.writeDefaultNamespace("http://www.opengis.net/kml/2.2");
        this.xmlOut.writeNamespace("atom", "http://www.w3.org/2005/Atom");
        this.xmlOut.writeNamespace("kml", "http://www.opengis.net/kml/2.2");
        this.xmlOut.writeNamespace("gx", "http://www.google.com/kml/ext/2.2");
        this.xmlOut.writeNamespace("xal", "urn:oasis:names:tc:ciq:xsdschema:xAL:2.0");
        this.xmlOut.writeStartElement("Document");
        return this;
    }

    public KMLDocument writeFooter() throws XMLStreamException {
        this.xmlOut.writeEndElement();
        this.xmlOut.writeEndDocument();
        this.xmlOut.close();
        return this;
    }

    public KMLDocument setOffset(Coordinate offset) {
        this.offset = offset;
        return this;
    }

    private Coordinate copyCoord(Coordinate in) {
        return new Coordinate(in.x + this.offset.x, in.y + this.offset.y, Double.isNaN(in.z) ? this.offset.z : in.z + this.offset.z);
    }

    public KMLDocument writeTopographic(List<Triangle> triVertices, List<Coordinate> vertices) throws XMLStreamException {
        this.xmlOut.writeStartElement("Style");
        this.xmlOut.writeAttribute("id", "mnt");
        this.xmlOut.writeStartElement("LineStyle");
        this.xmlOut.writeStartElement("width");
        this.xmlOut.writeCharacters("0");
        this.xmlOut.writeEndElement();
        this.xmlOut.writeEndElement();
        this.xmlOut.writeStartElement("PolyStyle");
        this.xmlOut.writeStartElement("color");
        this.xmlOut.writeCharacters("640078FF");
        this.xmlOut.writeEndElement();
        this.xmlOut.writeEndElement();
        this.xmlOut.writeEndElement();
        this.xmlOut.writeStartElement("Schema");
        this.xmlOut.writeAttribute("name", "mnt");
        this.xmlOut.writeAttribute("id", "mnt");
        this.xmlOut.writeEndElement();
        this.xmlOut.writeStartElement("Folder");
        this.xmlOut.writeStartElement("name");
        this.xmlOut.writeCharacters("mnt");
        this.xmlOut.writeEndElement();
        this.xmlOut.writeStartElement("Placemark");
        this.xmlOut.writeStartElement("styleUrl");
        this.xmlOut.writeCharacters("#mnt");
        this.xmlOut.writeEndElement();
        this.xmlOut.writeStartElement("name");
        this.xmlOut.writeCharacters("tri");
        this.xmlOut.writeEndElement();
        Polygon[] polygons = new Polygon[triVertices.size()];
        int idTri = 0;
        for (Triangle triangle : triVertices) {
            Polygon poly = this.geometryFactory.createPolygon(new Coordinate[]{this.copyCoord(vertices.get(triangle.getA())), this.copyCoord(vertices.get(triangle.getB())), this.copyCoord(vertices.get(triangle.getC())), this.copyCoord(vertices.get(triangle.getA()))});
            if (Orientation.isCCW((Coordinate[])poly.getCoordinates())) {
                poly = poly.reverse();
            }
            this.doTransform((Geometry)poly);
            polygons[idTri++] = poly;
        }
        this.writeRawXml(KMLWriter.writeGeometry((Geometry)this.geometryFactory.createMultiPolygon(polygons), (double)Double.NaN, (int)this.wgs84Precision, (boolean)false, (String)KMLWriter.ALTITUDE_MODE_ABSOLUTE));
        this.xmlOut.writeEndElement();
        this.xmlOut.writeEndElement();
        return this;
    }

    private void writeRawXml(String rowXml) throws XMLStreamException {
        this.xmlOut.flush();
        try {
            this.outputStream.write(rowXml.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public KMLDocument writeBuildings(ProfileBuilder profileBuilder) throws XMLStreamException {
        this.xmlOut.writeStartElement("Schema");
        this.xmlOut.writeAttribute("name", "buildings");
        this.xmlOut.writeAttribute("id", "buildings");
        this.xmlOut.writeEndElement();
        this.xmlOut.writeStartElement("Folder");
        this.xmlOut.writeStartElement("name");
        this.xmlOut.writeCharacters("buildings");
        this.xmlOut.writeEndElement();
        List<Building> buildings = profileBuilder.getBuildings();
        int idPoly = 0;
        KMLWriter buildingWriter = new KMLWriter();
        buildingWriter.setPrecision(this.wgs84Precision);
        buildingWriter.setExtrude(true);
        buildingWriter.setTesselate(true);
        buildingWriter.setAltitudeMode(profileBuilder.hasDem() ? KMLWriter.ALTITUDE_MODE_ABSOLUTE : KMLWriter.ALTITUDE_MODE_RELATIVETOGROUND);
        for (Building building : buildings) {
            Coordinate[] original = building.getGeometry().getCoordinates();
            Coordinate[] coordinates = new Coordinate[original.length];
            double z = profileBuilder.getBuilding(idPoly).getZ();
            for (int i = 0; i < coordinates.length; ++i) {
                coordinates[i] = this.copyCoord(new Coordinate(original[i].x, original[i].y, z));
            }
            if (coordinates.length > 3 && coordinates[0].equals2D(coordinates[coordinates.length - 1])) {
                Polygon poly = this.geometryFactory.createPolygon(coordinates);
                if (!Orientation.isCCW((Coordinate[])poly.getCoordinates())) {
                    poly = poly.reverse();
                }
                this.doTransform((Geometry)poly);
                this.xmlOut.writeStartElement("Placemark");
                this.xmlOut.writeStartElement("name");
                this.xmlOut.writeCharacters("building");
                this.xmlOut.writeEndElement();
                buildingWriter.setZ(z);
                this.writeRawXml(buildingWriter.write((Geometry)poly));
                this.xmlOut.writeEndElement();
            }
            ++idPoly;
        }
        this.xmlOut.writeEndElement();
        return this;
    }

    public KMLDocument writeWalls(ProfileBuilder profileBuilder) throws XMLStreamException {
        this.xmlOut.writeStartElement("Schema");
        this.xmlOut.writeAttribute("name", "walls");
        this.xmlOut.writeAttribute("id", "walls");
        this.xmlOut.writeEndElement();
        this.xmlOut.writeStartElement("Folder");
        this.xmlOut.writeStartElement("name");
        this.xmlOut.writeCharacters("walls");
        this.xmlOut.writeEndElement();
        List<Wall> walls = profileBuilder.getWalls();
        int idPoly = 0;
        KMLWriter wallWriter = new KMLWriter();
        wallWriter.setPrecision(this.wgs84Precision);
        wallWriter.setExtrude(true);
        wallWriter.setTesselate(true);
        wallWriter.setAltitudeMode(profileBuilder.hasDem() ? KMLWriter.ALTITUDE_MODE_ABSOLUTE : KMLWriter.ALTITUDE_MODE_RELATIVETOGROUND);
        for (Wall wall : walls) {
            Coordinate[] original = new Coordinate[]{wall.p0, wall.p1};
            Coordinate[] coordinates = new Coordinate[original.length];
            for (int i = 0; i < coordinates.length; ++i) {
                coordinates[i] = this.copyCoord(original[i]);
            }
            LineString poly = this.geometryFactory.createLineString(coordinates);
            if (!Orientation.isCCW((Coordinate[])poly.getCoordinates())) {
                poly = poly.reverse();
            }
            this.doTransform((Geometry)poly);
            this.xmlOut.writeStartElement("Placemark");
            this.xmlOut.writeStartElement("name");
            this.xmlOut.writeCharacters("walls");
            this.xmlOut.writeEndElement();
            this.writeRawXml(wallWriter.write((Geometry)poly));
            this.xmlOut.writeEndElement();
            ++idPoly;
        }
        this.xmlOut.writeEndElement();
        return this;
    }

    public KMLDocument writeProfile(String layerName, CutProfile profile) throws XMLStreamException {
        this.xmlOut.writeStartElement("Schema");
        this.xmlOut.writeAttribute("name", "profile");
        this.xmlOut.writeAttribute("id", "profile");
        this.xmlOut.writeEndElement();
        this.xmlOut.writeStartElement("Folder");
        this.xmlOut.writeStartElement("name");
        this.xmlOut.writeCharacters("profile");
        this.xmlOut.writeEndElement();
        this.xmlOut.writeStartElement("Placemark");
        this.xmlOut.writeStartElement("name");
        this.xmlOut.writeCharacters(layerName);
        this.xmlOut.writeEndElement();
        Coordinate[] coordinates = new Coordinate[profile.cutPoints.size()];
        int i = 0;
        for (CutPoint cutPoint : profile.cutPoints) {
            coordinates[i++] = this.copyCoord(cutPoint.getCoordinate());
        }
        LineString lineString = this.geometryFactory.createLineString(coordinates);
        this.doTransform((Geometry)lineString);
        this.writeRawXml(KMLWriter.writeGeometry((Geometry)lineString, (double)Double.NaN, (int)this.wgs84Precision, (boolean)false, (String)KMLWriter.ALTITUDE_MODE_ABSOLUTE));
        this.xmlOut.writeEndElement();
        this.xmlOut.writeEndElement();
        return this;
    }

    private String formatColorEntry(double key) {
        return String.format(Locale.ROOT, "scale%g", key);
    }

    public void doTransform(Geometry geometry) {
        if (this.transform != null && geometry != null) {
            geometry.apply((CoordinateFilter)new CRSTransformFilter(this.transform));
            geometry.setSRID(4326);
        }
    }

    public static final class CRSTransformFilter
    implements CoordinateFilter {
        private final CoordinateOperation coordinateOperation;

        public CRSTransformFilter(CoordinateOperation coordinateOperation) {
            this.coordinateOperation = coordinateOperation;
        }

        public void filter(Coordinate coord) {
            try {
                if (Double.isNaN(coord.z)) {
                    coord.z = 0.0;
                }
                double[] xyz = this.coordinateOperation.transform(new double[]{coord.x, coord.y, coord.z});
                coord.x = xyz[0];
                coord.y = xyz[1];
                if (xyz.length > 2) {
                    coord.z = xyz[2];
                }
            }
            catch (IllegalCoordinateException | CoordinateOperationException var3) {
                Logger.getLogger(KMLDocument.class.getName()).log(Level.SEVERE, (String)null, var3);
            }
        }
    }
}

