/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.utils.profiler;

import java.beans.PropertyChangeListener;
import org.h2gis.api.ProgressVisitor;

public class DefaultProgressVisitor
implements ProgressVisitor {
    protected long subprocessSize;
    protected double subprocessDone = 0.0;
    DefaultProgressVisitor parentProcess;

    public DefaultProgressVisitor(long subprocessSize, DefaultProgressVisitor parentProcess) {
        this.subprocessSize = subprocessSize;
        this.parentProcess = parentProcess;
    }

    public ProgressVisitor subProcess(int i) {
        return new DefaultProgressVisitor(i, this);
    }

    public void endStep() {
        this.pushProgression(1.0);
    }

    protected synchronized void pushProgression(double incProg) {
        if (this.subprocessDone + incProg <= (double)this.subprocessSize) {
            this.subprocessDone += incProg;
            if (this.parentProcess != null) {
                this.parentProcess.pushProgression(incProg / (double)this.subprocessSize);
            }
        }
    }

    public void setStep(int i) {
    }

    public int getStepCount() {
        return (int)this.subprocessSize;
    }

    public void endOfProgress() {
    }

    public double getProgression() {
        if (this.parentProcess != null) {
            return this.parentProcess.getProgression();
        }
        return this.subprocessDone / (double)this.subprocessSize;
    }

    public boolean isCanceled() {
        return this.parentProcess != null && this.parentProcess.isCanceled();
    }

    public void cancel() {
        if (this.parentProcess != null) {
            this.parentProcess.cancel();
        }
    }

    public void addPropertyChangeListener(String s, PropertyChangeListener propertyChangeListener) {
        if (this.parentProcess != null) {
            this.parentProcess.addPropertyChangeListener(s, propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.parentProcess != null) {
            this.parentProcess.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

