/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.pathfinder.utils.profiler;

import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.ProfilerThread;

public class ReceiverStatsMetric
implements ProfilerThread.Metric {
    private ConcurrentLinkedDeque<ReceiverComputationTime> receiverComputationTimes = new ConcurrentLinkedDeque();
    private ConcurrentLinkedDeque<ReceiverCutProfiles> receiverCutProfilesDeque = new ConcurrentLinkedDeque();
    private DescriptiveStatistics computationTime = new DescriptiveStatistics();
    private DescriptiveStatistics computationCutProfiles = new DescriptiveStatistics();
    private DescriptiveStatistics computationProcessSourcesPercentage = new DescriptiveStatistics();
    private DescriptiveStatistics collectSourcesTime = new DescriptiveStatistics();
    private DescriptiveStatistics precomputeReflectionTime = new DescriptiveStatistics();
    private DescriptiveStatistics sourcesPerReceiver = new DescriptiveStatistics();

    @Override
    public void tick(long currentMillis) {
        Object receiverProfile;
        while (!this.receiverComputationTimes.isEmpty()) {
            receiverProfile = this.receiverComputationTimes.pop();
            this.computationTime.addValue((double)((ReceiverComputationTime)receiverProfile).computationTime);
            this.collectSourcesTime.addValue((double)((ReceiverComputationTime)receiverProfile).sourceCollectTime);
            this.precomputeReflectionTime.addValue((double)((ReceiverComputationTime)receiverProfile).reflectionPreprocessTime);
        }
        while (!this.receiverCutProfilesDeque.isEmpty()) {
            receiverProfile = this.receiverCutProfilesDeque.pop();
            this.computationCutProfiles.addValue((double)((ReceiverCutProfiles)receiverProfile).numberOfRays);
            this.sourcesPerReceiver.addValue((double)((ReceiverCutProfiles)receiverProfile).numberOfSources);
            if (((ReceiverCutProfiles)receiverProfile).numberOfSources <= 0) continue;
            this.computationProcessSourcesPercentage.addValue((double)((ReceiverCutProfiles)receiverProfile).numberOfProcessSources / (double)((ReceiverCutProfiles)receiverProfile).numberOfSources * 100.0);
        }
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"receiver_min_milliseconds", "receiver_median_milliseconds", "receiver_mean_milliseconds", "receiver_max_milliseconds", "receiver_collect_sources_max_milliseconds", "receiver_precompute_reflection_max_milliseconds", "receiver_median_profiles_count", "receiver_max_profiles_count", "receiver_processed_sources_percentage_mean", "receiver_median_point_sources_in_range"};
    }

    public void onEndComputation(ReceiverComputationTime receiverComputationTime) {
        this.receiverComputationTimes.add(receiverComputationTime);
    }

    public void onReceiverCutProfiles(int receiverId, int receiverCutProfiles, int numberOfSources, int numberOfProcessSources) {
        this.receiverCutProfilesDeque.add(new ReceiverCutProfiles(receiverId, receiverCutProfiles, numberOfSources, numberOfProcessSources));
    }

    @Override
    public String[] getCurrentValues() {
        String[] res = new String[]{Integer.toString((int)this.computationTime.getMin()), Integer.toString((int)this.computationTime.getPercentile(50.0)), Integer.toString((int)this.computationTime.getMean()), Integer.toString((int)this.computationTime.getMax()), Integer.toString((int)this.collectSourcesTime.getMax()), Integer.toString((int)this.precomputeReflectionTime.getMax()), Integer.toString((int)this.computationCutProfiles.getPercentile(50.0)), Integer.toString((int)this.computationCutProfiles.getMax()), Integer.toString((int)this.computationProcessSourcesPercentage.getMean()), Integer.toString((int)this.sourcesPerReceiver.getPercentile(50.0))};
        this.computationTime.clear();
        this.computationCutProfiles.clear();
        this.computationProcessSourcesPercentage.clear();
        this.collectSourcesTime.clear();
        this.precomputeReflectionTime.clear();
        this.sourcesPerReceiver.clear();
        return res;
    }

    public static class ReceiverCutProfiles {
        public int receiverId;
        public int numberOfRays;
        int numberOfSources;
        int numberOfProcessSources;

        public ReceiverCutProfiles(int receiverId, int numberOfCutProfiles, int numberOfSources, int numberOfProcessSources) {
            this.receiverId = receiverId;
            this.numberOfRays = numberOfCutProfiles;
            this.numberOfSources = numberOfSources;
            this.numberOfProcessSources = numberOfProcessSources;
        }
    }

    public static class ReceiverComputationTime {
        public int receiverId;
        public int computationTime;
        public int reflectionPreprocessTime;
        public int sourceCollectTime;

        public ReceiverComputationTime(int receiverId, int computationTime, int reflectionPreprocessTime, int sourceCollectTime) {
            this.receiverId = receiverId;
            this.computationTime = computationTime;
            this.reflectionPreprocessTime = reflectionPreprocessTime;
            this.sourceCollectTime = sourceCollectTime;
        }
    }
}

