/*
 * Decompiled with CFR 0.152.
 */
import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.sql.Sql;
import groovy.text.SimpleTemplateEngine;
import groovy.transform.Generated;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.h2.util.ScriptReader;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.RootProgressVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enrich_DEM
extends Script {
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Enrich_DEM() {
        CallSite[] callSiteArray = Enrich_DEM.$getCallSiteArray();
    }

    public Enrich_DEM(Binding context) {
        CallSite[] callSiteArray = Enrich_DEM.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = Enrich_DEM.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, Enrich_DEM.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = Enrich_DEM.$getCallSiteArray();
        String string = "Enrich DEM";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, Enrich_DEM.class, (GroovyObject)this, (String)"title");
        Object object = callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call(callSiteArray[15].call(callSiteArray[16].call(callSiteArray[17].call(callSiteArray[18].call(callSiteArray[19].call(callSiteArray[20].call(callSiteArray[21].call(callSiteArray[22].call(callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].call(callSiteArray[26].call((Object)"&#10145;&#65039; Insert altimetric points coming from input layers into the input DEM. </br>", (Object)"<hr>"), (Object)"This script works with five input layers:</br>"), (Object)" <ul>"), (Object)"<li>Digital Elevation Model (DEM) to be enriched</li>"), (Object)"<li>Orographic lines</li>"), (Object)"<li>Hydrograpic network</li>"), (Object)"<li>Roads</li>"), (Object)"<li>Railways</li>"), (Object)"</ul>"), (Object)"And six parameters:</br>"), (Object)" <ul>"), (Object)"<li>Road width (roadWidth): Name of column where the road width is stored (Mandatory)</li>"), (Object)"<li>Roads platform height (hRoad) (Optionnal). Default value = 0m</li>"), (Object)"<li>Railroads right-of-way (railWidth): Name of column where the railroad right-of-way is stored (Mandatory)</li>"), (Object)"<li>Rail platform height (hRail) (Optionnal). Default value = 0.5m</li>"), (Object)"<li>Input SRID (inputSRID): SRID of the input tables (Optionnal)</li>"), (Object)"<li>Output suffixe (outputSuffixe): Suffixe applied at the end of the resuling table name (Optionnal). If not specified, \"ENRICHED\" is applied</li>"), (Object)"</ul>"), (Object)"<hr>"), (Object)"In the schema below, orange points will be inserted into the DEM. d2, d3 and d4 are deduced from the information provided in the parameter <b>railWidth</b>, using the following formula:"), (Object)"<ul>"), (Object)"<li>d2 = (railWidth - 5.5)/2</li>"), (Object)"<li>d3 = (railWidth - 4)/2</li>"), (Object)"<li>d4 = (railWidth)/2</li>"), (Object)"</ul>"), (Object)"<img src=\"wps_images/railway_plateform.png\" alt=\"Railways platform\" width=\"95%\" align=\"center\">");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Enrich_DEM.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"inputSRID", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Input SRID", "title", "Input SRID", "description", callSiteArray[27].call((Object)"&#127757; SRID of the input tables. </br> </br>", (Object)"&#128736; If not specified, the SRID from DEM layer is applied. If DEM has no SRID, 0 is applied"), "min", 0, "max", 1, "type", Integer.class}), "inputDEM", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Input DEM", "title", "Input DEM table", "description", "Name of the input DEM table to be enriched", "type", String.class}), "inputOro", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Input Orography", "title", "Input orography table", "description", "Name of the input orography table", "type", String.class}), "inputHydro", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Input Hydrography", "title", "Input hydrographic table", "description", "Name of the input hydrographic network table", "type", String.class}), "inputRoad", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Input Roads", "title", "Input roads table", "description", "Name of the input roads table", "type", String.class}), "roadWidth", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Road width", "title", "Road width", "description", "Name of column where the road width is stored", "type", String.class}), "hRoad", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Roads platform height", "title", "Roads platform height", "description", callSiteArray[28].call((Object)"Roads platform height (in meters) (Optionnal) </br> </br>", (Object)"&#128736; Default value = <b>0</b>"), "min", 0, "max", 1, "type", Double.TYPE}), "inputRail", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Input Railways", "title", "Input railways table", "description", "Name of the input railways table", "type", String.class}), "railWidth", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Railways width", "title", "Railways width", "description", "Name of column where the railways width is stored", "type", String.class}), "hRail", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Rail platform height", "title", "Railways platform height", "description", callSiteArray[29].call((Object)"Railways platform height (in meters) (Optionnal)</br> </br>", (Object)"&#128736; Default value = <b>0.5</b>"), "min", 0, "max", 1, "type", Double.TYPE}), "outputSuffixe", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Output suffixe", "title", "Output suffixe", "description", callSiteArray[30].call((Object)"Suffixe applied at the end of the resuling table name </br> </br>", (Object)"&#128736; If not specified, \"ENRICHED\" is applied"), "min", 0, "max", 1, "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, Enrich_DEM.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "This type of result does not allow the blocks to be linked together.", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, Enrich_DEM.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Object parseScript(String sqlInstructions, Sql sql, ProgressVisitor progressVisitor, Logger logger) {
        InputStreamReader reader = null;
        ByteArrayInputStream s = new ByteArrayInputStream(sqlInstructions.getBytes());
        ByteArrayInputStream is = s;
        LinkedList<String> statementList = new LinkedList<String>();
        try {
            reader = new InputStreamReader(is);
            ScriptReader scriptReader = new ScriptReader((Reader)reader);
            scriptReader.setSkipRemarks(false);
            String statement = scriptReader.readStatement();
            while (statement != null && !statement.trim().isEmpty()) {
                statementList.add(statement);
                scriptReader.readStatement();
            }
        }
        finally {
            reader.close();
        }
        int idStatement = 0;
        int nbStatements = statementList.size();
        ProgressVisitor evalProgress = progressVisitor.subProcess(nbStatements);
        LinkedList<String> linkedList = statementList;
        Iterator iterator = linkedList != null ? linkedList.iterator() : null;
        String statement = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                statement = ShortTypeHandling.castToString(iterator2.next());
                String subStatement2 = null;
                String[] stringArray = statement.split("\n");
                if (stringArray != null) {
                    for (String subStatement2 : stringArray) {
                        if (!subStatement2.trim().startsWith("--")) continue;
                        logger.info(String.format(Locale.ROOT, "%d/%d %s", idStatement + 1, nbStatements, subStatement2.replace("--", "")));
                    }
                }
                int n = idStatement;
                int cfr_ignored_0 = n + 1;
                sql.execute(statement);
                evalProgress.endStep();
                if (!evalProgress.isCanceled()) continue;
                throw (Throwable)new SQLException("Canceled by user");
            }
        }
        return null;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = Enrich_DEM.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[31].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[32].call(callSiteArray[33].call(callSiteArray[34].callGroovyObjectGetProperty(callSiteArray[35].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].call(callSiteArray[37].callGroovyObjectGetProperty(callSiteArray[38].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].call(callSiteArray[40].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call(callSiteArray[42].call((Object)jdbcDataStore)), Connection.class);
    }

    public Object run(Object input) {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure1(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = Enrich_DEM.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[43].call(callSiteArray[44].callStatic(Enrich_DEM.class, (Object)dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
        }
        return callSiteArray[45].call((Object)Enrich_DEM.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
    }

    public Object exec(Connection connection, Object input) {
        Reference connection2 = new Reference((Object)connection);
        CallSite[] callSiteArray = Enrich_DEM.$getCallSiteArray();
        Reference ignorelst = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"SPATIAL_REF_SYS", "GEOMETRY_COLUMNS"}));
        Reference sb = new Reference((Object)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].callConstructor(StringBuilder.class), StringBuilder.class)));
        List tables = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].call(JDBCUtilities.class, ArrayUtil.createArray((Object)((Connection)connection2.get()), null, (Object)"PUBLIC", (Object)"%", null)), List.class);
        public final class _exec_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference ignorelst;
            private /* synthetic */ Reference sb;
            private /* synthetic */ Reference connection;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _exec_closure2(Object _outerInstance, Object _thisObject, Reference ignorelst, Reference sb, Reference connection) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.ignorelst = reference3 = ignorelst;
                this.sb = reference2 = sb;
                this.connection = reference = connection;
            }

            public Object doCall(Object t) {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                TableLocation tab = (TableLocation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(TableLocation.class, t), TableLocation.class);
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(this.ignorelst.get(), callSiteArray[2].call((Object)tab)))) {
                    if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[3].call(this.sb.get()), (Object)0)) {
                        callSiteArray[4].call(this.sb.get(), (Object)" || ");
                    }
                    callSiteArray[5].call(this.sb.get(), callSiteArray[6].call((Object)tab));
                    Statement stmt = (Statement)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].call(this.connection.get()), Statement.class);
                    return stmt;
                }
                return null;
            }

            @Generated
            public List getIgnorelst() {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.ignorelst.get(), List.class);
            }

            @Generated
            public StringBuilder getSb() {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class);
            }

            @Generated
            public Connection getConnection() {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                return (Connection)ScriptBytecodeAdapter.castToType((Object)this.connection.get(), Connection.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _exec_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "parse";
                stringArray[1] = "contains";
                stringArray[2] = "getTable";
                stringArray[3] = "size";
                stringArray[4] = "append";
                stringArray[5] = "append";
                stringArray[6] = "getTable";
                stringArray[7] = "createStatement";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _exec_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_exec_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _exec_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[48].call((Object)tables, (Object)new _exec_closure2((Object)this, (Object)this, ignorelst, sb, connection2));
        Object resultString = null;
        Logger logger = (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[49].call(LoggerFactory.class, (Object)"org.noise_planet.noisemodelling"), Logger.class);
        ProgressVisitor progressVisitor = null;
        progressVisitor = ScriptBytecodeAdapter.isCase((Object)"progressVisitor", (Object)input) ? (ProgressVisitor)ScriptBytecodeAdapter.asType((Object)callSiteArray[50].call(input, (Object)"progressVisitor"), ProgressVisitor.class) : (ProgressVisitor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callConstructor(RootProgressVisitor.class, (Object)1, (Object)true, (Object)1), ProgressVisitor.class);
        ProgressVisitor progress = (ProgressVisitor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].call((Object)progressVisitor, (Object)2), ProgressVisitor.class);
        String inputDEM = ShortTypeHandling.castToString((Object)callSiteArray[53].call(input, (Object)"inputDEM"));
        String inputOro = ShortTypeHandling.castToString((Object)callSiteArray[54].call(input, (Object)"inputOro"));
        String inputHydro = ShortTypeHandling.castToString((Object)callSiteArray[55].call(input, (Object)"inputHydro"));
        String inputRail = ShortTypeHandling.castToString((Object)callSiteArray[56].call(input, (Object)"inputRail"));
        String railWidth = ShortTypeHandling.castToString((Object)callSiteArray[57].call(input, (Object)"railWidth"));
        String inputRoad = ShortTypeHandling.castToString((Object)callSiteArray[58].call(input, (Object)"inputRoad"));
        String roadWidth = ShortTypeHandling.castToString((Object)callSiteArray[59].call(input, (Object)"roadWidth"));
        double hRail = DefaultTypeTransformation.doubleUnbox((Object)$const$0);
        if (ScriptBytecodeAdapter.isCase((Object)"hRail", (Object)input)) {
            hRail = DefaultTypeTransformation.doubleUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[60].call(input, (Object)"hRail"), Double.TYPE));
        }
        double hRoad = 0.0;
        if (ScriptBytecodeAdapter.isCase((Object)"hRoad", (Object)input)) {
            hRoad = DefaultTypeTransformation.doubleUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[61].call(input, (Object)"hRoad"), Double.TYPE));
        }
        Integer srid = 0;
        srid = ScriptBytecodeAdapter.isCase((Object)"inputSRID", (Object)input) ? (Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[62].call(input, (Object)"inputSRID"), Integer.class) : (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].call(GeometryTableUtilities.class, (Object)((Connection)connection2.get()), callSiteArray[64].call(TableLocation.class, (Object)inputDEM)), Integer.class);
        String outputSuffixe = "ENRICHED";
        if (ScriptBytecodeAdapter.isCase((Object)"outputSuffixe", (Object)input)) {
            outputSuffixe = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[65].call(input, (Object)"outputSuffixe"), String.class);
        }
        String enrichedDEM = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[66].call(callSiteArray[67].call(callSiteArray[68].call(input, (Object)"inputDEM"), (Object)"_"), callSiteArray[69].call(input, (Object)"outputSuffixe")), String.class);
        callSiteArray[70].call((Object)logger, (Object)"List of the input parameters:");
        callSiteArray[71].call((Object)logger, (Object)"--------------------------------------------");
        callSiteArray[72].call((Object)logger, callSiteArray[73].call((Object)"# SRID: ", (Object)srid));
        callSiteArray[74].call((Object)logger, callSiteArray[75].call((Object)"# DEM table: ", (Object)inputDEM));
        callSiteArray[76].call((Object)logger, callSiteArray[77].call((Object)"# Orography table: ", (Object)inputOro));
        callSiteArray[78].call((Object)logger, callSiteArray[79].call((Object)"# Hydrograpic network table: ", (Object)inputHydro));
        callSiteArray[80].call((Object)logger, callSiteArray[81].call((Object)"# Roads network table: ", (Object)inputRoad));
        callSiteArray[82].call((Object)logger, callSiteArray[83].call((Object)"# Roads width column: ", (Object)roadWidth));
        callSiteArray[84].call((Object)logger, callSiteArray[85].call((Object)"# Roads platform height: ", (Object)hRoad));
        callSiteArray[86].call((Object)logger, callSiteArray[87].call((Object)"# Railways network table: ", (Object)inputRail));
        callSiteArray[88].call((Object)logger, callSiteArray[89].call((Object)"# Railways width column: ", (Object)railWidth));
        callSiteArray[90].call((Object)logger, callSiteArray[91].call((Object)"# Railways platform height: ", (Object)hRail));
        callSiteArray[92].call((Object)logger, callSiteArray[93].call((Object)"# Output suffixe: ", (Object)outputSuffixe));
        callSiteArray[94].call((Object)logger, (Object)"--------------------------------------------");
        callSiteArray[95].call((Object)logger, (Object)"Start enrich the DEM");
        Object sql = callSiteArray[96].callConstructor(Sql.class, (Object)((Connection)connection2.get()));
        GStringImpl import_dem = new GStringImpl(new Object[]{inputDEM, inputDEM}, new String[]{"\n    ------------\n    -- Import DEM\n\n    DROP TABLE IF EXISTS dem_to_enrich;\n    CREATE TABLE dem_to_enrich AS SELECT THE_GEOM, 'DEM' as SOURCE FROM ", ";\n    \n    -- DEM: layer ", " imported\n    "});
        GStringImpl import_oro = new GStringImpl(new Object[]{inputOro, inputOro}, new String[]{"\n    ------------\n    -- Import orography\n\n    DROP TABLE IF EXISTS dem_oro;\n    CREATE TABLE dem_oro AS SELECT THE_GEOM FROM ", ";\n    CREATE SPATIAL INDEX ON dem_oro(THE_GEOM);\n    ALTER TABLE dem_oro ADD PK_LINE INT AUTO_INCREMENT NOT NULL;\n    ALTER TABLE dem_oro add primary key(PK_LINE);\n    \n    -- Orography: layer ", " imported\n    "});
        GStringImpl import_hydro = new GStringImpl(new Object[]{inputHydro, inputHydro}, new String[]{"\n    ------------\n    -- Import hydrography\n\n    DROP TABLE IF EXISTS dem_hydro;\n    CREATE TABLE dem_hydro AS SELECT THE_GEOM FROM ", ";\n    CREATE SPATIAL INDEX ON dem_hydro(THE_GEOM);\n    ALTER TABLE dem_hydro ADD PK_LINE INT AUTO_INCREMENT NOT NULL;\n    ALTER TABLE dem_hydro add primary key(PK_LINE);\n    \n    -- Hydrography: layer ", " imported\n    "});
        GStringImpl import_roads = new GStringImpl(new Object[]{roadWidth, roadWidth, inputRoad, inputRoad}, new String[]{"\n    ------------\n    -- Import roads (that are on the floor --> POS_SOL=0)\n    -- Road width is precalculated into WIDTH column. When largeur < 3, then 3m\n\n    DROP TABLE IF EXISTS dem_roads;\n    CREATE TABLE dem_roads AS SELECT THE_GEOM, 'ROAD' as SOURCE, (CASE WHEN ", ">3 THEN ", "/2 ELSE 1.5 END) as WIDTH \n        FROM ", " WHERE POS_SOL = '0' AND st_zmin(THE_GEOM) > 0;\n    CREATE SPATIAL INDEX ON dem_roads(THE_GEOM);\n    ALTER TABLE dem_roads ADD PK_LINE INT AUTO_INCREMENT NOT NULL;\n    ALTER TABLE dem_roads add primary key(PK_LINE);\n    \n    -- Roads: layer ", " imported\n    "});
        GStringImpl import_rail = new GStringImpl(new Object[]{railWidth, inputRail, inputRail}, new String[]{"\n    ------------\n    -- Import railways (that are on the floor --> POS_SOL=0)\n\n    DROP TABLE IF EXISTS dem_rail;    \n    CREATE TABLE dem_rail AS SELECT THE_GEOM, 'RAIL' as SOURCE, ", " as WIDTH FROM ", " WHERE st_zmin(THE_GEOM) > 0;\n    CREATE SPATIAL INDEX ON dem_rail(THE_GEOM);\n    ALTER TABLE dem_rail ADD PK_LINE INT AUTO_INCREMENT NOT NULL;\n    ALTER TABLE dem_rail add primary key(PK_LINE);\n    \n    -- Railways: layer ", " imported\n    "});
        GStringImpl enrich_oro = new GStringImpl(new Object[]{enrichedDEM, enrichedDEM, srid, enrichedDEM}, new String[]{"    \n    ----------------------------------\n    -- Start enrich the DEM in a new layer called ", "\n\n    ------------\n    -- Insert orography into ", "\n\n    DROP TABLE IF EXISTS ORO_DENSIFY;\n    CREATE TABLE ORO_DENSIFY AS SELECT ST_ToMultiPoint(ST_Densify(st_force2D(THE_GEOM), 5)) THE_GEOM, PK_LINE FROM dem_oro WHERE st_length(st_simplify(THE_GEOM, 2)) > 0 ;\n    INSERT INTO dem_to_enrich(THE_GEOM, SOURCE) SELECT st_setsrid(ST_MakePoint(ST_X(P.THE_GEOM), ST_Y(P.THE_GEOM), ST_Z(ST_ProjectPoint(P.THE_GEOM,L.THE_GEOM))), ", ") THE_GEOM, 'ORO' \n        FROM ST_EXPLODE('ORO_DENSIFY') P, dem_oro L WHERE P.PK_LINE = L.PK_LINE;\n    DROP TABLE IF EXISTS ORO_DENSIFY;\n    \n    -- ", " enriched with orography\n    "});
        GStringImpl enrich_hydro = new GStringImpl(new Object[]{enrichedDEM, srid, enrichedDEM}, new String[]{"\n    ------------\n    -- Insert hydrography into ", "\n\n    DROP TABLE IF EXISTS HYDRO_DENSIFY;\n    CREATE TABLE HYDRO_DENSIFY AS SELECT ST_ToMultiPoint(ST_Densify(st_force2D(THE_GEOM), 5)) THE_GEOM, PK_LINE FROM dem_hydro WHERE st_length(st_simplify(THE_GEOM, 2)) > 0 ;\n    INSERT INTO dem_to_enrich(THE_GEOM, SOURCE) SELECT st_setsrid(ST_MakePoint(ST_X(P.THE_GEOM), ST_Y(P.THE_GEOM), ST_Z(ST_ProjectPoint(P.THE_GEOM,L.THE_GEOM))), ", ") THE_GEOM, 'HYD' \n        FROM ST_EXPLODE('HYDRO_DENSIFY') P, dem_hydro L WHERE P.PK_LINE = L.PK_LINE;\n    DROP TABLE IF EXISTS HYDRO_DENSIFY;   \n    \n    -- ", " enriched with hydrography\n    "});
        GStringImpl enrich_roads = new GStringImpl(new Object[]{enrichedDEM, srid, srid, roadWidth, roadWidth, roadWidth, srid, enrichedDEM}, new String[]{"\n    ------------\n    -- Insert roads platform into ", "\n\n    DROP TABLE DEM_WITHOUT_PTLINE IF EXISTS;\n    CREATE TABLE DEM_WITHOUT_PTLINE(THE_GEOM geometry(POINTZ, ", "), source varchar) AS SELECT st_setsrid(THE_GEOM, ", "), SOURCE FROM dem_to_enrich;\n    -- Remove DEM points that are less than ", " far FROM roads\n    DELETE FROM DEM_WITHOUT_PTLINE WHERE EXISTS (SELECT 1 FROM dem_roads b \n        WHERE ST_EXPAND(DEM_WITHOUT_PTLINE.THE_GEOM, 20) && b.THE_GEOM \n        AND ST_DISTANCE(DEM_WITHOUT_PTLINE.THE_GEOM, b.THE_GEOM)< b.WIDTH+5 LIMIT 1) ;\n    \n    -- Create buffer points from roads and copy the elevation from the roads to the point\n    DROP TABLE IF EXISTS BUFFERED_PTLINE;\n    -- The buffer size correspond to the greatest value between ", " and 3m. If ", " is null or lower than 3m, then 3m is returned\n    CREATE TABLE BUFFERED_PTLINE AS SELECT ST_ToMultiPoint(ST_Densify(ST_Buffer(ST_Simplify(st_force2D(THE_GEOM), 2), WIDTH, 'endcap=flat join=mitre'), 5)) THE_GEOM, PK_LINE \n        FROM dem_roads WHERE st_length(st_simplify(THE_GEOM, 2)) > 0;\n    INSERT INTO DEM_WITHOUT_PTLINE(THE_GEOM, SOURCE) SELECT st_setsrid(ST_MakePoint(ST_X(P.THE_GEOM), ST_Y(P.THE_GEOM), ST_Z(ST_ProjectPoint(P.THE_GEOM,L.THE_GEOM))), ", ") THE_GEOM, 'ROA' \n        FROM ST_EXPLODE('BUFFERED_PTLINE') P, dem_roads L WHERE P.PK_LINE = L.PK_LINE;\n    \n    -- ", " enriched with roads\n    "});
        GStringImpl enrich_rail = new GStringImpl(new Object[]{enrichedDEM, railWidth, srid, railWidth, hRail, srid, railWidth, hRail, srid, enrichedDEM}, new String[]{"\n    ------------\n    -- Insert rail platform into ", "\n\n    -- Remove DEM points that are less than \"WIDTH/2\" far FROM rails\n    DELETE FROM DEM_WITHOUT_PTLINE WHERE EXISTS (SELECT 1 FROM dem_rail b WHERE ST_EXPAND(DEM_WITHOUT_PTLINE.THE_GEOM, 20) && b.THE_GEOM AND ST_DISTANCE(DEM_WITHOUT_PTLINE.THE_GEOM, b.THE_GEOM)< ((b.WIDTH/2) + 5)  LIMIT 1) ;\n    \n    -- Create buffer points from rails and copy the elevation from the rails to the point\n    DROP TABLE IF EXISTS BUFFERED_D2, BUFFERED_D3, BUFFERED_D4;\n    -- The buffer sizes correspond to: \n    -- # d2 = (", " - 5.5)/2\n    CREATE TABLE BUFFERED_D2 AS SELECT ST_ToMultiPoint(ST_Densify(ST_Buffer(ST_Simplify(st_force2D(THE_GEOM), 2), (WIDTH - 5.5)/2, 'endcap=flat join=mitre'), 5)) THE_GEOM, PK_LINE FROM dem_rail WHERE st_length(st_simplify(THE_GEOM, 2)) > 0 ;\n    INSERT INTO DEM_WITHOUT_PTLINE(THE_GEOM, SOURCE) SELECT st_setsrid(ST_MakePoint(ST_X(P.THE_GEOM), ST_Y(P.THE_GEOM), ST_Z(ST_ProjectPoint(P.THE_GEOM,L.THE_GEOM))), ", ") THE_GEOM, 'RAI' FROM ST_EXPLODE('BUFFERED_D2') P, dem_rail L WHERE P.PK_LINE = L.PK_LINE;\n    \n    -- # d3 = (", " - 4)/2\n    CREATE TABLE BUFFERED_D3 AS SELECT ST_ToMultiPoint(ST_Densify(ST_Buffer(ST_Simplify(THE_GEOM, 2), (WIDTH - 4)/2, 'endcap=flat join=mitre'), 5)) THE_GEOM, PK_LINE FROM dem_rail WHERE st_length(st_simplify(THE_GEOM, 2)) > 0 ;\n    INSERT INTO DEM_WITHOUT_PTLINE(THE_GEOM, SOURCE) SELECT st_setsrid(ST_MakePoint(ST_X(P.THE_GEOM), ST_Y(P.THE_GEOM), ST_Z(ST_ProjectPoint(P.THE_GEOM,L.THE_GEOM))-", "), ", ") THE_GEOM, 'RAI' FROM ST_EXPLODE('BUFFERED_D3') P, dem_rail L WHERE P.PK_LINE = L.PK_LINE;\n\n    -- # d4 = (", ")/2\n    CREATE TABLE BUFFERED_D4 AS SELECT ST_ToMultiPoint(ST_Densify(ST_Buffer(ST_Simplify(THE_GEOM, 2), WIDTH/2, 'endcap=flat join=mitre'), 5)) THE_GEOM, PK_LINE FROM dem_rail WHERE st_length(st_simplify(THE_GEOM, 2)) > 0 ;\n    INSERT INTO DEM_WITHOUT_PTLINE(THE_GEOM, SOURCE) SELECT st_setsrid(ST_MakePoint(ST_X(P.THE_GEOM), ST_Y(P.THE_GEOM), ST_Z(ST_ProjectPoint(P.THE_GEOM,L.THE_GEOM))-", "), ", ") THE_GEOM, 'RAI' FROM ST_EXPLODE('BUFFERED_D4') P, dem_rail L WHERE P.PK_LINE = L.PK_LINE;\n    \n    -- ", " enriched with railways\n    "});
        GStringImpl enrich_final = new GStringImpl(new Object[]{enrichedDEM, enrichedDEM, enrichedDEM, enrichedDEM, enrichedDEM}, new String[]{"\n    \n    DROP TABLE IF EXISTS ", ";\n    ALTER TABLE DEM_WITHOUT_PTLINE RENAME TO ", ";\n    -- Create a spatial index on ", "\n    CREATE SPATIAL INDEX ON ", " (THE_GEOM);\n\n    ----------------------------------\n    -- Remove non needed tables\n    \n    DROP TABLE IF EXISTS DEM_ORO, DEM_HYDRO, DEM_RAIL, DEM_ROADS, BUFFERED_D2, BUFFERED_D3, BUFFERED_D4, BUFFERED_PTLINE, dem_to_enrich;\n\n    -- DEM successfully enriched in the table ", "\n    "});
        StringBuilder stringBuilder = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[97].callConstructor(StringBuilder.class), StringBuilder.class);
        Object engine = callSiteArray[98].callConstructor(SimpleTemplateEngine.class);
        callSiteArray[99].call((Object)stringBuilder, (Object)import_dem);
        callSiteArray[100].call((Object)stringBuilder, (Object)import_oro);
        callSiteArray[101].call((Object)stringBuilder, (Object)import_hydro);
        callSiteArray[102].call((Object)stringBuilder, (Object)import_rail);
        callSiteArray[103].call((Object)stringBuilder, (Object)import_roads);
        callSiteArray[104].call((Object)stringBuilder, (Object)enrich_oro);
        callSiteArray[105].call((Object)stringBuilder, (Object)enrich_hydro);
        callSiteArray[106].call((Object)stringBuilder, (Object)enrich_roads);
        callSiteArray[107].call((Object)stringBuilder, (Object)enrich_rail);
        callSiteArray[108].call((Object)stringBuilder, (Object)enrich_final);
        Map binding = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"inputDEM", inputDEM, "inputOro", inputOro, "inputHydro", inputHydro, "inputRail", inputRail, "railWidth", railWidth, "inputRoad", inputRoad, "roadWidth", roadWidth, "outputSuffixe", outputSuffixe, "srid", srid, "hRail", hRail, "hRoad", hRoad});
        Object template = callSiteArray[109].call(callSiteArray[110].call(engine, callSiteArray[111].call((Object)stringBuilder)), (Object)binding);
        callSiteArray[112].callStatic(Enrich_DEM.class, callSiteArray[113].call(template), sql, (Object)progress, (Object)logger);
        return callSiteArray[114].call((Object)"DEM successfully enriched in the table ", (Object)enrichedDEM);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Enrich_DEM.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        CallSite[] callSiteArray = Enrich_DEM.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = bigDecimal = new BigDecimal("0.5");
    }

    static {
        Enrich_DEM.__$swapInit();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "plus";
        stringArray[12] = "plus";
        stringArray[13] = "plus";
        stringArray[14] = "plus";
        stringArray[15] = "plus";
        stringArray[16] = "plus";
        stringArray[17] = "plus";
        stringArray[18] = "plus";
        stringArray[19] = "plus";
        stringArray[20] = "plus";
        stringArray[21] = "plus";
        stringArray[22] = "plus";
        stringArray[23] = "plus";
        stringArray[24] = "plus";
        stringArray[25] = "plus";
        stringArray[26] = "plus";
        stringArray[27] = "plus";
        stringArray[28] = "plus";
        stringArray[29] = "plus";
        stringArray[30] = "plus";
        stringArray[31] = "isEmpty";
        stringArray[32] = "get";
        stringArray[33] = "getStoreNames";
        stringArray[34] = "catalog";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "getStore";
        stringArray[37] = "catalog";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "getDataStore";
        stringArray[40] = "getDataStoreInfo";
        stringArray[41] = "getConnection";
        stringArray[42] = "getDataSource";
        stringArray[43] = "withCloseable";
        stringArray[44] = "openGeoserverDataStoreConnection";
        stringArray[45] = "withCloseable";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "getTableNames";
        stringArray[48] = "each";
        stringArray[49] = "getLogger";
        stringArray[50] = "getAt";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "subProcess";
        stringArray[53] = "getAt";
        stringArray[54] = "getAt";
        stringArray[55] = "getAt";
        stringArray[56] = "getAt";
        stringArray[57] = "getAt";
        stringArray[58] = "getAt";
        stringArray[59] = "getAt";
        stringArray[60] = "getAt";
        stringArray[61] = "getAt";
        stringArray[62] = "getAt";
        stringArray[63] = "getSRID";
        stringArray[64] = "parse";
        stringArray[65] = "getAt";
        stringArray[66] = "plus";
        stringArray[67] = "plus";
        stringArray[68] = "getAt";
        stringArray[69] = "getAt";
        stringArray[70] = "info";
        stringArray[71] = "info";
        stringArray[72] = "info";
        stringArray[73] = "plus";
        stringArray[74] = "info";
        stringArray[75] = "plus";
        stringArray[76] = "info";
        stringArray[77] = "plus";
        stringArray[78] = "info";
        stringArray[79] = "plus";
        stringArray[80] = "info";
        stringArray[81] = "plus";
        stringArray[82] = "info";
        stringArray[83] = "plus";
        stringArray[84] = "info";
        stringArray[85] = "plus";
        stringArray[86] = "info";
        stringArray[87] = "plus";
        stringArray[88] = "info";
        stringArray[89] = "plus";
        stringArray[90] = "info";
        stringArray[91] = "plus";
        stringArray[92] = "info";
        stringArray[93] = "plus";
        stringArray[94] = "info";
        stringArray[95] = "info";
        stringArray[96] = "<$constructor$>";
        stringArray[97] = "<$constructor$>";
        stringArray[98] = "<$constructor$>";
        stringArray[99] = "append";
        stringArray[100] = "append";
        stringArray[101] = "append";
        stringArray[102] = "append";
        stringArray[103] = "append";
        stringArray[104] = "append";
        stringArray[105] = "append";
        stringArray[106] = "append";
        stringArray[107] = "append";
        stringArray[108] = "append";
        stringArray[109] = "make";
        stringArray[110] = "createTemplate";
        stringArray[111] = "toString";
        stringArray[112] = "parseScript";
        stringArray[113] = "toString";
        stringArray[114] = "plus";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[115];
        Enrich_DEM.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Enrich_DEM.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Enrich_DEM.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

