/*
 * Decompiled with CFR 0.152.
 */
import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.sql.Sql;
import groovy.text.SimpleTemplateEngine;
import groovy.transform.Generated;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.h2.util.ScriptReader;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.RootProgressVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enrich_DEM_with_rail
extends Script {
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Enrich_DEM_with_rail() {
        CallSite[] callSiteArray = Enrich_DEM_with_rail.$getCallSiteArray();
    }

    public Enrich_DEM_with_rail(Binding context) {
        CallSite[] callSiteArray = Enrich_DEM_with_rail.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = Enrich_DEM_with_rail.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, Enrich_DEM_with_rail.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = Enrich_DEM_with_rail.$getCallSiteArray();
        String string = "Enrich DEM with railways";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, Enrich_DEM_with_rail.class, (GroovyObject)this, (String)"title");
        Object object = callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call(callSiteArray[15].call(callSiteArray[16].call(callSiteArray[17].call(callSiteArray[18].call(callSiteArray[19].call(callSiteArray[20].call(callSiteArray[21].call((Object)"&#10145;&#65039; Insert altimetric points coming from railways into the input DEM.</br>", (Object)"<hr>"), (Object)"This script works with two input layers:</br>"), (Object)" <ul>"), (Object)"<li>Digital Elevation Model (DEM) to be enriched</li>"), (Object)"<li>Railways</li>"), (Object)"</ul>"), (Object)"And four parameters:</br>"), (Object)" <ul>"), (Object)"<li>Railroads right-of-way (railWidth): Name of column where the railroad right-of-way is stored (Mandatory)</li>"), (Object)"<li>Rail platform height (hRail): Railways platform height (Optionnal). Default value = 0.5m</li>"), (Object)"<li>Input SRID (inputSRID): SRID of the input tables (Optionnal)</li>"), (Object)"<li>Output suffixe (outputSuffixe): Suffixe applied at the end of the resuling table name (Optionnal). If not specified, \"ENRICHED\" is applied</li>"), (Object)"</ul>"), (Object)"<hr>"), (Object)"In the schema below, orange points will be inserted into the DEM. d2, d3 and d4 are deduced from the information provided in the parameter <b>railWidth</b>, using the following formula:"), (Object)"<ul>"), (Object)"<li>d2 = (railWidth - 5.5)/2</li>"), (Object)"<li>d3 = (railWidth - 4)/2</li>"), (Object)"<li>d4 = (railWidth)/2</li>"), (Object)"</ul>"), (Object)"<img src=\"wps_images/railway_plateform.png\" alt=\"Railways platform\" width=\"95%\" align=\"center\">");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Enrich_DEM_with_rail.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"inputSRID", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Input SRID", "title", "Input SRID", "description", callSiteArray[22].call((Object)"&#127757; SRID of the input tables. </br> </br>", (Object)"&#128736; If not specified, the SRID from DEM layer is applied. If DEM has no SRID, 0 is applied"), "min", 0, "max", 1, "type", Integer.class}), "inputDEM", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Input DEM", "title", "Input DEM table", "description", "Name of the input DEM table to be enriched", "type", String.class}), "inputRail", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Input Railways", "title", "Input railways table", "description", "Name of the input railways table", "type", String.class}), "railWidth", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Railways width", "title", "Railways width", "description", "Name of column where the railways width is stored", "type", String.class}), "hRail", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Rail platform height", "title", "Railways platform height", "description", callSiteArray[23].call((Object)"Railways platform height (in meters) (Optionnal)</br> </br>", (Object)"&#128736; Default value = <b>0.5</b>"), "min", 0, "max", 1, "type", Double.TYPE}), "outputSuffixe", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Output suffixe", "title", "Output suffixe", "description", callSiteArray[24].call((Object)"Suffixe applied at the end of the resuling table name </br> </br>", (Object)"&#128736; If not specified, \"ENRICHED\" is applied"), "min", 0, "max", 1, "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, Enrich_DEM_with_rail.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "This type of result does not allow the blocks to be linked together.", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, Enrich_DEM_with_rail.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Object parseScript(String sqlInstructions, Sql sql, ProgressVisitor progressVisitor, Logger logger) {
        InputStreamReader reader = null;
        ByteArrayInputStream s = new ByteArrayInputStream(sqlInstructions.getBytes());
        ByteArrayInputStream is = s;
        LinkedList<String> statementList = new LinkedList<String>();
        try {
            reader = new InputStreamReader(is);
            ScriptReader scriptReader = new ScriptReader((Reader)reader);
            scriptReader.setSkipRemarks(false);
            String statement = scriptReader.readStatement();
            while (statement != null && !statement.trim().isEmpty()) {
                statementList.add(statement);
                scriptReader.readStatement();
            }
        }
        finally {
            reader.close();
        }
        int idStatement = 0;
        int nbStatements = statementList.size();
        ProgressVisitor evalProgress = progressVisitor.subProcess(nbStatements);
        LinkedList<String> linkedList = statementList;
        Iterator iterator = linkedList != null ? linkedList.iterator() : null;
        String statement = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                statement = ShortTypeHandling.castToString(iterator2.next());
                String subStatement2 = null;
                String[] stringArray = statement.split("\n");
                if (stringArray != null) {
                    for (String subStatement2 : stringArray) {
                        if (!subStatement2.trim().startsWith("--")) continue;
                        logger.info(String.format(Locale.ROOT, "%d/%d %s", idStatement + 1, nbStatements, subStatement2.replace("--", "")));
                    }
                }
                int n = idStatement;
                int cfr_ignored_0 = n + 1;
                sql.execute(statement);
                evalProgress.endStep();
                if (!evalProgress.isCanceled()) continue;
                throw (Throwable)new SQLException("Canceled by user");
            }
        }
        return null;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = Enrich_DEM_with_rail.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[25].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[26].call(callSiteArray[27].call(callSiteArray[28].callGroovyObjectGetProperty(callSiteArray[29].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call(callSiteArray[31].callGroovyObjectGetProperty(callSiteArray[32].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].call(callSiteArray[34].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].call(callSiteArray[36].call((Object)jdbcDataStore)), Connection.class);
    }

    public Object run(Object input) {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure1(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = Enrich_DEM_with_rail.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[37].call(callSiteArray[38].callStatic(Enrich_DEM_with_rail.class, (Object)dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
        }
        return callSiteArray[39].call((Object)Enrich_DEM_with_rail.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
    }

    public Object exec(Connection connection, Object input) {
        Reference connection2 = new Reference((Object)connection);
        CallSite[] callSiteArray = Enrich_DEM_with_rail.$getCallSiteArray();
        Reference ignorelst = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"SPATIAL_REF_SYS", "GEOMETRY_COLUMNS"}));
        Reference sb = new Reference((Object)((StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].callConstructor(StringBuilder.class), StringBuilder.class)));
        List tables = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call(JDBCUtilities.class, ArrayUtil.createArray((Object)((Connection)connection2.get()), null, (Object)"PUBLIC", (Object)"%", null)), List.class);
        public final class _exec_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference ignorelst;
            private /* synthetic */ Reference sb;
            private /* synthetic */ Reference connection;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _exec_closure2(Object _outerInstance, Object _thisObject, Reference ignorelst, Reference sb, Reference connection) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.ignorelst = reference3 = ignorelst;
                this.sb = reference2 = sb;
                this.connection = reference = connection;
            }

            public Object doCall(Object t) {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                TableLocation tab = (TableLocation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(TableLocation.class, t), TableLocation.class);
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call(this.ignorelst.get(), callSiteArray[2].call((Object)tab)))) {
                    if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[3].call(this.sb.get()), (Object)0)) {
                        callSiteArray[4].call(this.sb.get(), (Object)" || ");
                    }
                    callSiteArray[5].call(this.sb.get(), callSiteArray[6].call((Object)tab));
                    Statement stmt = (Statement)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].call(this.connection.get()), Statement.class);
                    return stmt;
                }
                return null;
            }

            @Generated
            public List getIgnorelst() {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.ignorelst.get(), List.class);
            }

            @Generated
            public StringBuilder getSb() {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.sb.get(), StringBuilder.class);
            }

            @Generated
            public Connection getConnection() {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                return (Connection)ScriptBytecodeAdapter.castToType((Object)this.connection.get(), Connection.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _exec_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "parse";
                stringArray[1] = "contains";
                stringArray[2] = "getTable";
                stringArray[3] = "size";
                stringArray[4] = "append";
                stringArray[5] = "append";
                stringArray[6] = "getTable";
                stringArray[7] = "createStatement";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _exec_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_exec_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _exec_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[42].call((Object)tables, (Object)new _exec_closure2((Object)this, (Object)this, ignorelst, sb, connection2));
        Object resultString = null;
        Logger logger = (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].call(LoggerFactory.class, (Object)"org.noise_planet.noisemodelling"), Logger.class);
        ProgressVisitor progressVisitor = null;
        progressVisitor = ScriptBytecodeAdapter.isCase((Object)"progressVisitor", (Object)input) ? (ProgressVisitor)ScriptBytecodeAdapter.asType((Object)callSiteArray[44].call(input, (Object)"progressVisitor"), ProgressVisitor.class) : (ProgressVisitor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[45].callConstructor(RootProgressVisitor.class, (Object)1, (Object)true, (Object)1), ProgressVisitor.class);
        ProgressVisitor progress = (ProgressVisitor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].call((Object)progressVisitor, (Object)2), ProgressVisitor.class);
        String inputDEM = ShortTypeHandling.castToString((Object)callSiteArray[47].call(input, (Object)"inputDEM"));
        String inputRail = ShortTypeHandling.castToString((Object)callSiteArray[48].call(input, (Object)"inputRail"));
        String railWidth = ShortTypeHandling.castToString((Object)callSiteArray[49].call(input, (Object)"railWidth"));
        double hRail = DefaultTypeTransformation.doubleUnbox((Object)$const$0);
        if (ScriptBytecodeAdapter.isCase((Object)"hRail", (Object)input)) {
            hRail = DefaultTypeTransformation.doubleUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[50].call(input, (Object)"hRail"), Double.TYPE));
        }
        Integer srid = 0;
        srid = ScriptBytecodeAdapter.isCase((Object)"inputSRID", (Object)input) ? (Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[51].call(input, (Object)"inputSRID"), Integer.class) : (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].call(GeometryTableUtilities.class, (Object)((Connection)connection2.get()), callSiteArray[53].call(TableLocation.class, (Object)inputDEM)), Integer.class);
        String outputSuffixe = "ENRICHED";
        if (ScriptBytecodeAdapter.isCase((Object)"outputSuffixe", (Object)input)) {
            outputSuffixe = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[54].call(input, (Object)"outputSuffixe"), String.class);
        }
        String enrichedDEM = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[55].call(callSiteArray[56].call(callSiteArray[57].call(input, (Object)"inputDEM"), (Object)"_"), callSiteArray[58].call(input, (Object)"outputSuffixe")), String.class);
        callSiteArray[59].call((Object)logger, (Object)"List of the input parameters:");
        callSiteArray[60].call((Object)logger, (Object)"--------------------------------------------");
        callSiteArray[61].call((Object)logger, callSiteArray[62].call((Object)"# SRID: ", (Object)srid));
        callSiteArray[63].call((Object)logger, callSiteArray[64].call((Object)"# DEM table: ", (Object)inputDEM));
        callSiteArray[65].call((Object)logger, callSiteArray[66].call((Object)"# Railways network table: ", (Object)inputRail));
        callSiteArray[67].call((Object)logger, callSiteArray[68].call((Object)"# Railways width column: ", (Object)railWidth));
        callSiteArray[69].call((Object)logger, callSiteArray[70].call((Object)"# Railways platform height: ", (Object)hRail));
        callSiteArray[71].call((Object)logger, callSiteArray[72].call((Object)"# Output suffixe: ", (Object)outputSuffixe));
        callSiteArray[73].call((Object)logger, (Object)"--------------------------------------------");
        callSiteArray[74].call((Object)logger, (Object)"Start enrich the DEM");
        Object sql = callSiteArray[75].callConstructor(Sql.class, (Object)((Connection)connection2.get()));
        GStringImpl import_dem = new GStringImpl(new Object[]{inputDEM, inputDEM}, new String[]{"\n    ------------\n    -- Import DEM\n\n    DROP TABLE IF EXISTS dem_to_enrich;\n    CREATE TABLE dem_to_enrich AS SELECT THE_GEOM, 'DEM' as SOURCE FROM ", ";\n    \n    -- DEM: layer ", " imported\n    "});
        GStringImpl import_rail = new GStringImpl(new Object[]{railWidth, inputRail, inputRail}, new String[]{"\n    ------------\n    -- Import railways (that are on the floor --> POS_SOL=0)\n\n    DROP TABLE IF EXISTS dem_rail;    \n    CREATE TABLE dem_rail AS SELECT THE_GEOM, 'RAIL' as SOURCE, ", " as WIDTH FROM ", " WHERE st_zmin(THE_GEOM) > 0;\n    CREATE SPATIAL INDEX ON dem_rail(THE_GEOM);\n    ALTER TABLE dem_rail ADD PK_LINE INT AUTO_INCREMENT NOT NULL;\n    ALTER TABLE dem_rail add primary key(PK_LINE);\n    \n    -- Railways: layer ", " imported\n    "});
        GStringImpl enrich_rail = new GStringImpl(new Object[]{enrichedDEM, enrichedDEM, srid, srid, railWidth, srid, railWidth, hRail, srid, railWidth, hRail, srid, enrichedDEM}, new String[]{"\n    ------------\n    -- Start enrich the DEM in a new layer called ", "\n\n    -- Insert rail platform into ", "\n\n    DROP TABLE DEM_WITHOUT_PTLINE IF EXISTS;\n    CREATE TABLE DEM_WITHOUT_PTLINE(THE_GEOM geometry(POINTZ, ", "), source varchar) AS SELECT st_setsrid(THE_GEOM, ", "), SOURCE FROM dem_to_enrich;\n    \n    -- Remove DEM points that are less than \"WIDTH/2\" far FROM rails\n    DELETE FROM DEM_WITHOUT_PTLINE WHERE EXISTS (SELECT 1 FROM dem_rail b \n        WHERE ST_EXPAND(DEM_WITHOUT_PTLINE.THE_GEOM, 20) && b.THE_GEOM \n        AND ST_DISTANCE(DEM_WITHOUT_PTLINE.THE_GEOM, b.THE_GEOM)< ((b.WIDTH/2) + 5)  LIMIT 1) ;\n    \n    -- Create buffer points from rails and copy the elevation from the rails to the point\n    DROP TABLE IF EXISTS BUFFERED_D2, BUFFERED_D3, BUFFERED_D4;\n    -- The buffer sizes correspond to: \n    -- # d2 = (", " - 5.5)/2\n    CREATE TABLE BUFFERED_D2 AS SELECT ST_ToMultiPoint(ST_Densify(ST_Buffer(ST_Simplify(st_force2D(THE_GEOM), 2), (WIDTH - 5.5)/2, 'endcap=flat join=mitre'), 5)) THE_GEOM, PK_LINE FROM dem_rail WHERE st_length(st_simplify(THE_GEOM, 2)) > 0 ;\n    INSERT INTO DEM_WITHOUT_PTLINE(THE_GEOM, SOURCE) SELECT st_setsrid(ST_MakePoint(ST_X(P.THE_GEOM), ST_Y(P.THE_GEOM), ST_Z(ST_ProjectPoint(P.THE_GEOM,L.THE_GEOM))), ", ") THE_GEOM, 'RAI' FROM ST_EXPLODE('BUFFERED_D2') P, dem_rail L WHERE P.PK_LINE = L.PK_LINE;\n    \n    -- # d3 = (", " - 4)/2\n    CREATE TABLE BUFFERED_D3 AS SELECT ST_ToMultiPoint(ST_Densify(ST_Buffer(ST_Simplify(THE_GEOM, 2), (WIDTH - 4)/2, 'endcap=flat join=mitre'), 5)) THE_GEOM, PK_LINE FROM dem_rail WHERE st_length(st_simplify(THE_GEOM, 2)) > 0 ;\n    INSERT INTO DEM_WITHOUT_PTLINE(THE_GEOM, SOURCE) SELECT st_setsrid(ST_MakePoint(ST_X(P.THE_GEOM), ST_Y(P.THE_GEOM), ST_Z(ST_ProjectPoint(P.THE_GEOM,L.THE_GEOM))-", "), ", ") THE_GEOM, 'RAI' FROM ST_EXPLODE('BUFFERED_D3') P, dem_rail L WHERE P.PK_LINE = L.PK_LINE;\n\n    -- # d4 = (", ")/2\n    CREATE TABLE BUFFERED_D4 AS SELECT ST_ToMultiPoint(ST_Densify(ST_Buffer(ST_Simplify(THE_GEOM, 2), WIDTH/2, 'endcap=flat join=mitre'), 5)) THE_GEOM, PK_LINE FROM dem_rail WHERE st_length(st_simplify(THE_GEOM, 2)) > 0 ;\n    INSERT INTO DEM_WITHOUT_PTLINE(THE_GEOM, SOURCE) SELECT st_setsrid(ST_MakePoint(ST_X(P.THE_GEOM), ST_Y(P.THE_GEOM), ST_Z(ST_ProjectPoint(P.THE_GEOM,L.THE_GEOM))-", "), ", ") THE_GEOM, 'RAI' FROM ST_EXPLODE('BUFFERED_D4') P, dem_rail L WHERE P.PK_LINE = L.PK_LINE;\n    \n    -- ", " enriched with railways\n    "});
        GStringImpl enrich_final = new GStringImpl(new Object[]{enrichedDEM, enrichedDEM, enrichedDEM, enrichedDEM, enrichedDEM}, new String[]{"\n    \n    DROP TABLE IF EXISTS ", ";\n    ALTER TABLE DEM_WITHOUT_PTLINE RENAME TO ", ";\n    -- Create a spatial index on ", "\n    CREATE SPATIAL INDEX ON ", " (THE_GEOM);\n\n    ----------------------------------\n    -- Remove non needed tables\n    \n    DROP TABLE IF EXISTS DEM_RAIL, BUFFERED_D2, BUFFERED_D3, BUFFERED_D4, BUFFERED_PTLINE, dem_to_enrich;\n\n    -- DEM successfully enriched in the table ", "\n    "});
        StringBuilder stringBuilder = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[76].callConstructor(StringBuilder.class), StringBuilder.class);
        Object engine = callSiteArray[77].callConstructor(SimpleTemplateEngine.class);
        callSiteArray[78].call((Object)stringBuilder, (Object)import_dem);
        callSiteArray[79].call((Object)stringBuilder, (Object)import_rail);
        callSiteArray[80].call((Object)stringBuilder, (Object)enrich_rail);
        callSiteArray[81].call((Object)stringBuilder, (Object)enrich_final);
        Map binding = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"inputDEM", inputDEM, "inputRail", inputRail, "railWidth", railWidth, "outputSuffixe", outputSuffixe, "srid", srid, "hRail", hRail});
        Object template = callSiteArray[82].call(callSiteArray[83].call(engine, callSiteArray[84].call((Object)stringBuilder)), (Object)binding);
        callSiteArray[85].callStatic(Enrich_DEM_with_rail.class, callSiteArray[86].call(template), sql, (Object)progress, (Object)logger);
        return callSiteArray[87].call((Object)"DEM successfully enriched in the table ", (Object)enrichedDEM);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Enrich_DEM_with_rail.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        CallSite[] callSiteArray = Enrich_DEM_with_rail.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = bigDecimal = new BigDecimal("0.5");
    }

    static {
        Enrich_DEM_with_rail.__$swapInit();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "plus";
        stringArray[12] = "plus";
        stringArray[13] = "plus";
        stringArray[14] = "plus";
        stringArray[15] = "plus";
        stringArray[16] = "plus";
        stringArray[17] = "plus";
        stringArray[18] = "plus";
        stringArray[19] = "plus";
        stringArray[20] = "plus";
        stringArray[21] = "plus";
        stringArray[22] = "plus";
        stringArray[23] = "plus";
        stringArray[24] = "plus";
        stringArray[25] = "isEmpty";
        stringArray[26] = "get";
        stringArray[27] = "getStoreNames";
        stringArray[28] = "catalog";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "getStore";
        stringArray[31] = "catalog";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "getDataStore";
        stringArray[34] = "getDataStoreInfo";
        stringArray[35] = "getConnection";
        stringArray[36] = "getDataSource";
        stringArray[37] = "withCloseable";
        stringArray[38] = "openGeoserverDataStoreConnection";
        stringArray[39] = "withCloseable";
        stringArray[40] = "<$constructor$>";
        stringArray[41] = "getTableNames";
        stringArray[42] = "each";
        stringArray[43] = "getLogger";
        stringArray[44] = "getAt";
        stringArray[45] = "<$constructor$>";
        stringArray[46] = "subProcess";
        stringArray[47] = "getAt";
        stringArray[48] = "getAt";
        stringArray[49] = "getAt";
        stringArray[50] = "getAt";
        stringArray[51] = "getAt";
        stringArray[52] = "getSRID";
        stringArray[53] = "parse";
        stringArray[54] = "getAt";
        stringArray[55] = "plus";
        stringArray[56] = "plus";
        stringArray[57] = "getAt";
        stringArray[58] = "getAt";
        stringArray[59] = "info";
        stringArray[60] = "info";
        stringArray[61] = "info";
        stringArray[62] = "plus";
        stringArray[63] = "info";
        stringArray[64] = "plus";
        stringArray[65] = "info";
        stringArray[66] = "plus";
        stringArray[67] = "info";
        stringArray[68] = "plus";
        stringArray[69] = "info";
        stringArray[70] = "plus";
        stringArray[71] = "info";
        stringArray[72] = "plus";
        stringArray[73] = "info";
        stringArray[74] = "info";
        stringArray[75] = "<$constructor$>";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "<$constructor$>";
        stringArray[78] = "append";
        stringArray[79] = "append";
        stringArray[80] = "append";
        stringArray[81] = "append";
        stringArray[82] = "make";
        stringArray[83] = "createTemplate";
        stringArray[84] = "toString";
        stringArray[85] = "parseScript";
        stringArray[86] = "toString";
        stringArray[87] = "plus";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[88];
        Enrich_DEM_with_rail.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Enrich_DEM_with_rail.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Enrich_DEM_with_rail.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

