/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.runner;

import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.h2.Driver;
import org.h2.util.OsgiDataSourceFactory;
import org.h2gis.functions.factory.H2GISFunctions;
import org.h2gis.utilities.wrapper.ConnectionWrapper;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.RootProgressVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    public static final int SECONDS_BETWEEN_PROGRESSION_PRINT = 5;

    public static DataSource createDataSource(String user, String password, String dbDirectory, String dbName, boolean debug) throws SQLException {
        Driver driver = Driver.load();
        OsgiDataSourceFactory dataSourceFactory = new OsgiDataSourceFactory(driver);
        Properties properties = new Properties();
        String databasePath = "jdbc:h2:" + new File(dbDirectory, dbName).getAbsolutePath();
        properties.setProperty("url", databasePath);
        properties.setProperty("user", user);
        properties.setProperty("password", password);
        if (debug) {
            properties.setProperty("TRACE_LEVEL_FILE", "3");
        }
        DataSource dataSource = dataSourceFactory.createDataSource(properties);
        try (Connection connection = dataSource.getConnection();){
            H2GISFunctions.load((Connection)connection);
        }
        return dataSource;
    }

    public static void printBuildIdentifiers(Logger logger) {
        try {
            String columnFormat = "%-35.35s %-35.35s %-20.20s %-30.30s";
            String[] columns = new String[]{"name", "last-modified", "version", "commit"};
            Enumeration<URL> resources = Main.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Loaded libraries:\n");
            stringBuilder.append(String.format(Locale.ROOT, columnFormat, (Object[])columns));
            stringBuilder.append("\n");
            HashMap rows = new HashMap();
            for (String column : columns) {
                rows.put(column, new ArrayList());
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.getDefault());
            int nbRows = 0;
            while (resources.hasMoreElements()) {
                try {
                    Manifest manifest = new Manifest(resources.nextElement().openStream());
                    Attributes attributes = manifest.getMainAttributes();
                    String bundleName = attributes.getValue("Bundle-Name");
                    String bundleVersion = attributes.getValue("Bundle-Version");
                    String gitCommitId = attributes.getValue("Implementation-Build");
                    String lastModifier = attributes.getValue("Bnd-LastModified");
                    if (bundleName == null) continue;
                    ++nbRows;
                    ((ArrayList)rows.get(columns[0])).add(bundleName);
                    if (lastModifier != null) {
                        long lastModifiedLong = Long.parseLong(lastModifier);
                        ((ArrayList)rows.get(columns[1])).add(simpleDateFormat.format(new Date(lastModifiedLong)));
                    } else {
                        ((ArrayList)rows.get(columns[1])).add(" - ");
                    }
                    ((ArrayList)rows.get(columns[2])).add(bundleVersion != null ? bundleVersion : " - ");
                    ((ArrayList)rows.get(columns[3])).add(gitCommitId != null ? gitCommitId : " - ");
                }
                catch (IOException ex) {
                    logger.error(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            for (int idRow = 0; idRow < nbRows; ++idRow) {
                String[] rowValues = new String[columns.length];
                for (int idColumn = 0; idColumn < columns.length; ++idColumn) {
                    String column = columns[idColumn];
                    rowValues[idColumn] = (String)((ArrayList)rows.get(column)).get(idRow);
                }
                stringBuilder.append(String.format(Locale.ROOT, columnFormat, (Object[])rowValues));
                stringBuilder.append("\n");
            }
            logger.info(stringBuilder.toString());
        }
        catch (IOException ex) {
            logger.error("Error while accessing resources", (Throwable)ex);
        }
    }

    public static void main(String ... args) throws Exception {
        block31: {
            PropertyConfigurator.configure((URL)Main.class.getResource("log4j.properties"));
            Options options = new Options();
            Option workingDirOption = new Option("w", "working-dir", true, "Path where the database will be located");
            workingDirOption.setRequired(true);
            workingDirOption.setArgName("folder path");
            options.addOption(workingDirOption);
            Option scriptPathOption = new Option("s", "script", true, "Path and file name of the script");
            scriptPathOption.setRequired(true);
            scriptPathOption.setArgName("script path");
            options.addOption(scriptPathOption);
            Option databaseNameOption = new Option("d", "database-name", true, "Database name (default to h2gisdb)");
            options.addOption(databaseNameOption);
            Option printVersionOption = new Option("v", false, "Print version of all libraries");
            options.addOption(printVersionOption);
            Option shutdownOption = new Option("c", "shutdown", false, "Do not shutdown compact the database at the end of the execution");
            options.addOption(shutdownOption);
            Logger logger = LoggerFactory.getLogger((String)"org.noise_planet");
            try {
                boolean shutdown;
                CommandLine commandLine;
                String workingDir = "";
                String scriptPath = "";
                String databaseName = "";
                HashMap<String, Object> customParameters = new HashMap<String, Object>();
                boolean printVersion = false;
                DefaultParser commandLineParser = new DefaultParser();
                HelpFormatter helpFormatter = new HelpFormatter();
                try {
                    commandLine = commandLineParser.parse(options, args, true);
                }
                catch (ParseException ex) {
                    logger.info(ex.getMessage());
                    helpFormatter.printHelp("NoiseModelling Script Runner", options);
                    System.exit(1);
                    return;
                }
                workingDir = commandLine.getOptionValue(workingDirOption.getOpt());
                scriptPath = commandLine.getOptionValue(scriptPathOption.getOpt());
                printVersion = commandLine.hasOption(printVersionOption.getOpt());
                databaseName = commandLine.getOptionValue(databaseNameOption.getOpt(), "h2gisdb");
                boolean bl = shutdown = !commandLine.hasOption(shutdownOption.getOpt());
                if (printVersion) {
                    Main.printBuildIdentifiers(logger);
                }
                try {
                    RollingFileAppender rollingAppender = new RollingFileAppender();
                    rollingAppender.setName("rollingFile");
                    rollingAppender.setFile(new File(workingDir, "application.log").getPath());
                    rollingAppender.setAppend(true);
                    rollingAppender.setMaxBackupIndex(5);
                    rollingAppender.setMaximumFileSize(10000000L);
                    PatternLayout layout = new PatternLayout();
                    layout.setConversionPattern("[%t] %-5p %d{dd MMM HH:mm:ss} - %m%n");
                    rollingAppender.setLayout((Layout)layout);
                    rollingAppender.activateOptions();
                    org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
                    rootLogger.addAppender((Appender)rollingAppender);
                }
                catch (Exception e) {
                    System.err.println("Failed to configure logger: " + e.getMessage());
                }
                DataSource ds = Main.createDataSource("", "", new File(workingDir).getAbsolutePath(), databaseName, false);
                RootProgressVisitor progressVisitor = new RootProgressVisitor(1L, true, 5.0);
                try {
                    ConnectionWrapper connection = new ConnectionWrapper(ds.getConnection());
                    try {
                        GroovyShell shell = new GroovyShell();
                        Script script = shell.parse(new File(scriptPath));
                        script.run();
                        if (shell.getVariable("inputs") == null) {
                            throw new IllegalArgumentException("Script does not contains inputs variable");
                        }
                        ((Map)shell.getVariable("inputs")).forEach((key, value) -> {
                            Map optionAttributes = (Map)value;
                            Option customOption = new Option(key.toString(), optionAttributes.get("type") != Boolean.class, optionAttributes.getOrDefault("description", "").toString().replaceAll("<[^>]*>", ""));
                            customOption.setType((Class)optionAttributes.get("type"));
                            customOption.setArgs(1);
                            customOption.setArgName(optionAttributes.get("name").toString());
                            customOption.setRequired(!optionAttributes.containsKey("min") || (Integer)optionAttributes.get("min") == 1);
                            options.addOption(customOption);
                        });
                        try {
                            commandLine = commandLineParser.parse(options, args);
                            for (Option option : commandLine) {
                                if (option.getType() == String.class) {
                                    customParameters.put(option.getOpt(), option.getValue());
                                    continue;
                                }
                                if (option.getType() == Boolean.class) {
                                    customParameters.put(option.getOpt(), Boolean.valueOf(option.getValue()));
                                    continue;
                                }
                                if (option.getType() == Integer.class) {
                                    customParameters.put(option.getOpt(), Integer.valueOf(option.getValue()));
                                    continue;
                                }
                                if (option.getType() == Double.class) {
                                    customParameters.put(option.getOpt(), NumberFormat.getInstance(Locale.ROOT).parse(option.getValue()).doubleValue());
                                    continue;
                                }
                                throw new IllegalArgumentException("Unsupported type for option " + option.getOpt());
                            }
                        }
                        catch (ParseException ex) {
                            logger.info(ex.getMessage());
                            helpFormatter.printHelp("NoiseModelling Script Runner", options);
                            System.exit(1);
                            connection.close();
                            return;
                        }
                        HashMap<String, RootProgressVisitor> inputs = new HashMap<String, RootProgressVisitor>(customParameters);
                        inputs.put("progressVisitor", progressVisitor);
                        Object result = script.invokeMethod("exec", (Object)new Object[]{connection, inputs});
                        if (result != null) {
                            logger.info(result.toString());
                        }
                        if (!shutdown) break block31;
                        try (Statement st = connection.createStatement();){
                            logger.info("Shutdown compact the database..");
                            st.execute("SHUTDOWN COMPACT");
                            logger.info("done");
                        }
                    }
                    finally {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
                catch (SQLException ex) {
                    while (ex != null) {
                        logger.error(ex.getLocalizedMessage(), (Throwable)ex);
                        ex = ex.getNextException();
                    }
                    System.exit(1);
                }
            }
            catch (Throwable ex) {
                logger.error(ex.getLocalizedMessage(), ex);
                System.exit(1);
            }
        }
    }
}

