/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.wps.Acoustic_Tools;

import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.wrapper.ConnectionWrapper;
import org.noise_planet.noisemodelling.jdbc.utils.IsoSurface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Create_Isosurface
extends Script {
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ BigDecimal $const$1;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Create_Isosurface() {
        CallSite[] callSiteArray = Create_Isosurface.$getCallSiteArray();
    }

    public Create_Isosurface(Binding context) {
        CallSite[] callSiteArray = Create_Isosurface.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = Create_Isosurface.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, Create_Isosurface.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = Create_Isosurface.$getCallSiteArray();
        String string = "Create isosurfaces from a NoiseModelling resulting table and its associated TRIANGLES table.";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, Create_Isosurface.class, (GroovyObject)this, (String)"title");
        Object object = callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call((Object)"&#10145;&#65039; Create isosurfaces from a NoiseModelling resulting table and its associated TRIANGLES table.", (Object)"<hr>"), (Object)"&#x1F6A8; The triangle table must have been created using the WPS block \"<b>Receivers/Delaunay_Grid</b>\". </br> </br> "), (Object)"&#x2705; The output table is called <b>CONTOURING_NOISE_MAP</b> </br> </br> "), (Object)"<img src=\"/wps_images/create_isosurface.png\" alt=\"Create isosurfaces\" width=\"95%\" align=\"center\">");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Create_Isosurface.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"resultTable", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Sound levels table", "title", "Sound levels table", "description", callSiteArray[5].call((Object)"Name of the sound levels table, generated from \"Noise_level_from_source\". (STRING)</br> </br>", (Object)"Example : RECEIVERS_LEVEL."), "type", String.class}), "isoClass", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Iso levels in dB", "title", "Iso levels in dB", "description", callSiteArray[6].call(callSiteArray[7].call((Object)"Separation of sound levels for isosurfaces. First range is from -&#8734; to first value excluded. The first value included to next value excluded..</br> </br>", (Object)"Read <a href=\"https://noisemodelling.readthedocs.io/en/latest/Noise_Map_Color_Scheme.html#creation-of-the-isosurfaces\" target=_blank>this documentation</a> for more information about sound levels classes. </br> </br>"), (Object)"&#128736; Default value: <b>35.0,40.0,45.0,50.0,55.0,60.0,65.0,70.0,75.0,80.0,200.0 </b>"), "min", 0, "max", 1, "type", String.class}), "resultTableField", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Field of result table", "title", "Field of result table", "description", "Field to read in the result table to make the iso surface; Default value: LAEQ", "min", 0, "max", 1, "type", String.class}), "keepTriangles", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Keep triangles", "title", "Keep triangles", "description", callSiteArray[8].call((Object)"Point inside areas with the same iso levels are kept so elevation variation into ", (Object)"same iso level areas will be preserved but the output data size will be higher."), "min", 0, "max", 1, "type", Boolean.class}), "smoothCoefficient", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Polygon smoothing coefficient", "title", "Polygon smoothing coefficient", "description", callSiteArray[9].call(callSiteArray[10].call((Object)"This coefficient (<a href=\"https://en.wikipedia.org/wiki/B%C3%A9zier_curve\" target=\"_blank\">Bezier curve</a> coefficient) will smooth the generated isosurfaces. </br> </br>", (Object)"If equal to 0, it disables the smoothing step and will keep the altitude of receivers (3D geojson can be viewed on https://kepler.gl).</br> </br>"), (Object)"&#128736; Default value: <b>0.5 </b>"), "min", 0, "max", 1, "type", Double.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, Create_Isosurface.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "This type of result does not allow the blocks to be linked together.", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, Create_Isosurface.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = Create_Isosurface.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].callGroovyObjectGetProperty(callSiteArray[15].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].call(callSiteArray[17].callGroovyObjectGetProperty(callSiteArray[18].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[19].call(callSiteArray[20].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].call(callSiteArray[22].call((Object)jdbcDataStore)), Connection.class);
    }

    public Object exec(Connection connection, Map input) {
        CallSite[] callSiteArray = Create_Isosurface.$getCallSiteArray();
        connection = (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].callConstructor(ConnectionWrapper.class, (Object)connection), Connection.class);
        String resultString = null;
        Logger logger = (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].call(LoggerFactory.class, (Object)"org.noise_planet.noisemodelling"), Logger.class);
        callSiteArray[25].call((Object)logger, (Object)"Start : Compute Isosurfaces");
        callSiteArray[26].call((Object)logger, (Object)"inputs {}", (Object)input);
        List isoLevels = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].callGetProperty(IsoSurface.class), List.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].call((Object)input, (Object)"isoClass"))) {
            isoLevels = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[29].callConstructor(ArrayList.class), List.class);
            StringTokenizer st = (StringTokenizer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].callConstructor(StringTokenizer.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[31].call((Object)input, (Object)"isoClass"), String.class)), String.class), (Object)","), StringTokenizer.class);
            while (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[32].call((Object)st))) {
                callSiteArray[33].call((Object)isoLevels, callSiteArray[34].call(Double.class, callSiteArray[35].call((Object)st)));
            }
        }
        String levelTable = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[36].call((Object)input, (Object)"resultTable"), String.class);
        int srid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[37].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[38].call(TableLocation.class, (Object)levelTable)));
        IsoSurface isoSurface = (IsoSurface)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].callConstructor(IsoSurface.class, (Object)isoLevels, (Object)srid), IsoSurface.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[40].call((Object)input, (Object)"resultTableField"))) {
            callSiteArray[41].call((Object)isoSurface, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[42].call((Object)input, (Object)"resultTableField"), String.class)), String.class));
        }
        callSiteArray[43].call((Object)isoSurface, (Object)levelTable);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[44].call((Object)input, (Object)"smoothCoefficient"))) {
            double coefficient = (Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[45].call((Object)input, (Object)"smoothCoefficient"), Double.class);
            if (!BytecodeInterface8.isOrigD() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareLessThan((Object)coefficient, (Object)$const$0)) {
                    callSiteArray[46].call((Object)isoSurface, (Object)false);
                } else {
                    callSiteArray[47].call((Object)isoSurface, (Object)true);
                    callSiteArray[48].call((Object)isoSurface, (Object)coefficient);
                }
            } else if (coefficient < DefaultTypeTransformation.doubleUnbox((Object)$const$0)) {
                callSiteArray[49].call((Object)isoSurface, (Object)false);
            } else {
                callSiteArray[50].call((Object)isoSurface, (Object)true);
                callSiteArray[51].call((Object)isoSurface, (Object)coefficient);
            }
        } else {
            callSiteArray[52].call((Object)isoSurface, (Object)true);
            callSiteArray[53].call((Object)isoSurface, (Object)$const$1);
        }
        callSiteArray[54].call((Object)isoSurface, (Object)connection, (Object)"IDRECEIVER");
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[55].call(callSiteArray[56].call((Object)"Table ", callSiteArray[57].call((Object)isoSurface)), (Object)" created"));
        callSiteArray[58].call((Object)logger, (Object)"End : Compute Isosurfaces");
        callSiteArray[59].call((Object)logger, (Object)resultString);
        return resultString;
    }

    public Object run(Object input) {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure1(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = Create_Isosurface.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[60].call(callSiteArray[61].callStatic(Create_Isosurface.class, (Object)dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
        }
        return callSiteArray[62].call((Object)Create_Isosurface.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Create_Isosurface.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        CallSite[] callSiteArray = Create_Isosurface.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = bigDecimal2 = new BigDecimal("0.01");
        $const$1 = bigDecimal = new BigDecimal("0.5");
    }

    static {
        Create_Isosurface.__$swapInit();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "isEmpty";
        stringArray[12] = "get";
        stringArray[13] = "getStoreNames";
        stringArray[14] = "catalog";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "getStore";
        stringArray[17] = "catalog";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "getDataStore";
        stringArray[20] = "getDataStoreInfo";
        stringArray[21] = "getConnection";
        stringArray[22] = "getDataSource";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "getLogger";
        stringArray[25] = "info";
        stringArray[26] = "info";
        stringArray[27] = "NF31_133_ISO";
        stringArray[28] = "containsKey";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "getAt";
        stringArray[32] = "hasMoreTokens";
        stringArray[33] = "add";
        stringArray[34] = "parseDouble";
        stringArray[35] = "nextToken";
        stringArray[36] = "getAt";
        stringArray[37] = "getSRID";
        stringArray[38] = "parse";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "containsKey";
        stringArray[41] = "setPointTableField";
        stringArray[42] = "getAt";
        stringArray[43] = "setPointTable";
        stringArray[44] = "containsKey";
        stringArray[45] = "getAt";
        stringArray[46] = "setSmooth";
        stringArray[47] = "setSmooth";
        stringArray[48] = "setSmoothCoefficient";
        stringArray[49] = "setSmooth";
        stringArray[50] = "setSmooth";
        stringArray[51] = "setSmoothCoefficient";
        stringArray[52] = "setSmooth";
        stringArray[53] = "setSmoothCoefficient";
        stringArray[54] = "createTable";
        stringArray[55] = "plus";
        stringArray[56] = "plus";
        stringArray[57] = "getOutputTable";
        stringArray[58] = "info";
        stringArray[59] = "info";
        stringArray[60] = "withCloseable";
        stringArray[61] = "openGeoserverDataStoreConnection";
        stringArray[62] = "withCloseable";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[63];
        Create_Isosurface.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Create_Isosurface.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Create_Isosurface.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

