/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.wps.Geometric_Tools;

import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.sql.Sql;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clean_Buildings_Table
extends Script {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Clean_Buildings_Table() {
        CallSite[] callSiteArray = Clean_Buildings_Table.$getCallSiteArray();
    }

    public Clean_Buildings_Table(Binding context) {
        CallSite[] callSiteArray = Clean_Buildings_Table.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = Clean_Buildings_Table.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, Clean_Buildings_Table.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = Clean_Buildings_Table.$getCallSiteArray();
        String string = "Clean BUILDINGS Table";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, Clean_Buildings_Table.class, (GroovyObject)this, (String)"title");
        Object object = callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call((Object)"&#10145;&#65039; Clean the BUILDINGS table, avoiding overlapping areas and unclosed polygons.", (Object)"<hr>"), (Object)"NoiseModelling propagation code does not support well intersecting polygons </br> </br>"), (Object)"&#x2705;  The input table will be erased and replaced by the cleaned one.");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Clean_Buildings_Table.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"tableName", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Buildings table name", "title", "Buildings table name", "description", callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call((Object)"<b>Name of the Buildings table.</b> </br> </br>", (Object)"The table must be projected in a metric coordinate system (SRID). Use \"Change_SRID\" WPS Block if needed. </br> </br>"), (Object)"The table shall contain: </br>"), (Object)"- <b> THE_GEOM </b>: the 2D geometry of the building (POLYGON or MULTIPOLYGON).</br>"), (Object)"- <b> HEIGHT </b>: the height of the building (FLOAT)"), "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, Clean_Buildings_Table.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "This type of result does not allow the blocks to be linked together.", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, Clean_Buildings_Table.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = Clean_Buildings_Table.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].callGroovyObjectGetProperty(callSiteArray[12].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].call(callSiteArray[14].callGroovyObjectGetProperty(callSiteArray[15].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].call(callSiteArray[17].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].call(callSiteArray[19].call((Object)jdbcDataStore)), Connection.class);
    }

    public Object run(Object input) {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure1(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = Clean_Buildings_Table.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[20].call(callSiteArray[21].callStatic(Clean_Buildings_Table.class, (Object)dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
        }
        return callSiteArray[22].call((Object)Clean_Buildings_Table.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
    }

    public Object exec(Connection connection, Object input) {
        CallSite[] callSiteArray = Clean_Buildings_Table.$getCallSiteArray();
        String resultString = null;
        Sql sql = (Sql)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].callConstructor(Sql.class, (Object)connection), Sql.class);
        Logger logger = (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].call(LoggerFactory.class, (Object)"org.noise_planet.noisemodelling"), Logger.class);
        callSiteArray[25].call((Object)logger, (Object)"Start : Clean buildings table");
        callSiteArray[26].call((Object)logger, (Object)"inputs {}", input);
        String building_table_name = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[27].call(input, (Object)"tableName"), String.class);
        building_table_name = ShortTypeHandling.castToString((Object)callSiteArray[28].call((Object)building_table_name));
        int srid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[29].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[30].call(TableLocation.class, (Object)building_table_name)));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (srid == 3785 || srid == 4326) {
                throw (Throwable)callSiteArray[31].callConstructor(IllegalArgumentException.class, (Object)"Error : This SRID is not metric. Please use another SRID for your table.");
            }
        } else if (srid == 3785 || srid == 4326) {
            throw (Throwable)callSiteArray[32].callConstructor(IllegalArgumentException.class, (Object)"Error : This SRID is not metric. Please use another SRID for your table.");
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (srid == 0) {
                throw (Throwable)callSiteArray[33].callConstructor(IllegalArgumentException.class, (Object)"Error : The table does not have an associated SRID.");
            }
        } else if (srid == 0) {
            throw (Throwable)callSiteArray[34].callConstructor(IllegalArgumentException.class, (Object)"Error : The table does not have an associated SRID.");
        }
        Boolean hasPop = (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].call(JDBCUtilities.class, (Object)connection, (Object)building_table_name, (Object)"POP"), Boolean.class);
        String popField = "";
        String popFieldDef = "";
        if (DefaultTypeTransformation.booleanUnbox((Object)hasPop)) {
            callSiteArray[36].call((Object)logger, (Object)"The building table has a column named POP.");
            popField = ", POP";
            popFieldDef = ", POP REAL";
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)hasPop)) {
            callSiteArray[37].call((Object)logger, (Object)"The building table has not a column named POP.");
        }
        callSiteArray[38].call((Object)sql, callSiteArray[39].call(callSiteArray[40].call(callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call((Object)"drop table if exists buildings_temp;", (Object)"create table buildings_temp as select ST_MAKEVALID(ST_SIMPLIFYPRESERVETOPOLOGY(ST_precisionreducer(THE_GEOM,2),0.1)) THE_GEOM, PK, HEIGHT "), (Object)popField), (Object)" from "), (Object)building_table_name), (Object)"  WHERE ST_Perimeter(THE_GEOM)<1000;"));
        callSiteArray[44].call((Object)logger, (Object)"Make valid every buildings - ok");
        callSiteArray[45].call((Object)sql, (Object)"ALTER TABLE buildings_temp ALTER COLUMN PK INT NOT NULL;");
        callSiteArray[46].call((Object)sql, (Object)"ALTER TABLE buildings_temp ADD PRIMARY KEY (PK); ");
        callSiteArray[47].call((Object)sql, callSiteArray[48].call(callSiteArray[49].call((Object)"CREATE SPATIAL INDEX ON buildings_temp(the_geom);", (Object)"drop table if exists tmp_relation_buildings;"), (Object)"create table tmp_relation_buildings as select s1.PK as PK_BUILDING, S2.PK as PK2_BUILDING FROM buildings_temp S1, buildings_temp S2 WHERE ST_AREA(S1.THE_GEOM) < ST_AREA(S2.THE_GEOM) AND S1.THE_GEOM && S2.THE_GEOM AND ST_DISTANCE(S1.THE_GEOM, S2.THE_GEOM) <= 0.1;"));
        callSiteArray[50].call((Object)logger, (Object)"Intersection founded");
        String fieldPopS1 = "";
        if (DefaultTypeTransformation.booleanUnbox((Object)hasPop)) {
            fieldPopS1 = ", s1.POP";
        }
        callSiteArray[51].call((Object)sql, callSiteArray[52].call(callSiteArray[53].call(callSiteArray[54].call(callSiteArray[55].call((Object)"CREATE INDEX ON tmp_relation_buildings(PK_BUILDING);", (Object)"drop table if exists tmp_buildings_truncated;"), (Object)"create table tmp_buildings_truncated as select PK_BUILDING, ST_DIFFERENCE(s1.the_geom,  ST_BUFFER(ST_ACCUM(s2.the_geom), 0.1, 'join=mitre')) the_geom, s1.HEIGHT "), (Object)fieldPopS1), (Object)" from tmp_relation_buildings r, buildings_temp s1, buildings_temp s2 WHERE PK_BUILDING = S1.PK  AND PK2_BUILDING = S2.PK   GROUP BY PK_BUILDING;"));
        callSiteArray[56].call((Object)logger, (Object)"Intersection remove buildings with intersections");
        callSiteArray[57].call((Object)sql, callSiteArray[58].call(callSiteArray[59].call((Object)"DROP TABLE IF EXISTS ", (Object)building_table_name), (Object)";"));
        callSiteArray[60].call((Object)sql, callSiteArray[61].call(callSiteArray[62].call(callSiteArray[63].call(callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].call(callSiteArray[67].call(callSiteArray[68].call(callSiteArray[69].call(callSiteArray[70].call(callSiteArray[71].call(callSiteArray[72].call((Object)"create table ", (Object)building_table_name), (Object)"(PK INTEGER PRIMARY KEY, THE_GEOM GEOMETRY, HEIGHT FLOAT "), (Object)popFieldDef), (Object)")  as select s.PK, ST_SetSRID(s.the_geom,"), (Object)srid), (Object)"), s.HEIGHT "), (Object)popField), (Object)" from  BUILDINGS_TEMP s where PK not in (select PK_BUILDING from tmp_buildings_truncated) UNION ALL select PK_BUILDING, ST_SetSRID(the_geom,"), (Object)srid), (Object)"), HEIGHT "), (Object)popField), (Object)" from tmp_buildings_truncated WHERE NOT st_isempty(the_geom);"));
        callSiteArray[73].call((Object)logger, (Object)"Create spatial index on new building table");
        callSiteArray[74].call((Object)sql, callSiteArray[75].call(callSiteArray[76].call((Object)"CREATE SPATIAL INDEX ON ", (Object)building_table_name), (Object)"(the_geom);"));
        callSiteArray[77].call((Object)sql, (Object)"drop table if exists tmp_buildings_truncated;");
        callSiteArray[78].call((Object)sql, (Object)"drop table if exists tmp_relation_buildings;");
        callSiteArray[79].call((Object)sql, (Object)"drop table if exists buildings_temp;");
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[80].call(resultString, (Object)"Calculation Done !"));
        callSiteArray[81].call((Object)logger, callSiteArray[82].call((Object)"Result : ", (Object)resultString));
        callSiteArray[83].call((Object)logger, (Object)"End : Clean buildings table");
        return resultString;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Clean_Buildings_Table.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "isEmpty";
        stringArray[9] = "get";
        stringArray[10] = "getStoreNames";
        stringArray[11] = "catalog";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "getStore";
        stringArray[14] = "catalog";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "getDataStore";
        stringArray[17] = "getDataStoreInfo";
        stringArray[18] = "getConnection";
        stringArray[19] = "getDataSource";
        stringArray[20] = "withCloseable";
        stringArray[21] = "openGeoserverDataStoreConnection";
        stringArray[22] = "withCloseable";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "getLogger";
        stringArray[25] = "info";
        stringArray[26] = "info";
        stringArray[27] = "getAt";
        stringArray[28] = "toUpperCase";
        stringArray[29] = "getSRID";
        stringArray[30] = "parse";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "<$constructor$>";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "hasField";
        stringArray[36] = "info";
        stringArray[37] = "info";
        stringArray[38] = "execute";
        stringArray[39] = "plus";
        stringArray[40] = "plus";
        stringArray[41] = "plus";
        stringArray[42] = "plus";
        stringArray[43] = "plus";
        stringArray[44] = "info";
        stringArray[45] = "execute";
        stringArray[46] = "execute";
        stringArray[47] = "execute";
        stringArray[48] = "plus";
        stringArray[49] = "plus";
        stringArray[50] = "info";
        stringArray[51] = "execute";
        stringArray[52] = "plus";
        stringArray[53] = "plus";
        stringArray[54] = "plus";
        stringArray[55] = "plus";
        stringArray[56] = "info";
        stringArray[57] = "execute";
        stringArray[58] = "plus";
        stringArray[59] = "plus";
        stringArray[60] = "execute";
        stringArray[61] = "plus";
        stringArray[62] = "plus";
        stringArray[63] = "plus";
        stringArray[64] = "plus";
        stringArray[65] = "plus";
        stringArray[66] = "plus";
        stringArray[67] = "plus";
        stringArray[68] = "plus";
        stringArray[69] = "plus";
        stringArray[70] = "plus";
        stringArray[71] = "plus";
        stringArray[72] = "plus";
        stringArray[73] = "info";
        stringArray[74] = "execute";
        stringArray[75] = "plus";
        stringArray[76] = "plus";
        stringArray[77] = "execute";
        stringArray[78] = "execute";
        stringArray[79] = "execute";
        stringArray[80] = "plus";
        stringArray[81] = "info";
        stringArray[82] = "plus";
        stringArray[83] = "info";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[84];
        Clean_Buildings_Table.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Clean_Buildings_Table.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Clean_Buildings_Table.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

