/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.wps.Geometric_Tools;

import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.sql.Sql;
import groovy.text.SimpleTemplateEngine;
import groovy.transform.Generated;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.h2.util.ScriptReader;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.TableLocation;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.RootProgressVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enrich_DEM_with_road
extends Script {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Enrich_DEM_with_road() {
        CallSite[] callSiteArray = Enrich_DEM_with_road.$getCallSiteArray();
    }

    public Enrich_DEM_with_road(Binding context) {
        CallSite[] callSiteArray = Enrich_DEM_with_road.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = Enrich_DEM_with_road.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, Enrich_DEM_with_road.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = Enrich_DEM_with_road.$getCallSiteArray();
        String string = "Enrich DEM with roads";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, Enrich_DEM_with_road.class, (GroovyObject)this, (String)"title");
        Object object = callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call((Object)"&#10145;&#65039; Insert altimetric points coming from roads into the input DEM.</br>", (Object)"<hr>"), (Object)"This script works with two input layers:</br>"), (Object)" <ul>"), (Object)"<li>Digital Elevation Model (DEM) to be enriched</li>"), (Object)"<li>Roads</li>"), (Object)"</ul>"), (Object)"And four parameters:</br>"), (Object)" <ul>"), (Object)"<li>Roads right-of-way (roadWidth): Name of column where the road right-of-way is stored (Mandatory)</li>"), (Object)"<li>Road platform height (hRoad): Roads platform height (Optional). Default value = 0.0m</li>"), (Object)"<li>Input SRID (inputSRID): SRID of the input tables (Optional)</li>"), (Object)"<li>Output suffix (outputSuffix): Suffix applied at the end of the resulting table name (Optional). If not specified, \"ENRICHED\" is applied</li>"), (Object)"</ul>");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Enrich_DEM_with_road.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"inputSRID", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Input SRID", "title", "Input SRID", "description", callSiteArray[14].call((Object)"&#127757; SRID of the input tables. </br> </br>", (Object)"&#128736; If not specified, the SRID from DEM layer is applied. If DEM has no SRID, 0 is applied"), "min", 0, "max", 1, "type", Integer.class}), "inputDEM", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Input DEM", "title", "Input DEM table", "description", "Name of the input DEM table to be enriched", "type", String.class}), "inputRoad", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Input Roads", "title", "Input roads table", "description", "Name of the input roads table", "type", String.class}), "roadWidth", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Road width", "title", "Road width", "description", "Name of column where the road width is stored", "type", String.class}), "hRoad", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Roads platform height", "title", "Roads platform height", "description", callSiteArray[15].call((Object)"Roads platform height (in meters) (Optional)  </br> </br>", (Object)"&#128736; Default value = <b>0</b>"), "min", 0, "max", 1, "type", Double.TYPE}), "outputSuffix", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Output suffix", "title", "Output suffix", "description", callSiteArray[16].call((Object)"Suffix applied at the end of the resulting table name </br> </br>", (Object)"&#128736; If not specified, \"ENRICHED\" is applied"), "min", 0, "max", 1, "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, Enrich_DEM_with_road.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "This type of result does not allow the blocks to be linked together.", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, Enrich_DEM_with_road.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Object parseScript(String sqlInstructions, Sql sql, ProgressVisitor progressVisitor, Logger logger) {
        InputStreamReader reader = null;
        ByteArrayInputStream s = new ByteArrayInputStream(sqlInstructions.getBytes());
        ByteArrayInputStream is = s;
        LinkedList<String> statementList = new LinkedList<String>();
        try {
            reader = new InputStreamReader(is);
            ScriptReader scriptReader = new ScriptReader((Reader)reader);
            scriptReader.setSkipRemarks(false);
            String statement = scriptReader.readStatement();
            while (statement != null && !statement.trim().isEmpty()) {
                statementList.add(statement);
                scriptReader.readStatement();
            }
        }
        finally {
            reader.close();
        }
        int idStatement = 0;
        int nbStatements = statementList.size();
        ProgressVisitor evalProgress = progressVisitor.subProcess(nbStatements);
        LinkedList<String> linkedList = statementList;
        Iterator iterator = linkedList != null ? linkedList.iterator() : null;
        String statement = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                statement = ShortTypeHandling.castToString(iterator2.next());
                String subStatement2 = null;
                String[] stringArray = statement.split("\n");
                if (stringArray != null) {
                    for (String subStatement2 : stringArray) {
                        if (!subStatement2.trim().startsWith("--")) continue;
                        logger.info(String.format(Locale.ROOT, "%d/%d %s", idStatement + 1, nbStatements, subStatement2.replace("--", "")));
                    }
                }
                int n = idStatement;
                int cfr_ignored_0 = n + 1;
                sql.execute(statement);
                evalProgress.endStep();
                if (!evalProgress.isCanceled()) continue;
                throw (Throwable)new SQLException("Canceled by user");
            }
        }
        return null;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = Enrich_DEM_with_road.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[18].call(callSiteArray[19].call(callSiteArray[20].callGroovyObjectGetProperty(callSiteArray[21].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].call(callSiteArray[23].callGroovyObjectGetProperty(callSiteArray[24].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].call(callSiteArray[26].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].call(callSiteArray[28].call((Object)jdbcDataStore)), Connection.class);
    }

    public Object run(Object input) {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure1(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = Enrich_DEM_with_road.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[29].call(callSiteArray[30].callStatic(Enrich_DEM_with_road.class, (Object)dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
        }
        return callSiteArray[31].call((Object)Enrich_DEM_with_road.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
    }

    public Object exec(Connection connection, Object input) {
        CallSite[] callSiteArray = Enrich_DEM_with_road.$getCallSiteArray();
        Logger logger = (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].call(LoggerFactory.class, (Object)"Enrich_DEM_with_road"), Logger.class);
        ProgressVisitor progressVisitor = null;
        progressVisitor = ScriptBytecodeAdapter.isCase((Object)"progressVisitor", (Object)input) ? (ProgressVisitor)ScriptBytecodeAdapter.asType((Object)callSiteArray[33].call(input, (Object)"progressVisitor"), ProgressVisitor.class) : (ProgressVisitor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].callConstructor(RootProgressVisitor.class, (Object)1, (Object)true, (Object)1), ProgressVisitor.class);
        ProgressVisitor progress = (ProgressVisitor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].call((Object)progressVisitor, (Object)2), ProgressVisitor.class);
        String inputDEM = ShortTypeHandling.castToString((Object)callSiteArray[36].call(input, (Object)"inputDEM"));
        String inputRoad = ShortTypeHandling.castToString((Object)callSiteArray[37].call(input, (Object)"inputRoad"));
        String roadWidth = ShortTypeHandling.castToString((Object)callSiteArray[38].call(input, (Object)"roadWidth"));
        double hRoad = 0.0;
        if (ScriptBytecodeAdapter.isCase((Object)"hRoad", (Object)input)) {
            hRoad = DefaultTypeTransformation.doubleUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[39].call(input, (Object)"hRoad"), Double.TYPE));
        }
        Integer srid = 0;
        srid = ScriptBytecodeAdapter.isCase((Object)"inputSRID", (Object)input) ? (Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[40].call(input, (Object)"inputSRID"), Integer.class) : (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[42].call(TableLocation.class, (Object)inputDEM)), Integer.class);
        String outputSuffix = "ENRICHED";
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[43].call(input, (Object)"outputSuffix"))) {
            outputSuffix = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[44].call(input, (Object)"outputSuffix"), String.class);
        }
        String enrichedDEM = ShortTypeHandling.castToString((Object)callSiteArray[45].call(callSiteArray[46].call(callSiteArray[47].call(input, (Object)"inputDEM"), (Object)"_"), (Object)outputSuffix));
        callSiteArray[48].call((Object)logger, (Object)"List of the input parameters:");
        callSiteArray[49].call((Object)logger, (Object)"--------------------------------------------");
        callSiteArray[50].call((Object)logger, callSiteArray[51].call((Object)"# SRID: ", (Object)srid));
        callSiteArray[52].call((Object)logger, callSiteArray[53].call((Object)"# DEM table: ", (Object)inputDEM));
        callSiteArray[54].call((Object)logger, callSiteArray[55].call((Object)"# Roads network table: ", (Object)inputRoad));
        callSiteArray[56].call((Object)logger, callSiteArray[57].call((Object)"# Roads width column: ", (Object)roadWidth));
        callSiteArray[58].call((Object)logger, callSiteArray[59].call((Object)"# Roads platform height: ", (Object)hRoad));
        callSiteArray[60].call((Object)logger, callSiteArray[61].call((Object)"# Output suffix: ", (Object)outputSuffix));
        callSiteArray[62].call((Object)logger, (Object)"--------------------------------------------");
        callSiteArray[63].call((Object)logger, (Object)"Start enrich the DEM");
        Object sql = callSiteArray[64].callConstructor(Sql.class, (Object)connection);
        GStringImpl import_roads = new GStringImpl(new Object[]{roadWidth, roadWidth, roadWidth, inputRoad, inputRoad}, new String[]{"\n    ------------\n    -- Import roads\n    -- Road width is precalculated into WIDTH column. When largeur < 3, then 3m\n\n    DROP TABLE IF EXISTS dem_roads;\n    CREATE TABLE dem_roads AS SELECT THE_GEOM, 'ROAD' as SOURCE, (CASE WHEN ", " IS NOT NULL AND ", ">3 THEN ", "/2 ELSE 1.5 END) as WIDTH \n        FROM ", " WHERE st_zmin(THE_GEOM) > 0;\n    CREATE SPATIAL INDEX ON dem_roads(THE_GEOM);\n    ALTER TABLE dem_roads ADD PK_LINE INT AUTO_INCREMENT NOT NULL;\n    ALTER TABLE dem_roads add primary key(PK_LINE);\n    \n    -- Roads: layer ", " imported\n    "});
        GStringImpl enrich_roads = new GStringImpl(new Object[]{enrichedDEM, srid, srid, inputDEM, roadWidth, roadWidth, roadWidth, srid, enrichedDEM}, new String[]{"\n    ------------\n    -- Insert roads platform into ", "\n\n    DROP TABLE DEM_WITHOUT_PTLINE IF EXISTS;\n    CREATE TABLE DEM_WITHOUT_PTLINE(THE_GEOM geometry(POINTZ, ", "), source varchar) AS SELECT st_setsrid(THE_GEOM, ", "), 'DEM' FROM ", ";\n    -- Remove DEM points that are less than ", " far FROM roads\n    DELETE FROM DEM_WITHOUT_PTLINE WHERE EXISTS (SELECT 1 FROM dem_roads b \n        WHERE ST_EXPAND(DEM_WITHOUT_PTLINE.THE_GEOM, 20) && b.THE_GEOM \n        AND ST_DISTANCE(DEM_WITHOUT_PTLINE.THE_GEOM, b.THE_GEOM)< b.WIDTH+5 LIMIT 1) ;\n    \n    -- Create buffer points from roads and copy the elevation from the roads to the point\n    DROP TABLE IF EXISTS BUFFERED_PTLINE;\n    -- The buffer size correspond to the greatest value between ", " and 3m. If ", " is null or lower than 3m, then 3m is returned\n    CREATE TABLE BUFFERED_PTLINE AS SELECT ST_ToMultiPoint(ST_Densify(ST_Buffer(ST_Simplify(st_force2D(THE_GEOM), 2), WIDTH, 'endcap=flat join=mitre'), 5)) THE_GEOM, PK_LINE \n        FROM dem_roads WHERE st_length(st_simplify(THE_GEOM, 2)) > 0;\n    INSERT INTO DEM_WITHOUT_PTLINE(THE_GEOM, SOURCE) SELECT st_setsrid(ST_MakePoint(ST_X(P.THE_GEOM), ST_Y(P.THE_GEOM), ST_Z(ST_ProjectPoint(P.THE_GEOM,L.THE_GEOM))), ", ") THE_GEOM, 'ROA' \n        FROM ST_EXPLODE('BUFFERED_PTLINE') P, dem_roads L WHERE P.PK_LINE = L.PK_LINE;\n    \n    -- ", " enriched with roads\n    "});
        GStringImpl enrich_final = new GStringImpl(new Object[]{enrichedDEM, enrichedDEM, enrichedDEM, enrichedDEM, enrichedDEM}, new String[]{"\n    \n    DROP TABLE IF EXISTS ", ";\n    ALTER TABLE DEM_WITHOUT_PTLINE RENAME TO ", ";\n    -- Create a spatial index on ", "\n    CREATE SPATIAL INDEX ON ", " (THE_GEOM);\n\n    ----------------------------------\n    -- Remove non needed tables\n    \n    DROP TABLE IF EXISTS DEM_ROADS, BUFFERED_PTLINE;\n\n    -- DEM successfully enriched in the table ", "\n    "});
        StringBuilder stringBuilder = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[65].callConstructor(StringBuilder.class), StringBuilder.class);
        Object engine = callSiteArray[66].callConstructor(SimpleTemplateEngine.class);
        callSiteArray[67].call((Object)stringBuilder, (Object)import_roads);
        callSiteArray[68].call((Object)stringBuilder, (Object)enrich_roads);
        callSiteArray[69].call((Object)stringBuilder, (Object)enrich_final);
        Map binding = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"inputDEM", inputDEM, "inputRoad", inputRoad, "roadWidth", roadWidth, "outputSuffix", outputSuffix, "srid", srid, "hRoad", hRoad});
        Object template = callSiteArray[70].call(callSiteArray[71].call(engine, callSiteArray[72].call((Object)stringBuilder)), (Object)binding);
        callSiteArray[73].callStatic(Enrich_DEM_with_road.class, callSiteArray[74].call(template), sql, (Object)progress, (Object)logger);
        return callSiteArray[75].call((Object)"DEM successfully enriched in the table ", (Object)enrichedDEM);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Enrich_DEM_with_road.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "plus";
        stringArray[12] = "plus";
        stringArray[13] = "plus";
        stringArray[14] = "plus";
        stringArray[15] = "plus";
        stringArray[16] = "plus";
        stringArray[17] = "isEmpty";
        stringArray[18] = "get";
        stringArray[19] = "getStoreNames";
        stringArray[20] = "catalog";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "getStore";
        stringArray[23] = "catalog";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "getDataStore";
        stringArray[26] = "getDataStoreInfo";
        stringArray[27] = "getConnection";
        stringArray[28] = "getDataSource";
        stringArray[29] = "withCloseable";
        stringArray[30] = "openGeoserverDataStoreConnection";
        stringArray[31] = "withCloseable";
        stringArray[32] = "getLogger";
        stringArray[33] = "getAt";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "subProcess";
        stringArray[36] = "getAt";
        stringArray[37] = "getAt";
        stringArray[38] = "getAt";
        stringArray[39] = "getAt";
        stringArray[40] = "getAt";
        stringArray[41] = "getSRID";
        stringArray[42] = "parse";
        stringArray[43] = "getAt";
        stringArray[44] = "getAt";
        stringArray[45] = "plus";
        stringArray[46] = "plus";
        stringArray[47] = "getAt";
        stringArray[48] = "info";
        stringArray[49] = "info";
        stringArray[50] = "info";
        stringArray[51] = "plus";
        stringArray[52] = "info";
        stringArray[53] = "plus";
        stringArray[54] = "info";
        stringArray[55] = "plus";
        stringArray[56] = "info";
        stringArray[57] = "plus";
        stringArray[58] = "info";
        stringArray[59] = "plus";
        stringArray[60] = "info";
        stringArray[61] = "plus";
        stringArray[62] = "info";
        stringArray[63] = "info";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "<$constructor$>";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "append";
        stringArray[68] = "append";
        stringArray[69] = "append";
        stringArray[70] = "make";
        stringArray[71] = "createTemplate";
        stringArray[72] = "toString";
        stringArray[73] = "parseScript";
        stringArray[74] = "toString";
        stringArray[75] = "plus";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[76];
        Enrich_DEM_with_road.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Enrich_DEM_with_road.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Enrich_DEM_with_road.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

