/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.wps.Geometric_Tools;

import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.sql.Sql;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.wrapper.ConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Simplify_Geometries
extends Script {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Simplify_Geometries() {
        CallSite[] callSiteArray = Simplify_Geometries.$getCallSiteArray();
    }

    public Simplify_Geometries(Binding context) {
        CallSite[] callSiteArray = Simplify_Geometries.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = Simplify_Geometries.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, Simplify_Geometries.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = Simplify_Geometries.$getCallSiteArray();
        String string = "Simplify geometries";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, Simplify_Geometries.class, (GroovyObject)this, (String)"title");
        Object object = callSiteArray[1].call(callSiteArray[2].call((Object)"&#10145;&#65039; Use <a href=\"https://en.wikipedia.org/wiki/Ramer%E2%80%93Douglas%E2%80%93Peucker_algorithm\" target=\"_blank\">Douglas-Peucker algorithm</a> to simplify geometries in the selected table.", (Object)"<hr>"), (Object)"&#x2705; The input table geometries will be updated.");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Simplify_Geometries.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"tableName", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"title", "Name of the table", "name", "Name of the table", "description", "Name of the table on which geometries will be simplified.", "type", String.class}), "distanceTolerance", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Distance tolerance", "title", "Distance tolerance", "description", callSiteArray[3].call((Object)"Sets the tolerance distance for the simplification (FLOAT). </br> </br> ", (Object)"&#128736; Default value: <b>1 </b>"), "min", 0, "max", 1, "type", Double.class}), "preserveTopology", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"title", "Preserve topology ?", "name", "Preserve topology ?", "description", callSiteArray[4].call((Object)"Do you want to preserve topology? </br> </br>", (Object)"&#128736; Default value: <b>false </b>"), "min", 0, "max", 1, "type", Boolean.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, Simplify_Geometries.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "This type of result does not allow the blocks to be linked together.", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, Simplify_Geometries.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = Simplify_Geometries.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].callGroovyObjectGetProperty(callSiteArray[9].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].call(callSiteArray[11].callGroovyObjectGetProperty(callSiteArray[12].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[13].call(callSiteArray[14].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].call(callSiteArray[16].call((Object)jdbcDataStore)), Connection.class);
    }

    public Object run(Object input) {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure1(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = Simplify_Geometries.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[17].call(callSiteArray[18].callStatic(Simplify_Geometries.class, (Object)dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
        }
        return callSiteArray[19].call((Object)Simplify_Geometries.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
    }

    public Object exec(Connection connection, Object input) {
        CallSite[] callSiteArray = Simplify_Geometries.$getCallSiteArray();
        connection = (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].callConstructor(ConnectionWrapper.class, (Object)connection), Connection.class);
        Sql sql = (Sql)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].callConstructor(Sql.class, (Object)connection), Sql.class);
        String resultString = null;
        Logger logger = (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].call(LoggerFactory.class, (Object)"org.noise_planet.noisemodelling"), Logger.class);
        callSiteArray[23].call((Object)logger, (Object)"Start : Template");
        callSiteArray[24].call((Object)logger, (Object)"inputs {}", input);
        Double distanceTolerance = (Double)ScriptBytecodeAdapter.castToType((Object)1, Double.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[25].call(input, (Object)"distanceTolerance"))) {
            distanceTolerance = (Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[26].call(input, (Object)"distanceTolerance"), Double.class);
        }
        String table_name = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[27].call(input, (Object)"tableName"), String.class);
        table_name = ShortTypeHandling.castToString((Object)callSiteArray[28].call((Object)table_name));
        TableLocation sourceTableIdentifier = (TableLocation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[29].call(TableLocation.class, (Object)table_name), TableLocation.class);
        List geomFields = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call(GeometryTableUtilities.class, (Object)connection, (Object)sourceTableIdentifier), List.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[31].call((Object)geomFields))) {
            throw (Throwable)callSiteArray[32].callConstructor(SQLException.class, callSiteArray[33].call(String.class, (Object)"The table %s does not exists or does not contain a geometry field", (Object)sourceTableIdentifier));
        }
        int srid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[34].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[35].call(TableLocation.class, (Object)table_name)));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (srid == 3785 || srid == 4326) {
                throw (Throwable)callSiteArray[36].callConstructor(IllegalArgumentException.class, (Object)"Error : This SRID is not metric. Please use another SRID for your table.");
            }
        } else if (srid == 3785 || srid == 4326) {
            throw (Throwable)callSiteArray[37].callConstructor(IllegalArgumentException.class, (Object)"Error : This SRID is not metric. Please use another SRID for your table.");
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (srid == 0) {
                throw (Throwable)callSiteArray[38].callConstructor(IllegalArgumentException.class, (Object)"Error : The table does not have an associated SRID.");
            }
        } else if (srid == 0) {
            throw (Throwable)callSiteArray[39].callConstructor(IllegalArgumentException.class, (Object)"Error : The table does not have an associated SRID.");
        }
        Boolean preserveTopology = false;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[40].call(input, (Object)"preserveTopology"))) {
            preserveTopology = (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call(input, (Object)"preserveTopology"), Boolean.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)preserveTopology)) {
            callSiteArray[42].call((Object)sql, callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].call(callSiteArray[47].call(callSiteArray[48].call((Object)"UPDATE ", (Object)table_name), (Object)" SET THE_GEOM = ST_SETSRID(ST_SimplifyPreserveTopology(THE_GEOM, "), (Object)distanceTolerance), (Object)"), "), (Object)srid), (Object)");"));
        } else {
            callSiteArray[49].call((Object)logger, (Object)"Topology may not be preserved and may result in invalid geometries");
            callSiteArray[50].call((Object)sql, callSiteArray[51].call(callSiteArray[52].call(callSiteArray[53].call(callSiteArray[54].call(callSiteArray[55].call(callSiteArray[56].call((Object)"UPDATE ", (Object)table_name), (Object)" SET THE_GEOM = ST_SETSRID(ST_Simplify(THE_GEOM, "), (Object)distanceTolerance), (Object)"), "), (Object)srid), (Object)");"));
        }
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[57].call(callSiteArray[58].call((Object)"Process done. Geometries in table ", (Object)table_name), (Object)" have been simplified."));
        callSiteArray[59].call((Object)logger, (Object)"End : Geometries simplified");
        return resultString;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Simplify_Geometries.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "isEmpty";
        stringArray[6] = "get";
        stringArray[7] = "getStoreNames";
        stringArray[8] = "catalog";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "getStore";
        stringArray[11] = "catalog";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "getDataStore";
        stringArray[14] = "getDataStoreInfo";
        stringArray[15] = "getConnection";
        stringArray[16] = "getDataSource";
        stringArray[17] = "withCloseable";
        stringArray[18] = "openGeoserverDataStoreConnection";
        stringArray[19] = "withCloseable";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "getLogger";
        stringArray[23] = "info";
        stringArray[24] = "info";
        stringArray[25] = "getAt";
        stringArray[26] = "getAt";
        stringArray[27] = "getAt";
        stringArray[28] = "toUpperCase";
        stringArray[29] = "parse";
        stringArray[30] = "getGeometryFields";
        stringArray[31] = "isEmpty";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "format";
        stringArray[34] = "getSRID";
        stringArray[35] = "parse";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "getAt";
        stringArray[41] = "getAt";
        stringArray[42] = "execute";
        stringArray[43] = "plus";
        stringArray[44] = "plus";
        stringArray[45] = "plus";
        stringArray[46] = "plus";
        stringArray[47] = "plus";
        stringArray[48] = "plus";
        stringArray[49] = "info";
        stringArray[50] = "execute";
        stringArray[51] = "plus";
        stringArray[52] = "plus";
        stringArray[53] = "plus";
        stringArray[54] = "plus";
        stringArray[55] = "plus";
        stringArray[56] = "plus";
        stringArray[57] = "plus";
        stringArray[58] = "plus";
        stringArray[59] = "info";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[60];
        Simplify_Geometries.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Simplify_Geometries.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Simplify_Geometries.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

