/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.wps.Import_and_Export;

import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.transform.Generated;
import java.io.File;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.h2gis.functions.io.asc.AscReaderDriver;
import org.h2gis.functions.io.utility.PRJUtil;
import org.h2gis.functions.spatial.crs.ST_SetSRID;
import org.h2gis.functions.spatial.crs.ST_Transform;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.RootProgressVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Import_Asc_File
extends Script {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Import_Asc_File() {
        CallSite[] callSiteArray = Import_Asc_File.$getCallSiteArray();
    }

    public Import_Asc_File(Binding context) {
        CallSite[] callSiteArray = Import_Asc_File.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = Import_Asc_File.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, Import_Asc_File.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = Import_Asc_File.$getCallSiteArray();
        String string = "Import Asc File.";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, Import_Asc_File.class, (GroovyObject)this, (String)"title");
        Object object = callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call((Object)"&#10145;&#65039; Import ESRI Ascii Raster file and convert into a Digital Elevation Model (DEM) compatible with NoiseModelling (X,Y,Z). </br>", (Object)"<hr>"), (Object)" Valid file extensions : asc. </br> </br>"), (Object)"&#x2705; The output table is called: <b>DEM</b> and contain: </br>"), (Object)"- <b>THE_GEOM</b>: the 3D point cloud of the DEM (POINT) </br> </br>"), (Object)"<img src=\"/wps_images/import_asc_file.png\" alt=\"Import asc file\" width=\"95%\" align=\"center\">");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Import_Asc_File.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pathFile", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Path of the input File", "title", "Path of the ESRI Ascii Raster file", "description", callSiteArray[6].call((Object)"&#128194; Path of the ESRI Ascii Raster file you want to import, including its extension. Can be gzip compressed. </br> </br>", (Object)"For example: c:/home/receivers.asc or c:/home/receivers.asc.gz"), "type", String.class}), "inputSRID", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Projection identifier", "title", "Projection identifier", "description", callSiteArray[7].call(callSiteArray[8].call((Object)"&#127757; Original projection identifier (also called SRID) of the .asc files. </br> </br>", (Object)"It should be an <a href=\"https://epsg.io/\" target=\"_blank\">EPSG</a> code, an integer with 4 or 5 digits (ex: <a href=\"https://epsg.io/3857\" target=\"_blank\">3857</a> is Pseudo-Mercator projection). </br> </br>"), (Object)"&#128736; Default value: <b>4326 </b> "), "type", Integer.class, "min", 0, "max", 1}), "fence", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Fence geometry", "title", "Fence geometry", "description", "Create DEM table only in the provided polygon", "min", 0, "max", 1, "type", Geometry.class}), "downscale", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Skip pixels on each axis", "title", "Skip pixels on each axis", "description", callSiteArray[9].call((Object)"Divide the number of rows and columns read by the following coefficient (FLOAT) </br> </br>", (Object)"&#128736; Default value: <b>1.0 </b>"), "min", 0, "max", 1, "type", Integer.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, Import_Asc_File.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "This type of result does not allow the blocks to be linked together.", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, Import_Asc_File.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = Import_Asc_File.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].callGroovyObjectGetProperty(callSiteArray[14].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].call(callSiteArray[16].callGroovyObjectGetProperty(callSiteArray[17].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].call(callSiteArray[19].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].call(callSiteArray[21].call((Object)jdbcDataStore)), Connection.class);
    }

    public Object run(Object input) {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure1(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = Import_Asc_File.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[22].call(callSiteArray[23].callStatic(Import_Asc_File.class, (Object)dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
        }
        return callSiteArray[24].call((Object)Import_Asc_File.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object exec(Connection connection, Object input) {
        int srid;
        AscReaderDriver ascDriver;
        Statement stmt;
        String outputTableName;
        String pathFile;
        Integer downscale;
        Logger logger;
        String resultString;
        CallSite[] callSiteArray;
        block24: {
            block25: {
                String fence;
                block23: {
                    block17: {
                        File prjFile;
                        Integer defaultSRID;
                        block18: {
                            callSiteArray = Import_Asc_File.$getCallSiteArray();
                            resultString = null;
                            logger = (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].call(LoggerFactory.class, (Object)"org.noise_planet.noisemodelling"), Logger.class);
                            callSiteArray[26].call((Object)logger, (Object)"Start : Import Asc File");
                            callSiteArray[27].call((Object)logger, (Object)"inputs {}", input);
                            defaultSRID = 4326;
                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].call(input, (Object)"inputSRID"))) {
                                defaultSRID = (Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[29].call(input, (Object)"inputSRID"), Integer.class);
                            }
                            downscale = 1;
                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[30].call(input, (Object)"downscale"))) {
                                downscale = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].call(Math.class, (Object)1, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[32].call(input, (Object)"downscale"), Integer.class)), Integer.class)), Integer.class);
                            }
                            fence = null;
                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[33].call(input, (Object)"fence"))) {
                                fence = ShortTypeHandling.castToString((Object)callSiteArray[34].call(input, (Object)"fence"));
                            }
                            pathFile = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[35].call(input, (Object)"pathFile"), String.class);
                            Object file = callSiteArray[36].callConstructor(File.class, (Object)pathFile);
                            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[37].call(file))) {
                                resultString = ShortTypeHandling.castToString((Object)callSiteArray[38].call((Object)pathFile, (Object)" is not found."));
                                throw (Throwable)callSiteArray[39].callConstructor(Exception.class, callSiteArray[40].call((Object)"ERROR : ", (Object)resultString));
                            }
                            outputTableName = "DEM";
                            stmt = (Statement)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call((Object)connection), Statement.class);
                            String dropOutputTable = ShortTypeHandling.castToString((Object)callSiteArray[42].call((Object)"drop table if exists ", (Object)outputTableName));
                            callSiteArray[43].call((Object)stmt, (Object)dropOutputTable);
                            if (!(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[44].call(callSiteArray[45].call((Object)pathFile, callSiteArray[46].callGetProperty(Locale.class)), (Object)".asc")) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].call(callSiteArray[48].call((Object)pathFile, callSiteArray[49].callGetProperty(Locale.class)), (Object)".asc.gz")))) {
                                resultString = "The extension is not valid";
                                throw (Throwable)callSiteArray[50].callConstructor(Exception.class, callSiteArray[51].call((Object)"ERROR : ", (Object)resultString));
                            }
                            ascDriver = (AscReaderDriver)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].callConstructor(AscReaderDriver.class), AscReaderDriver.class);
                            callSiteArray[53].call((Object)ascDriver, (Object)true);
                            callSiteArray[54].call((Object)ascDriver);
                            srid = defaultSRID;
                            String filePath = ShortTypeHandling.castToString((Object)callSiteArray[55].call(callSiteArray[56].callConstructor(File.class, (Object)pathFile)));
                            int dotIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[57].call((Object)filePath, (Object)"."));
                            String fileNamePrefix = ShortTypeHandling.castToString((Object)callSiteArray[58].call((Object)filePath, (Object)0, (Object)dotIndex));
                            prjFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].callConstructor(File.class, callSiteArray[60].call((Object)fileNamePrefix, (Object)".prj")), File.class);
                            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[61].call((Object)prjFile))) break block18;
                            callSiteArray[62].call((Object)logger, callSiteArray[63].call((Object)"Found prj file :", callSiteArray[64].call((Object)prjFile)));
                            try {
                                boolean bl;
                                block22: {
                                    block20: {
                                        block21: {
                                            block19: {
                                                srid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[65].call(PRJUtil.class, (Object)prjFile));
                                                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) break block19;
                                                if (srid != 0) break block20;
                                                break block21;
                                            }
                                            if (srid == 0) {
                                                srid = defaultSRID;
                                            }
                                            break block17;
                                        }
                                        bl = true;
                                        break block22;
                                    }
                                    bl = false;
                                }
                                if (bl) {
                                    srid = defaultSRID;
                                }
                                break block17;
                            }
                            catch (IllegalArgumentException ex) {
                                throw (Throwable)callSiteArray[66].callConstructor(IllegalArgumentException.class, callSiteArray[67].call((Object)"PRJ file invalid, use default SRID ", callSiteArray[68].call((Object)prjFile)));
                            }
                        }
                        srid = defaultSRID;
                        callSiteArray[69].call((Object)logger, callSiteArray[70].call((Object)"PRJ file not found, use default SRID", callSiteArray[71].call((Object)prjFile)));
                    }
                    if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) break block23;
                    if (!ScriptBytecodeAdapter.compareNotEqual((Object)fence, null)) break block24;
                    break block25;
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)fence, null)) {
                    if (!(srid != 0)) {
                        throw (Throwable)callSiteArray[87].callConstructor(IllegalArgumentException.class, (Object)"Unable to find DEM SRID but fence was provided");
                    }
                    Geometry fenceGeom = null;
                    WKTReader wktReader = (WKTReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].callConstructor(WKTReader.class), WKTReader.class);
                    WKTWriter wktWriter = (WKTWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[73].callConstructor(WKTWriter.class), WKTWriter.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[74].call(input, (Object)"fence"))) {
                        fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[75].call((Object)wktReader, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[76].call(input, (Object)"fence"), String.class)), String.class)), Geometry.class);
                    }
                    callSiteArray[77].call((Object)logger, callSiteArray[78].call((Object)"Got fence :", callSiteArray[79].call((Object)wktWriter, fenceGeom)));
                    Geometry fenceTransform = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].call(ST_Transform.class, (Object)connection, callSiteArray[81].call(ST_SetSRID.class, (Object)fenceGeom, (Object)4326), (Object)srid), Geometry.class);
                    callSiteArray[82].call((Object)ascDriver, callSiteArray[83].call((Object)fenceTransform));
                    callSiteArray[84].call((Object)logger, callSiteArray[85].call((Object)"Fence coordinate transformed :", callSiteArray[86].call((Object)wktWriter, (Object)fenceTransform)));
                }
                break block24;
            }
            if (!(srid != 0)) {
                throw (Throwable)callSiteArray[103].callConstructor(IllegalArgumentException.class, (Object)"Unable to find DEM SRID but fence was provided");
            }
            Geometry fenceGeom = null;
            WKTReader wktReader = (WKTReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[88].callConstructor(WKTReader.class), WKTReader.class);
            WKTWriter wktWriter = (WKTWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[89].callConstructor(WKTWriter.class), WKTWriter.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[90].call(input, (Object)"fence"))) {
                fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].call((Object)wktReader, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[92].call(input, (Object)"fence"), String.class)), String.class)), Geometry.class);
            }
            callSiteArray[93].call((Object)logger, callSiteArray[94].call((Object)"Got fence :", callSiteArray[95].call((Object)wktWriter, fenceGeom)));
            Geometry fenceTransform = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[96].call(ST_Transform.class, (Object)connection, callSiteArray[97].call(ST_SetSRID.class, (Object)fenceGeom, (Object)4326), (Object)srid), Geometry.class);
            callSiteArray[98].call((Object)ascDriver, callSiteArray[99].call((Object)fenceTransform));
            callSiteArray[100].call((Object)logger, callSiteArray[101].call((Object)"Fence coordinate transformed :", callSiteArray[102].call((Object)wktWriter, (Object)fenceTransform)));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)downscale, (Object)1)) {
            callSiteArray[104].call((Object)ascDriver, (Object)downscale);
        }
        RootProgressVisitor progressLogger = (RootProgressVisitor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].callConstructor(RootProgressVisitor.class, (Object)1, (Object)true, (Object)1), RootProgressVisitor.class);
        callSiteArray[106].call((Object)ascDriver, ArrayUtil.createArray((Object)connection, (Object)callSiteArray[107].callConstructor(File.class, (Object)pathFile), (Object)progressLogger, (Object)outputTableName, (Object)srid));
        callSiteArray[108].call((Object)logger, callSiteArray[109].call((Object)"Create spatial index on ", (Object)outputTableName));
        callSiteArray[110].call((Object)stmt, callSiteArray[111].call(callSiteArray[112].call((Object)"Create spatial index on ", (Object)outputTableName), (Object)"(the_geom);"));
        callSiteArray[113].call((Object)logger, callSiteArray[114].call((Object)"The SRID of your table is ", (Object)srid));
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[115].call(callSiteArray[116].call((Object)"The table DEM has been uploaded to database ! </br>  Its SRID is : ", (Object)srid), (Object)". </br> Remember that to calculate a noise map, your SRID must be in metric coordinates. Please use the Wps block 'Change SRID' if needed."));
        callSiteArray[117].call((Object)logger, (Object)resultString);
        callSiteArray[118].call((Object)logger, (Object)"End : Import Asc File");
        return resultString;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Import_Asc_File.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "isEmpty";
        stringArray[11] = "get";
        stringArray[12] = "getStoreNames";
        stringArray[13] = "catalog";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "getStore";
        stringArray[16] = "catalog";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "getDataStore";
        stringArray[19] = "getDataStoreInfo";
        stringArray[20] = "getConnection";
        stringArray[21] = "getDataSource";
        stringArray[22] = "withCloseable";
        stringArray[23] = "openGeoserverDataStoreConnection";
        stringArray[24] = "withCloseable";
        stringArray[25] = "getLogger";
        stringArray[26] = "info";
        stringArray[27] = "info";
        stringArray[28] = "getAt";
        stringArray[29] = "getAt";
        stringArray[30] = "getAt";
        stringArray[31] = "max";
        stringArray[32] = "getAt";
        stringArray[33] = "getAt";
        stringArray[34] = "getAt";
        stringArray[35] = "getAt";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "exists";
        stringArray[38] = "plus";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "plus";
        stringArray[41] = "createStatement";
        stringArray[42] = "plus";
        stringArray[43] = "execute";
        stringArray[44] = "endsWith";
        stringArray[45] = "toLowerCase";
        stringArray[46] = "ROOT";
        stringArray[47] = "endsWith";
        stringArray[48] = "toLowerCase";
        stringArray[49] = "ROOT";
        stringArray[50] = "<$constructor$>";
        stringArray[51] = "plus";
        stringArray[52] = "<$constructor$>";
        stringArray[53] = "setAs3DPoint";
        stringArray[54] = "setExtractEnvelope";
        stringArray[55] = "getAbsolutePath";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "lastIndexOf";
        stringArray[58] = "substring";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "plus";
        stringArray[61] = "exists";
        stringArray[62] = "info";
        stringArray[63] = "plus";
        stringArray[64] = "getAbsolutePath";
        stringArray[65] = "getSRID";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "plus";
        stringArray[68] = "getAbsolutePath";
        stringArray[69] = "warn";
        stringArray[70] = "plus";
        stringArray[71] = "getAbsolutePath";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "<$constructor$>";
        stringArray[74] = "getAt";
        stringArray[75] = "read";
        stringArray[76] = "getAt";
        stringArray[77] = "info";
        stringArray[78] = "plus";
        stringArray[79] = "write";
        stringArray[80] = "ST_Transform";
        stringArray[81] = "setSRID";
        stringArray[82] = "setExtractEnvelope";
        stringArray[83] = "getEnvelopeInternal";
        stringArray[84] = "info";
        stringArray[85] = "plus";
        stringArray[86] = "write";
        stringArray[87] = "<$constructor$>";
        stringArray[88] = "<$constructor$>";
        stringArray[89] = "<$constructor$>";
        stringArray[90] = "getAt";
        stringArray[91] = "read";
        stringArray[92] = "getAt";
        stringArray[93] = "info";
        stringArray[94] = "plus";
        stringArray[95] = "write";
        stringArray[96] = "ST_Transform";
        stringArray[97] = "setSRID";
        stringArray[98] = "setExtractEnvelope";
        stringArray[99] = "getEnvelopeInternal";
        stringArray[100] = "info";
        stringArray[101] = "plus";
        stringArray[102] = "write";
        stringArray[103] = "<$constructor$>";
        stringArray[104] = "setDownScale";
        stringArray[105] = "<$constructor$>";
        stringArray[106] = "read";
        stringArray[107] = "<$constructor$>";
        stringArray[108] = "info";
        stringArray[109] = "plus";
        stringArray[110] = "execute";
        stringArray[111] = "plus";
        stringArray[112] = "plus";
        stringArray[113] = "info";
        stringArray[114] = "plus";
        stringArray[115] = "plus";
        stringArray[116] = "plus";
        stringArray[117] = "info";
        stringArray[118] = "info";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[119];
        Import_Asc_File.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Import_Asc_File.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Import_Asc_File.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

