/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.wps.Import_and_Export;

import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.io.FileType;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.transform.Generated;
import java.io.File;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.functions.io.csv.CSVDriverFunction;
import org.h2gis.functions.io.dbf.DBFDriverFunction;
import org.h2gis.functions.io.geojson.GeoJsonDriverFunction;
import org.h2gis.functions.io.gpx.GPXDriverFunction;
import org.h2gis.functions.io.osm.OSMDriverFunction;
import org.h2gis.functions.io.shp.SHPDriverFunction;
import org.h2gis.functions.io.tsv.TSVDriverFunction;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Import_Folder
extends Script {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Import_Folder() {
        CallSite[] callSiteArray = Import_Folder.$getCallSiteArray();
    }

    public Import_Folder(Binding context) {
        CallSite[] callSiteArray = Import_Folder.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = Import_Folder.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, Import_Folder.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = Import_Folder.$getCallSiteArray();
        String string = "Import all files from a folder";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, Import_Folder.class, (GroovyObject)this, (String)"title");
        Object object = callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call((Object)"&#10145;&#65039; Import all files with a specified extension from a folder to the database. ", (Object)"<hr>"), (Object)"Valid file extensions: csv, dbf, geojson, gpx, bz2, gz, osm, shp, tsv.</br> </br>"), (Object)"&#x2705; The resulting tables will have the same name as the input files</br> </br>"), (Object)"<img src=\"/wps_images/import_folder.png\" alt=\"Import folder\" width=\"95%\" align=\"center\">");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Import_Folder.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pathFolder", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Path of the folder", "title", "Path of the folder", "description", callSiteArray[5].call((Object)"&#128194; Path of the folder </br> </br>", (Object)" For example : c:/home/inputdata/ "), "type", String.class}), "inputSRID", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Projection identifier", "title", "Projection identifier", "description", callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].call((Object)"&#127757; Original projection identifier (also called SRID) of your table. </br> </br>", (Object)"It should be an <a href=\"https://epsg.io/\" target=\"_blank\">EPSG</a> code, an integer with 4 or 5 digits (ex: <a href=\"https://epsg.io/3857\" target=\"_blank\">3857</a> is Pseudo-Mercator projection). </br> </br>"), (Object)"This entry is optional because many formats already include the projection and you can also import files without geometry attributes.</br> </br>"), (Object)"If the table is geometric and if this parameter is not filled and:</br>"), (Object)"- the file has a .prj file associated: the SRID is deduced from the .prj </br>"), (Object)"- the file has no .prj file associated: we apply the WGS84 (<a href=\"https://epsg.io/4326\" target=\"_blank\">EPSG:4326</a>) code </br> </br>"), (Object)"&#128736; Default value: <b>4326 </b> "), "type", Integer.class, "min", 0, "max", 1}), "importExt", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Extension to import", "title", "Extension to import", "description", callSiteArray[12].call((Object)"Extension to import. </br> </br>", (Object)"For example: shp "), "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, Import_Folder.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "This type of result does not allow the blocks to be linked together.", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, Import_Folder.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = Import_Folder.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[14].call(callSiteArray[15].call(callSiteArray[16].callGroovyObjectGetProperty(callSiteArray[17].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].call(callSiteArray[19].callGroovyObjectGetProperty(callSiteArray[20].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].call(callSiteArray[22].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].call(callSiteArray[24].call((Object)jdbcDataStore)), Connection.class);
    }

    /*
     * WARNING - void declaration
     */
    public Object exec(Connection connection, Object input) {
        void var2_2;
        Reference connection2 = new Reference((Object)connection);
        Reference input2 = new Reference((Object)var2_2);
        CallSite[] callSiteArray = Import_Folder.$getCallSiteArray();
        Reference resultString = new Reference(null);
        Reference logger = new Reference((Object)((Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].call(LoggerFactory.class, (Object)"org.noise_planet.noisemodelling"), Logger.class)));
        callSiteArray[26].call((Object)((Logger)logger.get()), (Object)"Start : Import all files of a folder");
        callSiteArray[27].call((Object)((Logger)logger.get()), (Object)"inputs {}", input2.get());
        Reference srid = new Reference((Object)4326);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].call(input2.get(), (Object)"inputSRID"))) {
            srid.set((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[29].call(input2.get(), (Object)"inputSRID"), Integer.class)));
        }
        Reference importExt = new Reference((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[30].call(input2.get(), (Object)"importExt"), String.class)));
        String folder = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[31].call(input2.get(), (Object)"pathFolder"), String.class);
        Object dir = callSiteArray[32].callConstructor(File.class, (Object)folder);
        Reference outputTableName_full = new Reference((Object)"");
        Reference stmt = new Reference((Object)((Statement)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].call((Object)((Connection)connection2.get())), Statement.class)));
        public final class _exec_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference importExt;
            private /* synthetic */ Reference connection;
            private /* synthetic */ Reference stmt;
            private /* synthetic */ Reference outputTableName_full;
            private /* synthetic */ Reference logger;
            private /* synthetic */ Reference srid;
            private /* synthetic */ Reference input;
            private /* synthetic */ Reference resultString;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _exec_closure1(Object _outerInstance, Object _thisObject, Reference importExt, Reference connection, Reference stmt, Reference outputTableName_full, Reference logger, Reference srid, Reference input, Reference resultString) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                Reference reference8;
                CallSite[] callSiteArray = _exec_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.importExt = reference8 = importExt;
                this.connection = reference7 = connection;
                this.stmt = reference6 = stmt;
                this.outputTableName_full = reference5 = outputTableName_full;
                this.logger = reference4 = logger;
                this.srid = reference3 = srid;
                this.input = reference2 = input;
                this.resultString = reference = resultString;
            }

            public Object doCall(Object file) {
                CallSite[] callSiteArray = _exec_closure1.$getCallSiteArray();
                String pathFile = (String)ScriptBytecodeAdapter.asType((Object)file, String.class);
                String ext = ShortTypeHandling.castToString((Object)callSiteArray[0].call((Object)pathFile, callSiteArray[1].call(callSiteArray[2].call((Object)pathFile, (Object)"."), (Object)1), callSiteArray[3].call((Object)pathFile)));
                if (ScriptBytecodeAdapter.compareEqual((Object)ext, (Object)this.importExt.get())) {
                    String fileName = ShortTypeHandling.castToString((Object)callSiteArray[4].call(FilenameUtils.class, callSiteArray[5].call(callSiteArray[6].callConstructor(File.class, (Object)pathFile))));
                    callSiteArray[7].call((Object)fileName, (Object)"\\s", (Object)"_");
                    callSiteArray[8].call((Object)fileName, (Object)"[^a-zA-Z0-9 ]+", (Object)"_");
                    String outputTableName = ShortTypeHandling.castToString((Object)callSiteArray[9].call((Object)fileName));
                    TableLocation outputTableIdentifier = (TableLocation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].call(TableLocation.class, (Object)outputTableName, callSiteArray[11].call(DBUtils.class, this.connection.get())), TableLocation.class);
                    String dropOutputTable = ShortTypeHandling.castToString((Object)callSiteArray[12].call((Object)"drop table if exists ", callSiteArray[13].call((Object)outputTableIdentifier)));
                    callSiteArray[14].call(this.stmt.get(), (Object)dropOutputTable);
                    String string = ext;
                    if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"csv")) {
                        CSVDriverFunction csvDriver = (CSVDriverFunction)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].callConstructor(CSVDriverFunction.class), CSVDriverFunction.class);
                        callSiteArray[16].call((Object)csvDriver, this.connection.get(), (Object)outputTableName, callSiteArray[17].callConstructor(File.class, (Object)pathFile), callSiteArray[18].callConstructor(EmptyProgressVisitor.class));
                        Object object = callSiteArray[19].call(callSiteArray[20].call((Object)outputTableName, (Object)" & "), this.outputTableName_full.get());
                        this.outputTableName_full.set((Object)ShortTypeHandling.castToString((Object)object));
                    } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"dbf")) {
                        DBFDriverFunction dbfDriver = (DBFDriverFunction)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].callConstructor(DBFDriverFunction.class), DBFDriverFunction.class);
                        callSiteArray[22].call((Object)dbfDriver, this.connection.get(), (Object)outputTableName, callSiteArray[23].callConstructor(File.class, (Object)pathFile), callSiteArray[24].callConstructor(EmptyProgressVisitor.class));
                        Object object = callSiteArray[25].call(callSiteArray[26].call((Object)outputTableName, (Object)" & "), this.outputTableName_full.get());
                        this.outputTableName_full.set((Object)ShortTypeHandling.castToString((Object)object));
                    } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"geojson")) {
                        GeoJsonDriverFunction geoJsonDriver = (GeoJsonDriverFunction)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].callConstructor(GeoJsonDriverFunction.class), GeoJsonDriverFunction.class);
                        callSiteArray[28].call((Object)geoJsonDriver, this.connection.get(), (Object)outputTableName, callSiteArray[29].callConstructor(File.class, (Object)pathFile), callSiteArray[30].callConstructor(EmptyProgressVisitor.class));
                        Object object = callSiteArray[31].call(callSiteArray[32].call((Object)outputTableName, (Object)" & "), this.outputTableName_full.get());
                        this.outputTableName_full.set((Object)ShortTypeHandling.castToString((Object)object));
                    } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"gpx")) {
                        GPXDriverFunction gpxDriver = (GPXDriverFunction)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].callConstructor(GPXDriverFunction.class), GPXDriverFunction.class);
                        callSiteArray[34].call((Object)gpxDriver, this.connection.get(), (Object)outputTableName, callSiteArray[35].callConstructor(File.class, (Object)pathFile), callSiteArray[36].callConstructor(EmptyProgressVisitor.class));
                        Object object = callSiteArray[37].call(callSiteArray[38].call((Object)outputTableName, (Object)" & "), this.outputTableName_full.get());
                        this.outputTableName_full.set((Object)ShortTypeHandling.castToString((Object)object));
                    } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"bz2")) {
                        OSMDriverFunction osmDriver = (OSMDriverFunction)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].callConstructor(OSMDriverFunction.class), OSMDriverFunction.class);
                        callSiteArray[40].call((Object)osmDriver, this.connection.get(), (Object)outputTableName, callSiteArray[41].callConstructor(File.class, (Object)pathFile), callSiteArray[42].callConstructor(EmptyProgressVisitor.class));
                        Object object = callSiteArray[43].call(callSiteArray[44].call((Object)outputTableName, (Object)" & "), this.outputTableName_full.get());
                        this.outputTableName_full.set((Object)ShortTypeHandling.castToString((Object)object));
                    } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"gz")) {
                        OSMDriverFunction osmDriver = (OSMDriverFunction)ScriptBytecodeAdapter.castToType((Object)callSiteArray[45].callConstructor(OSMDriverFunction.class), OSMDriverFunction.class);
                        callSiteArray[46].call((Object)osmDriver, this.connection.get(), (Object)outputTableName, callSiteArray[47].callConstructor(File.class, (Object)pathFile), callSiteArray[48].callConstructor(EmptyProgressVisitor.class));
                        Object object = callSiteArray[49].call(callSiteArray[50].call((Object)outputTableName, (Object)" & "), this.outputTableName_full.get());
                        this.outputTableName_full.set((Object)ShortTypeHandling.castToString((Object)object));
                    } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"osm")) {
                        OSMDriverFunction osmDriver = (OSMDriverFunction)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callConstructor(OSMDriverFunction.class), OSMDriverFunction.class);
                        callSiteArray[52].call((Object)osmDriver, this.connection.get(), (Object)outputTableName, callSiteArray[53].callConstructor(File.class, (Object)pathFile), callSiteArray[54].callConstructor(EmptyProgressVisitor.class));
                        Object object = callSiteArray[55].call(callSiteArray[56].call((Object)outputTableName, (Object)" & "), this.outputTableName_full.get());
                        this.outputTableName_full.set((Object)ShortTypeHandling.castToString((Object)object));
                    } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"shp")) {
                        SHPDriverFunction shpDriver = (SHPDriverFunction)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].callConstructor(SHPDriverFunction.class), SHPDriverFunction.class);
                        callSiteArray[58].call((Object)shpDriver, this.connection.get(), (Object)outputTableName, callSiteArray[59].callConstructor(File.class, (Object)pathFile), callSiteArray[60].callConstructor(EmptyProgressVisitor.class));
                        Object object = callSiteArray[61].call(callSiteArray[62].call((Object)outputTableName, (Object)" & "), this.outputTableName_full.get());
                        this.outputTableName_full.set((Object)ShortTypeHandling.castToString((Object)object));
                    } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"tsv")) {
                        TSVDriverFunction tsvDriver = (TSVDriverFunction)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].callConstructor(TSVDriverFunction.class), TSVDriverFunction.class);
                        callSiteArray[64].call((Object)tsvDriver, this.connection.get(), (Object)outputTableName, callSiteArray[65].callConstructor(File.class, (Object)pathFile), callSiteArray[66].callConstructor(EmptyProgressVisitor.class));
                        Object object = callSiteArray[67].call(callSiteArray[68].call((Object)outputTableName, (Object)" & "), this.outputTableName_full.get());
                        this.outputTableName_full.set((Object)ShortTypeHandling.castToString((Object)object));
                    }
                    ResultSet rs = (ResultSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].call(this.stmt.get(), callSiteArray[70].call(callSiteArray[71].call((Object)"SELECT * FROM \"", (Object)outputTableName), (Object)"\"")), ResultSet.class);
                    int pk2Field = DefaultTypeTransformation.intUnbox((Object)callSiteArray[72].call(JDBCUtilities.class, callSiteArray[73].call((Object)rs), (Object)"PK2"));
                    int pkField = DefaultTypeTransformation.intUnbox((Object)callSiteArray[74].call(JDBCUtilities.class, callSiteArray[75].call((Object)rs), (Object)"PK"));
                    if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        if (pk2Field > 0 && pkField > 0) {
                            callSiteArray[76].call(this.stmt.get(), callSiteArray[77].call(callSiteArray[78].call((Object)"ALTER TABLE ", (Object)outputTableIdentifier), (Object)" DROP COLUMN PK2;"));
                            callSiteArray[79].call(this.logger.get(), (Object)"The PK2 column automatically created by the SHP driver has been deleted.");
                        }
                    } else if (pk2Field > 0 && pkField > 0) {
                        callSiteArray[80].call(this.stmt.get(), callSiteArray[81].call(callSiteArray[82].call((Object)"ALTER TABLE ", (Object)outputTableIdentifier), (Object)" DROP COLUMN PK2;"));
                        callSiteArray[83].call(this.logger.get(), (Object)"The PK2 column automatically created by the SHP driver has been deleted.");
                    }
                    List spatialFieldNames = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[84].call(GeometryTableUtilities.class, this.connection.get(), callSiteArray[85].call(TableLocation.class, (Object)outputTableName, callSiteArray[86].call(DBUtils.class, this.connection.get()))), List.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[87].call((Object)spatialFieldNames))) {
                        callSiteArray[88].call(this.logger.get(), callSiteArray[89].call(callSiteArray[90].call((Object)"The table ", (Object)outputTableName), (Object)" does not contain a geometry field."));
                    } else {
                        callSiteArray[91].call(this.stmt.get(), callSiteArray[92].call(callSiteArray[93].call(callSiteArray[94].call(callSiteArray[95].call((Object)"CREATE SPATIAL INDEX IF NOT EXISTS ", (Object)outputTableName), (Object)"_INDEX ON "), (Object)outputTableIdentifier), (Object)"(the_geom);"));
                        Integer tableSrid = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[96].call(GeometryTableUtilities.class, this.connection.get(), (Object)outputTableIdentifier), Integer.class);
                        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            if (ScriptBytecodeAdapter.compareNotEqual((Object)tableSrid, (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)tableSrid, (Object)this.srid.get()) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[97].call(this.input.get(), (Object)"inputSRID"))) {
                                Object object = callSiteArray[98].call(callSiteArray[99].call((Object)"The table ", (Object)outputTableName), (Object)" already has a different SRID than the one you gave.");
                                this.resultString.set((Object)ShortTypeHandling.castToString((Object)object));
                                throw (Throwable)callSiteArray[100].callConstructor(Exception.class, callSiteArray[101].call((Object)"ERROR : ", this.resultString.get()));
                            }
                        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)tableSrid, (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)tableSrid, (Object)this.srid.get()) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[102].call(this.input.get(), (Object)"inputSRID"))) {
                            Object object = callSiteArray[103].call(callSiteArray[104].call((Object)"The table ", (Object)outputTableName), (Object)" already has a different SRID than the one you gave.");
                            this.resultString.set((Object)ShortTypeHandling.castToString((Object)object));
                            throw (Throwable)callSiteArray[105].callConstructor(Exception.class, callSiteArray[106].call((Object)"ERROR : ", this.resultString.get()));
                        }
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)tableSrid, (Object)0)) {
                            Integer n = tableSrid;
                            this.srid.set((Object)n);
                        }
                        if (ScriptBytecodeAdapter.compareEqual((Object)tableSrid, (Object)0)) {
                            Statement st = (Statement)ScriptBytecodeAdapter.castToType((Object)callSiteArray[107].call(this.connection.get()), Statement.class);
                            try {
                                callSiteArray[108].call((Object)st, callSiteArray[109].call(String.class, ArrayUtil.createArray((Object)callSiteArray[110].callGetProperty(Locale.class), (Object)"SELECT UpdateGeometrySRID('%s', '%s', %d);", (Object)outputTableIdentifier, (Object)callSiteArray[111].call((Object)spatialFieldNames, (Object)0), (Object)this.srid.get())));
                            }
                            catch (SQLException ex) {
                                callSiteArray[112].call(this.logger.get(), (Object)"Failed to convert the SRID of the file:\n{}", (Object)pathFile, (Object)ex);
                            }
                        }
                        callSiteArray[113].call(this.logger.get(), callSiteArray[114].call(callSiteArray[115].call(callSiteArray[116].call(callSiteArray[117].call(callSiteArray[118].call((Object)"The SRID of the table ", (Object)outputTableName), (Object)" is "), this.srid.get()), (Object)" was "), (Object)tableSrid));
                    }
                    ResultSet rs2 = (ResultSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[119].call(this.stmt.get(), callSiteArray[120].call((Object)"SELECT * FROM ", (Object)outputTableIdentifier)), ResultSet.class);
                    int pkUserIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[121].call(JDBCUtilities.class, callSiteArray[122].call((Object)rs2), (Object)"PK"));
                    int pkIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[123].call(JDBCUtilities.class, this.connection.get(), (Object)outputTableIdentifier));
                    if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        if (pkIndex == 0) {
                            if (pkUserIndex > 0) {
                                callSiteArray[124].call(this.stmt.get(), callSiteArray[125].call(callSiteArray[126].call((Object)"ALTER TABLE ", (Object)outputTableIdentifier), (Object)" ALTER COLUMN PK INT NOT NULL;"));
                                callSiteArray[127].call(this.stmt.get(), callSiteArray[128].call(callSiteArray[129].call((Object)"ALTER TABLE ", (Object)outputTableIdentifier), (Object)" ADD PRIMARY KEY (PK);  "));
                                Object object = callSiteArray[130].call(this.resultString.get(), callSiteArray[131].call(String.class, callSiteArray[132].call(callSiteArray[133].call((Object)outputTableIdentifier), (Object)" has a new primary key constraint on PK")));
                                this.resultString.set((Object)ShortTypeHandling.castToString((Object)object));
                                return callSiteArray[134].call(this.logger.get(), callSiteArray[135].call(String.class, callSiteArray[136].call(callSiteArray[137].call((Object)outputTableIdentifier), (Object)" has a new primary key constraint on PK")));
                            }
                            return null;
                        }
                        return null;
                    }
                    if (pkIndex == 0) {
                        if (pkUserIndex > 0) {
                            callSiteArray[138].call(this.stmt.get(), callSiteArray[139].call(callSiteArray[140].call((Object)"ALTER TABLE ", (Object)outputTableIdentifier), (Object)" ALTER COLUMN PK INT NOT NULL;"));
                            callSiteArray[141].call(this.stmt.get(), callSiteArray[142].call(callSiteArray[143].call((Object)"ALTER TABLE ", (Object)outputTableIdentifier), (Object)" ADD PRIMARY KEY (PK);  "));
                            Object object = callSiteArray[144].call(this.resultString.get(), callSiteArray[145].call(String.class, callSiteArray[146].call(callSiteArray[147].call((Object)outputTableIdentifier), (Object)" has a new primary key constraint on PK")));
                            this.resultString.set((Object)ShortTypeHandling.castToString((Object)object));
                            return callSiteArray[148].call(this.logger.get(), callSiteArray[149].call(String.class, callSiteArray[150].call(callSiteArray[151].call((Object)outputTableIdentifier), (Object)" has a new primary key constraint on PK")));
                        }
                        return null;
                    }
                    return null;
                }
                return null;
            }

            @Generated
            public String getImportExt() {
                CallSite[] callSiteArray = _exec_closure1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.importExt.get());
            }

            @Generated
            public Connection getConnection() {
                CallSite[] callSiteArray = _exec_closure1.$getCallSiteArray();
                return (Connection)ScriptBytecodeAdapter.castToType((Object)this.connection.get(), Connection.class);
            }

            @Generated
            public Statement getStmt() {
                CallSite[] callSiteArray = _exec_closure1.$getCallSiteArray();
                return (Statement)ScriptBytecodeAdapter.castToType((Object)this.stmt.get(), Statement.class);
            }

            @Generated
            public String getOutputTableName_full() {
                CallSite[] callSiteArray = _exec_closure1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.outputTableName_full.get());
            }

            @Generated
            public Logger getLogger() {
                CallSite[] callSiteArray = _exec_closure1.$getCallSiteArray();
                return (Logger)ScriptBytecodeAdapter.castToType((Object)this.logger.get(), Logger.class);
            }

            @Generated
            public Integer getSrid() {
                CallSite[] callSiteArray = _exec_closure1.$getCallSiteArray();
                return (Integer)ScriptBytecodeAdapter.castToType((Object)this.srid.get(), Integer.class);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _exec_closure1.$getCallSiteArray();
                return this.input.get();
            }

            @Generated
            public String getResultString() {
                CallSite[] callSiteArray = _exec_closure1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.resultString.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _exec_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "substring";
                stringArray[1] = "plus";
                stringArray[2] = "lastIndexOf";
                stringArray[3] = "length";
                stringArray[4] = "removeExtension";
                stringArray[5] = "getName";
                stringArray[6] = "<$constructor$>";
                stringArray[7] = "replaceAll";
                stringArray[8] = "replaceAll";
                stringArray[9] = "toUpperCase";
                stringArray[10] = "parse";
                stringArray[11] = "getDBType";
                stringArray[12] = "plus";
                stringArray[13] = "toString";
                stringArray[14] = "execute";
                stringArray[15] = "<$constructor$>";
                stringArray[16] = "importFile";
                stringArray[17] = "<$constructor$>";
                stringArray[18] = "<$constructor$>";
                stringArray[19] = "plus";
                stringArray[20] = "plus";
                stringArray[21] = "<$constructor$>";
                stringArray[22] = "importFile";
                stringArray[23] = "<$constructor$>";
                stringArray[24] = "<$constructor$>";
                stringArray[25] = "plus";
                stringArray[26] = "plus";
                stringArray[27] = "<$constructor$>";
                stringArray[28] = "importFile";
                stringArray[29] = "<$constructor$>";
                stringArray[30] = "<$constructor$>";
                stringArray[31] = "plus";
                stringArray[32] = "plus";
                stringArray[33] = "<$constructor$>";
                stringArray[34] = "importFile";
                stringArray[35] = "<$constructor$>";
                stringArray[36] = "<$constructor$>";
                stringArray[37] = "plus";
                stringArray[38] = "plus";
                stringArray[39] = "<$constructor$>";
                stringArray[40] = "importFile";
                stringArray[41] = "<$constructor$>";
                stringArray[42] = "<$constructor$>";
                stringArray[43] = "plus";
                stringArray[44] = "plus";
                stringArray[45] = "<$constructor$>";
                stringArray[46] = "importFile";
                stringArray[47] = "<$constructor$>";
                stringArray[48] = "<$constructor$>";
                stringArray[49] = "plus";
                stringArray[50] = "plus";
                stringArray[51] = "<$constructor$>";
                stringArray[52] = "importFile";
                stringArray[53] = "<$constructor$>";
                stringArray[54] = "<$constructor$>";
                stringArray[55] = "plus";
                stringArray[56] = "plus";
                stringArray[57] = "<$constructor$>";
                stringArray[58] = "importFile";
                stringArray[59] = "<$constructor$>";
                stringArray[60] = "<$constructor$>";
                stringArray[61] = "plus";
                stringArray[62] = "plus";
                stringArray[63] = "<$constructor$>";
                stringArray[64] = "importFile";
                stringArray[65] = "<$constructor$>";
                stringArray[66] = "<$constructor$>";
                stringArray[67] = "plus";
                stringArray[68] = "plus";
                stringArray[69] = "executeQuery";
                stringArray[70] = "plus";
                stringArray[71] = "plus";
                stringArray[72] = "getFieldIndex";
                stringArray[73] = "getMetaData";
                stringArray[74] = "getFieldIndex";
                stringArray[75] = "getMetaData";
                stringArray[76] = "execute";
                stringArray[77] = "plus";
                stringArray[78] = "plus";
                stringArray[79] = "warn";
                stringArray[80] = "execute";
                stringArray[81] = "plus";
                stringArray[82] = "plus";
                stringArray[83] = "warn";
                stringArray[84] = "getGeometryColumnNames";
                stringArray[85] = "parse";
                stringArray[86] = "getDBType";
                stringArray[87] = "isEmpty";
                stringArray[88] = "warn";
                stringArray[89] = "plus";
                stringArray[90] = "plus";
                stringArray[91] = "execute";
                stringArray[92] = "plus";
                stringArray[93] = "plus";
                stringArray[94] = "plus";
                stringArray[95] = "plus";
                stringArray[96] = "getSRID";
                stringArray[97] = "getAt";
                stringArray[98] = "plus";
                stringArray[99] = "plus";
                stringArray[100] = "<$constructor$>";
                stringArray[101] = "plus";
                stringArray[102] = "getAt";
                stringArray[103] = "plus";
                stringArray[104] = "plus";
                stringArray[105] = "<$constructor$>";
                stringArray[106] = "plus";
                stringArray[107] = "createStatement";
                stringArray[108] = "execute";
                stringArray[109] = "format";
                stringArray[110] = "ROOT";
                stringArray[111] = "get";
                stringArray[112] = "error";
                stringArray[113] = "info";
                stringArray[114] = "plus";
                stringArray[115] = "plus";
                stringArray[116] = "plus";
                stringArray[117] = "plus";
                stringArray[118] = "plus";
                stringArray[119] = "executeQuery";
                stringArray[120] = "plus";
                stringArray[121] = "getFieldIndex";
                stringArray[122] = "getMetaData";
                stringArray[123] = "getIntegerPrimaryKey";
                stringArray[124] = "execute";
                stringArray[125] = "plus";
                stringArray[126] = "plus";
                stringArray[127] = "execute";
                stringArray[128] = "plus";
                stringArray[129] = "plus";
                stringArray[130] = "plus";
                stringArray[131] = "format";
                stringArray[132] = "plus";
                stringArray[133] = "toString";
                stringArray[134] = "info";
                stringArray[135] = "format";
                stringArray[136] = "plus";
                stringArray[137] = "toString";
                stringArray[138] = "execute";
                stringArray[139] = "plus";
                stringArray[140] = "plus";
                stringArray[141] = "execute";
                stringArray[142] = "plus";
                stringArray[143] = "plus";
                stringArray[144] = "plus";
                stringArray[145] = "format";
                stringArray[146] = "plus";
                stringArray[147] = "toString";
                stringArray[148] = "info";
                stringArray[149] = "format";
                stringArray[150] = "plus";
                stringArray[151] = "toString";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[152];
                _exec_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_exec_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _exec_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[34].call(dir, callSiteArray[35].callGetProperty(FileType.class), (Object)new _exec_closure1((Object)this, (Object)this, importExt, connection2, stmt, outputTableName_full, logger, srid, input2, resultString));
        resultString.set((Object)ShortTypeHandling.castToString((Object)callSiteArray[36].call(callSiteArray[37].call((Object)"The table(s) ", (Object)((String)outputTableName_full.get())), (Object)" has/have been uploaded to database !")));
        callSiteArray[38].call((Object)((Logger)logger.get()), (Object)((String)resultString.get()));
        callSiteArray[39].call((Object)((Logger)logger.get()), (Object)"End : Import all files of a folder");
        return (String)resultString.get();
    }

    public Object run(Object input) {
        public final class _run_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure2(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure2.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure2.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure2.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = Import_Folder.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[40].call(callSiteArray[41].callStatic(Import_Folder.class, (Object)dbName), (Object)new _run_closure2((Object)this, (Object)this, input2));
        }
        return callSiteArray[42].call((Object)Import_Folder.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure2((Object)this, (Object)this, input2));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Import_Folder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "plus";
        stringArray[12] = "plus";
        stringArray[13] = "isEmpty";
        stringArray[14] = "get";
        stringArray[15] = "getStoreNames";
        stringArray[16] = "catalog";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "getStore";
        stringArray[19] = "catalog";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "getDataStore";
        stringArray[22] = "getDataStoreInfo";
        stringArray[23] = "getConnection";
        stringArray[24] = "getDataSource";
        stringArray[25] = "getLogger";
        stringArray[26] = "info";
        stringArray[27] = "info";
        stringArray[28] = "getAt";
        stringArray[29] = "getAt";
        stringArray[30] = "getAt";
        stringArray[31] = "getAt";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "createStatement";
        stringArray[34] = "eachFileRecurse";
        stringArray[35] = "FILES";
        stringArray[36] = "plus";
        stringArray[37] = "plus";
        stringArray[38] = "info";
        stringArray[39] = "info";
        stringArray[40] = "withCloseable";
        stringArray[41] = "openGeoserverDataStoreConnection";
        stringArray[42] = "withCloseable";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[43];
        Import_Folder.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Import_Folder.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Import_Folder.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

