/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.wps.Import_and_Export;

import crosby.binary.osmosis.OsmosisReader;
import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.sql.Sql;
import groovy.transform.Generated;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.h2gis.utilities.wrapper.ConnectionWrapper;
import org.noise_planet.noisemodelling.wps.Import_and_Export.Building;
import org.noise_planet.noisemodelling.wps.Import_and_Export.Ground;
import org.noise_planet.noisemodelling.wps.Import_and_Export.OsmHandler;
import org.noise_planet.noisemodelling.wps.Import_and_Export.Road;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.v0_6.XmlReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Import_OSM
extends Script {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Import_OSM() {
        CallSite[] callSiteArray = Import_OSM.$getCallSiteArray();
    }

    public Import_OSM(Binding context) {
        CallSite[] callSiteArray = Import_OSM.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = Import_OSM.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, Import_OSM.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = Import_OSM.$getCallSiteArray();
        String string = "Import BUILDINGS, GROUND and ROADS tables from OSM";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, Import_OSM.class, (GroovyObject)this, (String)"title");
        Object object = callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call((Object)"&#10145;&#65039; Convert <b>.osm</b>, <b>.osm.gz</b> or <b>.osm.pbf</b> file into NoiseModelling input tables. We recommend using OSMBBBike : https://extract.bbbike.org/ </br>", (Object)"<hr>"), (Object)"The following output tables will be created: <br>"), (Object)"- <b> BUILDINGS </b>: a table containing the buildings<br>"), (Object)"- <b> GROUND </b>: a table containing ground acoustic absorption, based on OSM landcover surfaces<br>"), (Object)"- <b> ROADS </b>: a table containing the roads. As OSM does not include data on road traffic flows, default values are assigned according to the -Good Practice Guide for Strategic Noise Mapping and the Production of Associated Data on Noise Exposure - Version 2<br><br>"), (Object)"&#128161; The user can choose to avoid creating some of these tables by checking the dedicated boxes </br> </br>"), (Object)"<img src=\"/wps_images/import_osm_file.png\" alt=\"Import OSM file\" width=\"95%\" align=\"center\">");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Import_OSM.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"pathFile", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Path of the OSM file", "title", "Path of the OSM file", "description", callSiteArray[8].call((Object)"&#128194; Path of the OSM file, including its extension (.osm, .osm.gz or .osm.pbf).<br>", (Object)"For example: c:/home/area.osm.pbf"), "type", String.class}), "targetSRID", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Target projection identifier", "title", "Target projection identifier", "description", callSiteArray[9].call(callSiteArray[10].call((Object)"&#127757; Target projection identifier (also called SRID) of your table.<br>", (Object)"It should be an <a href=\"https://epsg.io/\" target=\"_blank\">EPSG</a> code, an integer with 4 or 5 digits (ex: <a href=\"https://epsg.io/3857\" target=\"_blank\">3857</a> is Web Mercator projection).<br><br>"), (Object)"&#x1F6A8; The target SRID must be in <b>metric</b> coordinates."), "type", Integer.class}), "ignoreBuilding", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Do not import Buildings", "title", "Do not import Buildings", "description", callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call(callSiteArray[15].call(callSiteArray[16].call((Object)"&#9989; If the box is checked</i> &#8594; the table BUILDINGS will <b>NOT</b> be created.<br><br>", (Object)"&#129001; If the box is <b>NOT</b> checked &#8594; the table BUILDINGS will be created and will contain:<br>"), (Object)"- <b> PK </b> : An identifier. It shall be a primary key (INTEGER, PRIMARY KEY)<br>"), (Object)"- <b> THE_GEOM </b> : The 2D geometry of the building (POLYGON or MULTIPOLYGON). <br>"), (Object)"- <b> HEIGHT </b> : The height of the building (FLOAT). "), (Object)"If this information is not available then it is deduced from the number of floors (if available) with the addition of a small random variation from one building to another. "), (Object)"Finally, if no information is available, a height of 5m is set by default."), "min", 0, "max", 1, "type", Boolean.class}), "ignoreGround", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Do not import Surface acoustic absorption", "title", "Do not import Surface acoustic absorption", "description", callSiteArray[17].call(callSiteArray[18].call(callSiteArray[19].call(callSiteArray[20].call(callSiteArray[21].call(callSiteArray[22].call((Object)"&#9989; If the box is checked &#8594; the table GROUND will <b>NOT</b> be created.<br><br>", (Object)"&#129001; If the box is <b>NOT</b> checked &#8594; the table GROUND will be created and will contain: <br>"), (Object)"- <b> PK </b> : An identifier. It shall be a primary key (INTEGER, PRIMARY KEY)<br>"), (Object)"- <b> ID_WAY </b> : OSM identifier (INTEGER)<br>"), (Object)"- <b> THE_GEOM </b> : The 2D geometry of the sources (POLYGON or MULTIPOLYGON)<br>"), (Object)"- <b> PRIORITY </b> : Since NoiseModelling does not allowed overlapping geometries, if this is the case, this column is used to prioritize the geometry that will win over the other one when cutting. The order is given according to the type of land use<br>"), (Object)"- <b> G </b> : The acoustic absorption of a ground (FLOAT) (between 0 : very hard and 1 : very soft)"), "min", 0, "max", 1, "type", Boolean.class}), "ignoreRoads", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Do not import Roads", "title", "Do not import Roads", "description", callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].call(callSiteArray[26].call(callSiteArray[27].call(callSiteArray[28].call(callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].call(callSiteArray[32].call(callSiteArray[33].call(callSiteArray[34].call(callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].call(callSiteArray[38].call(callSiteArray[39].call(callSiteArray[40].call((Object)"&#9989; If the box is checked &#8594; the table ROADS will <b>NOT</b> be created.<br><br>", (Object)"&#129001; If the box is <b>NOT</b> checked &#8594; the table ROADS will be created and will contain:<br>"), (Object)"- <b> PK </b> : An identifier. It shall be a primary key (INTEGER, PRIMARY KEY)<br>"), (Object)"- <b> ID_WAY </b> : OSM identifier (INTEGER)<br>"), (Object)"- <b> THE_GEOM </b> : The 2D geometry of the sources (LINESTRING or MULTILINESTRING)<br>"), (Object)"- <b> LV_D </b> : Hourly average light and heavy vehicle count (6-18h) (DOUBLE)<br>"), (Object)"- <b> LV_E </b> : Hourly average light and heavy vehicle count (18-22h) (DOUBLE)<br>"), (Object)"- <b> LV_N </b> : Hourly average light and heavy vehicle count (22-6h) (DOUBLE)<br>"), (Object)"- <b> HGV_D </b> : Hourly average heavy vehicle count (6-18h) (DOUBLE)<br>"), (Object)"- <b> HGV_E </b> : Hourly average heavy vehicle count (18-22h) (DOUBLE)<br>"), (Object)"- <b> HGV_N </b> : Hourly average heavy vehicle count (22-6h) (DOUBLE)<br>"), (Object)"- <b> LV_SPD_D </b> : Hourly average light vehicle speed (6-18h) (DOUBLE)<br>"), (Object)"- <b> LV_SPD_E </b> : Hourly average light vehicle speed (18-22h) (DOUBLE)<br>"), (Object)"- <b> LV_SPD_N </b> : Hourly average light vehicle speed (22-6h) (DOUBLE)<br>"), (Object)"- <b> HGV_SPD_D </b> : Hourly average heavy vehicle speed (6-18h) (DOUBLE)<br>"), (Object)"- <b> HGV_SPD_E </b> : Hourly average heavy vehicle speed (18-22h) (DOUBLE)<br>"), (Object)"- <b> HGV_SPD_N </b> : Hourly average heavy vehicle speed (22-6h) (DOUBLE)<br>"), (Object)"- <b> PVMT </b> : CNOSSOS road pavement identifier (ex: NL05) (VARCHAR)<br> <br>"), (Object)"&#128161; <b>These information are deduced from the roads importance in OSM.</b>."), "min", 0, "max", 1, "type", Boolean.class}), "removeTunnels", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Remove tunnels from OSM data", "title", "Remove tunnels from OSM data", "description", "&#9989; If checked, remove roads from OSM data that contain OSM tag <b>tunnel=yes</b>.", "min", 0, "max", 1, "type", Boolean.class}), "eliminateNoTrafficRoads", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Eliminate no traffic roads", "title", "Eliminate no traffic roads", "description", callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].call(callSiteArray[47].call(callSiteArray[48].call(callSiteArray[49].call(callSiteArray[50].call(callSiteArray[51].call(callSiteArray[52].call(callSiteArray[53].call(callSiteArray[54].call(callSiteArray[55].call(callSiteArray[56].call(callSiteArray[57].call(callSiteArray[58].call(callSiteArray[59].call(callSiteArray[60].call(callSiteArray[61].call(callSiteArray[62].call((Object)"<b>If checked</b>, only roads with these \"TYPE\" values will remain:<br>", (Object)"- bus_guideway: Dedicated lanes or tracks for buses<br>"), (Object)"- busway: Bus-only lanes<br>"), (Object)"- living_street: Residential streets with pedestrian priority<br>"), (Object)"- motorway: High-speed, restricted-access highways<br>"), (Object)"- motorway_link: Connector ramps for motorways<br>"), (Object)"- primary: Major roads linking large cities<br>"), (Object)"- primary_link: Connector ramps for primary roads<br>"), (Object)"- raceway: Racing tracks<br>"), (Object)"- residential: Roads in residential areas<br>"), (Object)"- road: Generic roads<br>"), (Object)"- secondary: Roads connecting smaller towns<br>"), (Object)"- secondary_link: Connector ramps for secondary roads<br>"), (Object)"- service: Service lanes (access to parking lots, etc.)<br>"), (Object)"- tertiary: Roads connecting villages and hamlets<br>"), (Object)"- tertiary_link: Connector ramps for tertiary roads<br>"), (Object)"- trunk: Important roads that are not motorways<br>"), (Object)"- trunk_link: Connector ramps for trunk roads<br>"), (Object)"- unclassified: Minor roads not fitting higher classifications<br>"), (Object)"- rest_area: Areas for rest along roads<br>"), (Object)"- traffic_calming: Traffic calming features (speed bumps, etc.)<br>"), (Object)"- traffic_island: Traffic islands<br><br>"), (Object)"<b>If not checked</b>, all roads are processed as before."), "min", 0, "max", 1, "type", Boolean.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, Import_OSM.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "This type of result does not allow the blocks to be linked together.", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, Import_OSM.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = Import_OSM.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[63].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].callGroovyObjectGetProperty(callSiteArray[67].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].call(callSiteArray[69].callGroovyObjectGetProperty(callSiteArray[70].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[71].call(callSiteArray[72].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[73].call(callSiteArray[74].call((Object)jdbcDataStore)), Connection.class);
    }

    public Object run(Object input) {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure1(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = Import_OSM.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[75].call(callSiteArray[76].callStatic(Import_OSM.class, (Object)dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
        }
        return callSiteArray[77].call((Object)Import_OSM.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
    }

    public Object exec(Connection connection, Object input) {
        CallSite[] callSiteArray = Import_OSM.$getCallSiteArray();
        connection = (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].callConstructor(ConnectionWrapper.class, (Object)connection), Connection.class);
        Sql sql = (Sql)ScriptBytecodeAdapter.castToType((Object)callSiteArray[79].callConstructor(Sql.class, (Object)connection), Sql.class);
        String resultString = null;
        Logger logger = (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].call(LoggerFactory.class, (Object)"org.noise_planet.noisemodelling"), Logger.class);
        callSiteArray[81].call((Object)logger, (Object)"Start : Get Buildings from OSM");
        callSiteArray[82].call((Object)logger, (Object)"inputs {}", input);
        String pathFile = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[83].call(input, (Object)"pathFile"), String.class);
        Boolean ignoreBuilding = false;
        if (ScriptBytecodeAdapter.isCase((Object)"ignoreBuilding", (Object)input)) {
            ignoreBuilding = (Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[84].call(input, (Object)"ignoreBuilding"), Boolean.class);
        }
        Boolean ignoreGround = false;
        if (ScriptBytecodeAdapter.isCase((Object)"ignoreGround", (Object)input)) {
            ignoreGround = (Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[85].call(input, (Object)"ignoreGround"), Boolean.class);
        }
        Boolean ignoreRoads = false;
        if (ScriptBytecodeAdapter.isCase((Object)"ignoreRoads", (Object)input)) {
            ignoreRoads = (Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[86].call(input, (Object)"ignoreRoads"), Boolean.class);
        }
        Integer srid = 3857;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[87].call(input, (Object)"targetSRID"))) {
            srid = (Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[88].call(input, (Object)"targetSRID"), Integer.class);
        }
        Boolean removeTunnels = false;
        if (ScriptBytecodeAdapter.isCase((Object)"removeTunnels", (Object)input)) {
            removeTunnels = (Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[89].call(input, (Object)"removeTunnels"), Boolean.class);
        }
        Boolean eliminateNoTrafficRoads = false;
        if (ScriptBytecodeAdapter.isCase((Object)"eliminateNoTrafficRoads", (Object)input)) {
            eliminateNoTrafficRoads = (Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[90].call(input, (Object)"eliminateNoTrafficRoads"), Boolean.class);
        }
        Object reader = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[91].call(callSiteArray[92].call((Object)pathFile, callSiteArray[93].call(Locale.class)), (Object)".pbf"))) {
            InputStream inputStream = (InputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[94].callConstructor(FileInputStream.class, (Object)pathFile), InputStream.class);
            reader = callSiteArray[95].callConstructor(OsmosisReader.class, (Object)inputStream);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[96].call(callSiteArray[97].call((Object)pathFile, callSiteArray[98].call(Locale.class)), (Object)".osm"))) {
            reader = callSiteArray[99].callConstructor(XmlReader.class, callSiteArray[100].callConstructor(File.class, (Object)pathFile), (Object)true, callSiteArray[101].callGetProperty(CompressionMethod.class));
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[102].call(callSiteArray[103].call((Object)pathFile, callSiteArray[104].call(Locale.class)), (Object)".osm.gz"))) {
            reader = callSiteArray[105].callConstructor(XmlReader.class, callSiteArray[106].callConstructor(File.class, (Object)pathFile), (Object)true, callSiteArray[107].callGetProperty(CompressionMethod.class));
        } else {
            throw (Throwable)callSiteArray[108].callConstructor(IllegalArgumentException.class, callSiteArray[109].call((Object)"File extension not known.Should be pbf, osm or osm.gz but got ", (Object)pathFile));
        }
        OsmHandler handler = (OsmHandler)ScriptBytecodeAdapter.castToType((Object)callSiteArray[110].callConstructor(OsmHandler.class, ArrayUtil.createArray((Object)logger, (Object)ignoreBuilding, (Object)ignoreRoads, (Object)ignoreGround, (Object)removeTunnels)), OsmHandler.class);
        callSiteArray[111].call(reader, (Object)handler);
        callSiteArray[112].call(reader);
        callSiteArray[113].call((Object)logger, (Object)"OSM Read done");
        if (DefaultTypeTransformation.booleanUnbox((Object)eliminateNoTrafficRoads) && !DefaultTypeTransformation.booleanUnbox((Object)ignoreRoads)) {
            Reference validRoadTypes = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"bus_guideway", "busway", "living_street", "motorway", "motorway_link", "primary", "primary_link", "raceway", "residential", "road", "secondary", "secondary_link", "service", "tertiary", "tertiary_link", "trunk", "trunk_link", "unclassified", "rest_area", "traffic_calming", "traffic_island"}));
            public final class _exec_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference validRoadTypes;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _exec_closure2(Object _outerInstance, Object _thisObject, Reference validRoadTypes) {
                    Reference reference;
                    CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.validRoadTypes = reference = validRoadTypes;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                    return callSiteArray[0].call(this.validRoadTypes.get(), callSiteArray[1].callGetProperty(it));
                }

                @Generated
                public Object getValidRoadTypes() {
                    CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                    return this.validRoadTypes.get();
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _exec_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "contains";
                    stringArray[1] = "type";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _exec_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_exec_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _exec_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Object object = callSiteArray[114].call(callSiteArray[115].callGroovyObjectGetProperty((Object)handler), (Object)new _exec_closure2((Object)this, (Object)this, validRoadTypes));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Import_OSM.class, (GroovyObject)handler, (String)"roads");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)ignoreBuilding)) {
            String tableName = "MAP_BUILDINGS_GEOM";
            callSiteArray[116].call((Object)sql, callSiteArray[117].call((Object)"DROP TABLE IF EXISTS ", (Object)tableName));
            callSiteArray[118].call((Object)sql, callSiteArray[119].call(callSiteArray[120].call((Object)"CREATE TABLE ", (Object)tableName), (Object)"( \n            ID_WAY integer PRIMARY KEY, \n            THE_GEOM geometry,\n            HEIGHT real\n        );"));
            Building building = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[121].call(callSiteArray[122].callGroovyObjectGetProperty((Object)handler)), Iterator.class);
            if (iterator != null) {
                while (iterator.hasNext()) {
                    building = (Building)ScriptBytecodeAdapter.castToType(iterator.next(), Building.class);
                    callSiteArray[123].call((Object)sql, callSiteArray[124].call(callSiteArray[125].call(callSiteArray[126].call(callSiteArray[127].call(callSiteArray[128].call(callSiteArray[129].call(callSiteArray[130].call(callSiteArray[131].call(callSiteArray[132].call(callSiteArray[133].call((Object)"INSERT INTO ", (Object)tableName), (Object)" VALUES ("), callSiteArray[134].callGroovyObjectGetProperty((Object)building)), (Object)", ST_MakeValid(ST_SIMPLIFYPRESERVETOPOLOGY(ST_Transform(ST_GeomFromText('"), callSiteArray[135].callGroovyObjectGetProperty((Object)building)), (Object)"', 4326), "), (Object)srid), (Object)"),0.1)), "), callSiteArray[136].callGroovyObjectGetProperty((Object)building)), (Object)")"));
                }
            }
            callSiteArray[137].call((Object)sql, callSiteArray[138].call(callSiteArray[139].call(callSiteArray[140].call(callSiteArray[141].call(callSiteArray[142].call(callSiteArray[143].call((Object)"\n            CREATE SPATIAL INDEX IF NOT EXISTS BUILDINGS_INDEX ON ", (Object)tableName), (Object)"(the_geom);\n            -- List buildings that intersects with other buildings that have a greater area\n            DROP TABLE IF EXISTS tmp_relation_buildings_buildings;\n            CREATE TABLE tmp_relation_buildings_buildings AS SELECT s1.ID_WAY as PK_BUILDING, S2.ID_WAY as PK2_BUILDING FROM MAP_BUILDINGS_GEOM S1, MAP_BUILDINGS_GEOM S2 WHERE ST_AREA(S1.THE_GEOM) < ST_AREA(S2.THE_GEOM) AND S1.THE_GEOM && S2.THE_GEOM AND ST_DISTANCE(S1.THE_GEOM, S2.THE_GEOM) <= 0.1;\n            \n            -- Alter that small area buildings by removing shared area\n            DROP TABLE IF EXISTS tmp_buildings_truncated;\n            CREATE TABLE tmp_buildings_truncated AS SELECT PK_BUILDING, ST_DIFFERENCE(s1.the_geom, ST_BUFFER(ST_Collect(s2.the_geom), 0.1, 'join=mitre')) the_geom, s1.HEIGHT HEIGHT from tmp_relation_buildings_buildings r, MAP_BUILDINGS_GEOM s1, MAP_BUILDINGS_GEOM s2 WHERE PK_BUILDING = S1.ID_WAY AND PK2_BUILDING = S2.ID_WAY  GROUP BY PK_BUILDING;\n            \n            -- Merge original buildings with altered buildings \n            DROP TABLE IF EXISTS BUILDINGS;\n            CREATE TABLE BUILDINGS(PK INTEGER PRIMARY KEY, THE_GEOM GEOMETRY, HEIGHT real) AS SELECT s.id_way, ST_SETSRID(s.the_geom, "), (Object)srid), (Object)"), s.HEIGHT from  MAP_BUILDINGS_GEOM s where id_way not in (select PK_BUILDING from tmp_buildings_truncated) UNION ALL select PK_BUILDING, ST_SETSRID(the_geom, "), (Object)srid), (Object)"), HEIGHT from tmp_buildings_truncated WHERE NOT st_isempty(the_geom);\n    \n            DROP TABLE IF EXISTS tmp_buildings_truncated;\n            DROP TABLE IF EXISTS tmp_relation_buildings_buildings;\n            DROP TABLE IF EXISTS MAP_BUILDINGS_GEOM;\n        "));
            callSiteArray[144].call((Object)sql, callSiteArray[145].call(callSiteArray[146].call((Object)"CREATE SPATIAL INDEX IF NOT EXISTS BUILDING_GEOM_INDEX ON ", (Object)"BUILDINGS"), (Object)"(THE_GEOM)"));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)ignoreRoads)) {
            callSiteArray[147].call((Object)sql, (Object)"DROP TABLE IF EXISTS ROADS");
            callSiteArray[148].call((Object)sql, (Object)"CREATE TABLE ROADS (PK serial PRIMARY KEY, ID_WAY integer, THE_GEOM geometry, TYPE varchar, LV_D integer, LV_E integer,LV_N integer,HGV_D integer,HGV_E integer,HGV_N integer,LV_SPD_D integer,LV_SPD_E integer,LV_SPD_N integer,HGV_SPD_D integer, HGV_SPD_E integer,HGV_SPD_N integer, PVMT varchar(10));");
            Road road = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[149].call(callSiteArray[150].callGroovyObjectGetProperty((Object)handler)), Iterator.class);
            if (iterator != null) {
                while (iterator.hasNext()) {
                    road = (Road)ScriptBytecodeAdapter.castToType(iterator.next(), Road.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[151].call(callSiteArray[152].callGroovyObjectGetProperty((Object)road)))) continue;
                    String query = ShortTypeHandling.castToString((Object)callSiteArray[153].call(callSiteArray[154].call(callSiteArray[155].call(callSiteArray[156].call(callSiteArray[157].call(callSiteArray[158].call(callSiteArray[159].call(callSiteArray[160].call(callSiteArray[161].call(callSiteArray[162].call(callSiteArray[163].call(callSiteArray[164].call(callSiteArray[165].call(callSiteArray[166].call((Object)"INSERT INTO ROADS(ID_WAY, ", (Object)"THE_GEOM, "), (Object)"TYPE, "), (Object)"LV_D, LV_E, LV_N, "), (Object)"HGV_D, HGV_E, HGV_N, "), (Object)"LV_SPD_D, LV_SPD_E, LV_SPD_N, "), (Object)"HGV_SPD_D, HGV_SPD_E, HGV_SPD_N, "), (Object)"PVMT) "), (Object)" VALUES (?,"), (Object)"st_setsrid(st_updatez(ST_precisionreducer(ST_SIMPLIFYPRESERVETOPOLOGY(ST_TRANSFORM(ST_GeomFromText(?, 4326), "), (Object)srid), (Object)"),0.1),1), 0.05), "), (Object)srid), (Object)"),"), (Object)"?,?,?,?,?,?,?,?,?,?,?,?,?,?);"));
                    callSiteArray[167].call((Object)sql, (Object)query, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[168].callGroovyObjectGetProperty((Object)road), callSiteArray[169].callGroovyObjectGetProperty((Object)road), callSiteArray[170].callGroovyObjectGetProperty((Object)road), callSiteArray[171].call((Object)road, (Object)"d"), callSiteArray[172].call((Object)road, (Object)"e"), callSiteArray[173].call((Object)road, (Object)"n"), callSiteArray[174].call((Object)road, (Object)"d"), callSiteArray[175].call((Object)road, (Object)"e"), callSiteArray[176].call((Object)road, (Object)"n"), callSiteArray[177].call(callSiteArray[178].callGetProperty(Road.class), callSiteArray[179].callGroovyObjectGetProperty((Object)road)), callSiteArray[180].call(callSiteArray[181].callGetProperty(Road.class), callSiteArray[182].callGroovyObjectGetProperty((Object)road)), callSiteArray[183].call(callSiteArray[184].callGetProperty(Road.class), callSiteArray[185].callGroovyObjectGetProperty((Object)road)), callSiteArray[186].call(Math.class, (Object)90, callSiteArray[187].call(callSiteArray[188].callGetProperty(Road.class), callSiteArray[189].callGroovyObjectGetProperty((Object)road))), callSiteArray[190].call(Math.class, (Object)90, callSiteArray[191].call(callSiteArray[192].callGetProperty(Road.class), callSiteArray[193].callGroovyObjectGetProperty((Object)road))), callSiteArray[194].call(Math.class, (Object)90, callSiteArray[195].call(callSiteArray[196].callGetProperty(Road.class), callSiteArray[197].callGroovyObjectGetProperty((Object)road))), "NL08"}));
                }
            }
            callSiteArray[198].call((Object)sql, callSiteArray[199].call(callSiteArray[200].call((Object)"CREATE SPATIAL INDEX IF NOT EXISTS ROADS_GEOM_INDEX ON ", (Object)"ROADS"), (Object)"(THE_GEOM)"));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)ignoreGround)) {
            callSiteArray[201].call((Object)sql, (Object)"DROP TABLE IF EXISTS GROUND");
            callSiteArray[202].call((Object)sql, (Object)"CREATE TABLE GROUND (PK serial PRIMARY KEY, ID_WAY int, THE_GEOM geometry, PRIORITY int, G double);");
            Ground ground = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[203].call(callSiteArray[204].callGroovyObjectGetProperty((Object)handler)), Iterator.class);
            if (iterator != null) {
                while (iterator.hasNext()) {
                    ground = (Ground)ScriptBytecodeAdapter.castToType(iterator.next(), Ground.class);
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[205].callGroovyObjectGetProperty((Object)ground), (Object)0) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[206].call(callSiteArray[207].callGroovyObjectGetProperty((Object)ground)))) continue;
                    callSiteArray[208].call((Object)sql, callSiteArray[209].call(callSiteArray[210].call(callSiteArray[211].call(callSiteArray[212].call(callSiteArray[213].call(callSiteArray[214].call(callSiteArray[215].call(callSiteArray[216].call(callSiteArray[217].call(callSiteArray[218].call((Object)"INSERT INTO GROUND (ID_WAY, THE_GEOM, PRIORITY, G) VALUES (", callSiteArray[219].callGroovyObjectGetProperty((Object)ground)), (Object)", ST_Transform(ST_GeomFromText('"), callSiteArray[220].callGroovyObjectGetProperty((Object)ground)), (Object)"', 4326), "), (Object)srid), (Object)"), "), callSiteArray[221].callGroovyObjectGetProperty((Object)ground)), (Object)", "), callSiteArray[222].callGroovyObjectGetProperty((Object)ground)), (Object)")"));
                }
            }
            callSiteArray[223].call((Object)sql, callSiteArray[224].call(callSiteArray[225].call((Object)"CREATE SPATIAL INDEX IF NOT EXISTS GROUND_GEOM_INDEX ON ", (Object)"GROUND"), (Object)"(THE_GEOM)"));
        }
        callSiteArray[226].call((Object)logger, (Object)"SQL INSERT done");
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[227].call((Object)"nodes : ", callSiteArray[228].callGroovyObjectGetProperty((Object)handler)));
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[229].call((Object)resultString, (Object)"<br>\n"));
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[230].call((Object)resultString, callSiteArray[231].call((Object)"ways : ", callSiteArray[232].callGroovyObjectGetProperty((Object)handler))));
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[233].call((Object)resultString, (Object)"<br>\n"));
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[234].call((Object)resultString, callSiteArray[235].call((Object)"relations : ", callSiteArray[236].callGroovyObjectGetProperty((Object)handler))));
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[237].call((Object)resultString, (Object)"<br>\n"));
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[238].call((Object)resultString, callSiteArray[239].call((Object)"buildings : ", callSiteArray[240].callGroovyObjectGetProperty((Object)handler))));
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[241].call((Object)resultString, (Object)"<br>\n"));
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[242].call((Object)resultString, callSiteArray[243].call((Object)"roads : ", callSiteArray[244].callGroovyObjectGetProperty((Object)handler))));
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[245].call((Object)resultString, (Object)"<br>\n"));
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[246].call((Object)resultString, callSiteArray[247].call((Object)"grounds : ", callSiteArray[248].callGroovyObjectGetProperty((Object)handler))));
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[249].call((Object)resultString, (Object)"<br>\n"));
        callSiteArray[250].call((Object)logger, (Object)"End : Get Buildings from OSM");
        callSiteArray[251].call((Object)logger, callSiteArray[252].call((Object)"Result : ", (Object)resultString));
        return resultString;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Import_OSM.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "plus";
        stringArray[12] = "plus";
        stringArray[13] = "plus";
        stringArray[14] = "plus";
        stringArray[15] = "plus";
        stringArray[16] = "plus";
        stringArray[17] = "plus";
        stringArray[18] = "plus";
        stringArray[19] = "plus";
        stringArray[20] = "plus";
        stringArray[21] = "plus";
        stringArray[22] = "plus";
        stringArray[23] = "plus";
        stringArray[24] = "plus";
        stringArray[25] = "plus";
        stringArray[26] = "plus";
        stringArray[27] = "plus";
        stringArray[28] = "plus";
        stringArray[29] = "plus";
        stringArray[30] = "plus";
        stringArray[31] = "plus";
        stringArray[32] = "plus";
        stringArray[33] = "plus";
        stringArray[34] = "plus";
        stringArray[35] = "plus";
        stringArray[36] = "plus";
        stringArray[37] = "plus";
        stringArray[38] = "plus";
        stringArray[39] = "plus";
        stringArray[40] = "plus";
        stringArray[41] = "plus";
        stringArray[42] = "plus";
        stringArray[43] = "plus";
        stringArray[44] = "plus";
        stringArray[45] = "plus";
        stringArray[46] = "plus";
        stringArray[47] = "plus";
        stringArray[48] = "plus";
        stringArray[49] = "plus";
        stringArray[50] = "plus";
        stringArray[51] = "plus";
        stringArray[52] = "plus";
        stringArray[53] = "plus";
        stringArray[54] = "plus";
        stringArray[55] = "plus";
        stringArray[56] = "plus";
        stringArray[57] = "plus";
        stringArray[58] = "plus";
        stringArray[59] = "plus";
        stringArray[60] = "plus";
        stringArray[61] = "plus";
        stringArray[62] = "plus";
        stringArray[63] = "isEmpty";
        stringArray[64] = "get";
        stringArray[65] = "getStoreNames";
        stringArray[66] = "catalog";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "getStore";
        stringArray[69] = "catalog";
        stringArray[70] = "<$constructor$>";
        stringArray[71] = "getDataStore";
        stringArray[72] = "getDataStoreInfo";
        stringArray[73] = "getConnection";
        stringArray[74] = "getDataSource";
        stringArray[75] = "withCloseable";
        stringArray[76] = "openGeoserverDataStoreConnection";
        stringArray[77] = "withCloseable";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "<$constructor$>";
        stringArray[80] = "getLogger";
        stringArray[81] = "info";
        stringArray[82] = "info";
        stringArray[83] = "getAt";
        stringArray[84] = "getAt";
        stringArray[85] = "getAt";
        stringArray[86] = "getAt";
        stringArray[87] = "getAt";
        stringArray[88] = "getAt";
        stringArray[89] = "getAt";
        stringArray[90] = "getAt";
        stringArray[91] = "endsWith";
        stringArray[92] = "toLowerCase";
        stringArray[93] = "getDefault";
        stringArray[94] = "<$constructor$>";
        stringArray[95] = "<$constructor$>";
        stringArray[96] = "endsWith";
        stringArray[97] = "toLowerCase";
        stringArray[98] = "getDefault";
        stringArray[99] = "<$constructor$>";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "None";
        stringArray[102] = "endsWith";
        stringArray[103] = "toLowerCase";
        stringArray[104] = "getDefault";
        stringArray[105] = "<$constructor$>";
        stringArray[106] = "<$constructor$>";
        stringArray[107] = "GZip";
        stringArray[108] = "<$constructor$>";
        stringArray[109] = "plus";
        stringArray[110] = "<$constructor$>";
        stringArray[111] = "setSink";
        stringArray[112] = "run";
        stringArray[113] = "info";
        stringArray[114] = "findAll";
        stringArray[115] = "roads";
        stringArray[116] = "execute";
        stringArray[117] = "plus";
        stringArray[118] = "execute";
        stringArray[119] = "plus";
        stringArray[120] = "plus";
        stringArray[121] = "iterator";
        stringArray[122] = "buildings";
        stringArray[123] = "execute";
        stringArray[124] = "plus";
        stringArray[125] = "plus";
        stringArray[126] = "plus";
        stringArray[127] = "plus";
        stringArray[128] = "plus";
        stringArray[129] = "plus";
        stringArray[130] = "plus";
        stringArray[131] = "plus";
        stringArray[132] = "plus";
        stringArray[133] = "plus";
        stringArray[134] = "id";
        stringArray[135] = "geom";
        stringArray[136] = "height";
        stringArray[137] = "execute";
        stringArray[138] = "plus";
        stringArray[139] = "plus";
        stringArray[140] = "plus";
        stringArray[141] = "plus";
        stringArray[142] = "plus";
        stringArray[143] = "plus";
        stringArray[144] = "execute";
        stringArray[145] = "plus";
        stringArray[146] = "plus";
        stringArray[147] = "execute";
        stringArray[148] = "execute";
        stringArray[149] = "iterator";
        stringArray[150] = "roads";
        stringArray[151] = "isEmpty";
        stringArray[152] = "geom";
        stringArray[153] = "plus";
        stringArray[154] = "plus";
        stringArray[155] = "plus";
        stringArray[156] = "plus";
        stringArray[157] = "plus";
        stringArray[158] = "plus";
        stringArray[159] = "plus";
        stringArray[160] = "plus";
        stringArray[161] = "plus";
        stringArray[162] = "plus";
        stringArray[163] = "plus";
        stringArray[164] = "plus";
        stringArray[165] = "plus";
        stringArray[166] = "plus";
        stringArray[167] = "execute";
        stringArray[168] = "id";
        stringArray[169] = "geom";
        stringArray[170] = "type";
        stringArray[171] = "getNbLV";
        stringArray[172] = "getNbLV";
        stringArray[173] = "getNbLV";
        stringArray[174] = "getNbHV";
        stringArray[175] = "getNbHV";
        stringArray[176] = "getNbHV";
        stringArray[177] = "getAt";
        stringArray[178] = "speed";
        stringArray[179] = "category";
        stringArray[180] = "getAt";
        stringArray[181] = "speed";
        stringArray[182] = "category";
        stringArray[183] = "getAt";
        stringArray[184] = "speed";
        stringArray[185] = "category";
        stringArray[186] = "min";
        stringArray[187] = "getAt";
        stringArray[188] = "speed";
        stringArray[189] = "category";
        stringArray[190] = "min";
        stringArray[191] = "getAt";
        stringArray[192] = "speed";
        stringArray[193] = "category";
        stringArray[194] = "min";
        stringArray[195] = "getAt";
        stringArray[196] = "speed";
        stringArray[197] = "category";
        stringArray[198] = "execute";
        stringArray[199] = "plus";
        stringArray[200] = "plus";
        stringArray[201] = "execute";
        stringArray[202] = "execute";
        stringArray[203] = "iterator";
        stringArray[204] = "grounds";
        stringArray[205] = "priority";
        stringArray[206] = "isEmpty";
        stringArray[207] = "geom";
        stringArray[208] = "execute";
        stringArray[209] = "plus";
        stringArray[210] = "plus";
        stringArray[211] = "plus";
        stringArray[212] = "plus";
        stringArray[213] = "plus";
        stringArray[214] = "plus";
        stringArray[215] = "plus";
        stringArray[216] = "plus";
        stringArray[217] = "plus";
        stringArray[218] = "plus";
        stringArray[219] = "id";
        stringArray[220] = "geom";
        stringArray[221] = "priority";
        stringArray[222] = "coeff_G";
        stringArray[223] = "execute";
        stringArray[224] = "plus";
        stringArray[225] = "plus";
        stringArray[226] = "info";
        stringArray[227] = "plus";
        stringArray[228] = "nb_nodes";
        stringArray[229] = "plus";
        stringArray[230] = "plus";
        stringArray[231] = "plus";
        stringArray[232] = "nb_ways";
        stringArray[233] = "plus";
        stringArray[234] = "plus";
        stringArray[235] = "plus";
        stringArray[236] = "nb_relations";
        stringArray[237] = "plus";
        stringArray[238] = "plus";
        stringArray[239] = "plus";
        stringArray[240] = "nb_buildings";
        stringArray[241] = "plus";
        stringArray[242] = "plus";
        stringArray[243] = "plus";
        stringArray[244] = "nb_roads";
        stringArray[245] = "plus";
        stringArray[246] = "plus";
        stringArray[247] = "plus";
        stringArray[248] = "nb_grounds";
        stringArray[249] = "plus";
        stringArray[250] = "info";
        stringArray[251] = "info";
        stringArray[252] = "plus";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[253];
        Import_OSM.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Import_OSM.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Import_OSM.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

