/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.wps.NoiseModelling;

import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.sql.Sql;
import groovy.transform.Generated;
import java.io.File;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.h2gis.utilities.wrapper.ConnectionWrapper;
import org.noise_planet.noisemodelling.jdbc.NoiseMapByReceiverMaker;
import org.noise_planet.noisemodelling.jdbc.NoiseMapDatabaseParameters;
import org.noise_planet.noisemodelling.jdbc.input.DefaultTableLoader;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.RootProgressVisitor;
import org.noise_planet.noisemodelling.propagation.AttenuationParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Noise_level_from_source
extends Script {
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Noise_level_from_source() {
        CallSite[] callSiteArray = Noise_level_from_source.$getCallSiteArray();
    }

    public Noise_level_from_source(Binding context) {
        CallSite[] callSiteArray = Noise_level_from_source.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = Noise_level_from_source.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, Noise_level_from_source.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = Noise_level_from_source.$getCallSiteArray();
        String string = "Computes the propagation from the sounds sources to the receivers";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, Noise_level_from_source.class, (GroovyObject)this, (String)"title");
        Object object = callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call((Object)"&#10145;&#65039; Computes the propagation from the sounds sources to the receivers location using the noise emission table.", (Object)"<hr>"), (Object)"&#127757; Tables must be projected in a metric coordinate system (SRID). Use \"Change_SRID\" WPS Block if needed. </br></br>"), (Object)"&#x2705; The output table are called: <b> RECEIVERS_LEVEL </b> </br></br>"), (Object)"The output table contain: </br> <ul>"), (Object)"<li><b> IDRECEIVER</b>: receiver an identifier (INTEGER) linked to RECEIVERS table primary key</li>"), (Object)"<li><b> IDSOURCE</b>: source identifier (INTEGER) linked to SOURCES_GEOM primary key. Only if Keep source id is checked.</li>"), (Object)"<li><b> PERIOD </b>: Time period (VARCHAR) ex. L D E and DEN. Only if you provide emission power to sources or the atmospheric settings table.</li>"), (Object)"<li><b> THE_GEOM </b>: the 3D geometry of the receivers with the Z as the altitude (POINTZ)</li>"), (Object)"<li><b> Hz63, Hz125, Hz250, Hz500, Hz1000,Hz2000, Hz4000, Hz8000 </b>: 8 columns giving the sound level for each octave band (FLOAT)</li></ul>");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Noise_level_from_source.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"tableBuilding", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Buildings table name", "title", "Buildings table name", "description", callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call(callSiteArray[15].call((Object)"&#127968; Name of the Buildings table</br> </br>", (Object)"The table must contain: </br><ul>"), (Object)"<li><b> THE_GEOM </b>: the 2D geometry of the building (POLYGON or MULTIPOLYGON)</li>"), (Object)"<li><b> HEIGHT </b>: the height of the building (FLOAT)</li>"), (Object)"<li><b> G </b>: Optional, Wall absorption value if g is [0, 1] or wall surface impedance"), (Object)" ([N.s.m-4] static air flow resistivity of material) if G is [20, 20000]"), (Object)" (default is 0.1 if the column G does not exists) (FLOAT)</li></ul>"), "type", String.class}), "tableSources", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Sources geometry table name", "title", "Sources geometry table name", "description", callSiteArray[16].call(callSiteArray[17].call(callSiteArray[18].call(callSiteArray[19].call(callSiteArray[20].call(callSiteArray[21].call(callSiteArray[22].call(callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].call(callSiteArray[26].call((Object)"Name of the Sources table (if only geometry is specified) </br> </br>", (Object)"The table must contain (* mandatory): </br> <ul>"), (Object)"<li> <b> PK *</b> : an identifier. It shall be a primary key (INTEGER, PRIMARY KEY) </li> "), (Object)"<li> <b> THE_GEOM *</b> : the 3D geometry of the sources (POINT, MULTIPOINT, LINESTRING, MULTILINESTRING). According to CNOSSOS-EU, you need to set a height of 0.05 m for a road traffic emission </li> "), (Object)"<li> <b> LWD63, LWD125, LWD250, LWD500, LWD1000, LWD2000, LWD4000, LWD8000 </b> : 8 columns giving the day emission sound level for each octave band (FLOAT) </li> "), (Object)"<li> <b> LWE </b> : 8 columns giving the evening emission sound level for each octave band (FLOAT) </li> "), (Object)"<li> <b> LWN </b> : 8 columns giving the night emission sound level for each octave band (FLOAT) </li> "), (Object)"<li> <b> YAW </b> : Source horizontal orientation in degrees. For points 0&#176; North, 90&#176; East. For lines 0&#176; line direction, 90&#176; right of the line direction.  (FLOAT) </li> "), (Object)"<li> <b> PITCH </b> : Source vertical orientation in degrees. 0&#176; front, 90&#176; top, -90&#176; bottom. (FLOAT) </li> "), (Object)"<li> <b> ROLL </b> : Source roll in degrees (FLOAT) </li> "), (Object)"<li> <b> DIR_ID </b> : identifier of the directivity sphere from tableSourceDirectivity parameter or train directivity if not provided -> OMNIDIRECTIONAL(0), ROLLING(1), TRACTIONA(2), TRACTIONB(3), AERODYNAMICA(4), AERODYNAMICB(5), BRIDGE(6) (INTEGER) </li> </ul> "), (Object)"&#128161; This table can be generated from the WPS Block \"Road_Emission_from_Traffic\""), "type", String.class}), "tableSourcesEmission", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Sources emission table name", "title", "Sources emission table name", "description", callSiteArray[27].call(callSiteArray[28].call(callSiteArray[29].call(callSiteArray[30].call((Object)"Name of the Sources table (ex. SOURCES_EMISSION) </br> </br>", (Object)"The table must contain: </br> <ul>"), (Object)"<li><b> IDSOURCE </b>* : an identifier. It shall be linked to the primary key of tableRoads (INTEGER)</li>"), (Object)"<li><b> PERIOD </b>* : Time period, you will find this column on the output (VARCHAR)</li>"), (Object)"<li> <b> LW63, LW125, LW250, LW500, LW1000, LW2000, LW4000, LW8000 </b> : Emission noise level in dB can be third-octave 50Hz to 10000Hz (FLOAT) </li> "), "min", 0, "max", 1, "type", String.class}), "tableReceivers", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Receivers table name", "title", "Receivers table name", "description", callSiteArray[31].call(callSiteArray[32].call(callSiteArray[33].call(callSiteArray[34].call((Object)"Name of the Receivers table </br> </br>", (Object)"The table must contain: </br> <ul>"), (Object)"<li> <b> PK </b> : an identifier. It shall be a primary key (INTEGER, PRIMARY KEY) </li> "), (Object)"<li> <b> THE_GEOM </b> : the 3D geometry of the sources (POINT, MULTIPOINT) </li> </ul>"), (Object)"&#128161; This table can be generated from the WPS Blocks in the \"Receivers\" folder"), "type", String.class}), "tableDEM", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "DEM table name", "title", "DEM table name", "description", callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].call((Object)"Name of the Digital Elevation Model (DEM) table </br> </br>", (Object)"The table must contain: </br> <ul>"), (Object)"<li> <b> THE_GEOM </b> : the 3D geometry of the sources (POINT, MULTIPOINT) </li> </ul>"), (Object)"&#128161; This table can be generated from the WPS Block \"Import_Asc_File\""), "min", 0, "max", 1, "type", String.class}), "tableGroundAbs", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Ground absorption table name", "title", "Ground absorption table name", "description", callSiteArray[38].call(callSiteArray[39].call(callSiteArray[40].call((Object)"Name of the surface/ground acoustic absorption table </br> </br>", (Object)"The table must contain: </br> <ul>"), (Object)"<li> <b> THE_GEOM </b>: the 2D geometry of the sources (POLYGON or MULTIPOLYGON) </li>"), (Object)"<li> <b> G </b>: the acoustic absorption of a ground (FLOAT between 0 : very hard and 1 : very soft) </li> </ul> "), "min", 0, "max", 1, "type", String.class}), "tableSourceDirectivity", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Source directivity table name", "title", "Source directivity table name", "description", callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].call((Object)"Name of the emission directivity table </br> </br>", (Object)"If not specified the default is train directivity of CNOSSOS-EU</b> </br> </br>"), (Object)"The table must contain the following columns: </br> <ul>"), (Object)"<li> <b> DIR_ID </b>: identifier of the directivity sphere (INTEGER) </li> "), (Object)"<li> <b> THETA </b>: [-90;90] Vertical angle in degree. 0&#176; front 90&#176; top -90&#176; bottom (FLOAT) </li> "), (Object)"<li> <b> PHI </b>: [0;360] Horizontal angle in degree. 0&#176; front 90&#176; right (FLOAT) </li> "), (Object)"<li> <b> LW63, LW125, LW250, LW500, LW1000, LW2000, LW4000, LW8000 </b>: attenuation levels in dB for each octave or third octave (FLOAT) </li> </ul> "), "min", 0, "max", 1, "type", String.class}), "tablePeriodAtmosphericSettings", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Atmospheric settings table name for each time period", "title", "Atmospheric settings table name for each time period", "description", callSiteArray[47].call(callSiteArray[48].call(callSiteArray[49].call(callSiteArray[50].call(callSiteArray[51].call(callSiteArray[52].call(callSiteArray[53].call(callSiteArray[54].call(callSiteArray[55].call((Object)"Name of the Atmospheric settings table </br> </br>", (Object)"The table must contain the following columns: </br> <ul>"), (Object)"<li> <b> PERIOD </b>: time period (VARCHAR PRIMARY KEY) </li> "), (Object)"<li> <b> WINDROSE </b>: probability of occurrences of favourable propagation conditions (ARRAY(16)) </li> "), (Object)"<li> <b> TEMPERATURE </b>: Temperature in celsius (FLOAT) </li> "), (Object)"<li> <b> PRESSURE </b>: air pressure in pascal (FLOAT) </li> "), (Object)"<li> <b> HUMIDITY </b>: air humidity in percentage (FLOAT) </li> "), (Object)"<li> <b> GDISC </b>: choose between accept G discontinuity or not (BOOLEAN) default true </li> "), (Object)"<li> <b> PRIME2520 </b>: choose to use prime values to compute eq. 2.5.20 (BOOLEAN) default false </li> "), (Object)"</ul>"), "min", 0, "max", 1, "type", String.class}), "paramWallAlpha", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "wallAlpha", "title", "Wall absorption coefficient", "description", callSiteArray[56].call(callSiteArray[57].call(callSiteArray[58].call(callSiteArray[59].call((Object)"Wall absorption coefficient (FLOAT) </br> </br>", (Object)"This coefficient is going <br> <ul>"), (Object)"<li> from 0 : fully absorbent </li>"), (Object)"<li> to strictly less than 1 : fully reflective. </li> </ul>"), (Object)"&#128736; Default value: <b>0.1 </b> "), "min", 0, "max", 1, "type", String.class}), "confReflOrder", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Order of reflexion", "title", "Order of reflexion", "description", callSiteArray[60].call(callSiteArray[61].call((Object)"Maximum number of reflections to be taken into account (INTEGER). </br> </br>", (Object)"&#x1F6A8; Adding 1 order of reflexion can significantly increase the processing time. </br> </br>"), (Object)"&#128736; Default value: <b>1 </b>"), "min", 0, "max", 1, "type", String.class}), "confMaxSrcDist", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Maximum source-receiver distance", "title", "Maximum source-receiver distance", "description", callSiteArray[62].call((Object)"Maximum distance between source and receiver (FLOAT, in meters). </br> </br>", (Object)"&#128736; Default value: <b>150 </b>"), "min", 0, "max", 1, "type", String.class}), "confMaxReflDist", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Maximum source-reflexion distance", "title", "Maximum source-reflexion distance", "description", callSiteArray[63].call((Object)"Maximum reflection distance from the source (FLOAT, in meters). </br> </br>", (Object)"&#128736; Default value: <b>50 </b>"), "min", 0, "max", 1, "type", String.class}), "confThreadNumber", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Thread number", "title", "Thread number", "description", callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].call((Object)"Number of thread to use on the computer (INTEGER). </br> </br>", (Object)"To set this value, look at the number of cores you have. </br>"), (Object)"If it is set to 0, use the maximum number of cores available.</br> </br>"), (Object)"&#128736; Default value: <b>0 </b>"), "min", 0, "max", 1, "type", String.class}), "confDiffVertical", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Diffraction on vertical edges", "title", "Diffraction on vertical edges", "description", callSiteArray[67].call((Object)"Compute or not the diffraction on vertical edges. Following Directive 2015/996, enable this option for rail and industrial sources only. </br> </br>", (Object)"&#128736; Default value: <b>false </b>"), "min", 0, "max", 1, "type", Boolean.class}), "confDiffHorizontal", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Diffraction on horizontal edges", "title", "Diffraction on horizontal edges", "description", callSiteArray[68].call((Object)"Compute or not the diffraction on horizontal edges. </br> </br>", (Object)"&#128736; Default value: <b>false </b>"), "min", 0, "max", 1, "type", Boolean.class}), "confExportSourceId", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Keep source id", "title", "Separate receiver level by source identifier", "description", callSiteArray[69].call((Object)"Keep source identifier in output in order to get noise contribution of each noise source. </br> </br>", (Object)"&#128736; Default value: <b>false </b>"), "min", 0, "max", 1, "type", Boolean.class}), "confHumidity", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Relative humidity", "title", "Relative humidity", "description", callSiteArray[70].call((Object)"&#127783; Humidity for noise propagation. </br> </br>", (Object)"&#128736; Default value: <b>70</b>"), "min", 0, "max", 1, "type", Double.class}), "confTemperature", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Temperature", "title", "Air temperature", "description", callSiteArray[71].call((Object)"&#127777; Air temperature in degree celsius </br> </br>", (Object)"&#128736; Default value: <b> 15</b>"), "min", 0, "max", 1, "type", Double.class}), "confFavorableOccurrencesDefault", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Probability of occurrences", "title", "Probability of occurrences", "description", callSiteArray[72].call(callSiteArray[73].call(callSiteArray[74].call(callSiteArray[75].call(callSiteArray[76].call((Object)"Comma-delimited string containing the default probability of occurrences of favourable propagation conditions. </br> </br>", (Object)"The north slice is the last array index not the first one <br/>"), (Object)"Slice width are 22.5&#176;: (16 slices)</br> <ul>"), (Object)"<li>The first column 22.5&#176; contain occurrences between 11.25 to 33.75 &#176; </li>"), (Object)"<li>The last column 360&#176; contains occurrences between 348.75&#176; to 360&#176; and 0 to 11.25&#176; </li> </ul>"), (Object)"&#128736; Default value: <b>0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5</b>"), "min", 0, "max", 1, "type", String.class}), "confRaysName", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "", "title", "Export scene", "description", callSiteArray[77].call(callSiteArray[78].call(callSiteArray[79].call((Object)"Save each mnt, buildings and propagation rays into the specified table (ex:RAYS) or file URL (ex: file:///Z:/dir/map.kml) </br> </br>", (Object)"You can set a table name here in order to save all the rays computed by NoiseModelling. </br> </br>"), (Object)"The number of rays has been limited in this script in order to avoid memory exception. </br> </br>"), (Object)"&#128736; Default value: <b>empty (do not keep rays)</b>"), "min", 0, "max", 1, "type", String.class}), "confMaxError", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Max Error (dB)", "title", "Max Error (dB)", "description", "Threshold for excluding negligible sound sources in calculations. Default value: <b>0.1</b>", "min", 0, "max", 1, "type", Double.class}), "frequencyFieldPrepend", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Frequency field name", "title", "Frequency field name", "description", callSiteArray[80].call((Object)"Frequency field name prepend. Ex. for 1000 Hz frequency the default column name is HZ1000.", (Object)"&#128736; Default value: <b>HZ</b>"), "min", 0, "max", 1, "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, Noise_level_from_source.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "This type of result does not allow the blocks to be linked together.", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, Noise_level_from_source.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = Noise_level_from_source.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[81].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[82].call(callSiteArray[83].call(callSiteArray[84].callGroovyObjectGetProperty(callSiteArray[85].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].call(callSiteArray[87].callGroovyObjectGetProperty(callSiteArray[88].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[89].call(callSiteArray[90].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].call(callSiteArray[92].call((Object)jdbcDataStore)), Connection.class);
    }

    public Object run(Object input) {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure1(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = Noise_level_from_source.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[93].call(callSiteArray[94].callStatic(Noise_level_from_source.class, (Object)dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
        }
        return callSiteArray[95].call((Object)Noise_level_from_source.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
    }

    public Object exec(Connection connection, Map input) {
        CallSite[] callSiteArray = Noise_level_from_source.$getCallSiteArray();
        long startCompute = DefaultTypeTransformation.longUnbox((Object)callSiteArray[96].call(System.class));
        int maximumRaysToExport = 5000;
        DBTypes dbType = (DBTypes)ShortTypeHandling.castToEnum((Object)callSiteArray[97].call(DBUtils.class, callSiteArray[98].call((Object)connection, Connection.class)), DBTypes.class);
        connection = (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[99].callConstructor(ConnectionWrapper.class, (Object)connection), Connection.class);
        Sql sql = (Sql)ScriptBytecodeAdapter.castToType((Object)callSiteArray[100].callConstructor(Sql.class, (Object)connection), Sql.class);
        Logger logger = (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[101].call(LoggerFactory.class, (Object)"org.noise_planet.noisemodelling"), Logger.class);
        callSiteArray[102].call((Object)logger, (Object)"Start : Level from Emission");
        callSiteArray[103].call((Object)logger, (Object)"inputs {}", (Object)input);
        String sources_table_name = ShortTypeHandling.castToString((Object)callSiteArray[104].call((Object)input, (Object)"tableSources"));
        sources_table_name = ShortTypeHandling.castToString((Object)callSiteArray[105].call((Object)sources_table_name));
        int sridSources = DefaultTypeTransformation.intUnbox((Object)callSiteArray[106].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[107].call(TableLocation.class, (Object)sources_table_name)));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (sridSources == 3785 || sridSources == 4326) {
                throw (Throwable)callSiteArray[108].callConstructor(IllegalArgumentException.class, callSiteArray[109].call(callSiteArray[110].call((Object)"Error : Please use a metric projection for ", (Object)sources_table_name), (Object)"."));
            }
        } else if (sridSources == 3785 || sridSources == 4326) {
            throw (Throwable)callSiteArray[111].callConstructor(IllegalArgumentException.class, callSiteArray[112].call(callSiteArray[113].call((Object)"Error : Please use a metric projection for ", (Object)sources_table_name), (Object)"."));
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (sridSources == 0) {
                throw (Throwable)callSiteArray[114].callConstructor(IllegalArgumentException.class, callSiteArray[115].call(callSiteArray[116].call((Object)"Error : The table ", (Object)sources_table_name), (Object)" does not have an associated SRID."));
            }
        } else if (sridSources == 0) {
            throw (Throwable)callSiteArray[117].callConstructor(IllegalArgumentException.class, callSiteArray[118].call(callSiteArray[119].call((Object)"Error : The table ", (Object)sources_table_name), (Object)" does not have an associated SRID."));
        }
        TableLocation sourceTableIdentifier = (TableLocation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[120].call(TableLocation.class, (Object)sources_table_name), TableLocation.class);
        List geomFields = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[121].call(GeometryTableUtilities.class, (Object)connection, (Object)sourceTableIdentifier), List.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[122].call((Object)geomFields))) {
            throw (Throwable)callSiteArray[123].callConstructor(SQLException.class, callSiteArray[124].call(String.class, (Object)"The table %s does not exists or does not contain a geometry field", (Object)sourceTableIdentifier));
        }
        int pkIndex = DefaultTypeTransformation.intUnbox((Object)callSiteArray[125].call(JDBCUtilities.class, (Object)connection, callSiteArray[126].call(TableLocation.class, (Object)sources_table_name)));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (pkIndex < 1) {
                throw (Throwable)callSiteArray[127].callConstructor(IllegalArgumentException.class, callSiteArray[128].call(String.class, (Object)"Source table %s does not contain a primary key", (Object)sourceTableIdentifier));
            }
        } else if (pkIndex < 1) {
            throw (Throwable)callSiteArray[129].callConstructor(IllegalArgumentException.class, callSiteArray[130].call(String.class, (Object)"Source table %s does not contain a primary key", (Object)sourceTableIdentifier));
        }
        String receivers_table_name = ShortTypeHandling.castToString((Object)callSiteArray[131].call((Object)input, (Object)"tableReceivers"));
        receivers_table_name = ShortTypeHandling.castToString((Object)callSiteArray[132].call((Object)receivers_table_name));
        TableLocation receiverTableIdentifier = (TableLocation)ScriptBytecodeAdapter.castToType((Object)callSiteArray[133].call(TableLocation.class, (Object)receivers_table_name), TableLocation.class);
        List geomFieldsRcv = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[134].call(GeometryTableUtilities.class, (Object)connection, (Object)receiverTableIdentifier), List.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[135].call((Object)geomFieldsRcv))) {
            throw (Throwable)callSiteArray[136].callConstructor(SQLException.class, callSiteArray[137].call(String.class, (Object)"The table %s does not exists or does not contain a geometry field", (Object)receiverTableIdentifier));
        }
        int sridReceivers = DefaultTypeTransformation.intUnbox((Object)callSiteArray[138].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[139].call(TableLocation.class, (Object)receivers_table_name)));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (sridReceivers == 3785 || sridReceivers == 4326) {
                throw (Throwable)callSiteArray[140].callConstructor(IllegalArgumentException.class, callSiteArray[141].call(callSiteArray[142].call((Object)"Error : Please use a metric projection for ", (Object)receivers_table_name), (Object)"."));
            }
        } else if (sridReceivers == 3785 || sridReceivers == 4326) {
            throw (Throwable)callSiteArray[143].callConstructor(IllegalArgumentException.class, callSiteArray[144].call(callSiteArray[145].call((Object)"Error : Please use a metric projection for ", (Object)receivers_table_name), (Object)"."));
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (sridReceivers == 0) {
                throw (Throwable)callSiteArray[146].callConstructor(IllegalArgumentException.class, callSiteArray[147].call(callSiteArray[148].call((Object)"Error : The table ", (Object)receivers_table_name), (Object)" does not have an associated SRID."));
            }
        } else if (sridReceivers == 0) {
            throw (Throwable)callSiteArray[149].callConstructor(IllegalArgumentException.class, callSiteArray[150].call(callSiteArray[151].call((Object)"Error : The table ", (Object)receivers_table_name), (Object)" does not have an associated SRID."));
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (sridReceivers != sridSources) {
                throw (Throwable)callSiteArray[152].callConstructor(IllegalArgumentException.class, callSiteArray[153].call(callSiteArray[154].call(callSiteArray[155].call(callSiteArray[156].call((Object)"Error : The SRID of table ", (Object)sources_table_name), (Object)" and "), (Object)receivers_table_name), (Object)" are not the same."));
            }
        } else if (sridReceivers != sridSources) {
            throw (Throwable)callSiteArray[157].callConstructor(IllegalArgumentException.class, callSiteArray[158].call(callSiteArray[159].call(callSiteArray[160].call(callSiteArray[161].call((Object)"Error : The SRID of table ", (Object)sources_table_name), (Object)" and "), (Object)receivers_table_name), (Object)" are not the same."));
        }
        int pkIndexRecv = DefaultTypeTransformation.intUnbox((Object)callSiteArray[162].call(JDBCUtilities.class, (Object)connection, callSiteArray[163].call(TableLocation.class, (Object)receivers_table_name)));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (pkIndexRecv < 1) {
                throw (Throwable)callSiteArray[164].callConstructor(IllegalArgumentException.class, callSiteArray[165].call(String.class, (Object)"Source table %s does not contain a primary key", (Object)receiverTableIdentifier));
            }
        } else if (pkIndexRecv < 1) {
            throw (Throwable)callSiteArray[166].callConstructor(IllegalArgumentException.class, callSiteArray[167].call(String.class, (Object)"Source table %s does not contain a primary key", (Object)receiverTableIdentifier));
        }
        String building_table_name = ShortTypeHandling.castToString((Object)callSiteArray[168].call((Object)input, (Object)"tableBuilding"));
        building_table_name = ShortTypeHandling.castToString((Object)callSiteArray[169].call((Object)building_table_name));
        int sridBuildings = DefaultTypeTransformation.intUnbox((Object)callSiteArray[170].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[171].call(TableLocation.class, (Object)building_table_name)));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (sridBuildings == 3785 || sridReceivers == 4326) {
                throw (Throwable)callSiteArray[172].callConstructor(IllegalArgumentException.class, callSiteArray[173].call(callSiteArray[174].call((Object)"Error : Please use a metric projection for ", (Object)building_table_name), (Object)"."));
            }
        } else if (sridBuildings == 3785 || sridReceivers == 4326) {
            throw (Throwable)callSiteArray[175].callConstructor(IllegalArgumentException.class, callSiteArray[176].call(callSiteArray[177].call((Object)"Error : Please use a metric projection for ", (Object)building_table_name), (Object)"."));
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (sridBuildings == 0) {
                throw (Throwable)callSiteArray[178].callConstructor(IllegalArgumentException.class, callSiteArray[179].call(callSiteArray[180].call((Object)"Error : The table ", (Object)building_table_name), (Object)" does not have an associated SRID."));
            }
        } else if (sridBuildings == 0) {
            throw (Throwable)callSiteArray[181].callConstructor(IllegalArgumentException.class, callSiteArray[182].call(callSiteArray[183].call((Object)"Error : The table ", (Object)building_table_name), (Object)" does not have an associated SRID."));
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (sridReceivers != sridBuildings) {
                throw (Throwable)callSiteArray[184].callConstructor(IllegalArgumentException.class, callSiteArray[185].call(callSiteArray[186].call(callSiteArray[187].call(callSiteArray[188].call((Object)"Error : The SRID of table ", (Object)building_table_name), (Object)" and "), (Object)receivers_table_name), (Object)" are not the same."));
            }
        } else if (sridReceivers != sridBuildings) {
            throw (Throwable)callSiteArray[189].callConstructor(IllegalArgumentException.class, callSiteArray[190].call(callSiteArray[191].call(callSiteArray[192].call(callSiteArray[193].call((Object)"Error : The SRID of table ", (Object)building_table_name), (Object)" and "), (Object)receivers_table_name), (Object)" are not the same."));
        }
        String dem_table_name = "";
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[194].call((Object)input, (Object)"tableDEM"))) {
            dem_table_name = ShortTypeHandling.castToString((Object)callSiteArray[195].call((Object)input, (Object)"tableDEM"));
            dem_table_name = ShortTypeHandling.castToString((Object)callSiteArray[196].call((Object)dem_table_name));
            int sridDEM = DefaultTypeTransformation.intUnbox((Object)callSiteArray[197].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[198].call(TableLocation.class, (Object)dem_table_name)));
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (sridDEM == 3785 || sridReceivers == 4326) {
                    throw (Throwable)callSiteArray[199].callConstructor(IllegalArgumentException.class, callSiteArray[200].call(callSiteArray[201].call((Object)"Error : Please use a metric projection for ", (Object)dem_table_name), (Object)"."));
                }
            } else if (sridDEM == 3785 || sridReceivers == 4326) {
                throw (Throwable)callSiteArray[202].callConstructor(IllegalArgumentException.class, callSiteArray[203].call(callSiteArray[204].call((Object)"Error : Please use a metric projection for ", (Object)dem_table_name), (Object)"."));
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (sridDEM == 0) {
                    throw (Throwable)callSiteArray[205].callConstructor(IllegalArgumentException.class, callSiteArray[206].call(callSiteArray[207].call((Object)"Error : The table ", (Object)dem_table_name), (Object)" does not have an associated SRID."));
                }
            } else if (sridDEM == 0) {
                throw (Throwable)callSiteArray[208].callConstructor(IllegalArgumentException.class, callSiteArray[209].call(callSiteArray[210].call((Object)"Error : The table ", (Object)dem_table_name), (Object)" does not have an associated SRID."));
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (sridDEM != sridSources) {
                    throw (Throwable)callSiteArray[211].callConstructor(IllegalArgumentException.class, callSiteArray[212].call(callSiteArray[213].call(callSiteArray[214].call(callSiteArray[215].call((Object)"Error : The SRID of table ", (Object)sources_table_name), (Object)" and "), (Object)dem_table_name), (Object)" are not the same."));
                }
            } else if (sridDEM != sridSources) {
                throw (Throwable)callSiteArray[216].callConstructor(IllegalArgumentException.class, callSiteArray[217].call(callSiteArray[218].call(callSiteArray[219].call(callSiteArray[220].call((Object)"Error : The SRID of table ", (Object)sources_table_name), (Object)" and "), (Object)dem_table_name), (Object)" are not the same."));
            }
        }
        String ground_table_name = "";
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[221].call((Object)input, (Object)"tableGroundAbs"))) {
            ground_table_name = ShortTypeHandling.castToString((Object)callSiteArray[222].call((Object)input, (Object)"tableGroundAbs"));
            ground_table_name = ShortTypeHandling.castToString((Object)callSiteArray[223].call((Object)ground_table_name));
            int sridGROUND = DefaultTypeTransformation.intUnbox((Object)callSiteArray[224].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[225].call(TableLocation.class, (Object)ground_table_name)));
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (sridGROUND == 3785 || sridReceivers == 4326) {
                    throw (Throwable)callSiteArray[226].callConstructor(IllegalArgumentException.class, callSiteArray[227].call(callSiteArray[228].call((Object)"Error : Please use a metric projection for ", (Object)ground_table_name), (Object)"."));
                }
            } else if (sridGROUND == 3785 || sridReceivers == 4326) {
                throw (Throwable)callSiteArray[229].callConstructor(IllegalArgumentException.class, callSiteArray[230].call(callSiteArray[231].call((Object)"Error : Please use a metric projection for ", (Object)ground_table_name), (Object)"."));
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (sridGROUND == 0) {
                    throw (Throwable)callSiteArray[232].callConstructor(IllegalArgumentException.class, callSiteArray[233].call(callSiteArray[234].call((Object)"Error : The table ", (Object)ground_table_name), (Object)" does not have an associated SRID."));
                }
            } else if (sridGROUND == 0) {
                throw (Throwable)callSiteArray[235].callConstructor(IllegalArgumentException.class, callSiteArray[236].call(callSiteArray[237].call((Object)"Error : The table ", (Object)ground_table_name), (Object)" does not have an associated SRID."));
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (sridGROUND != sridSources) {
                    throw (Throwable)callSiteArray[238].callConstructor(IllegalArgumentException.class, callSiteArray[239].call(callSiteArray[240].call(callSiteArray[241].call(callSiteArray[242].call((Object)"Error : The SRID of table ", (Object)ground_table_name), (Object)" and "), (Object)sources_table_name), (Object)" are not the same."));
                }
            } else if (sridGROUND != sridSources) {
                throw (Throwable)callSiteArray[243].callConstructor(IllegalArgumentException.class, callSiteArray[244].call(callSiteArray[245].call(callSiteArray[246].call(callSiteArray[247].call((Object)"Error : The SRID of table ", (Object)ground_table_name), (Object)" and "), (Object)sources_table_name), (Object)" are not the same."));
            }
        }
        String tableSourceDirectivity = "";
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[248].call((Object)input, (Object)"tableSourceDirectivity"))) {
            tableSourceDirectivity = ShortTypeHandling.castToString((Object)callSiteArray[249].call((Object)input, (Object)"tableSourceDirectivity"));
            tableSourceDirectivity = ShortTypeHandling.castToString((Object)callSiteArray[250].call((Object)tableSourceDirectivity));
        }
        boolean recordProfile = false;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[251].call((Object)input, (Object)"confRecordProfile"))) {
            recordProfile = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[252].call((Object)input, (Object)"confRecordProfile"));
        }
        int reflexion_order = 0;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[253].call((Object)input, (Object)"confReflOrder"))) {
            reflexion_order = DefaultTypeTransformation.intUnbox((Object)callSiteArray[254].call(Integer.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[255].call((Object)input, (Object)"confReflOrder"), String.class)), String.class)));
        }
        double max_src_dist = 150;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[256].call((Object)input, (Object)"confMaxSrcDist"))) {
            max_src_dist = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[257].call(Double.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[258].call((Object)input, (Object)"confMaxSrcDist"), String.class)), String.class)));
        }
        double max_ref_dist = 50;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[259].call((Object)input, (Object)"confMaxReflDist"))) {
            max_ref_dist = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[260].call(Double.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[261].call((Object)input, (Object)"confMaxReflDist"), String.class)), String.class)));
        }
        double wall_alpha = DefaultTypeTransformation.doubleUnbox((Object)$const$0);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[262].call((Object)input, (Object)"paramWallAlpha"))) {
            wall_alpha = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[263].call(Double.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[264].call((Object)input, (Object)"paramWallAlpha"), String.class)), String.class)));
        }
        int n_thread = 0;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[265].call((Object)input, (Object)"confThreadNumber"))) {
            n_thread = DefaultTypeTransformation.intUnbox((Object)callSiteArray[266].call(Integer.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[267].call((Object)input, (Object)"confThreadNumber"), String.class)), String.class)));
        }
        boolean compute_vertical_diffraction = false;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[268].call((Object)input, (Object)"confDiffVertical"))) {
            compute_vertical_diffraction = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[269].call((Object)input, (Object)"confDiffVertical"));
        }
        boolean compute_horizontal_diffraction = false;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[270].call((Object)input, (Object)"confDiffHorizontal"))) {
            compute_horizontal_diffraction = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[271].call((Object)input, (Object)"confDiffHorizontal"));
        }
        boolean confExportSourceId = false;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[272].call((Object)input, (Object)"confExportSourceId"))) {
            confExportSourceId = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[273].call((Object)input, (Object)"confExportSourceId"));
        }
        double confMaxError = DefaultTypeTransformation.doubleUnbox((Object)$const$0);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[274].call((Object)input, (Object)"confMaxError"))) {
            confMaxError = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[275].call(Double.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[276].call((Object)input, (Object)"confMaxError"), String.class)), String.class)));
        }
        String frequencyFieldPrepend = "HZ";
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[277].call((Object)input, (Object)"frequencyFieldPrepend"))) {
            frequencyFieldPrepend = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[278].call((Object)input, (Object)"frequencyFieldPrepend"), String.class);
        }
        NoiseMapByReceiverMaker pointNoiseMap = (NoiseMapByReceiverMaker)ScriptBytecodeAdapter.castToType((Object)callSiteArray[279].callConstructor(NoiseMapByReceiverMaker.class, (Object)building_table_name, (Object)sources_table_name, (Object)receivers_table_name), NoiseMapByReceiverMaker.class);
        Object parameters = callSiteArray[280].call((Object)pointNoiseMap);
        callSiteArray[281].call(parameters, (Object)(!confExportSourceId ? 1 : 0));
        boolean bl = true;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)parameters, (String)"exportReceiverPosition");
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[282].call((Object)input, (Object)"tableSourcesEmission"))) {
            String tableSourcesEmission = ShortTypeHandling.castToString((Object)callSiteArray[283].call(TableLocation.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[284].call((Object)input, (Object)"tableSourcesEmission"), String.class)), String.class), (Object)dbType));
            callSiteArray[285].call((Object)pointNoiseMap, (Object)tableSourcesEmission);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[286].call((Object)tableSourceDirectivity))) {
            callSiteArray[287].call(callSiteArray[288].callGetProperty((Object)pointNoiseMap), (Object)true);
        } else {
            callSiteArray[289].call(callSiteArray[290].callGetProperty((Object)pointNoiseMap), (Object)tableSourceDirectivity);
            callSiteArray[291].call((Object)logger, callSiteArray[292].call(String.class, callSiteArray[293].callGetProperty(Locale.class), (Object)"Loaded directivity from %s table", (Object)tableSourceDirectivity));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[294].call((Object)input, (Object)"tableSourceEmission"))) {
            String tableSourceEmission = ShortTypeHandling.castToString((Object)callSiteArray[295].call(TableLocation.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[296].call((Object)input, (Object)"tableSourceEmission"), String.class)), String.class), (Object)dbType));
            callSiteArray[297].call((Object)pointNoiseMap, (Object)tableSourceEmission);
        }
        callSiteArray[298].call((Object)sql, callSiteArray[299].call((Object)"drop table if exists ", callSiteArray[300].call(TableLocation.class, callSiteArray[301].callGetProperty(callSiteArray[302].callGetProperty((Object)pointNoiseMap)))));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[303].call((Object)input, (Object)"confRaysName")) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[304].call((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[305].call((Object)input, (Object)"confRaysName"), String.class))))) {
            callSiteArray[306].call(parameters, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[307].call((Object)input, (Object)"confRaysName"), String.class)), String.class));
            callSiteArray[308].call(parameters, callSiteArray[309].callGetProperty(NoiseMapDatabaseParameters.ExportRaysMethods.class));
            callSiteArray[310].call(parameters, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[311].call((Object)input, (Object)"confRaysName"), String.class)), String.class));
            boolean bl2 = true;
            ScriptBytecodeAdapter.setProperty((Object)bl2, null, (Object)parameters, (String)"keepAbsorption");
            callSiteArray[312].call(parameters, (Object)maximumRaysToExport);
        }
        callSiteArray[313].call((Object)pointNoiseMap, (Object)compute_vertical_diffraction);
        callSiteArray[314].call((Object)pointNoiseMap, (Object)compute_horizontal_diffraction);
        callSiteArray[315].call((Object)pointNoiseMap, (Object)reflexion_order);
        callSiteArray[316].call((Object)pointNoiseMap, (Object)frequencyFieldPrepend);
        DefaultTableLoader defaultTableLoader = (DefaultTableLoader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[317].callGetProperty((Object)pointNoiseMap), DefaultTableLoader.class);
        AttenuationParameters environmentalData = (AttenuationParameters)ScriptBytecodeAdapter.castToType((Object)callSiteArray[318].callGetProperty((Object)defaultTableLoader), AttenuationParameters.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[319].call((Object)input, (Object)"confFavorableOccurrencesDefault"))) {
            StringTokenizer tk = (StringTokenizer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[320].callConstructor(StringTokenizer.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[321].call((Object)input, (Object)"confFavorableOccurrencesDefault"), String.class)), String.class), (Object)","), StringTokenizer.class);
            double[] favOccurrences = new double[DefaultTypeTransformation.intUnbox((Object)callSiteArray[322].callGetProperty(callSiteArray[323].callGetProperty(callSiteArray[324].callGroovyObjectGetProperty((Object)this))))];
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigD() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                int i = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[325].callGetProperty((Object)favOccurrences))) {
                    Object object = callSiteArray[326].call(Math.class, (Object)0, callSiteArray[327].call(Math.class, (Object)1, callSiteArray[328].call(Double.class, callSiteArray[329].call(callSiteArray[330].call((Object)tk)))));
                    callSiteArray[331].call((Object)favOccurrences, (Object)i, object);
                    int n = i;
                    i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[332].call((Object)n));
                }
            } else {
                int i = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[333].callGetProperty((Object)favOccurrences))) {
                    Object object = callSiteArray[334].call(Math.class, (Object)0, callSiteArray[335].call(Math.class, (Object)1, callSiteArray[336].call(Double.class, callSiteArray[337].call(callSiteArray[338].call((Object)tk)))));
                    BytecodeInterface8.dArraySet((double[])favOccurrences, (int)i, (double)DefaultTypeTransformation.doubleUnbox((Object)object));
                    int n = i;
                    int cfr_ignored_0 = n + 1;
                }
            }
            callSiteArray[339].call((Object)environmentalData, (Object)favOccurrences);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[340].call((Object)input, (Object)"confHumidity"))) {
            callSiteArray[341].call((Object)environmentalData, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[342].call((Object)input, (Object)"confHumidity"), Double.class)), Double.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[343].call((Object)input, (Object)"confTemperature"))) {
            callSiteArray[344].call((Object)environmentalData, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[345].call((Object)input, (Object)"confTemperature"), Double.class)), Double.class));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[346].call((Object)input, (Object)"tablePeriodAtmosphericSettings"))) {
            callSiteArray[347].call(callSiteArray[348].call((Object)pointNoiseMap), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[349].call((Object)input, (Object)"tablePeriodAtmosphericSettings"), String.class)), String.class));
        }
        callSiteArray[350].call((Object)pointNoiseMap, (Object)"HEIGHT");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)ground_table_name, (Object)"")) {
            callSiteArray[351].call((Object)pointNoiseMap, (Object)ground_table_name);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)dem_table_name, (Object)"")) {
            callSiteArray[352].call((Object)pointNoiseMap, (Object)dem_table_name);
        }
        callSiteArray[353].call((Object)pointNoiseMap, (Object)max_src_dist);
        callSiteArray[354].call((Object)pointNoiseMap, (Object)max_ref_dist);
        callSiteArray[355].call((Object)pointNoiseMap, (Object)wall_alpha);
        callSiteArray[356].call((Object)pointNoiseMap, (Object)n_thread);
        if (recordProfile) {
            LocalDateTime now = (LocalDateTime)ScriptBytecodeAdapter.castToType((Object)callSiteArray[357].call(LocalDateTime.class), LocalDateTime.class);
            Object object = callSiteArray[358].callConstructor(File.class, callSiteArray[359].call(String.class, ArrayUtil.createArray((Object)"profile_%d_%d_%d_%dh%d.csv", (Object)callSiteArray[360].call((Object)now), (Object)callSiteArray[361].call((Object)now), (Object)callSiteArray[362].call((Object)now), (Object)callSiteArray[363].call((Object)now), (Object)callSiteArray[364].call((Object)now))));
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)callSiteArray[365].callGetProperty((Object)pointNoiseMap), (String)"CSVProfilerOutputPath");
            int n = 120;
            ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)callSiteArray[366].callGetProperty((Object)pointNoiseMap), (String)"CSVProfilerWriteInterval");
        }
        callSiteArray[367].call(parameters, (Object)confMaxError);
        RootProgressVisitor progressLogger = (RootProgressVisitor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[368].callConstructor(RootProgressVisitor.class, (Object)1, (Object)true, (Object)1), RootProgressVisitor.class);
        callSiteArray[369].call((Object)logger, (Object)"Start calculation... ");
        callSiteArray[370].call((Object)pointNoiseMap, (Object)connection, (Object)progressLogger);
        long elapsed = DefaultTypeTransformation.longUnbox((Object)callSiteArray[371].call(callSiteArray[372].call(System.class), (Object)startCompute));
        long hours = DefaultTypeTransformation.longUnbox((Object)callSiteArray[373].call(callSiteArray[374].callGetProperty(TimeUnit.class), (Object)elapsed));
        elapsed = DefaultTypeTransformation.longUnbox((Object)callSiteArray[375].call((Object)elapsed, callSiteArray[376].call(callSiteArray[377].callGetProperty(TimeUnit.class), (Object)hours)));
        long minutes = DefaultTypeTransformation.longUnbox((Object)callSiteArray[378].call(callSiteArray[379].callGetProperty(TimeUnit.class), (Object)elapsed));
        elapsed = DefaultTypeTransformation.longUnbox((Object)callSiteArray[380].call((Object)elapsed, callSiteArray[381].call(callSiteArray[382].callGetProperty(TimeUnit.class), (Object)minutes)));
        long seconds = DefaultTypeTransformation.longUnbox((Object)callSiteArray[383].call(callSiteArray[384].callGetProperty(TimeUnit.class), (Object)elapsed));
        String timeString = ShortTypeHandling.castToString((Object)callSiteArray[385].call(String.class, ArrayUtil.createArray((Object)callSiteArray[386].callGetProperty(Locale.class), (Object)"%02d:%02d:%02d", (Object)hours, (Object)minutes, (Object)seconds)));
        callSiteArray[387].call((Object)logger, (Object)new GStringImpl(new Object[]{timeString}, new String[]{"Calculation Done in ", " ! "}));
        return new GStringImpl(new Object[]{callSiteArray[388].callGetProperty(callSiteArray[389].callGetProperty((Object)pointNoiseMap))}, new String[]{"Calculation Done ! The table ", " have been created."});
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Noise_level_from_source.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        CallSite[] callSiteArray = Noise_level_from_source.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = bigDecimal = new BigDecimal("0.1");
    }

    static {
        Noise_level_from_source.__$swapInit();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "plus";
        stringArray[12] = "plus";
        stringArray[13] = "plus";
        stringArray[14] = "plus";
        stringArray[15] = "plus";
        stringArray[16] = "plus";
        stringArray[17] = "plus";
        stringArray[18] = "plus";
        stringArray[19] = "plus";
        stringArray[20] = "plus";
        stringArray[21] = "plus";
        stringArray[22] = "plus";
        stringArray[23] = "plus";
        stringArray[24] = "plus";
        stringArray[25] = "plus";
        stringArray[26] = "plus";
        stringArray[27] = "plus";
        stringArray[28] = "plus";
        stringArray[29] = "plus";
        stringArray[30] = "plus";
        stringArray[31] = "plus";
        stringArray[32] = "plus";
        stringArray[33] = "plus";
        stringArray[34] = "plus";
        stringArray[35] = "plus";
        stringArray[36] = "plus";
        stringArray[37] = "plus";
        stringArray[38] = "plus";
        stringArray[39] = "plus";
        stringArray[40] = "plus";
        stringArray[41] = "plus";
        stringArray[42] = "plus";
        stringArray[43] = "plus";
        stringArray[44] = "plus";
        stringArray[45] = "plus";
        stringArray[46] = "plus";
        stringArray[47] = "plus";
        stringArray[48] = "plus";
        stringArray[49] = "plus";
        stringArray[50] = "plus";
        stringArray[51] = "plus";
        stringArray[52] = "plus";
        stringArray[53] = "plus";
        stringArray[54] = "plus";
        stringArray[55] = "plus";
        stringArray[56] = "plus";
        stringArray[57] = "plus";
        stringArray[58] = "plus";
        stringArray[59] = "plus";
        stringArray[60] = "plus";
        stringArray[61] = "plus";
        stringArray[62] = "plus";
        stringArray[63] = "plus";
        stringArray[64] = "plus";
        stringArray[65] = "plus";
        stringArray[66] = "plus";
        stringArray[67] = "plus";
        stringArray[68] = "plus";
        stringArray[69] = "plus";
        stringArray[70] = "plus";
        stringArray[71] = "plus";
        stringArray[72] = "plus";
        stringArray[73] = "plus";
        stringArray[74] = "plus";
        stringArray[75] = "plus";
        stringArray[76] = "plus";
        stringArray[77] = "plus";
        stringArray[78] = "plus";
        stringArray[79] = "plus";
        stringArray[80] = "plus";
        stringArray[81] = "isEmpty";
        stringArray[82] = "get";
        stringArray[83] = "getStoreNames";
        stringArray[84] = "catalog";
        stringArray[85] = "<$constructor$>";
        stringArray[86] = "getStore";
        stringArray[87] = "catalog";
        stringArray[88] = "<$constructor$>";
        stringArray[89] = "getDataStore";
        stringArray[90] = "getDataStoreInfo";
        stringArray[91] = "getConnection";
        stringArray[92] = "getDataSource";
        stringArray[93] = "withCloseable";
        stringArray[94] = "openGeoserverDataStoreConnection";
        stringArray[95] = "withCloseable";
        stringArray[96] = "currentTimeMillis";
        stringArray[97] = "getDBType";
        stringArray[98] = "unwrap";
        stringArray[99] = "<$constructor$>";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "getLogger";
        stringArray[102] = "info";
        stringArray[103] = "info";
        stringArray[104] = "getAt";
        stringArray[105] = "toUpperCase";
        stringArray[106] = "getSRID";
        stringArray[107] = "parse";
        stringArray[108] = "<$constructor$>";
        stringArray[109] = "plus";
        stringArray[110] = "plus";
        stringArray[111] = "<$constructor$>";
        stringArray[112] = "plus";
        stringArray[113] = "plus";
        stringArray[114] = "<$constructor$>";
        stringArray[115] = "plus";
        stringArray[116] = "plus";
        stringArray[117] = "<$constructor$>";
        stringArray[118] = "plus";
        stringArray[119] = "plus";
        stringArray[120] = "parse";
        stringArray[121] = "getGeometryColumnNames";
        stringArray[122] = "isEmpty";
        stringArray[123] = "<$constructor$>";
        stringArray[124] = "format";
        stringArray[125] = "getIntegerPrimaryKey";
        stringArray[126] = "parse";
        stringArray[127] = "<$constructor$>";
        stringArray[128] = "format";
        stringArray[129] = "<$constructor$>";
        stringArray[130] = "format";
        stringArray[131] = "getAt";
        stringArray[132] = "toUpperCase";
        stringArray[133] = "parse";
        stringArray[134] = "getGeometryColumnNames";
        stringArray[135] = "isEmpty";
        stringArray[136] = "<$constructor$>";
        stringArray[137] = "format";
        stringArray[138] = "getSRID";
        stringArray[139] = "parse";
        stringArray[140] = "<$constructor$>";
        stringArray[141] = "plus";
        stringArray[142] = "plus";
        stringArray[143] = "<$constructor$>";
        stringArray[144] = "plus";
        stringArray[145] = "plus";
        stringArray[146] = "<$constructor$>";
        stringArray[147] = "plus";
        stringArray[148] = "plus";
        stringArray[149] = "<$constructor$>";
        stringArray[150] = "plus";
        stringArray[151] = "plus";
        stringArray[152] = "<$constructor$>";
        stringArray[153] = "plus";
        stringArray[154] = "plus";
        stringArray[155] = "plus";
        stringArray[156] = "plus";
        stringArray[157] = "<$constructor$>";
        stringArray[158] = "plus";
        stringArray[159] = "plus";
        stringArray[160] = "plus";
        stringArray[161] = "plus";
        stringArray[162] = "getIntegerPrimaryKey";
        stringArray[163] = "parse";
        stringArray[164] = "<$constructor$>";
        stringArray[165] = "format";
        stringArray[166] = "<$constructor$>";
        stringArray[167] = "format";
        stringArray[168] = "getAt";
        stringArray[169] = "toUpperCase";
        stringArray[170] = "getSRID";
        stringArray[171] = "parse";
        stringArray[172] = "<$constructor$>";
        stringArray[173] = "plus";
        stringArray[174] = "plus";
        stringArray[175] = "<$constructor$>";
        stringArray[176] = "plus";
        stringArray[177] = "plus";
        stringArray[178] = "<$constructor$>";
        stringArray[179] = "plus";
        stringArray[180] = "plus";
        stringArray[181] = "<$constructor$>";
        stringArray[182] = "plus";
        stringArray[183] = "plus";
        stringArray[184] = "<$constructor$>";
        stringArray[185] = "plus";
        stringArray[186] = "plus";
        stringArray[187] = "plus";
        stringArray[188] = "plus";
        stringArray[189] = "<$constructor$>";
        stringArray[190] = "plus";
        stringArray[191] = "plus";
        stringArray[192] = "plus";
        stringArray[193] = "plus";
        stringArray[194] = "getAt";
        stringArray[195] = "getAt";
        stringArray[196] = "toUpperCase";
        stringArray[197] = "getSRID";
        stringArray[198] = "parse";
        stringArray[199] = "<$constructor$>";
        stringArray[200] = "plus";
        stringArray[201] = "plus";
        stringArray[202] = "<$constructor$>";
        stringArray[203] = "plus";
        stringArray[204] = "plus";
        stringArray[205] = "<$constructor$>";
        stringArray[206] = "plus";
        stringArray[207] = "plus";
        stringArray[208] = "<$constructor$>";
        stringArray[209] = "plus";
        stringArray[210] = "plus";
        stringArray[211] = "<$constructor$>";
        stringArray[212] = "plus";
        stringArray[213] = "plus";
        stringArray[214] = "plus";
        stringArray[215] = "plus";
        stringArray[216] = "<$constructor$>";
        stringArray[217] = "plus";
        stringArray[218] = "plus";
        stringArray[219] = "plus";
        stringArray[220] = "plus";
        stringArray[221] = "getAt";
        stringArray[222] = "getAt";
        stringArray[223] = "toUpperCase";
        stringArray[224] = "getSRID";
        stringArray[225] = "parse";
        stringArray[226] = "<$constructor$>";
        stringArray[227] = "plus";
        stringArray[228] = "plus";
        stringArray[229] = "<$constructor$>";
        stringArray[230] = "plus";
        stringArray[231] = "plus";
        stringArray[232] = "<$constructor$>";
        stringArray[233] = "plus";
        stringArray[234] = "plus";
        stringArray[235] = "<$constructor$>";
        stringArray[236] = "plus";
        stringArray[237] = "plus";
        stringArray[238] = "<$constructor$>";
        stringArray[239] = "plus";
        stringArray[240] = "plus";
        stringArray[241] = "plus";
        stringArray[242] = "plus";
        stringArray[243] = "<$constructor$>";
        stringArray[244] = "plus";
        stringArray[245] = "plus";
        stringArray[246] = "plus";
        stringArray[247] = "plus";
        stringArray[248] = "getAt";
        stringArray[249] = "getAt";
        stringArray[250] = "toUpperCase";
        stringArray[251] = "getAt";
        stringArray[252] = "getAt";
        stringArray[253] = "getAt";
        stringArray[254] = "valueOf";
        stringArray[255] = "getAt";
        stringArray[256] = "getAt";
        stringArray[257] = "valueOf";
        stringArray[258] = "getAt";
        stringArray[259] = "getAt";
        stringArray[260] = "valueOf";
        stringArray[261] = "getAt";
        stringArray[262] = "getAt";
        stringArray[263] = "valueOf";
        stringArray[264] = "getAt";
        stringArray[265] = "getAt";
        stringArray[266] = "valueOf";
        stringArray[267] = "getAt";
        stringArray[268] = "getAt";
        stringArray[269] = "getAt";
        stringArray[270] = "getAt";
        stringArray[271] = "getAt";
        stringArray[272] = "getAt";
        stringArray[273] = "getAt";
        stringArray[274] = "getAt";
        stringArray[275] = "valueOf";
        stringArray[276] = "getAt";
        stringArray[277] = "getAt";
        stringArray[278] = "getAt";
        stringArray[279] = "<$constructor$>";
        stringArray[280] = "getNoiseMapDatabaseParameters";
        stringArray[281] = "setMergeSources";
        stringArray[282] = "getAt";
        stringArray[283] = "capsIdentifier";
        stringArray[284] = "getAt";
        stringArray[285] = "setSourcesEmissionTableName";
        stringArray[286] = "isEmpty";
        stringArray[287] = "setUseTrainDirectivity";
        stringArray[288] = "sceneInputSettings";
        stringArray[289] = "setDirectivityTableName";
        stringArray[290] = "sceneInputSettings";
        stringArray[291] = "info";
        stringArray[292] = "format";
        stringArray[293] = "ROOT";
        stringArray[294] = "getAt";
        stringArray[295] = "capsIdentifier";
        stringArray[296] = "getAt";
        stringArray[297] = "setSourcesEmissionTableName";
        stringArray[298] = "execute";
        stringArray[299] = "plus";
        stringArray[300] = "parse";
        stringArray[301] = "receiversLevelTable";
        stringArray[302] = "noiseMapDatabaseParameters";
        stringArray[303] = "getAt";
        stringArray[304] = "isEmpty";
        stringArray[305] = "getAt";
        stringArray[306] = "setRaysTable";
        stringArray[307] = "getAt";
        stringArray[308] = "setExportRaysMethod";
        stringArray[309] = "TO_RAYS_TABLE";
        stringArray[310] = "setRaysTable";
        stringArray[311] = "getAt";
        stringArray[312] = "setMaximumRaysOutputCount";
        stringArray[313] = "setComputeHorizontalDiffraction";
        stringArray[314] = "setComputeVerticalDiffraction";
        stringArray[315] = "setSoundReflectionOrder";
        stringArray[316] = "setFrequencyFieldPrepend";
        stringArray[317] = "tableLoader";
        stringArray[318] = "defaultParameters";
        stringArray[319] = "containsKey";
        stringArray[320] = "<$constructor$>";
        stringArray[321] = "getAt";
        stringArray[322] = "length";
        stringArray[323] = "DEFAULT_WIND_ROSE";
        stringArray[324] = "AttenuationCnossosParameters";
        stringArray[325] = "length";
        stringArray[326] = "max";
        stringArray[327] = "min";
        stringArray[328] = "valueOf";
        stringArray[329] = "trim";
        stringArray[330] = "nextToken";
        stringArray[331] = "putAt";
        stringArray[332] = "next";
        stringArray[333] = "length";
        stringArray[334] = "max";
        stringArray[335] = "min";
        stringArray[336] = "valueOf";
        stringArray[337] = "trim";
        stringArray[338] = "nextToken";
        stringArray[339] = "setWindRose";
        stringArray[340] = "containsKey";
        stringArray[341] = "setHumidity";
        stringArray[342] = "getAt";
        stringArray[343] = "containsKey";
        stringArray[344] = "setTemperature";
        stringArray[345] = "getAt";
        stringArray[346] = "containsKey";
        stringArray[347] = "setPeriodAtmosphericSettingsTableName";
        stringArray[348] = "getSceneInputSettings";
        stringArray[349] = "get";
        stringArray[350] = "setHeightField";
        stringArray[351] = "setSoilTableName";
        stringArray[352] = "setDemTable";
        stringArray[353] = "setMaximumPropagationDistance";
        stringArray[354] = "setMaximumReflectionDistance";
        stringArray[355] = "setWallAbsorption";
        stringArray[356] = "setThreadCount";
        stringArray[357] = "now";
        stringArray[358] = "<$constructor$>";
        stringArray[359] = "format";
        stringArray[360] = "getYear";
        stringArray[361] = "getMonthValue";
        stringArray[362] = "getDayOfMonth";
        stringArray[363] = "getHour";
        stringArray[364] = "getMinute";
        stringArray[365] = "noiseMapDatabaseParameters";
        stringArray[366] = "noiseMapDatabaseParameters";
        stringArray[367] = "setMaximumError";
        stringArray[368] = "<$constructor$>";
        stringArray[369] = "info";
        stringArray[370] = "run";
        stringArray[371] = "minus";
        stringArray[372] = "currentTimeMillis";
        stringArray[373] = "toHours";
        stringArray[374] = "MILLISECONDS";
        stringArray[375] = "minus";
        stringArray[376] = "toMillis";
        stringArray[377] = "HOURS";
        stringArray[378] = "toMinutes";
        stringArray[379] = "MILLISECONDS";
        stringArray[380] = "minus";
        stringArray[381] = "toMillis";
        stringArray[382] = "MINUTES";
        stringArray[383] = "toSeconds";
        stringArray[384] = "MILLISECONDS";
        stringArray[385] = "format";
        stringArray[386] = "ROOT";
        stringArray[387] = "info";
        stringArray[388] = "receiversLevelTable";
        stringArray[389] = "noiseMapDatabaseParameters";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[390];
        Noise_level_from_source.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Noise_level_from_source.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Noise_level_from_source.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

