/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.wps.NoiseModelling;

import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.noise_planet.noisemodelling.emission.directivity.OmnidirectionalDirection;
import org.noise_planet.noisemodelling.emission.directivity.PolarGraphDirectivity;
import org.noise_planet.noisemodelling.emission.railway.nmpb.RailWayNMPBParameters;
import org.noise_planet.noisemodelling.emission.railway.nmpb.TrainAttenuation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotDirectivity
extends Script {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public PlotDirectivity() {
        CallSite[] callSiteArray = PlotDirectivity.$getCallSiteArray();
    }

    public PlotDirectivity(Binding context) {
        CallSite[] callSiteArray = PlotDirectivity.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = PlotDirectivity.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, PlotDirectivity.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = PlotDirectivity.$getCallSiteArray();
        String string = "Plot the directivity graph of the specified DIR_ID";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, PlotDirectivity.class, (GroovyObject)this, (String)"title");
        String string2 = "&#10145;&#65039; Plot the directivity graph of the specified \"DIR_ID\"";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string2, PlotDirectivity.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"tableSourceDirectivity", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Source directivity table name", "title", "Source directivity table name", "description", callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call((Object)"Name of the emission directivity table.</br></br>", (Object)"&#128736;  If not specified the default is train directivity of CNOSSOS-EU </br> </br>"), (Object)"The table must contain the following columns: <ul> "), (Object)"<li> <b> DIR_ID </b> : identifier of the directivity sphere (INTEGER)</li> "), (Object)"<li> <b> THETA </b> : [-90;90] Vertical angle in degree. 0&#176; front 90&#176; top -90&#176; bottom (FLOAT)</li> "), (Object)"<li> <b> PHI </b> : [0;360] Horizontal angle in degree. 0&#176; front 90&#176; right (FLOAT)</li> "), (Object)"<li> <b> LW63, LW125, LW250, LW500, LW1000, LW2000, LW4000, LW8000 </b> : attenuation levels in dB for each octave or third octave (FLOAT). </li></ul> "), "min", 0, "max", 1, "type", String.class}), "confDirId", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Directivity Index", "title", "Directivity Index", "description", callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call((Object)"Identifier of the directivity sphere from \"tableSourceDirectivity\" parameter or train directivity if \"tableSourceDirectivity\" parameter is not filled (INTEGER)</br> </br>", (Object)"In case of train, you can use these values: <ul>"), (Object)"<li>0 = OMNIDIRECTIONAL</li>"), (Object)"<li>1 = ROLLING</li>"), (Object)"<li>2 = TRACTIONA</li>"), (Object)"<li>3 = TRACTIONB</li>"), (Object)"<li>4 = AERODYNAMICA</li>"), (Object)"<li>5 = AERODYNAMICB</li>"), (Object)"<li>6 = BRIDGE</li></ul>"), "type", Integer.class}), "confFrequency", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Frequency", "title", "Frequency", "description", "Frequency to plot (INTEGER). 63, 125, 250, 500, 1000, 2000, 4000, 8000 (should match with the column of tableSourceDirectivity</br>", "type", Integer.class}), "confScaleMinimum", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Minimum scale attenuation (dB)", "title", "Minimum scale attenuation (dB)", "description", callSiteArray[15].call((Object)"Minimum scale attenuation (in dB) </br> </br>", (Object)"&#128736; Default value: <b>-35 dB</b>"), "min", 0, "max", 1, "type", Double.class}), "confScaleMaximum", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Maximum scale attenuation (dB)", "title", "Maximum scale attenuation (dB)", "description", callSiteArray[16].call((Object)"Maximum scale attenuation (in dB) </br> </br>", (Object)"&#128736; Default value: <b>0 dB</b>"), "min", 0, "max", 1, "type", Double.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, PlotDirectivity.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "Svg/Html of the directivity chart", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, PlotDirectivity.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = PlotDirectivity.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[18].call(callSiteArray[19].call(callSiteArray[20].callGroovyObjectGetProperty(callSiteArray[21].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].call(callSiteArray[23].callGroovyObjectGetProperty(callSiteArray[24].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].call(callSiteArray[26].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].call(callSiteArray[28].call((Object)jdbcDataStore)), Connection.class);
    }

    public Object exec(Connection connection, Object input) {
        CallSite[] callSiteArray = PlotDirectivity.$getCallSiteArray();
        Logger logger = (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[29].call(LoggerFactory.class, (Object)"org.noise_planet.noisemodelling"), Logger.class);
        Map directivityData = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[30].call(input, (Object)"tableSourceDirectivity"))) {
            String tableSourceDirectivity = ShortTypeHandling.castToString((Object)callSiteArray[31].call(input, (Object)"tableSourceDirectivity"));
            tableSourceDirectivity = ShortTypeHandling.castToString((Object)callSiteArray[32].call((Object)tableSourceDirectivity));
            directivityData = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].call(callSiteArray[34].callGroovyObjectGetProperty((Object)this), (Object)connection, (Object)tableSourceDirectivity, (Object)1), Map.class);
        } else {
            directivityData = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].callConstructor(HashMap.class), Map.class);
            callSiteArray[36].call((Object)directivityData, (Object)0, callSiteArray[37].callConstructor(OmnidirectionalDirection.class));
            RailWayNMPBParameters.TrainNoiseSource noiseSource = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].call(callSiteArray[39].call(callSiteArray[40].callGetProperty(callSiteArray[41].callGroovyObjectGetProperty((Object)this)))), Iterator.class);
            if (iterator != null) {
                while (iterator.hasNext()) {
                    noiseSource = (RailWayNMPBParameters.TrainNoiseSource)ShortTypeHandling.castToEnum(iterator.next(), RailWayNMPBParameters.TrainNoiseSource.class);
                    callSiteArray[42].call((Object)directivityData, callSiteArray[43].call(callSiteArray[44].call((Object)noiseSource), (Object)1), callSiteArray[45].callConstructor(TrainAttenuation.class, (Object)noiseSource));
                }
            }
        }
        int directivityIndex = 0;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[46].call(input, (Object)"confDirId"))) {
            directivityIndex = (Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[47].call(input, (Object)"confDirId"), Integer.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].call((Object)directivityData, (Object)directivityIndex))) {
                return callSiteArray[49].call(callSiteArray[50].call((Object)"The specified directivity index does not exist (not in ", callSiteArray[51].call(Arrays.class, callSiteArray[52].call((Object)directivityData))), (Object)" )");
            }
        } else {
            return "Please provide confDirId parameter";
        }
        int frequency = 1000;
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[53].call(input, (Object)"confDirId"))) {
            return "Please provide frequency parameter";
        }
        Integer n = (Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[54].call(input, (Object)"confDirId"), Integer.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)n, PlotDirectivity.class, (GroovyObject)this, (String)"confFrequency");
        double scaleMinimum = DefaultTypeTransformation.doubleUnbox((Object)-35);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[55].call(input, (Object)"confScaleMinimum"))) {
            scaleMinimum = (Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[56].call(input, (Object)"confScaleMinimum"), Double.class);
        }
        double scaleMaximum = 0.0;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[57].call(input, (Object)"confScaleMaximum"))) {
            scaleMaximum = (Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[58].call(input, (Object)"confScaleMaximum"), Double.class);
        }
        Object object = callSiteArray[59].call((Object)directivityData, (Object)directivityIndex);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, PlotDirectivity.class, (GroovyObject)this, (String)"directionAttributes");
        PolarGraphDirectivity polarGraphDirectivity = (PolarGraphDirectivity)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].callConstructor(PolarGraphDirectivity.class), PolarGraphDirectivity.class);
        StringBuilder sb = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[61].callConstructor(StringBuilder.class), StringBuilder.class);
        callSiteArray[62].call((Object)sb, (Object)"<h2>Top</h2>");
        callSiteArray[63].call((Object)sb, callSiteArray[64].call((Object)polarGraphDirectivity, ArrayUtil.createArray((Object)callSiteArray[65].callGroovyObjectGetProperty((Object)this), (Object)frequency, (Object)scaleMinimum, (Object)scaleMaximum, (Object)callSiteArray[66].callGetProperty(PolarGraphDirectivity.ORIENTATION.class))));
        callSiteArray[67].call((Object)sb, (Object)"<h2>Side</h2>");
        callSiteArray[68].call((Object)sb, callSiteArray[69].call((Object)polarGraphDirectivity, ArrayUtil.createArray((Object)callSiteArray[70].callGroovyObjectGetProperty((Object)this), (Object)frequency, (Object)scaleMinimum, (Object)scaleMaximum, (Object)callSiteArray[71].callGetProperty(PolarGraphDirectivity.ORIENTATION.class))));
        callSiteArray[72].call((Object)sb, (Object)"<h2>Front</h2>");
        callSiteArray[73].call((Object)sb, callSiteArray[74].call((Object)polarGraphDirectivity, ArrayUtil.createArray((Object)callSiteArray[75].callGroovyObjectGetProperty((Object)this), (Object)frequency, (Object)scaleMinimum, (Object)scaleMaximum, (Object)callSiteArray[76].callGetProperty(PolarGraphDirectivity.ORIENTATION.class))));
        return callSiteArray[77].call((Object)sb);
    }

    public Object run(Object input) {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure1(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = PlotDirectivity.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[78].call(callSiteArray[79].callStatic(PlotDirectivity.class, (Object)dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
        }
        return callSiteArray[80].call((Object)PlotDirectivity.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != PlotDirectivity.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "plus";
        stringArray[12] = "plus";
        stringArray[13] = "plus";
        stringArray[14] = "plus";
        stringArray[15] = "plus";
        stringArray[16] = "plus";
        stringArray[17] = "isEmpty";
        stringArray[18] = "get";
        stringArray[19] = "getStoreNames";
        stringArray[20] = "catalog";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "getStore";
        stringArray[23] = "catalog";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "getDataStore";
        stringArray[26] = "getDataStoreInfo";
        stringArray[27] = "getConnection";
        stringArray[28] = "getDataSource";
        stringArray[29] = "getLogger";
        stringArray[30] = "getAt";
        stringArray[31] = "getAt";
        stringArray[32] = "toUpperCase";
        stringArray[33] = "fetchDirectivity";
        stringArray[34] = "NoiseMapLoader";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "put";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "iterator";
        stringArray[39] = "values";
        stringArray[40] = "TrainNoiseSource";
        stringArray[41] = "RailWayLW";
        stringArray[42] = "put";
        stringArray[43] = "plus";
        stringArray[44] = "ordinal";
        stringArray[45] = "<$constructor$>";
        stringArray[46] = "getAt";
        stringArray[47] = "getAt";
        stringArray[48] = "containsKey";
        stringArray[49] = "plus";
        stringArray[50] = "plus";
        stringArray[51] = "toString";
        stringArray[52] = "keySet";
        stringArray[53] = "getAt";
        stringArray[54] = "getAt";
        stringArray[55] = "getAt";
        stringArray[56] = "getAt";
        stringArray[57] = "getAt";
        stringArray[58] = "getAt";
        stringArray[59] = "get";
        stringArray[60] = "<$constructor$>";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "append";
        stringArray[63] = "append";
        stringArray[64] = "generatePolarGraph";
        stringArray[65] = "directionAttributes";
        stringArray[66] = "TOP";
        stringArray[67] = "append";
        stringArray[68] = "append";
        stringArray[69] = "generatePolarGraph";
        stringArray[70] = "directionAttributes";
        stringArray[71] = "SIDE";
        stringArray[72] = "append";
        stringArray[73] = "append";
        stringArray[74] = "generatePolarGraph";
        stringArray[75] = "directionAttributes";
        stringArray[76] = "FRONT";
        stringArray[77] = "toString";
        stringArray[78] = "withCloseable";
        stringArray[79] = "openGeoserverDataStoreConnection";
        stringArray[80] = "withCloseable";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[81];
        PlotDirectivity.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(PlotDirectivity.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = PlotDirectivity.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

