/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.wps.Receivers;

import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.sql.Sql;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.h2gis.functions.spatial.crs.ST_SetSRID;
import org.h2gis.functions.spatial.crs.ST_Transform;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.RootProgressVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Building_Grid
extends Script {
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ BigDecimal $const$1;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Building_Grid() {
        CallSite[] callSiteArray = Building_Grid.$getCallSiteArray();
    }

    public Building_Grid(Binding context) {
        CallSite[] callSiteArray = Building_Grid.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = Building_Grid.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, Building_Grid.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = Building_Grid.$getCallSiteArray();
        String string = "Buildings Grid";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, Building_Grid.class, (GroovyObject)this, (String)"title");
        Object object = callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call((Object)"&#10145;&#65039; Generates receivers, 2m around the building facades, at a given height. </br>", (Object)"<hr>"), (Object)"&#x2705; The output table is called <b>RECEIVERS</b> </br></br>"), (Object)"<img src=\"/wps_images/building_grid_output.png\" alt=\"Building grid output\" width=\"95%\" align=\"center\">");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Building_Grid.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"tableBuilding", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Buildings table name", "title", "Buildings table name", "description", callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call((Object)"Name of the Buildings table. <br></br>", (Object)"The table must contain: <ul>"), (Object)"<li> <b>THE_GEOM</b> : the 2D geometry of the building (POLYGON or MULTIPOLYGON)</li>"), (Object)"<li> <b>HEIGHT</b> : the height of the building (in meter) (FLOAT)</li>"), (Object)"<li> <b>POP</b> : (optional field) building population to add in the receiver attribute (FLOAT)</li></ul>"), "type", String.class}), "fence", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Fence geometry", "title", "Extent filter", "description", "Create receivers only in the provided polygon (fence)", "min", 0, "max", 1, "type", Geometry.class}), "fenceTableName", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Fence geometry from table", "title", "Filter using table bounding box", "description", callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].call((Object)"Filter receivers, using the bounding box of the given table name:<br><ol>", (Object)"<li> Extract the bounding box of the specified table,</li>"), (Object)"<li> then create only receivers on the table bounding box.</li></ol>"), (Object)"The given table must contain: <ul>"), (Object)"<li> <b>THE_GEOM</b> : any geometry type. </li></ul>"), "min", 0, "max", 1, "type", String.class}), "sourcesTableName", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Sources table name", "title", "Sources table name", "description", callSiteArray[12].call(callSiteArray[13].call((Object)"Keep only receivers that are at least 1 meter from the provided source geometries.</br></br>", (Object)"The source geometries table must contain: <ul>"), (Object)"<li> <b>THE_GEOM</b> : any geometry type. </li></ul>"), "min", 0, "max", 1, "type", String.class}), "delta", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Receivers minimal distance", "title", "Distance between receivers", "description", callSiteArray[14].call((Object)"Distance between receivers (in the Cartesian plane - in meter) (FLOAT) </br></br>", (Object)"&#128736; Default value: <b>10 </b>"), "min", 0, "max", 1, "type", Double.class}), "height", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Height", "title", "Height", "description", callSiteArray[15].call((Object)"Height of receivers (in meter) (FLOAT) </br></br>", (Object)"&#128736; Default value: <b>4</b>"), "min", 0, "max", 1, "type", Double.class}), "distance", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Distance", "title", "Distance from wall", "description", callSiteArray[16].call((Object)"Distance of receivers from the wall in meters (FLOAT) </br></br>", (Object)"&#128736; Default value: <b>2 </b>"), "min", 0, "max", 1, "type", Double.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, Building_Grid.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "This type of result does not allow the blocks to be linked together.", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, Building_Grid.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = Building_Grid.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[18].call(callSiteArray[19].call(callSiteArray[20].callGroovyObjectGetProperty(callSiteArray[21].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].call(callSiteArray[23].callGroovyObjectGetProperty(callSiteArray[24].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].call(callSiteArray[26].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].call(callSiteArray[28].call((Object)jdbcDataStore)), Connection.class);
    }

    public Object run(Object input) {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure1(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = Building_Grid.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[29].call(callSiteArray[30].callStatic(Building_Grid.class, (Object)dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
        }
        return callSiteArray[31].call((Object)Building_Grid.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object exec(Connection connection, Object input) {
        CallSite[] callSiteArray = Building_Grid.$getCallSiteArray();
        String resultString = null;
        Logger logger = (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].call(LoggerFactory.class, (Object)"org.noise_planet.noisemodelling"), Logger.class);
        callSiteArray[33].call((Object)logger, (Object)"Start : Receivers grid around buildings");
        callSiteArray[34].call((Object)logger, (Object)"inputs {}", input);
        String receivers_table_name = "RECEIVERS";
        Reference delta = new Reference((Object)((Double)ScriptBytecodeAdapter.castToType((Object)10, Double.class)));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].call(input, (Object)"delta"))) {
            delta.set((Object)((Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[36].call(input, (Object)"delta"), Double.class)));
        }
        Reference h = new Reference((Object)4.0);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[37].call(input, (Object)"height"))) {
            h.set((Object)((Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[38].call(input, (Object)"height"), Double.class)));
        }
        Double distance = 2.0;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[39].call(input, (Object)"distance"))) {
            distance = (Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[40].call(input, (Object)"distance"), Double.class);
        }
        String sources_table_name = "SOURCES";
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[41].call(input, (Object)"sourcesTableName"))) {
            sources_table_name = ShortTypeHandling.castToString((Object)callSiteArray[42].call(input, (Object)"sourcesTableName"));
        }
        sources_table_name = ShortTypeHandling.castToString((Object)callSiteArray[43].call((Object)sources_table_name));
        String building_table_name = ShortTypeHandling.castToString((Object)callSiteArray[44].call(input, (Object)"tableBuilding"));
        building_table_name = ShortTypeHandling.castToString((Object)callSiteArray[45].call((Object)building_table_name));
        Boolean hasPop = (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].call(JDBCUtilities.class, (Object)connection, (Object)building_table_name, (Object)"POP"), Boolean.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)hasPop)) {
            callSiteArray[47].call((Object)logger, (Object)"The building table has a column named POP.");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)hasPop)) {
            callSiteArray[48].call((Object)logger, (Object)"The building table has not a column named POP.");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[49].call(JDBCUtilities.class, (Object)connection, (Object)building_table_name, (Object)"HEIGHT"))) {
            return "Buildings table must have HEIGHT field";
        }
        boolean bl = false;
        if (bl) {
            return "Buildings table must have HEIGHT field";
        }
        Reference sql = new Reference((Object)((Sql)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].callConstructor(Sql.class, (Object)connection), Sql.class)));
        callSiteArray[51].call((Object)((Sql)sql.get()), callSiteArray[52].call(String.class, (Object)"DROP TABLE IF EXISTS %s", (Object)receivers_table_name));
        int targetSrid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[53].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[54].call(TableLocation.class, (Object)building_table_name)));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (targetSrid == 0 && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[55].call(input, (Object)"sourcesTableName"))) {
                targetSrid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[56].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[57].call(TableLocation.class, (Object)sources_table_name)));
            }
        } else if (targetSrid == 0 && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].call(input, (Object)"sourcesTableName"))) {
            targetSrid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[59].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[60].call(TableLocation.class, (Object)sources_table_name)));
        }
        Geometry fenceGeom = null;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[61].call(input, (Object)"fence"), null)) {
                if (!(targetSrid != 0)) throw (Throwable)callSiteArray[68].callConstructor(Exception.class, (Object)"Unable to find buildings or sources SRID, ignore fence parameters");
                WKTReader wktReader = (WKTReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].callConstructor(WKTReader.class), WKTReader.class);
                Object object = callSiteArray[63].call((Object)wktReader, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[64].call(input, (Object)"fence"), String.class)), String.class));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Building_Grid.class, (GroovyObject)this, (String)"fence");
                fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[65].call(ST_Transform.class, (Object)connection, callSiteArray[66].call(ST_SetSRID.class, callSiteArray[67].callGroovyObjectGetProperty((Object)this), (Object)4326), (Object)targetSrid), Geometry.class);
            } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[69].call(input, (Object)"fenceTableName"))) {
                fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[71].call(TableLocation.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[72].call(input, (Object)"fenceTableName"), String.class)), String.class)), (Object)"THE_GEOM"), Geometry.class);
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[73].call(input, (Object)"fence"), null)) {
            if (!(targetSrid != 0)) throw (Throwable)callSiteArray[80].callConstructor(Exception.class, (Object)"Unable to find buildings or sources SRID, ignore fence parameters");
            WKTReader wktReader = (WKTReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].callConstructor(WKTReader.class), WKTReader.class);
            Object object = callSiteArray[75].call((Object)wktReader, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[76].call(input, (Object)"fence"), String.class)), String.class));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Building_Grid.class, (GroovyObject)this, (String)"fence");
            fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[77].call(ST_Transform.class, (Object)connection, callSiteArray[78].call(ST_SetSRID.class, callSiteArray[79].callGroovyObjectGetProperty((Object)this), (Object)4326), (Object)targetSrid), Geometry.class);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[81].call(input, (Object)"fenceTableName"))) {
            fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[83].call(TableLocation.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[84].call(input, (Object)"fenceTableName"), String.class)), String.class)), (Object)"THE_GEOM"), Geometry.class);
        }
        Object buildingPk = callSiteArray[85].call(JDBCUtilities.class, (Object)connection, (Object)building_table_name, callSiteArray[86].call(JDBCUtilities.class, (Object)connection, callSiteArray[87].call(TableLocation.class, (Object)building_table_name, callSiteArray[88].call(DBUtils.class, (Object)connection))));
        if (ScriptBytecodeAdapter.compareEqual((Object)buildingPk, (Object)"")) {
            return "Buildings table must have a primary key";
        }
        callSiteArray[89].call((Object)((Sql)sql.get()), (Object)"drop table if exists tmp_receivers_lines");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)fenceGeom, null)) {
            callSiteArray[90].call((Object)((Sql)sql.get()), callSiteArray[91].call(callSiteArray[92].call(callSiteArray[93].call(callSiteArray[94].call((Object)"create table tmp_receivers_lines(pk int not null primary key, the_geom geometry) as select ", buildingPk), (Object)" as pk, st_simplifypreservetopology(ST_ToMultiLine(ST_Buffer(the_geom, :distance_wall, 'join=bevel')), 0.05) the_geom from "), (Object)building_table_name), (Object)" WHERE the_geom && :fenceGeom AND ST_INTERSECTS(the_geom, :fenceGeom)"), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"fenceGeom", fenceGeom, "distance_wall", distance}));
        } else {
            callSiteArray[95].call((Object)((Sql)sql.get()), callSiteArray[96].call(callSiteArray[97].call(callSiteArray[98].call((Object)"create table tmp_receivers_lines(pk int not null primary key, the_geom geometry) as select ", buildingPk), (Object)" as pk, st_simplifypreservetopology(ST_ToMultiLine(ST_Buffer(the_geom, :distance_wall, 'join=bevel')), 0.05) the_geom from "), (Object)building_table_name), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"distance_wall", distance}));
        }
        callSiteArray[99].call((Object)logger, (Object)"create line of receivers");
        callSiteArray[100].call((Object)((Sql)sql.get()), (Object)"drop table if exists tmp_relation_screen_building;");
        callSiteArray[101].call((Object)((Sql)sql.get()), (Object)"create spatial index on tmp_receivers_lines(the_geom)");
        callSiteArray[102].call((Object)logger, (Object)"list buildings that will remove receivers (if height is superior than receiver height)");
        callSiteArray[103].call((Object)((Sql)sql.get()), callSiteArray[104].call(callSiteArray[105].call(callSiteArray[106].call(callSiteArray[107].call(callSiteArray[108].call((Object)"create table tmp_relation_screen_building as select b.", buildingPk), (Object)" as PK_building, s.pk as pk_screen from "), (Object)building_table_name), (Object)" b, tmp_receivers_lines s where b.the_geom && s.the_geom and s.pk != b.pk and ST_Intersects(b.the_geom, s.the_geom) and b.height > "), (Object)((Double)h.get())));
        callSiteArray[109].call((Object)((Sql)sql.get()), (Object)"CREATE INDEX ON tmp_relation_screen_building(PK_building);");
        callSiteArray[110].call((Object)((Sql)sql.get()), (Object)"CREATE INDEX ON tmp_relation_screen_building(pk_screen);");
        callSiteArray[111].call((Object)((Sql)sql.get()), (Object)"drop table if exists tmp_screen_truncated;");
        callSiteArray[112].call((Object)logger, (Object)"truncate receiver lines");
        callSiteArray[113].call((Object)((Sql)sql.get()), callSiteArray[114].call(callSiteArray[115].call(callSiteArray[116].call(callSiteArray[117].call((Object)"create table tmp_screen_truncated(pk_screen integer not null, the_geom geometry) as select r.pk_screen, ST_DIFFERENCE(s.the_geom, ST_BUFFER(ST_ACCUM(b.the_geom), :distance_wall)) the_geom from tmp_relation_screen_building r, ", (Object)building_table_name), (Object)" b, tmp_receivers_lines s WHERE PK_building = b."), buildingPk), (Object)" AND pk_screen = s.pk  GROUP BY pk_screen, s.the_geom;"), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"distance_wall", distance}));
        callSiteArray[118].call((Object)logger, (Object)"Add primary key");
        callSiteArray[119].call((Object)((Sql)sql.get()), (Object)"ALTER TABLE tmp_screen_truncated add primary key(pk_screen)");
        callSiteArray[120].call((Object)((Sql)sql.get()), (Object)"DROP TABLE IF EXISTS TMP_SCREENS_MERGE;");
        callSiteArray[121].call((Object)((Sql)sql.get()), (Object)"DROP TABLE IF EXISTS TMP_SCREENS;");
        callSiteArray[122].call((Object)logger, (Object)"union of truncated receivers and non tructated");
        callSiteArray[123].call((Object)((Sql)sql.get()), (Object)"create table TMP_SCREENS_MERGE (pk integer not null, the_geom geometry) as select s.pk, s.the_geom the_geom from tmp_receivers_lines s where not st_isempty(s.the_geom) and pk not in (select pk_screen from tmp_screen_truncated) UNION ALL select pk_screen, the_geom from tmp_screen_truncated where not st_isempty(the_geom);");
        callSiteArray[124].call((Object)logger, (Object)"Add primary key");
        callSiteArray[125].call((Object)((Sql)sql.get()), (Object)"ALTER TABLE TMP_SCREENS_MERGE add primary key(pk)");
        callSiteArray[126].call((Object)logger, (Object)"Collect all lines and convert into points using custom method");
        callSiteArray[127].call((Object)((Sql)sql.get()), (Object)"CREATE TABLE TMP_SCREENS(pk integer, the_geom geometry)");
        String qry = "INSERT INTO TMP_SCREENS(pk , the_geom) VALUES (?,?);";
        Reference factory = new Reference((Object)((GeometryFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[128].callConstructor(GeometryFactory.class, callSiteArray[129].callConstructor(PrecisionModel.class), (Object)targetSrid), GeometryFactory.class)));
        callSiteArray[130].call((Object)logger, (Object)"Split line to points");
        int nrows = (Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[131].call(callSiteArray[132].call((Object)((Sql)sql.get()), (Object)"SELECT COUNT(*) FROM TMP_SCREENS_MERGE"), (Object)0), Integer.class);
        Reference progressLogger = new Reference((Object)((RootProgressVisitor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[133].callConstructor(RootProgressVisitor.class, (Object)nrows, (Object)true, (Object)1), RootProgressVisitor.class)));
        public final class _exec_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sql;
            private /* synthetic */ Reference delta;
            private /* synthetic */ Reference h;
            private /* synthetic */ Reference factory;
            private /* synthetic */ Reference progressLogger;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _exec_closure2(Object _outerInstance, Object _thisObject, Reference sql, Reference delta, Reference h, Reference factory, Reference progressLogger) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.sql = reference5 = sql;
                this.delta = reference4 = delta;
                this.h = reference3 = h;
                this.factory = reference2 = factory;
                this.progressLogger = reference = progressLogger;
            }

            public Object doCall(Object ps) {
                Reference ps2 = new Reference(ps);
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                public final class _closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference delta;
                    private /* synthetic */ Reference h;
                    private /* synthetic */ Reference ps;
                    private /* synthetic */ Reference factory;
                    private /* synthetic */ Reference progressLogger;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure3(Object _outerInstance, Object _thisObject, Reference delta, Reference h, Reference ps, Reference factory, Reference progressLogger) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.delta = reference5 = delta;
                        this.h = reference4 = h;
                        this.ps = reference3 = ps;
                        this.factory = reference2 = factory;
                        this.progressLogger = reference = progressLogger;
                    }

                    public Object doCall(Object row) {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        List pts = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(ArrayList.class), List.class);
                        Geometry geom = (Geometry)ScriptBytecodeAdapter.asType((Object)callSiteArray[1].call(row, (Object)1), Geometry.class);
                        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            if (geom instanceof LineString) {
                                callSiteArray[2].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((LineString)ScriptBytecodeAdapter.asType((Object)geom, LineString.class)), LineString.class), this.delta.get(), (Object)pts);
                            } else if (geom instanceof MultiLineString) {
                                int idgeom = 0;
                                while (ScriptBytecodeAdapter.compareLessThan((Object)idgeom, (Object)callSiteArray[3].callGetProperty((Object)geom))) {
                                    callSiteArray[4].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((LineString)ScriptBytecodeAdapter.asType((Object)callSiteArray[5].call((Object)geom, (Object)idgeom), LineString.class)), LineString.class), this.delta.get(), (Object)pts);
                                    int n = idgeom;
                                    idgeom = DefaultTypeTransformation.intUnbox((Object)callSiteArray[6].call((Object)n));
                                }
                            }
                        } else if (geom instanceof LineString) {
                            callSiteArray[7].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((LineString)ScriptBytecodeAdapter.asType((Object)geom, LineString.class)), LineString.class), this.delta.get(), (Object)pts);
                        } else if (geom instanceof MultiLineString) {
                            int idgeom = 0;
                            while (ScriptBytecodeAdapter.compareLessThan((Object)idgeom, (Object)callSiteArray[8].callGetProperty((Object)geom))) {
                                callSiteArray[9].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((LineString)ScriptBytecodeAdapter.asType((Object)callSiteArray[10].call((Object)geom, (Object)idgeom), LineString.class)), LineString.class), this.delta.get(), (Object)pts);
                                int n = idgeom;
                                int cfr_ignored_0 = n + 1;
                            }
                        }
                        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            int idp = 0;
                            while (ScriptBytecodeAdapter.compareLessThan((Object)idp, (Object)callSiteArray[11].call((Object)pts))) {
                                Coordinate pt = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].call((Object)pts, (Object)idp), Coordinate.class);
                                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call(Double.class, callSiteArray[14].callGetProperty((Object)pt))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].call(Double.class, callSiteArray[16].callGetProperty((Object)pt)))) {
                                    Coordinate newCoord = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].callConstructor(Coordinate.class, callSiteArray[18].callGetProperty((Object)pt), callSiteArray[19].callGetProperty((Object)pt), this.h.get()), Coordinate.class);
                                    callSiteArray[20].call(this.ps.get(), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[21].call(row, (Object)0), Integer.class)), Integer.class), callSiteArray[22].call(this.factory.get(), (Object)newCoord));
                                }
                                int n = idp;
                                idp = DefaultTypeTransformation.intUnbox((Object)callSiteArray[23].call((Object)n));
                            }
                        } else {
                            int idp = 0;
                            while (ScriptBytecodeAdapter.compareLessThan((Object)idp, (Object)callSiteArray[24].call((Object)pts))) {
                                Coordinate pt = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].call((Object)pts, (Object)idp), Coordinate.class);
                                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].call(Double.class, callSiteArray[27].callGetProperty((Object)pt))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].call(Double.class, callSiteArray[29].callGetProperty((Object)pt)))) {
                                    Coordinate newCoord = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].callConstructor(Coordinate.class, callSiteArray[31].callGetProperty((Object)pt), callSiteArray[32].callGetProperty((Object)pt), this.h.get()), Coordinate.class);
                                    callSiteArray[33].call(this.ps.get(), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[34].call(row, (Object)0), Integer.class)), Integer.class), callSiteArray[35].call(this.factory.get(), (Object)newCoord));
                                }
                                int n = idp;
                                int cfr_ignored_1 = n + 1;
                            }
                        }
                        return callSiteArray[36].call(this.progressLogger.get());
                    }

                    @Generated
                    public Double getDelta() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return (Double)ScriptBytecodeAdapter.castToType((Object)this.delta.get(), Double.class);
                    }

                    @Generated
                    public Double getH() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return (Double)ScriptBytecodeAdapter.castToType((Object)this.h.get(), Double.class);
                    }

                    @Generated
                    public Object getPs() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return this.ps.get();
                    }

                    @Generated
                    public GeometryFactory getFactory() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return (GeometryFactory)ScriptBytecodeAdapter.castToType((Object)this.factory.get(), GeometryFactory.class);
                    }

                    @Generated
                    public RootProgressVisitor getProgressLogger() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return (RootProgressVisitor)ScriptBytecodeAdapter.castToType((Object)this.progressLogger.get(), RootProgressVisitor.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "<$constructor$>";
                        stringArray[1] = "getAt";
                        stringArray[2] = "splitLineStringIntoPoints";
                        stringArray[3] = "numGeometries";
                        stringArray[4] = "splitLineStringIntoPoints";
                        stringArray[5] = "getGeometryN";
                        stringArray[6] = "next";
                        stringArray[7] = "splitLineStringIntoPoints";
                        stringArray[8] = "numGeometries";
                        stringArray[9] = "splitLineStringIntoPoints";
                        stringArray[10] = "getGeometryN";
                        stringArray[11] = "size";
                        stringArray[12] = "get";
                        stringArray[13] = "isNaN";
                        stringArray[14] = "x";
                        stringArray[15] = "isNaN";
                        stringArray[16] = "y";
                        stringArray[17] = "<$constructor$>";
                        stringArray[18] = "x";
                        stringArray[19] = "y";
                        stringArray[20] = "addBatch";
                        stringArray[21] = "getAt";
                        stringArray[22] = "createPoint";
                        stringArray[23] = "next";
                        stringArray[24] = "size";
                        stringArray[25] = "get";
                        stringArray[26] = "isNaN";
                        stringArray[27] = "x";
                        stringArray[28] = "isNaN";
                        stringArray[29] = "y";
                        stringArray[30] = "<$constructor$>";
                        stringArray[31] = "x";
                        stringArray[32] = "y";
                        stringArray[33] = "addBatch";
                        stringArray[34] = "getAt";
                        stringArray[35] = "createPoint";
                        stringArray[36] = "endStep";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[37];
                        _closure3.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure3.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure3.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].call(this.sql.get(), (Object)"SELECT pk, the_geom from TMP_SCREENS_MERGE", (Object)new _closure3((Object)this, this.getThisObject(), this.delta, this.h, ps2, this.factory, this.progressLogger));
            }

            @Generated
            public Sql getSql() {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                return (Sql)ScriptBytecodeAdapter.castToType((Object)this.sql.get(), Sql.class);
            }

            @Generated
            public Double getDelta() {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                return (Double)ScriptBytecodeAdapter.castToType((Object)this.delta.get(), Double.class);
            }

            @Generated
            public Double getH() {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                return (Double)ScriptBytecodeAdapter.castToType((Object)this.h.get(), Double.class);
            }

            @Generated
            public GeometryFactory getFactory() {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                return (GeometryFactory)ScriptBytecodeAdapter.castToType((Object)this.factory.get(), GeometryFactory.class);
            }

            @Generated
            public RootProgressVisitor getProgressLogger() {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                return (RootProgressVisitor)ScriptBytecodeAdapter.castToType((Object)this.progressLogger.get(), RootProgressVisitor.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _exec_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "eachRow";
                return new CallSiteArray(_exec_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _exec_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[134].call((Object)((Sql)sql.get()), (Object)100, (Object)qry, (Object)new _exec_closure2((Object)this, (Object)this, sql, delta, h, factory, progressLogger));
        callSiteArray[135].call((Object)((Sql)sql.get()), (Object)"drop table if exists TMP_SCREENS_MERGE");
        callSiteArray[136].call((Object)((Sql)sql.get()), callSiteArray[137].call((Object)"drop table if exists ", (Object)receivers_table_name));
        if (!DefaultTypeTransformation.booleanUnbox((Object)hasPop)) {
            callSiteArray[138].call((Object)logger, (Object)"create RECEIVERS table...");
            callSiteArray[139].call((Object)((Sql)sql.get()), callSiteArray[140].call(callSiteArray[141].call((Object)"create table ", (Object)receivers_table_name), (Object)"(pk integer not null AUTO_INCREMENT, the_geom geometry,build_pk integer)"));
            callSiteArray[142].call((Object)((Sql)sql.get()), callSiteArray[143].call(callSiteArray[144].call(callSiteArray[145].call(callSiteArray[146].call((Object)"insert into ", (Object)receivers_table_name), (Object)"(the_geom, build_pk) select ST_SetSRID(the_geom,"), callSiteArray[147].call((Object)targetSrid)), (Object)") , pk building_pk from TMP_SCREENS;"));
            callSiteArray[148].call((Object)logger, (Object)"Add primary key");
            callSiteArray[149].call((Object)((Sql)sql.get()), callSiteArray[150].call(callSiteArray[151].call((Object)"ALTER TABLE ", (Object)receivers_table_name), (Object)" add primary key(pk)"));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[152].call(input, (Object)"sourcesTableName"))) {
                callSiteArray[153].call((Object)logger, (Object)"Delete receivers near sources...");
                callSiteArray[154].call((Object)((Sql)sql.get()), callSiteArray[155].call(callSiteArray[156].call((Object)"Create spatial index on ", (Object)sources_table_name), (Object)"(the_geom);"));
                callSiteArray[157].call((Object)((Sql)sql.get()), callSiteArray[158].call(callSiteArray[159].call(callSiteArray[160].call(callSiteArray[161].call((Object)"delete from ", (Object)receivers_table_name), (Object)" g where exists (select 1 from "), (Object)sources_table_name), (Object)" r where st_expand(g.the_geom, 1, 1) && r.the_geom and st_distance(g.the_geom, r.the_geom) < 1 limit 1);"));
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)fenceGeom, null)) {
                callSiteArray[162].call((Object)((Sql)sql.get()), callSiteArray[163].call(callSiteArray[164].call((Object)"delete from ", (Object)receivers_table_name), (Object)" g where not ST_INTERSECTS(g.the_geom , :fenceGeom);"), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"fenceGeom", fenceGeom}));
            }
        } else {
            callSiteArray[165].call((Object)logger, (Object)"create RECEIVERS table...");
            callSiteArray[166].call((Object)((Sql)sql.get()), (Object)"DROP TABLE IF EXISTS tmp_receivers");
            callSiteArray[167].call((Object)((Sql)sql.get()), (Object)"create table tmp_receivers(pk integer not null AUTO_INCREMENT, the_geom geometry,build_pk integer not null)");
            callSiteArray[168].call((Object)((Sql)sql.get()), callSiteArray[169].call(callSiteArray[170].call((Object)"insert into tmp_receivers(the_geom, build_pk) select ST_SetSRID(the_geom,", callSiteArray[171].call((Object)targetSrid)), (Object)"), pk building_pk from TMP_SCREENS;"));
            callSiteArray[172].call((Object)logger, (Object)"Add primary key");
            callSiteArray[173].call((Object)((Sql)sql.get()), (Object)"ALTER TABLE tmp_receivers add primary key(pk)");
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[174].call(input, (Object)"sourcesTableName"))) {
                callSiteArray[175].call((Object)logger, (Object)"Delete receivers near sources...");
                callSiteArray[176].call((Object)((Sql)sql.get()), callSiteArray[177].call(callSiteArray[178].call((Object)"Create spatial index on ", (Object)sources_table_name), (Object)"(the_geom);"));
                callSiteArray[179].call((Object)((Sql)sql.get()), callSiteArray[180].call(callSiteArray[181].call((Object)"delete from tmp_receivers g where exists (select 1 from ", (Object)sources_table_name), (Object)" r where st_expand(g.the_geom, 1) && r.the_geom and st_distance(g.the_geom, r.the_geom) < 1 limit 1);"));
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)fenceGeom, null)) {
                callSiteArray[182].call((Object)((Sql)sql.get()), (Object)"delete from tmp_receivers g where not ST_INTERSECTS(g.the_geom , :fenceGeom);", (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"fenceGeom", fenceGeom}));
            }
            callSiteArray[183].call((Object)((Sql)sql.get()), (Object)"CREATE INDEX ON tmp_receivers(build_pk)");
            callSiteArray[184].call((Object)logger, (Object)"Distribute population over receivers");
            callSiteArray[185].call((Object)((Sql)sql.get()), callSiteArray[186].call(callSiteArray[187].call((Object)"create table ", (Object)receivers_table_name), (Object)"(pk integer not null AUTO_INCREMENT, the_geom geometry,build_pk integer, pop real)"));
            callSiteArray[188].call((Object)((Sql)sql.get()), callSiteArray[189].call(callSiteArray[190].call(callSiteArray[191].call(callSiteArray[192].call(callSiteArray[193].call(callSiteArray[194].call((Object)"insert into ", (Object)receivers_table_name), (Object)"(the_geom, build_pk, pop) select a.the_geom, a.build_pk, b.pop/COUNT(DISTINCT aa.pk)::float from tmp_receivers a, "), (Object)building_table_name), (Object)" b,tmp_receivers aa where b."), buildingPk), (Object)" = a.build_pk and a.build_pk = aa.build_pk GROUP BY a.the_geom, a.build_pk, b.pop;"));
            callSiteArray[195].call((Object)logger, (Object)"Add primary key");
            callSiteArray[196].call((Object)((Sql)sql.get()), callSiteArray[197].call(callSiteArray[198].call((Object)"ALTER TABLE ", (Object)receivers_table_name), (Object)" add primary key(pk)"));
            callSiteArray[199].call((Object)((Sql)sql.get()), (Object)"drop table if exists tmp_receivers");
        }
        callSiteArray[200].call((Object)((Sql)sql.get()), (Object)"drop table TMP_SCREENS");
        callSiteArray[201].call((Object)((Sql)sql.get()), (Object)"drop table tmp_screen_truncated");
        callSiteArray[202].call((Object)((Sql)sql.get()), (Object)"drop table tmp_relation_screen_building");
        callSiteArray[203].call((Object)((Sql)sql.get()), (Object)"drop table tmp_receivers_lines");
        callSiteArray[204].call((Object)((Sql)sql.get()), (Object)"drop table if exists tmp_buildings;");
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[205].call(callSiteArray[206].call((Object)"Process done. Table of receivers ", (Object)receivers_table_name), (Object)" created !"));
        callSiteArray[207].call((Object)logger, callSiteArray[208].call((Object)"Result : ", (Object)resultString));
        callSiteArray[209].call((Object)logger, (Object)"End : Receivers grid around buildings");
        return resultString;
    }

    public double splitLineStringIntoPoints(LineString geom, double segmentSizeConstraint, List<Coordinate> pts) {
        CallSite[] callSiteArray = Building_Grid.$getCallSiteArray();
        double geomLength = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[210].call((Object)geom));
        if (!BytecodeInterface8.isOrigD() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (geomLength < segmentSizeConstraint) {
                Coordinate[] points = (Coordinate[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[211].call((Object)geom), Coordinate[].class);
                double segmentLength = 0.0;
                double targetSegmentSize = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[212].call((Object)geomLength, (Object)$const$0));
                int i = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[213].call(callSiteArray[214].callGetProperty((Object)points), (Object)1))) {
                    Coordinate a = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[215].call((Object)points, (Object)i), Coordinate.class);
                    Coordinate b = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[216].call((Object)points, callSiteArray[217].call((Object)i, (Object)1)), Coordinate.class);
                    double length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[218].call((Object)a, (Object)b));
                    if (!(DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[219].call((Object)length, (Object)segmentLength)) <= targetSegmentSize)) {
                        double segmentLengthFraction = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[220].call(callSiteArray[221].call((Object)targetSegmentSize, (Object)segmentLength), (Object)length));
                        Coordinate midPoint = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[222].callConstructor(Coordinate.class, callSiteArray[223].call(callSiteArray[224].callGetProperty((Object)a), callSiteArray[225].call((Object)segmentLengthFraction, callSiteArray[226].call(callSiteArray[227].callGetProperty((Object)b), callSiteArray[228].callGetProperty((Object)a)))), callSiteArray[229].call(callSiteArray[230].callGetProperty((Object)a), callSiteArray[231].call((Object)segmentLengthFraction, callSiteArray[232].call(callSiteArray[233].callGetProperty((Object)b), callSiteArray[234].callGetProperty((Object)a)))), callSiteArray[235].call(callSiteArray[236].callGetProperty((Object)a), callSiteArray[237].call((Object)segmentLengthFraction, callSiteArray[238].call(callSiteArray[239].callGetProperty((Object)b), callSiteArray[240].callGetProperty((Object)a))))), Coordinate.class);
                        callSiteArray[241].call(pts, (Object)midPoint);
                        break;
                    }
                    segmentLength = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[242].call((Object)segmentLength, (Object)length));
                    int n = i;
                    i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[243].call((Object)n));
                }
                return DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[244].call((Object)geom));
            }
            double targetSegmentSize = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[245].call((Object)geomLength, callSiteArray[246].call(Math.class, callSiteArray[247].call((Object)geomLength, (Object)segmentSizeConstraint))));
            Coordinate[] points = (Coordinate[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[248].call((Object)geom), Coordinate[].class);
            double segmentLength = DefaultTypeTransformation.doubleUnbox((Object)$const$1);
            Object midPoint = null;
            int i = 0;
            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[249].call(callSiteArray[250].callGetProperty((Object)points), (Object)1))) {
                Coordinate a = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[251].call((Object)points, (Object)i), Coordinate.class);
                Coordinate b = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[252].call((Object)points, callSiteArray[253].call((Object)i, (Object)1)), Coordinate.class);
                double length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[254].call((Object)a, (Object)b));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[255].call(Double.class, (Object)length))) {
                    length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[256].call((Object)a, (Object)b));
                }
                while (!(DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[257].call((Object)length, (Object)segmentLength)) <= targetSegmentSize)) {
                    double segmentLengthFraction = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[258].call(callSiteArray[259].call((Object)targetSegmentSize, (Object)segmentLength), (Object)length));
                    Coordinate splitPoint = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[260].callConstructor(Coordinate.class), Coordinate.class);
                    Object object = callSiteArray[261].call(callSiteArray[262].callGetProperty((Object)a), callSiteArray[263].call((Object)segmentLengthFraction, callSiteArray[264].call(callSiteArray[265].callGetProperty((Object)b), callSiteArray[266].callGetProperty((Object)a))));
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)splitPoint, (String)"x");
                    Object object2 = callSiteArray[267].call(callSiteArray[268].callGetProperty((Object)a), callSiteArray[269].call((Object)segmentLengthFraction, callSiteArray[270].call(callSiteArray[271].callGetProperty((Object)b), callSiteArray[272].callGetProperty((Object)a))));
                    ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)splitPoint, (String)"y");
                    Object object3 = callSiteArray[273].call(callSiteArray[274].callGetProperty((Object)a), callSiteArray[275].call((Object)segmentLengthFraction, callSiteArray[276].call(callSiteArray[277].callGetProperty((Object)b), callSiteArray[278].callGetProperty((Object)a))));
                    ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)splitPoint, (String)"z");
                    if (ScriptBytecodeAdapter.compareEqual((Object)midPoint, null) && !(DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[279].call((Object)length, (Object)segmentLength)) <= DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[280].call((Object)targetSegmentSize, (Object)2)))) {
                        segmentLengthFraction = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[281].call(callSiteArray[282].call(callSiteArray[283].call((Object)targetSegmentSize, (Object)$const$0), (Object)segmentLength), (Object)length));
                        midPoint = callSiteArray[284].callConstructor(Coordinate.class, callSiteArray[285].call(callSiteArray[286].callGetProperty((Object)a), callSiteArray[287].call((Object)segmentLengthFraction, callSiteArray[288].call(callSiteArray[289].callGetProperty((Object)b), callSiteArray[290].callGetProperty((Object)a)))), callSiteArray[291].call(callSiteArray[292].callGetProperty((Object)a), callSiteArray[293].call((Object)segmentLengthFraction, callSiteArray[294].call(callSiteArray[295].callGetProperty((Object)b), callSiteArray[296].callGetProperty((Object)a)))), callSiteArray[297].call(callSiteArray[298].callGetProperty((Object)a), callSiteArray[299].call((Object)segmentLengthFraction, callSiteArray[300].call(callSiteArray[301].callGetProperty((Object)b), callSiteArray[302].callGetProperty((Object)a)))));
                    }
                    callSiteArray[303].call(pts, midPoint);
                    length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[304].call((Object)a, (Object)b));
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[305].call(Double.class, (Object)length))) {
                        length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[306].call((Object)a, (Object)b));
                    }
                    segmentLength = 0.0;
                    midPoint = null;
                }
                if (ScriptBytecodeAdapter.compareEqual(midPoint, null) && !(DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[307].call((Object)length, (Object)segmentLength)) <= DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[308].call((Object)targetSegmentSize, (Object)2)))) {
                    double segmentLengthFraction = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[309].call(callSiteArray[310].call(callSiteArray[311].call((Object)targetSegmentSize, (Object)$const$0), (Object)segmentLength), (Object)length));
                    callSiteArray[312].callConstructor(Coordinate.class, callSiteArray[313].call(callSiteArray[314].callGetProperty((Object)a), callSiteArray[315].call((Object)segmentLengthFraction, callSiteArray[316].call(callSiteArray[317].callGetProperty((Object)b), callSiteArray[318].callGetProperty((Object)a)))), callSiteArray[319].call(callSiteArray[320].callGetProperty((Object)a), callSiteArray[321].call((Object)segmentLengthFraction, callSiteArray[322].call(callSiteArray[323].callGetProperty((Object)b), callSiteArray[324].callGetProperty((Object)a)))), callSiteArray[325].call(callSiteArray[326].callGetProperty((Object)a), callSiteArray[327].call((Object)segmentLengthFraction, callSiteArray[328].call(callSiteArray[329].callGetProperty((Object)b), callSiteArray[330].callGetProperty((Object)a)))));
                }
                segmentLength = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[331].call((Object)segmentLength, (Object)length));
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[332].call((Object)n));
            }
            if (ScriptBytecodeAdapter.compareNotEqual(midPoint, null)) {
                callSiteArray[333].call(pts, midPoint);
            }
            return targetSegmentSize;
        }
        if (geomLength < segmentSizeConstraint) {
            Object[] points = (Coordinate[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[334].call((Object)geom), Coordinate[].class);
            double segmentLength = 0.0;
            double targetSegmentSize = geomLength / DefaultTypeTransformation.doubleUnbox((Object)$const$0);
            int i = 0;
            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[335].call(callSiteArray[336].callGetProperty((Object)points), (Object)1))) {
                Coordinate a = (Coordinate)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])points, (int)i), Coordinate.class);
                Coordinate b = (Coordinate)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])points, (int)(i + 1)), Coordinate.class);
                double length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[337].call((Object)a, (Object)b));
                if (!(length + segmentLength <= targetSegmentSize)) {
                    double segmentLengthFraction = (targetSegmentSize - segmentLength) / length;
                    Coordinate midPoint = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[338].callConstructor(Coordinate.class, callSiteArray[339].call(callSiteArray[340].callGetProperty((Object)a), callSiteArray[341].call((Object)segmentLengthFraction, callSiteArray[342].call(callSiteArray[343].callGetProperty((Object)b), callSiteArray[344].callGetProperty((Object)a)))), callSiteArray[345].call(callSiteArray[346].callGetProperty((Object)a), callSiteArray[347].call((Object)segmentLengthFraction, callSiteArray[348].call(callSiteArray[349].callGetProperty((Object)b), callSiteArray[350].callGetProperty((Object)a)))), callSiteArray[351].call(callSiteArray[352].callGetProperty((Object)a), callSiteArray[353].call((Object)segmentLengthFraction, callSiteArray[354].call(callSiteArray[355].callGetProperty((Object)b), callSiteArray[356].callGetProperty((Object)a))))), Coordinate.class);
                    callSiteArray[357].call(pts, (Object)midPoint);
                    break;
                }
                double cfr_ignored_0 = segmentLength + length;
                int n = i;
                int cfr_ignored_1 = n + 1;
            }
            return DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[358].call((Object)geom));
        }
        double targetSegmentSize = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[359].call((Object)geomLength, callSiteArray[360].call(Math.class, (Object)(geomLength / segmentSizeConstraint))));
        Object[] points = (Coordinate[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[361].call((Object)geom), Coordinate[].class);
        double segmentLength = DefaultTypeTransformation.doubleUnbox((Object)$const$1);
        Object midPoint = null;
        int i = 0;
        while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[362].call(callSiteArray[363].callGetProperty((Object)points), (Object)1))) {
            Coordinate a = (Coordinate)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])points, (int)i), Coordinate.class);
            Coordinate b = (Coordinate)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])points, (int)(i + 1)), Coordinate.class);
            double length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[364].call((Object)a, (Object)b));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[365].call(Double.class, (Object)length))) {
                length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[366].call((Object)a, (Object)b));
            }
            while (!(length + segmentLength <= targetSegmentSize)) {
                double segmentLengthFraction = (targetSegmentSize - segmentLength) / length;
                Coordinate splitPoint = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[367].callConstructor(Coordinate.class), Coordinate.class);
                Object object = callSiteArray[368].call(callSiteArray[369].callGetProperty((Object)a), callSiteArray[370].call((Object)segmentLengthFraction, callSiteArray[371].call(callSiteArray[372].callGetProperty((Object)b), callSiteArray[373].callGetProperty((Object)a))));
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)splitPoint, (String)"x");
                Object object4 = callSiteArray[374].call(callSiteArray[375].callGetProperty((Object)a), callSiteArray[376].call((Object)segmentLengthFraction, callSiteArray[377].call(callSiteArray[378].callGetProperty((Object)b), callSiteArray[379].callGetProperty((Object)a))));
                ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)splitPoint, (String)"y");
                Object object5 = callSiteArray[380].call(callSiteArray[381].callGetProperty((Object)a), callSiteArray[382].call((Object)segmentLengthFraction, callSiteArray[383].call(callSiteArray[384].callGetProperty((Object)b), callSiteArray[385].callGetProperty((Object)a))));
                ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)splitPoint, (String)"z");
                if (ScriptBytecodeAdapter.compareEqual((Object)midPoint, null) && !(length + segmentLength <= targetSegmentSize / (double)2)) {
                    segmentLengthFraction = (targetSegmentSize / DefaultTypeTransformation.doubleUnbox((Object)$const$0) - segmentLength) / length;
                    midPoint = callSiteArray[386].callConstructor(Coordinate.class, callSiteArray[387].call(callSiteArray[388].callGetProperty((Object)a), callSiteArray[389].call((Object)segmentLengthFraction, callSiteArray[390].call(callSiteArray[391].callGetProperty((Object)b), callSiteArray[392].callGetProperty((Object)a)))), callSiteArray[393].call(callSiteArray[394].callGetProperty((Object)a), callSiteArray[395].call((Object)segmentLengthFraction, callSiteArray[396].call(callSiteArray[397].callGetProperty((Object)b), callSiteArray[398].callGetProperty((Object)a)))), callSiteArray[399].call(callSiteArray[400].callGetProperty((Object)a), callSiteArray[401].call((Object)segmentLengthFraction, callSiteArray[402].call(callSiteArray[403].callGetProperty((Object)b), callSiteArray[404].callGetProperty((Object)a)))));
                }
                callSiteArray[405].call(pts, midPoint);
                length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[406].call((Object)a, (Object)b));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[407].call(Double.class, (Object)length))) {
                    length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[408].call((Object)a, (Object)b));
                }
                segmentLength = 0.0;
                midPoint = null;
            }
            if (ScriptBytecodeAdapter.compareEqual(midPoint, null) && !(length + segmentLength <= targetSegmentSize / (double)2)) {
                double segmentLengthFraction = (targetSegmentSize / DefaultTypeTransformation.doubleUnbox((Object)$const$0) - segmentLength) / length;
                callSiteArray[409].callConstructor(Coordinate.class, callSiteArray[410].call(callSiteArray[411].callGetProperty((Object)a), callSiteArray[412].call((Object)segmentLengthFraction, callSiteArray[413].call(callSiteArray[414].callGetProperty((Object)b), callSiteArray[415].callGetProperty((Object)a)))), callSiteArray[416].call(callSiteArray[417].callGetProperty((Object)a), callSiteArray[418].call((Object)segmentLengthFraction, callSiteArray[419].call(callSiteArray[420].callGetProperty((Object)b), callSiteArray[421].callGetProperty((Object)a)))), callSiteArray[422].call(callSiteArray[423].callGetProperty((Object)a), callSiteArray[424].call((Object)segmentLengthFraction, callSiteArray[425].call(callSiteArray[426].callGetProperty((Object)b), callSiteArray[427].callGetProperty((Object)a)))));
            }
            double cfr_ignored_2 = segmentLength + length;
            int n = i;
            int cfr_ignored_3 = n + 1;
        }
        if (ScriptBytecodeAdapter.compareNotEqual(midPoint, null)) {
            callSiteArray[428].call(pts, midPoint);
        }
        return targetSegmentSize;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Building_Grid.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        CallSite[] callSiteArray = Building_Grid.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = bigDecimal2 = new BigDecimal("2.0");
        $const$1 = bigDecimal = new BigDecimal("0.0");
    }

    static {
        Building_Grid.__$swapInit();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "plus";
        stringArray[12] = "plus";
        stringArray[13] = "plus";
        stringArray[14] = "plus";
        stringArray[15] = "plus";
        stringArray[16] = "plus";
        stringArray[17] = "isEmpty";
        stringArray[18] = "get";
        stringArray[19] = "getStoreNames";
        stringArray[20] = "catalog";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "getStore";
        stringArray[23] = "catalog";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "getDataStore";
        stringArray[26] = "getDataStoreInfo";
        stringArray[27] = "getConnection";
        stringArray[28] = "getDataSource";
        stringArray[29] = "withCloseable";
        stringArray[30] = "openGeoserverDataStoreConnection";
        stringArray[31] = "withCloseable";
        stringArray[32] = "getLogger";
        stringArray[33] = "info";
        stringArray[34] = "info";
        stringArray[35] = "getAt";
        stringArray[36] = "getAt";
        stringArray[37] = "getAt";
        stringArray[38] = "getAt";
        stringArray[39] = "getAt";
        stringArray[40] = "getAt";
        stringArray[41] = "getAt";
        stringArray[42] = "getAt";
        stringArray[43] = "toUpperCase";
        stringArray[44] = "getAt";
        stringArray[45] = "toUpperCase";
        stringArray[46] = "hasField";
        stringArray[47] = "info";
        stringArray[48] = "info";
        stringArray[49] = "hasField";
        stringArray[50] = "<$constructor$>";
        stringArray[51] = "execute";
        stringArray[52] = "format";
        stringArray[53] = "getSRID";
        stringArray[54] = "parse";
        stringArray[55] = "getAt";
        stringArray[56] = "getSRID";
        stringArray[57] = "parse";
        stringArray[58] = "getAt";
        stringArray[59] = "getSRID";
        stringArray[60] = "parse";
        stringArray[61] = "getAt";
        stringArray[62] = "<$constructor$>";
        stringArray[63] = "read";
        stringArray[64] = "getAt";
        stringArray[65] = "ST_Transform";
        stringArray[66] = "setSRID";
        stringArray[67] = "fence";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "getAt";
        stringArray[70] = "getEnvelope";
        stringArray[71] = "parse";
        stringArray[72] = "getAt";
        stringArray[73] = "getAt";
        stringArray[74] = "<$constructor$>";
        stringArray[75] = "read";
        stringArray[76] = "getAt";
        stringArray[77] = "ST_Transform";
        stringArray[78] = "setSRID";
        stringArray[79] = "fence";
        stringArray[80] = "<$constructor$>";
        stringArray[81] = "getAt";
        stringArray[82] = "getEnvelope";
        stringArray[83] = "parse";
        stringArray[84] = "getAt";
        stringArray[85] = "getColumnName";
        stringArray[86] = "getIntegerPrimaryKey";
        stringArray[87] = "parse";
        stringArray[88] = "getDBType";
        stringArray[89] = "execute";
        stringArray[90] = "execute";
        stringArray[91] = "plus";
        stringArray[92] = "plus";
        stringArray[93] = "plus";
        stringArray[94] = "plus";
        stringArray[95] = "execute";
        stringArray[96] = "plus";
        stringArray[97] = "plus";
        stringArray[98] = "plus";
        stringArray[99] = "info";
        stringArray[100] = "execute";
        stringArray[101] = "execute";
        stringArray[102] = "info";
        stringArray[103] = "execute";
        stringArray[104] = "plus";
        stringArray[105] = "plus";
        stringArray[106] = "plus";
        stringArray[107] = "plus";
        stringArray[108] = "plus";
        stringArray[109] = "execute";
        stringArray[110] = "execute";
        stringArray[111] = "execute";
        stringArray[112] = "info";
        stringArray[113] = "execute";
        stringArray[114] = "plus";
        stringArray[115] = "plus";
        stringArray[116] = "plus";
        stringArray[117] = "plus";
        stringArray[118] = "info";
        stringArray[119] = "execute";
        stringArray[120] = "execute";
        stringArray[121] = "execute";
        stringArray[122] = "info";
        stringArray[123] = "execute";
        stringArray[124] = "info";
        stringArray[125] = "execute";
        stringArray[126] = "info";
        stringArray[127] = "execute";
        stringArray[128] = "<$constructor$>";
        stringArray[129] = "<$constructor$>";
        stringArray[130] = "info";
        stringArray[131] = "getAt";
        stringArray[132] = "firstRow";
        stringArray[133] = "<$constructor$>";
        stringArray[134] = "withBatch";
        stringArray[135] = "execute";
        stringArray[136] = "execute";
        stringArray[137] = "plus";
        stringArray[138] = "info";
        stringArray[139] = "execute";
        stringArray[140] = "plus";
        stringArray[141] = "plus";
        stringArray[142] = "execute";
        stringArray[143] = "plus";
        stringArray[144] = "plus";
        stringArray[145] = "plus";
        stringArray[146] = "plus";
        stringArray[147] = "toInteger";
        stringArray[148] = "info";
        stringArray[149] = "execute";
        stringArray[150] = "plus";
        stringArray[151] = "plus";
        stringArray[152] = "getAt";
        stringArray[153] = "info";
        stringArray[154] = "execute";
        stringArray[155] = "plus";
        stringArray[156] = "plus";
        stringArray[157] = "execute";
        stringArray[158] = "plus";
        stringArray[159] = "plus";
        stringArray[160] = "plus";
        stringArray[161] = "plus";
        stringArray[162] = "execute";
        stringArray[163] = "plus";
        stringArray[164] = "plus";
        stringArray[165] = "info";
        stringArray[166] = "execute";
        stringArray[167] = "execute";
        stringArray[168] = "execute";
        stringArray[169] = "plus";
        stringArray[170] = "plus";
        stringArray[171] = "toInteger";
        stringArray[172] = "info";
        stringArray[173] = "execute";
        stringArray[174] = "getAt";
        stringArray[175] = "info";
        stringArray[176] = "execute";
        stringArray[177] = "plus";
        stringArray[178] = "plus";
        stringArray[179] = "execute";
        stringArray[180] = "plus";
        stringArray[181] = "plus";
        stringArray[182] = "execute";
        stringArray[183] = "execute";
        stringArray[184] = "info";
        stringArray[185] = "execute";
        stringArray[186] = "plus";
        stringArray[187] = "plus";
        stringArray[188] = "execute";
        stringArray[189] = "plus";
        stringArray[190] = "plus";
        stringArray[191] = "plus";
        stringArray[192] = "plus";
        stringArray[193] = "plus";
        stringArray[194] = "plus";
        stringArray[195] = "info";
        stringArray[196] = "execute";
        stringArray[197] = "plus";
        stringArray[198] = "plus";
        stringArray[199] = "execute";
        stringArray[200] = "execute";
        stringArray[201] = "execute";
        stringArray[202] = "execute";
        stringArray[203] = "execute";
        stringArray[204] = "execute";
        stringArray[205] = "plus";
        stringArray[206] = "plus";
        stringArray[207] = "info";
        stringArray[208] = "plus";
        stringArray[209] = "info";
        stringArray[210] = "getLength";
        stringArray[211] = "getCoordinates";
        stringArray[212] = "div";
        stringArray[213] = "minus";
        stringArray[214] = "length";
        stringArray[215] = "getAt";
        stringArray[216] = "getAt";
        stringArray[217] = "plus";
        stringArray[218] = "distance3D";
        stringArray[219] = "plus";
        stringArray[220] = "div";
        stringArray[221] = "minus";
        stringArray[222] = "<$constructor$>";
        stringArray[223] = "plus";
        stringArray[224] = "x";
        stringArray[225] = "multiply";
        stringArray[226] = "minus";
        stringArray[227] = "x";
        stringArray[228] = "x";
        stringArray[229] = "plus";
        stringArray[230] = "y";
        stringArray[231] = "multiply";
        stringArray[232] = "minus";
        stringArray[233] = "y";
        stringArray[234] = "y";
        stringArray[235] = "plus";
        stringArray[236] = "z";
        stringArray[237] = "multiply";
        stringArray[238] = "minus";
        stringArray[239] = "z";
        stringArray[240] = "z";
        stringArray[241] = "add";
        stringArray[242] = "plus";
        stringArray[243] = "next";
        stringArray[244] = "getLength";
        stringArray[245] = "div";
        stringArray[246] = "ceil";
        stringArray[247] = "div";
        stringArray[248] = "getCoordinates";
        stringArray[249] = "minus";
        stringArray[250] = "length";
        stringArray[251] = "getAt";
        stringArray[252] = "getAt";
        stringArray[253] = "plus";
        stringArray[254] = "distance3D";
        stringArray[255] = "isNaN";
        stringArray[256] = "distance";
        stringArray[257] = "plus";
        stringArray[258] = "div";
        stringArray[259] = "minus";
        stringArray[260] = "<$constructor$>";
        stringArray[261] = "plus";
        stringArray[262] = "x";
        stringArray[263] = "multiply";
        stringArray[264] = "minus";
        stringArray[265] = "x";
        stringArray[266] = "x";
        stringArray[267] = "plus";
        stringArray[268] = "y";
        stringArray[269] = "multiply";
        stringArray[270] = "minus";
        stringArray[271] = "y";
        stringArray[272] = "y";
        stringArray[273] = "plus";
        stringArray[274] = "z";
        stringArray[275] = "multiply";
        stringArray[276] = "minus";
        stringArray[277] = "z";
        stringArray[278] = "z";
        stringArray[279] = "plus";
        stringArray[280] = "div";
        stringArray[281] = "div";
        stringArray[282] = "minus";
        stringArray[283] = "div";
        stringArray[284] = "<$constructor$>";
        stringArray[285] = "plus";
        stringArray[286] = "x";
        stringArray[287] = "multiply";
        stringArray[288] = "minus";
        stringArray[289] = "x";
        stringArray[290] = "x";
        stringArray[291] = "plus";
        stringArray[292] = "y";
        stringArray[293] = "multiply";
        stringArray[294] = "minus";
        stringArray[295] = "y";
        stringArray[296] = "y";
        stringArray[297] = "plus";
        stringArray[298] = "z";
        stringArray[299] = "multiply";
        stringArray[300] = "minus";
        stringArray[301] = "z";
        stringArray[302] = "z";
        stringArray[303] = "add";
        stringArray[304] = "distance3D";
        stringArray[305] = "isNaN";
        stringArray[306] = "distance";
        stringArray[307] = "plus";
        stringArray[308] = "div";
        stringArray[309] = "div";
        stringArray[310] = "minus";
        stringArray[311] = "div";
        stringArray[312] = "<$constructor$>";
        stringArray[313] = "plus";
        stringArray[314] = "x";
        stringArray[315] = "multiply";
        stringArray[316] = "minus";
        stringArray[317] = "x";
        stringArray[318] = "x";
        stringArray[319] = "plus";
        stringArray[320] = "y";
        stringArray[321] = "multiply";
        stringArray[322] = "minus";
        stringArray[323] = "y";
        stringArray[324] = "y";
        stringArray[325] = "plus";
        stringArray[326] = "z";
        stringArray[327] = "multiply";
        stringArray[328] = "minus";
        stringArray[329] = "z";
        stringArray[330] = "z";
        stringArray[331] = "plus";
        stringArray[332] = "next";
        stringArray[333] = "add";
        stringArray[334] = "getCoordinates";
        stringArray[335] = "minus";
        stringArray[336] = "length";
        stringArray[337] = "distance3D";
        stringArray[338] = "<$constructor$>";
        stringArray[339] = "plus";
        stringArray[340] = "x";
        stringArray[341] = "multiply";
        stringArray[342] = "minus";
        stringArray[343] = "x";
        stringArray[344] = "x";
        stringArray[345] = "plus";
        stringArray[346] = "y";
        stringArray[347] = "multiply";
        stringArray[348] = "minus";
        stringArray[349] = "y";
        stringArray[350] = "y";
        stringArray[351] = "plus";
        stringArray[352] = "z";
        stringArray[353] = "multiply";
        stringArray[354] = "minus";
        stringArray[355] = "z";
        stringArray[356] = "z";
        stringArray[357] = "add";
        stringArray[358] = "getLength";
        stringArray[359] = "div";
        stringArray[360] = "ceil";
        stringArray[361] = "getCoordinates";
        stringArray[362] = "minus";
        stringArray[363] = "length";
        stringArray[364] = "distance3D";
        stringArray[365] = "isNaN";
        stringArray[366] = "distance";
        stringArray[367] = "<$constructor$>";
        stringArray[368] = "plus";
        stringArray[369] = "x";
        stringArray[370] = "multiply";
        stringArray[371] = "minus";
        stringArray[372] = "x";
        stringArray[373] = "x";
        stringArray[374] = "plus";
        stringArray[375] = "y";
        stringArray[376] = "multiply";
        stringArray[377] = "minus";
        stringArray[378] = "y";
        stringArray[379] = "y";
        stringArray[380] = "plus";
        stringArray[381] = "z";
        stringArray[382] = "multiply";
        stringArray[383] = "minus";
        stringArray[384] = "z";
        stringArray[385] = "z";
        stringArray[386] = "<$constructor$>";
        stringArray[387] = "plus";
        stringArray[388] = "x";
        stringArray[389] = "multiply";
        stringArray[390] = "minus";
        stringArray[391] = "x";
        stringArray[392] = "x";
        stringArray[393] = "plus";
        stringArray[394] = "y";
        stringArray[395] = "multiply";
        stringArray[396] = "minus";
        stringArray[397] = "y";
        stringArray[398] = "y";
        stringArray[399] = "plus";
        stringArray[400] = "z";
        stringArray[401] = "multiply";
        stringArray[402] = "minus";
        stringArray[403] = "z";
        stringArray[404] = "z";
        stringArray[405] = "add";
        stringArray[406] = "distance3D";
        stringArray[407] = "isNaN";
        stringArray[408] = "distance";
        stringArray[409] = "<$constructor$>";
        stringArray[410] = "plus";
        stringArray[411] = "x";
        stringArray[412] = "multiply";
        stringArray[413] = "minus";
        stringArray[414] = "x";
        stringArray[415] = "x";
        stringArray[416] = "plus";
        stringArray[417] = "y";
        stringArray[418] = "multiply";
        stringArray[419] = "minus";
        stringArray[420] = "y";
        stringArray[421] = "y";
        stringArray[422] = "plus";
        stringArray[423] = "z";
        stringArray[424] = "multiply";
        stringArray[425] = "minus";
        stringArray[426] = "z";
        stringArray[427] = "z";
        stringArray[428] = "add";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[429];
        Building_Grid.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Building_Grid.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Building_Grid.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

