/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.wps.Receivers;

import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.sql.Sql;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.h2gis.functions.spatial.crs.ST_SetSRID;
import org.h2gis.functions.spatial.crs.ST_Transform;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Building_Grid3D
extends Script {
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ BigDecimal $const$1;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Building_Grid3D() {
        CallSite[] callSiteArray = Building_Grid3D.$getCallSiteArray();
    }

    public Building_Grid3D(Binding context) {
        CallSite[] callSiteArray = Building_Grid3D.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = Building_Grid3D.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, Building_Grid3D.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = Building_Grid3D.$getCallSiteArray();
        String string = "Buildings Grid";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, Building_Grid3D.class, (GroovyObject)this, (String)"title");
        Object object = callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call((Object)"&#10145;&#65039; Generates 3D receivers around the buildings and at different levels.</br>", (Object)"<hr>"), (Object)"Main parameters: </br><ul>"), (Object)"<li>\"Height between levels\": coupled with the building height, allows to determine the number of levels,</li>"), (Object)"<li>\"Distance from wall\": set the distance between the receivers and the building facades,</li>"), (Object)"<li>\"Distance between receivers\": set the number of receivers around the buildings.</li></ul></br>"), (Object)"&#x2705; The output table is called <b>RECEIVERS</b> </br></br>"), (Object)"<img src=\"/wps_images/Building_Grid3D.png\" alt=\"Building grid output\" width=\"95%\" align=\"center\">");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Building_Grid3D.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"tableBuilding", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Buildings table name", "title", "Buildings table name", "description", callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].call((Object)"Name of the Buildings table. <br></br>", (Object)"The table must contain: <ul>"), (Object)"<li> <b>THE_GEOM</b> : the 2D geometry of the building (POLYGON or MULTIPOLYGON)</li>"), (Object)"<li> <b>HEIGHT</b> : the height of the building (in meter) (FLOAT)</li>"), (Object)"<li> <b>POP</b> : building population to add in the receiver attribute (FLOAT) (Optionnal)</li></ul>"), "type", String.class}), "fence", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Fence geometry", "title", "Extent filter", "description", "Create receivers only in the provided polygon (fence)", "min", 0, "max", 1, "type", Geometry.class}), "fenceTableName", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Fence geometry from table", "title", "Filter using table bounding box", "description", callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].call(callSiteArray[15].call((Object)"Filter receivers, using the bounding box of the given table name:<br><ol>", (Object)"<li> Extract the bounding box of the specified table,</li>"), (Object)"<li> then create only receivers on the table bounding box.</li></ol>"), (Object)"The given table must contain: <ul>"), (Object)"<li> <b>THE_GEOM</b> : any geometry type. </li></ul>"), "min", 0, "max", 1, "type", String.class}), "sourcesTableName", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Sources table name", "title", "Sources table name", "description", callSiteArray[16].call(callSiteArray[17].call((Object)"Keep only receivers that are at least 1 meter from the provided source geometries.</br></br>", (Object)"The source geometries table must contain: <ul>"), (Object)"<li> <b>THE_GEOM</b> : any geometry type. </li></ul>"), "min", 0, "max", 1, "type", String.class}), "delta", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Receivers minimal distance", "title", "Distance between receivers", "description", callSiteArray[18].call((Object)"Distance between receivers (in the Cartesian plane - in meters) (FLOAT) </br></br>", (Object)"&#128736; Default value: <b>10 </b>"), "type", Double.class}), "heightLevels", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Height between levels", "title", "Height between levels", "description", callSiteArray[19].call((Object)"Height between each level of receivers (in meters) (FLOAT) </br> </br>", (Object)"&#128736; Default value: <b>2.5 </b> "), "min", 0, "max", 1, "type", Double.class}), "distance", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Distance", "title", "Distance from wall", "description", callSiteArray[20].call((Object)"Distance of receivers from the wall (in meters) (FLOAT) </br></br>", (Object)"&#128736; Default value: <b>2 </b>"), "min", 0, "max", 1, "type", Double.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, Building_Grid3D.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "This type of result does not allow the blocks to be linked together.", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, Building_Grid3D.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = Building_Grid3D.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[22].call(callSiteArray[23].call(callSiteArray[24].callGroovyObjectGetProperty(callSiteArray[25].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].call(callSiteArray[27].callGroovyObjectGetProperty(callSiteArray[28].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[29].call(callSiteArray[30].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].call(callSiteArray[32].call((Object)jdbcDataStore)), Connection.class);
    }

    public Object run(Object input) {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure1(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = Building_Grid3D.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[33].call(callSiteArray[34].callStatic(Building_Grid3D.class, (Object)dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
        }
        return callSiteArray[35].call((Object)Building_Grid3D.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object exec(Connection connection, Object input) {
        CallSite[] callSiteArray = Building_Grid3D.$getCallSiteArray();
        String resultString = null;
        Logger logger = (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].call(LoggerFactory.class, (Object)"org.noise_planet.noisemodelling"), Logger.class);
        callSiteArray[37].call((Object)logger, (Object)"Start : 3D Receivers grid around buildings");
        callSiteArray[38].call((Object)logger, (Object)"inputs {}", input);
        String receivers_table_name = "RECEIVERS";
        Reference delta = new Reference((Object)((Double)ScriptBytecodeAdapter.castToType((Object)10, Double.class)));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[39].call(input, (Object)"delta"))) {
            delta.set((Object)((Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[40].call(input, (Object)"delta"), Double.class)));
        }
        Reference h = new Reference((Object)2.5);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[41].call(input, (Object)"heightLevels"))) {
            h.set((Object)((Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[42].call(input, (Object)"heightLevels"), Double.class)));
        }
        Double distance = 2.0;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[43].call(input, (Object)"distance"))) {
            distance = (Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[44].call(input, (Object)"distance"), Double.class);
        }
        String sources_table_name = "SOURCES";
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[45].call(input, (Object)"sourcesTableName"))) {
            sources_table_name = ShortTypeHandling.castToString((Object)callSiteArray[46].call(input, (Object)"sourcesTableName"));
        }
        sources_table_name = ShortTypeHandling.castToString((Object)callSiteArray[47].call((Object)sources_table_name));
        String building_table_name = ShortTypeHandling.castToString((Object)callSiteArray[48].call(input, (Object)"tableBuilding"));
        building_table_name = ShortTypeHandling.castToString((Object)callSiteArray[49].call((Object)building_table_name));
        Boolean hasPop = (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].call(JDBCUtilities.class, (Object)connection, (Object)building_table_name, (Object)"POP"), Boolean.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)hasPop)) {
            callSiteArray[51].call((Object)logger, (Object)"The building table has a column named POP.");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)hasPop)) {
            callSiteArray[52].call((Object)logger, (Object)"The building table has not a column named POP.");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[53].call(JDBCUtilities.class, (Object)connection, (Object)building_table_name, (Object)"HEIGHT"))) {
            return "To run this script, your input Buildings table must have column named HEIGHT.";
        }
        boolean bl = false;
        if (bl) {
            return "To run this script, your input Buildings table must have column named HEIGHT.";
        }
        Reference sql = new Reference((Object)((Sql)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].callConstructor(Sql.class, (Object)connection), Sql.class)));
        callSiteArray[55].call((Object)((Sql)sql.get()), callSiteArray[56].call(String.class, (Object)"DROP TABLE IF EXISTS %s", (Object)receivers_table_name));
        int targetSrid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[57].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[58].call(TableLocation.class, (Object)building_table_name)));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (targetSrid == 0 && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[59].call(input, (Object)"sourcesTableName"))) {
                targetSrid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[60].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[61].call(TableLocation.class, (Object)sources_table_name)));
            }
        } else if (targetSrid == 0 && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[62].call(input, (Object)"sourcesTableName"))) {
            targetSrid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[63].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[64].call(TableLocation.class, (Object)sources_table_name)));
        }
        Geometry fenceGeom = null;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[65].call(input, (Object)"fence"))) {
                if (!(targetSrid != 0)) throw (Throwable)callSiteArray[72].callConstructor(Exception.class, (Object)"Unable to find buildings or sources SRID, ignore fence parameters");
                WKTReader wktReader = (WKTReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[66].callConstructor(WKTReader.class), WKTReader.class);
                Object object = callSiteArray[67].call((Object)wktReader, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[68].call(input, (Object)"fence"), String.class)), String.class));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Building_Grid3D.class, (GroovyObject)this, (String)"fence");
                fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].call(ST_Transform.class, (Object)connection, callSiteArray[70].call(ST_SetSRID.class, callSiteArray[71].callGroovyObjectGetProperty((Object)this), (Object)4326), (Object)targetSrid), Geometry.class);
            } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[73].call(input, (Object)"fenceTableName"))) {
                fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[75].call(TableLocation.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[76].call(input, (Object)"fenceTableName"), String.class)), String.class)), (Object)"THE_GEOM"), Geometry.class);
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[77].call(input, (Object)"fence"))) {
            if (!(targetSrid != 0)) throw (Throwable)callSiteArray[84].callConstructor(Exception.class, (Object)"Unable to find buildings or sources SRID, ignore fence parameters");
            WKTReader wktReader = (WKTReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].callConstructor(WKTReader.class), WKTReader.class);
            Object object = callSiteArray[79].call((Object)wktReader, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[80].call(input, (Object)"fence"), String.class)), String.class));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Building_Grid3D.class, (GroovyObject)this, (String)"fence");
            fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].call(ST_Transform.class, (Object)connection, callSiteArray[82].call(ST_SetSRID.class, callSiteArray[83].callGroovyObjectGetProperty((Object)this), (Object)4326), (Object)targetSrid), Geometry.class);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[85].call(input, (Object)"fenceTableName"))) {
            fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[87].call(TableLocation.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[88].call(input, (Object)"fenceTableName"), String.class)), String.class)), (Object)"THE_GEOM"), Geometry.class);
        }
        Object buildingPk = callSiteArray[89].call(JDBCUtilities.class, (Object)connection, (Object)building_table_name, callSiteArray[90].call(JDBCUtilities.class, (Object)connection, callSiteArray[91].call(TableLocation.class, (Object)building_table_name, callSiteArray[92].call(DBUtils.class, (Object)connection))));
        callSiteArray[93].call((Object)logger, callSiteArray[94].call((Object)"The input building table has a Primary Key named ", buildingPk));
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)buildingPk, (Object)"")) return "To run this script, your input Buildings table must have a Primary Key.";
            if (!DefaultTypeTransformation.booleanUnbox((Object)buildingPk)) {
                return "To run this script, your input Buildings table must have a Primary Key.";
            }
            boolean bl2 = false;
            if (bl2) {
                return "To run this script, your input Buildings table must have a Primary Key.";
            }
            boolean bl3 = false;
            if (bl3) {
                return "To run this script, your input Buildings table must have a Primary Key.";
            }
        } else {
            if (ScriptBytecodeAdapter.compareEqual((Object)buildingPk, (Object)"")) return "To run this script, your input Buildings table must have a Primary Key.";
            if (!DefaultTypeTransformation.booleanUnbox((Object)buildingPk)) {
                return "To run this script, your input Buildings table must have a Primary Key.";
            }
            boolean bl4 = false;
            if (bl4) {
                return "To run this script, your input Buildings table must have a Primary Key.";
            }
            boolean bl5 = false;
            if (bl5) {
                return "To run this script, your input Buildings table must have a Primary Key.";
            }
        }
        callSiteArray[95].call((Object)((Sql)sql.get()), (Object)"DROP TABLE IF EXISTS tmp_receivers_lines");
        String filter_geom_query = "";
        if (ScriptBytecodeAdapter.compareNotEqual((Object)fenceGeom, null)) {
            filter_geom_query = " WHERE the_geom && :fenceGeom AND ST_INTERSECTS(the_geom, :fenceGeom)";
        }
        callSiteArray[96].call((Object)((Sql)sql.get()), callSiteArray[97].call(callSiteArray[98].call(callSiteArray[99].call(callSiteArray[100].call(callSiteArray[101].call(callSiteArray[102].call((Object)"CREATE TABLE tmp_receivers_lines as SELECT ", buildingPk), (Object)" as pk_building, "), (Object)"ST_SimplifyPreserveTopology(ST_ToMultiLine(ST_Buffer(the_geom, :distance_wall, 'join=bevel')), 0.05) the_geom, HEIGHT "), (Object)"FROM "), (Object)building_table_name), (Object)filter_geom_query), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"fenceGeom", fenceGeom, "distance_wall", distance}));
        callSiteArray[103].call((Object)((Sql)sql.get()), (Object)"CREATE SPATIAL INDEX ON tmp_receivers_lines(the_geom)");
        callSiteArray[104].call((Object)((Sql)sql.get()), (Object)"DROP TABLE IF EXISTS TMP_SCREENS_MERGE");
        callSiteArray[105].call((Object)((Sql)sql.get()), (Object)"CREATE TABLE TMP_SCREENS_MERGE (the_geom geometry, hBuilding float, pk_building integer) as SELECT s.the_geom, s.height, s.pk_building FROM tmp_receivers_lines s WHERE not st_isempty(s.the_geom) ;");
        callSiteArray[106].call((Object)((Sql)sql.get()), (Object)"ALTER TABLE TMP_SCREENS_MERGE ADD COLUMN PK SERIAL PRIMARY KEY");
        callSiteArray[107].call((Object)((Sql)sql.get()), (Object)"DROP TABLE IF EXISTS TMP_SCREENS");
        callSiteArray[108].call((Object)((Sql)sql.get()), (Object)"CREATE TABLE TMP_SCREENS(pk integer, the_geom geometry, level int, pk_building int)");
        String qry = "INSERT INTO TMP_SCREENS(pk, the_geom, level, pk_building) VALUES (?,?,?,?);";
        Reference factory = new Reference((Object)((GeometryFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[109].callConstructor(GeometryFactory.class, callSiteArray[110].callConstructor(PrecisionModel.class), (Object)targetSrid), GeometryFactory.class)));
        public final class _exec_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference sql;
            private /* synthetic */ Reference delta;
            private /* synthetic */ Reference h;
            private /* synthetic */ Reference factory;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _exec_closure2(Object _outerInstance, Object _thisObject, Reference sql, Reference delta, Reference h, Reference factory) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.sql = reference4 = sql;
                this.delta = reference3 = delta;
                this.h = reference2 = h;
                this.factory = reference = factory;
            }

            public Object doCall(Object ps) {
                Reference ps2 = new Reference(ps);
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                public final class _closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference delta;
                    private /* synthetic */ Reference h;
                    private /* synthetic */ Reference ps;
                    private /* synthetic */ Reference factory;
                    private static /* synthetic */ BigDecimal $const$0;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure3(Object _outerInstance, Object _thisObject, Reference delta, Reference h, Reference ps, Reference factory) {
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.delta = reference4 = delta;
                        this.h = reference3 = h;
                        this.ps = reference2 = ps;
                        this.factory = reference = factory;
                    }

                    public Object doCall(Object row) {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        List pts = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(ArrayList.class), List.class);
                        Geometry geom = (Geometry)ScriptBytecodeAdapter.asType((Object)callSiteArray[1].call(row, (Object)1), Geometry.class);
                        Double hBuilding = (Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[2].call(row, (Object)2), Double.class);
                        Integer pk_building = (Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[3].call(row, (Object)3), Integer.class);
                        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                            if (geom instanceof LineString) {
                                callSiteArray[4].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((LineString)ScriptBytecodeAdapter.asType((Object)geom, LineString.class)), LineString.class), this.delta.get(), (Object)pts);
                            } else if (geom instanceof MultiLineString) {
                                int idgeom = 0;
                                while (ScriptBytecodeAdapter.compareLessThan((Object)idgeom, (Object)callSiteArray[5].callGetProperty((Object)geom))) {
                                    callSiteArray[6].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((LineString)ScriptBytecodeAdapter.asType((Object)callSiteArray[7].call((Object)geom, (Object)idgeom), LineString.class)), LineString.class), this.delta.get(), (Object)pts);
                                    int n = idgeom;
                                    idgeom = DefaultTypeTransformation.intUnbox((Object)callSiteArray[8].call((Object)n));
                                }
                            }
                        } else if (geom instanceof LineString) {
                            callSiteArray[9].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((LineString)ScriptBytecodeAdapter.asType((Object)geom, LineString.class)), LineString.class), this.delta.get(), (Object)pts);
                        } else if (geom instanceof MultiLineString) {
                            int idgeom = 0;
                            while (ScriptBytecodeAdapter.compareLessThan((Object)idgeom, (Object)callSiteArray[10].callGetProperty((Object)geom))) {
                                callSiteArray[11].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((LineString)ScriptBytecodeAdapter.asType((Object)callSiteArray[12].call((Object)geom, (Object)idgeom), LineString.class)), LineString.class), this.delta.get(), (Object)pts);
                                int n = idgeom;
                                int cfr_ignored_0 = n + 1;
                            }
                        }
                        int nLevels = DefaultTypeTransformation.intUnbox((Object)callSiteArray[13].call(Math.class, callSiteArray[14].call(callSiteArray[15].call((Object)hBuilding, (Object)$const$0), this.h.get())));
                        if (ScriptBytecodeAdapter.compareGreaterThan((Object)hBuilding, (Object)$const$0)) {
                            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                                int i = 0;
                                while (i < nLevels) {
                                    int idp = 0;
                                    while (ScriptBytecodeAdapter.compareLessThan((Object)idp, (Object)callSiteArray[16].call((Object)pts))) {
                                        Coordinate pt = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[17].call((Object)pts, (Object)idp), Coordinate.class);
                                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[18].call(Double.class, callSiteArray[19].callGetProperty((Object)pt))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].call(Double.class, callSiteArray[21].callGetProperty((Object)pt)))) {
                                            Coordinate newCoord = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].callConstructor(Coordinate.class, callSiteArray[23].callGetProperty((Object)pt), callSiteArray[24].callGetProperty((Object)pt), callSiteArray[25].call((Object)$const$0, callSiteArray[26].call((Object)i, this.h.get()))), Coordinate.class);
                                            callSiteArray[27].call(this.ps.get(), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[28].call(row, (Object)0), Integer.class)), Integer.class), callSiteArray[29].call(this.factory.get(), (Object)newCoord), (Object)i, (Object)pk_building);
                                        }
                                        int n = idp;
                                        idp = DefaultTypeTransformation.intUnbox((Object)callSiteArray[30].call((Object)n));
                                    }
                                    int n = i;
                                    i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[31].call((Object)n));
                                }
                            } else {
                                int i = 0;
                                while (i < nLevels) {
                                    int idp = 0;
                                    while (ScriptBytecodeAdapter.compareLessThan((Object)idp, (Object)callSiteArray[32].call((Object)pts))) {
                                        Coordinate pt = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].call((Object)pts, (Object)idp), Coordinate.class);
                                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[34].call(Double.class, callSiteArray[35].callGetProperty((Object)pt))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[36].call(Double.class, callSiteArray[37].callGetProperty((Object)pt)))) {
                                            Coordinate newCoord = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].callConstructor(Coordinate.class, callSiteArray[39].callGetProperty((Object)pt), callSiteArray[40].callGetProperty((Object)pt), callSiteArray[41].call((Object)$const$0, callSiteArray[42].call((Object)i, this.h.get()))), Coordinate.class);
                                            callSiteArray[43].call(this.ps.get(), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[44].call(row, (Object)0), Integer.class)), Integer.class), callSiteArray[45].call(this.factory.get(), (Object)newCoord), (Object)i, (Object)pk_building);
                                        }
                                        int n = idp;
                                        int cfr_ignored_1 = n + 1;
                                    }
                                    int n = i;
                                    int cfr_ignored_2 = n + 1;
                                }
                            }
                            return null;
                        }
                        return null;
                    }

                    @Generated
                    public Double getDelta() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return (Double)ScriptBytecodeAdapter.castToType((Object)this.delta.get(), Double.class);
                    }

                    @Generated
                    public Double getH() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return (Double)ScriptBytecodeAdapter.castToType((Object)this.h.get(), Double.class);
                    }

                    @Generated
                    public Object getPs() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return this.ps.get();
                    }

                    @Generated
                    public GeometryFactory getFactory() {
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        return (GeometryFactory)ScriptBytecodeAdapter.castToType((Object)this.factory.get(), GeometryFactory.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                        BigDecimal bigDecimal;
                        CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                        $callSiteArray = null;
                        $const$0 = bigDecimal = new BigDecimal("1.5");
                    }

                    static {
                        _closure3.__$swapInit();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "<$constructor$>";
                        stringArray[1] = "getAt";
                        stringArray[2] = "getAt";
                        stringArray[3] = "getAt";
                        stringArray[4] = "splitLineStringIntoPoints";
                        stringArray[5] = "numGeometries";
                        stringArray[6] = "splitLineStringIntoPoints";
                        stringArray[7] = "getGeometryN";
                        stringArray[8] = "next";
                        stringArray[9] = "splitLineStringIntoPoints";
                        stringArray[10] = "numGeometries";
                        stringArray[11] = "splitLineStringIntoPoints";
                        stringArray[12] = "getGeometryN";
                        stringArray[13] = "ceil";
                        stringArray[14] = "div";
                        stringArray[15] = "minus";
                        stringArray[16] = "size";
                        stringArray[17] = "get";
                        stringArray[18] = "isNaN";
                        stringArray[19] = "x";
                        stringArray[20] = "isNaN";
                        stringArray[21] = "y";
                        stringArray[22] = "<$constructor$>";
                        stringArray[23] = "x";
                        stringArray[24] = "y";
                        stringArray[25] = "plus";
                        stringArray[26] = "multiply";
                        stringArray[27] = "addBatch";
                        stringArray[28] = "getAt";
                        stringArray[29] = "createPoint";
                        stringArray[30] = "next";
                        stringArray[31] = "next";
                        stringArray[32] = "size";
                        stringArray[33] = "get";
                        stringArray[34] = "isNaN";
                        stringArray[35] = "x";
                        stringArray[36] = "isNaN";
                        stringArray[37] = "y";
                        stringArray[38] = "<$constructor$>";
                        stringArray[39] = "x";
                        stringArray[40] = "y";
                        stringArray[41] = "plus";
                        stringArray[42] = "multiply";
                        stringArray[43] = "addBatch";
                        stringArray[44] = "getAt";
                        stringArray[45] = "createPoint";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[46];
                        _closure3.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure3.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure3.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].call(this.sql.get(), (Object)"SELECT pk, the_geom, hBuilding, pk_building FROM TMP_SCREENS_MERGE", (Object)new _closure3((Object)this, this.getThisObject(), this.delta, this.h, ps2, this.factory));
            }

            @Generated
            public Sql getSql() {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                return (Sql)ScriptBytecodeAdapter.castToType((Object)this.sql.get(), Sql.class);
            }

            @Generated
            public Double getDelta() {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                return (Double)ScriptBytecodeAdapter.castToType((Object)this.delta.get(), Double.class);
            }

            @Generated
            public Double getH() {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                return (Double)ScriptBytecodeAdapter.castToType((Object)this.h.get(), Double.class);
            }

            @Generated
            public GeometryFactory getFactory() {
                CallSite[] callSiteArray = _exec_closure2.$getCallSiteArray();
                return (GeometryFactory)ScriptBytecodeAdapter.castToType((Object)this.factory.get(), GeometryFactory.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _exec_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "eachRow";
                return new CallSiteArray(_exec_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _exec_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[111].call((Object)((Sql)sql.get()), (Object)100, (Object)qry, (Object)new _exec_closure2((Object)this, (Object)this, sql, delta, h, factory));
        callSiteArray[112].call((Object)((Sql)sql.get()), (Object)"DROP TABLE IF EXISTS TMP_SCREENS_MERGE");
        callSiteArray[113].call((Object)((Sql)sql.get()), callSiteArray[114].call((Object)"DROP TABLE IF EXISTS ", (Object)receivers_table_name));
        if (!DefaultTypeTransformation.booleanUnbox((Object)hasPop)) {
            callSiteArray[115].call((Object)logger, (Object)"Create RECEIVERS table...");
            callSiteArray[116].call((Object)((Sql)sql.get()), callSiteArray[117].call(callSiteArray[118].call((Object)"CREATE TABLE ", (Object)receivers_table_name), (Object)"(pk serial, the_geom geometry, level integer, pk_building integer);"));
            callSiteArray[119].call((Object)((Sql)sql.get()), callSiteArray[120].call(callSiteArray[121].call(callSiteArray[122].call(callSiteArray[123].call(callSiteArray[124].call((Object)"INSERT INTO ", (Object)receivers_table_name), (Object)" (the_geom, level, pk_building) "), (Object)"SELECT ST_SetSRID(the_geom,"), callSiteArray[125].call((Object)targetSrid)), (Object)"), level, pk_building FROM TMP_SCREENS;"));
            callSiteArray[126].call((Object)((Sql)sql.get()), callSiteArray[127].call(callSiteArray[128].call((Object)"CREATE SPATIAL INDEX ON ", (Object)receivers_table_name), (Object)"(the_geom);"));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[129].call(input, (Object)"sourcesTableName"))) {
                callSiteArray[130].call((Object)logger, (Object)"Delete receivers near sources...");
                callSiteArray[131].call((Object)((Sql)sql.get()), callSiteArray[132].call(callSiteArray[133].call((Object)"CREATE SPATIAL INDEX ON ", (Object)sources_table_name), (Object)"(the_geom);"));
                callSiteArray[134].call((Object)((Sql)sql.get()), callSiteArray[135].call(callSiteArray[136].call(callSiteArray[137].call(callSiteArray[138].call(callSiteArray[139].call(callSiteArray[140].call((Object)"DELETE FROM ", (Object)receivers_table_name), (Object)" g WHERE exists  "), (Object)"(SELECT 1 FROM "), (Object)sources_table_name), (Object)" r  "), (Object)"WHERE st_expand(g.the_geom, 1, 1) && r.the_geom and st_distance(g.the_geom, r.the_geom) < 1 limit 1);"));
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)fenceGeom, null)) {
                callSiteArray[141].call((Object)logger, (Object)"Delete receivers that are not in the fence");
                callSiteArray[142].call((Object)((Sql)sql.get()), callSiteArray[143].call(callSiteArray[144].call((Object)"DELETE FROM ", (Object)receivers_table_name), (Object)" g WHERE not ST_INTERSECTS(g.the_geom , :fenceGeom);"), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"fenceGeom", fenceGeom}));
            }
        } else {
            callSiteArray[145].call((Object)logger, (Object)"Create RECEIVERS table...");
            callSiteArray[146].call((Object)((Sql)sql.get()), (Object)"DROP TABLE IF EXISTS tmp_receivers");
            callSiteArray[147].call((Object)((Sql)sql.get()), (Object)"CREATE TABLE tmp_receivers(the_geom geometry, build_pk integer, level integer, pk_building integer)");
            callSiteArray[148].call((Object)((Sql)sql.get()), (Object)"ALTER TABLE tmp_receivers ADD COLUMN PK SERIAL PRIMARY KEY");
            callSiteArray[149].call((Object)((Sql)sql.get()), callSiteArray[150].call(callSiteArray[151].call(callSiteArray[152].call((Object)"INSERT INTO tmp_receivers(the_geom, build_pk, level, pk_building) ", (Object)"SELECT ST_SetSRID(the_geom,"), callSiteArray[153].call((Object)targetSrid)), (Object)"), pk, level, pk_building FROM TMP_SCREENS;"));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[154].call(input, (Object)"sourcesTableName"))) {
                callSiteArray[155].call((Object)logger, (Object)"Delete receivers near sources...");
                callSiteArray[156].call((Object)((Sql)sql.get()), callSiteArray[157].call(callSiteArray[158].call((Object)"CREATE SPATIAL INDEX ON ", (Object)sources_table_name), (Object)"(the_geom);"));
                callSiteArray[159].call((Object)((Sql)sql.get()), callSiteArray[160].call(callSiteArray[161].call(callSiteArray[162].call(callSiteArray[163].call((Object)"DELETE FROM tmp_receivers g WHERE exists ", (Object)"(SELECT 1 FROM "), (Object)sources_table_name), (Object)" r "), (Object)"WHERE st_expand(g.the_geom, 1, 1) && r.the_geom and st_distance(g.the_geom, r.the_geom) < 1 limit 1);"));
            }
            if (ScriptBytecodeAdapter.compareNotEqual((Object)fenceGeom, null)) {
                callSiteArray[164].call((Object)logger, (Object)"Delete receivers that are not in the fence");
                callSiteArray[165].call((Object)((Sql)sql.get()), callSiteArray[166].call(callSiteArray[167].call(callSiteArray[168].call(callSiteArray[169].call(callSiteArray[170].call((Object)"DELETE FROM tmp_receivers g WHERE not ST_INTERSECTS(g.the_geom , ", (Object)"ST_SETSRID(ST_GeomFromText('"), (Object)fenceGeom), (Object)"'), "), callSiteArray[171].call((Object)targetSrid)), (Object)"));"));
            }
            callSiteArray[172].call((Object)((Sql)sql.get()), (Object)"CREATE INDEX ON tmp_receivers(build_pk)");
            callSiteArray[173].call((Object)((Sql)sql.get()), callSiteArray[174].call(callSiteArray[175].call((Object)"CREATE TABLE ", (Object)receivers_table_name), (Object)"(pk serial, the_geom geometry, level integer, pop float, pk_building integer)"));
            callSiteArray[176].call((Object)((Sql)sql.get()), callSiteArray[177].call(callSiteArray[178].call(callSiteArray[179].call(callSiteArray[180].call(callSiteArray[181].call(callSiteArray[182].call(callSiteArray[183].call(callSiteArray[184].call(callSiteArray[185].call(callSiteArray[186].call((Object)"INSERT INTO ", (Object)receivers_table_name), (Object)" (the_geom, level, pop, pk_building) "), (Object)"SELECT a.the_geom, a.level, b.pop/COUNT(DISTINCT aa.pk)::float, a.pk_building "), (Object)"FROM tmp_receivers a, "), (Object)building_table_name), (Object)" b,tmp_receivers aa "), (Object)"WHERE b."), buildingPk), (Object)" = a.pk_building AND a.build_pk = aa.build_pk "), (Object)"GROUP BY a.the_geom, a.build_pk, a.level, b.pop"));
            callSiteArray[187].call((Object)((Sql)sql.get()), (Object)"DROP TABLE IF EXISTS tmp_receivers");
        }
        callSiteArray[188].call((Object)logger, (Object)"Delete receivers inside buildings");
        callSiteArray[189].call((Object)((Sql)sql.get()), callSiteArray[190].call(callSiteArray[191].call(callSiteArray[192].call(callSiteArray[193].call(callSiteArray[194].call(callSiteArray[195].call((Object)"DELETE FROM ", (Object)receivers_table_name), (Object)" g WHERE exists "), (Object)"(SELECT 1 FROM "), (Object)building_table_name), (Object)" b "), (Object)"WHERE ST_Z(g.the_geom) < b.HEIGHT and g.the_geom && b.the_geom and ST_INTERSECTS(g.the_geom, b.the_geom) limit 1);"));
        callSiteArray[196].call((Object)((Sql)sql.get()), (Object)"drop table TMP_SCREENS if exists");
        callSiteArray[197].call((Object)((Sql)sql.get()), (Object)"drop table tmp_screen_truncated if exists");
        callSiteArray[198].call((Object)((Sql)sql.get()), (Object)"drop table tmp_relation_screen_building if exists");
        callSiteArray[199].call((Object)((Sql)sql.get()), (Object)"drop table tmp_receivers_lines if exists");
        callSiteArray[200].call((Object)((Sql)sql.get()), (Object)"DROP TABLE IF EXISTS tmp_buildings if exists;");
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[201].call(callSiteArray[202].call((Object)"Process done. The receivers table named ", (Object)receivers_table_name), (Object)" has been created!"));
        callSiteArray[203].call((Object)logger, callSiteArray[204].call((Object)"Result : ", (Object)resultString));
        callSiteArray[205].call((Object)logger, (Object)"End : 3D Receivers grid around buildings");
        return resultString;
    }

    public double splitLineStringIntoPoints(LineString geom, double segmentSizeConstraint, List<Coordinate> pts) {
        CallSite[] callSiteArray = Building_Grid3D.$getCallSiteArray();
        double geomLength = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[206].call((Object)geom));
        if (!BytecodeInterface8.isOrigD() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (geomLength < segmentSizeConstraint) {
                Coordinate[] points = (Coordinate[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[207].call((Object)geom), Coordinate[].class);
                double segmentLength = 0.0;
                double targetSegmentSize = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[208].call((Object)geomLength, (Object)$const$0));
                int i = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[209].call(callSiteArray[210].callGetProperty((Object)points), (Object)1))) {
                    Coordinate a = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[211].call((Object)points, (Object)i), Coordinate.class);
                    Coordinate b = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[212].call((Object)points, callSiteArray[213].call((Object)i, (Object)1)), Coordinate.class);
                    double length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[214].call((Object)a, (Object)b));
                    if (!(DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[215].call((Object)length, (Object)segmentLength)) <= targetSegmentSize)) {
                        double segmentLengthFraction = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[216].call(callSiteArray[217].call((Object)targetSegmentSize, (Object)segmentLength), (Object)length));
                        Coordinate midPoint = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[218].callConstructor(Coordinate.class, callSiteArray[219].call(callSiteArray[220].callGetProperty((Object)a), callSiteArray[221].call((Object)segmentLengthFraction, callSiteArray[222].call(callSiteArray[223].callGetProperty((Object)b), callSiteArray[224].callGetProperty((Object)a)))), callSiteArray[225].call(callSiteArray[226].callGetProperty((Object)a), callSiteArray[227].call((Object)segmentLengthFraction, callSiteArray[228].call(callSiteArray[229].callGetProperty((Object)b), callSiteArray[230].callGetProperty((Object)a)))), callSiteArray[231].call(callSiteArray[232].callGetProperty((Object)a), callSiteArray[233].call((Object)segmentLengthFraction, callSiteArray[234].call(callSiteArray[235].callGetProperty((Object)b), callSiteArray[236].callGetProperty((Object)a))))), Coordinate.class);
                        callSiteArray[237].call(pts, (Object)midPoint);
                        break;
                    }
                    segmentLength = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[238].call((Object)segmentLength, (Object)length));
                    int n = i;
                    i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[239].call((Object)n));
                }
                return DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[240].call((Object)geom));
            }
            double targetSegmentSize = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[241].call((Object)geomLength, callSiteArray[242].call(Math.class, callSiteArray[243].call((Object)geomLength, (Object)segmentSizeConstraint))));
            Coordinate[] points = (Coordinate[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[244].call((Object)geom), Coordinate[].class);
            double segmentLength = DefaultTypeTransformation.doubleUnbox((Object)$const$1);
            Object midPoint = null;
            int i = 0;
            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[245].call(callSiteArray[246].callGetProperty((Object)points), (Object)1))) {
                Coordinate a = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[247].call((Object)points, (Object)i), Coordinate.class);
                Coordinate b = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[248].call((Object)points, callSiteArray[249].call((Object)i, (Object)1)), Coordinate.class);
                double length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[250].call((Object)a, (Object)b));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[251].call(Double.class, (Object)length))) {
                    length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[252].call((Object)a, (Object)b));
                }
                while (!(DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[253].call((Object)length, (Object)segmentLength)) <= targetSegmentSize)) {
                    double segmentLengthFraction = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[254].call(callSiteArray[255].call((Object)targetSegmentSize, (Object)segmentLength), (Object)length));
                    Coordinate splitPoint = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[256].callConstructor(Coordinate.class), Coordinate.class);
                    Object object = callSiteArray[257].call(callSiteArray[258].callGetProperty((Object)a), callSiteArray[259].call((Object)segmentLengthFraction, callSiteArray[260].call(callSiteArray[261].callGetProperty((Object)b), callSiteArray[262].callGetProperty((Object)a))));
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)splitPoint, (String)"x");
                    Object object2 = callSiteArray[263].call(callSiteArray[264].callGetProperty((Object)a), callSiteArray[265].call((Object)segmentLengthFraction, callSiteArray[266].call(callSiteArray[267].callGetProperty((Object)b), callSiteArray[268].callGetProperty((Object)a))));
                    ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)splitPoint, (String)"y");
                    Object object3 = callSiteArray[269].call(callSiteArray[270].callGetProperty((Object)a), callSiteArray[271].call((Object)segmentLengthFraction, callSiteArray[272].call(callSiteArray[273].callGetProperty((Object)b), callSiteArray[274].callGetProperty((Object)a))));
                    ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)splitPoint, (String)"z");
                    if (ScriptBytecodeAdapter.compareEqual((Object)midPoint, null) && !(DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[275].call((Object)length, (Object)segmentLength)) <= DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[276].call((Object)targetSegmentSize, (Object)2)))) {
                        segmentLengthFraction = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[277].call(callSiteArray[278].call(callSiteArray[279].call((Object)targetSegmentSize, (Object)$const$0), (Object)segmentLength), (Object)length));
                        midPoint = callSiteArray[280].callConstructor(Coordinate.class, callSiteArray[281].call(callSiteArray[282].callGetProperty((Object)a), callSiteArray[283].call((Object)segmentLengthFraction, callSiteArray[284].call(callSiteArray[285].callGetProperty((Object)b), callSiteArray[286].callGetProperty((Object)a)))), callSiteArray[287].call(callSiteArray[288].callGetProperty((Object)a), callSiteArray[289].call((Object)segmentLengthFraction, callSiteArray[290].call(callSiteArray[291].callGetProperty((Object)b), callSiteArray[292].callGetProperty((Object)a)))), callSiteArray[293].call(callSiteArray[294].callGetProperty((Object)a), callSiteArray[295].call((Object)segmentLengthFraction, callSiteArray[296].call(callSiteArray[297].callGetProperty((Object)b), callSiteArray[298].callGetProperty((Object)a)))));
                    }
                    callSiteArray[299].call(pts, midPoint);
                    length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[300].call((Object)a, (Object)b));
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[301].call(Double.class, (Object)length))) {
                        length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[302].call((Object)a, (Object)b));
                    }
                    segmentLength = 0.0;
                    midPoint = null;
                }
                if (ScriptBytecodeAdapter.compareEqual(midPoint, null) && !(DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[303].call((Object)length, (Object)segmentLength)) <= DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[304].call((Object)targetSegmentSize, (Object)2)))) {
                    double segmentLengthFraction = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[305].call(callSiteArray[306].call(callSiteArray[307].call((Object)targetSegmentSize, (Object)$const$0), (Object)segmentLength), (Object)length));
                    callSiteArray[308].callConstructor(Coordinate.class, callSiteArray[309].call(callSiteArray[310].callGetProperty((Object)a), callSiteArray[311].call((Object)segmentLengthFraction, callSiteArray[312].call(callSiteArray[313].callGetProperty((Object)b), callSiteArray[314].callGetProperty((Object)a)))), callSiteArray[315].call(callSiteArray[316].callGetProperty((Object)a), callSiteArray[317].call((Object)segmentLengthFraction, callSiteArray[318].call(callSiteArray[319].callGetProperty((Object)b), callSiteArray[320].callGetProperty((Object)a)))), callSiteArray[321].call(callSiteArray[322].callGetProperty((Object)a), callSiteArray[323].call((Object)segmentLengthFraction, callSiteArray[324].call(callSiteArray[325].callGetProperty((Object)b), callSiteArray[326].callGetProperty((Object)a)))));
                }
                segmentLength = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[327].call((Object)segmentLength, (Object)length));
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[328].call((Object)n));
            }
            if (ScriptBytecodeAdapter.compareNotEqual(midPoint, null)) {
                callSiteArray[329].call(pts, midPoint);
            }
            return targetSegmentSize;
        }
        if (geomLength < segmentSizeConstraint) {
            Object[] points = (Coordinate[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[330].call((Object)geom), Coordinate[].class);
            double segmentLength = 0.0;
            double targetSegmentSize = geomLength / DefaultTypeTransformation.doubleUnbox((Object)$const$0);
            int i = 0;
            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[331].call(callSiteArray[332].callGetProperty((Object)points), (Object)1))) {
                Coordinate a = (Coordinate)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])points, (int)i), Coordinate.class);
                Coordinate b = (Coordinate)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])points, (int)(i + 1)), Coordinate.class);
                double length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[333].call((Object)a, (Object)b));
                if (!(length + segmentLength <= targetSegmentSize)) {
                    double segmentLengthFraction = (targetSegmentSize - segmentLength) / length;
                    Coordinate midPoint = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[334].callConstructor(Coordinate.class, callSiteArray[335].call(callSiteArray[336].callGetProperty((Object)a), callSiteArray[337].call((Object)segmentLengthFraction, callSiteArray[338].call(callSiteArray[339].callGetProperty((Object)b), callSiteArray[340].callGetProperty((Object)a)))), callSiteArray[341].call(callSiteArray[342].callGetProperty((Object)a), callSiteArray[343].call((Object)segmentLengthFraction, callSiteArray[344].call(callSiteArray[345].callGetProperty((Object)b), callSiteArray[346].callGetProperty((Object)a)))), callSiteArray[347].call(callSiteArray[348].callGetProperty((Object)a), callSiteArray[349].call((Object)segmentLengthFraction, callSiteArray[350].call(callSiteArray[351].callGetProperty((Object)b), callSiteArray[352].callGetProperty((Object)a))))), Coordinate.class);
                    callSiteArray[353].call(pts, (Object)midPoint);
                    break;
                }
                double cfr_ignored_0 = segmentLength + length;
                int n = i;
                int cfr_ignored_1 = n + 1;
            }
            return DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[354].call((Object)geom));
        }
        double targetSegmentSize = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[355].call((Object)geomLength, callSiteArray[356].call(Math.class, (Object)(geomLength / segmentSizeConstraint))));
        Object[] points = (Coordinate[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[357].call((Object)geom), Coordinate[].class);
        double segmentLength = DefaultTypeTransformation.doubleUnbox((Object)$const$1);
        Object midPoint = null;
        int i = 0;
        while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[358].call(callSiteArray[359].callGetProperty((Object)points), (Object)1))) {
            Coordinate a = (Coordinate)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])points, (int)i), Coordinate.class);
            Coordinate b = (Coordinate)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])points, (int)(i + 1)), Coordinate.class);
            double length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[360].call((Object)a, (Object)b));
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[361].call(Double.class, (Object)length))) {
                length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[362].call((Object)a, (Object)b));
            }
            while (!(length + segmentLength <= targetSegmentSize)) {
                double segmentLengthFraction = (targetSegmentSize - segmentLength) / length;
                Coordinate splitPoint = (Coordinate)ScriptBytecodeAdapter.castToType((Object)callSiteArray[363].callConstructor(Coordinate.class), Coordinate.class);
                Object object = callSiteArray[364].call(callSiteArray[365].callGetProperty((Object)a), callSiteArray[366].call((Object)segmentLengthFraction, callSiteArray[367].call(callSiteArray[368].callGetProperty((Object)b), callSiteArray[369].callGetProperty((Object)a))));
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)splitPoint, (String)"x");
                Object object4 = callSiteArray[370].call(callSiteArray[371].callGetProperty((Object)a), callSiteArray[372].call((Object)segmentLengthFraction, callSiteArray[373].call(callSiteArray[374].callGetProperty((Object)b), callSiteArray[375].callGetProperty((Object)a))));
                ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)splitPoint, (String)"y");
                Object object5 = callSiteArray[376].call(callSiteArray[377].callGetProperty((Object)a), callSiteArray[378].call((Object)segmentLengthFraction, callSiteArray[379].call(callSiteArray[380].callGetProperty((Object)b), callSiteArray[381].callGetProperty((Object)a))));
                ScriptBytecodeAdapter.setProperty((Object)object5, null, (Object)splitPoint, (String)"z");
                if (ScriptBytecodeAdapter.compareEqual((Object)midPoint, null) && !(length + segmentLength <= targetSegmentSize / (double)2)) {
                    segmentLengthFraction = (targetSegmentSize / DefaultTypeTransformation.doubleUnbox((Object)$const$0) - segmentLength) / length;
                    midPoint = callSiteArray[382].callConstructor(Coordinate.class, callSiteArray[383].call(callSiteArray[384].callGetProperty((Object)a), callSiteArray[385].call((Object)segmentLengthFraction, callSiteArray[386].call(callSiteArray[387].callGetProperty((Object)b), callSiteArray[388].callGetProperty((Object)a)))), callSiteArray[389].call(callSiteArray[390].callGetProperty((Object)a), callSiteArray[391].call((Object)segmentLengthFraction, callSiteArray[392].call(callSiteArray[393].callGetProperty((Object)b), callSiteArray[394].callGetProperty((Object)a)))), callSiteArray[395].call(callSiteArray[396].callGetProperty((Object)a), callSiteArray[397].call((Object)segmentLengthFraction, callSiteArray[398].call(callSiteArray[399].callGetProperty((Object)b), callSiteArray[400].callGetProperty((Object)a)))));
                }
                callSiteArray[401].call(pts, midPoint);
                length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[402].call((Object)a, (Object)b));
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[403].call(Double.class, (Object)length))) {
                    length = DefaultTypeTransformation.doubleUnbox((Object)callSiteArray[404].call((Object)a, (Object)b));
                }
                segmentLength = 0.0;
                midPoint = null;
            }
            if (ScriptBytecodeAdapter.compareEqual(midPoint, null) && !(length + segmentLength <= targetSegmentSize / (double)2)) {
                double segmentLengthFraction = (targetSegmentSize / DefaultTypeTransformation.doubleUnbox((Object)$const$0) - segmentLength) / length;
                callSiteArray[405].callConstructor(Coordinate.class, callSiteArray[406].call(callSiteArray[407].callGetProperty((Object)a), callSiteArray[408].call((Object)segmentLengthFraction, callSiteArray[409].call(callSiteArray[410].callGetProperty((Object)b), callSiteArray[411].callGetProperty((Object)a)))), callSiteArray[412].call(callSiteArray[413].callGetProperty((Object)a), callSiteArray[414].call((Object)segmentLengthFraction, callSiteArray[415].call(callSiteArray[416].callGetProperty((Object)b), callSiteArray[417].callGetProperty((Object)a)))), callSiteArray[418].call(callSiteArray[419].callGetProperty((Object)a), callSiteArray[420].call((Object)segmentLengthFraction, callSiteArray[421].call(callSiteArray[422].callGetProperty((Object)b), callSiteArray[423].callGetProperty((Object)a)))));
            }
            double cfr_ignored_2 = segmentLength + length;
            int n = i;
            int cfr_ignored_3 = n + 1;
        }
        if (ScriptBytecodeAdapter.compareNotEqual(midPoint, null)) {
            callSiteArray[424].call(pts, midPoint);
        }
        return targetSegmentSize;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Building_Grid3D.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        CallSite[] callSiteArray = Building_Grid3D.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = bigDecimal2 = new BigDecimal("2.0");
        $const$1 = bigDecimal = new BigDecimal("0.0");
    }

    static {
        Building_Grid3D.__$swapInit();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "plus";
        stringArray[12] = "plus";
        stringArray[13] = "plus";
        stringArray[14] = "plus";
        stringArray[15] = "plus";
        stringArray[16] = "plus";
        stringArray[17] = "plus";
        stringArray[18] = "plus";
        stringArray[19] = "plus";
        stringArray[20] = "plus";
        stringArray[21] = "isEmpty";
        stringArray[22] = "get";
        stringArray[23] = "getStoreNames";
        stringArray[24] = "catalog";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "getStore";
        stringArray[27] = "catalog";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "getDataStore";
        stringArray[30] = "getDataStoreInfo";
        stringArray[31] = "getConnection";
        stringArray[32] = "getDataSource";
        stringArray[33] = "withCloseable";
        stringArray[34] = "openGeoserverDataStoreConnection";
        stringArray[35] = "withCloseable";
        stringArray[36] = "getLogger";
        stringArray[37] = "info";
        stringArray[38] = "info";
        stringArray[39] = "getAt";
        stringArray[40] = "getAt";
        stringArray[41] = "getAt";
        stringArray[42] = "getAt";
        stringArray[43] = "getAt";
        stringArray[44] = "getAt";
        stringArray[45] = "getAt";
        stringArray[46] = "getAt";
        stringArray[47] = "toUpperCase";
        stringArray[48] = "getAt";
        stringArray[49] = "toUpperCase";
        stringArray[50] = "hasField";
        stringArray[51] = "info";
        stringArray[52] = "info";
        stringArray[53] = "hasField";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "execute";
        stringArray[56] = "format";
        stringArray[57] = "getSRID";
        stringArray[58] = "parse";
        stringArray[59] = "getAt";
        stringArray[60] = "getSRID";
        stringArray[61] = "parse";
        stringArray[62] = "getAt";
        stringArray[63] = "getSRID";
        stringArray[64] = "parse";
        stringArray[65] = "getAt";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "read";
        stringArray[68] = "getAt";
        stringArray[69] = "ST_Transform";
        stringArray[70] = "setSRID";
        stringArray[71] = "fence";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "getAt";
        stringArray[74] = "getEnvelope";
        stringArray[75] = "parse";
        stringArray[76] = "getAt";
        stringArray[77] = "getAt";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "read";
        stringArray[80] = "getAt";
        stringArray[81] = "ST_Transform";
        stringArray[82] = "setSRID";
        stringArray[83] = "fence";
        stringArray[84] = "<$constructor$>";
        stringArray[85] = "getAt";
        stringArray[86] = "getEnvelope";
        stringArray[87] = "parse";
        stringArray[88] = "getAt";
        stringArray[89] = "getColumnName";
        stringArray[90] = "getIntegerPrimaryKey";
        stringArray[91] = "parse";
        stringArray[92] = "getDBType";
        stringArray[93] = "info";
        stringArray[94] = "plus";
        stringArray[95] = "execute";
        stringArray[96] = "execute";
        stringArray[97] = "plus";
        stringArray[98] = "plus";
        stringArray[99] = "plus";
        stringArray[100] = "plus";
        stringArray[101] = "plus";
        stringArray[102] = "plus";
        stringArray[103] = "execute";
        stringArray[104] = "execute";
        stringArray[105] = "execute";
        stringArray[106] = "execute";
        stringArray[107] = "execute";
        stringArray[108] = "execute";
        stringArray[109] = "<$constructor$>";
        stringArray[110] = "<$constructor$>";
        stringArray[111] = "withBatch";
        stringArray[112] = "execute";
        stringArray[113] = "execute";
        stringArray[114] = "plus";
        stringArray[115] = "info";
        stringArray[116] = "execute";
        stringArray[117] = "plus";
        stringArray[118] = "plus";
        stringArray[119] = "execute";
        stringArray[120] = "plus";
        stringArray[121] = "plus";
        stringArray[122] = "plus";
        stringArray[123] = "plus";
        stringArray[124] = "plus";
        stringArray[125] = "toInteger";
        stringArray[126] = "execute";
        stringArray[127] = "plus";
        stringArray[128] = "plus";
        stringArray[129] = "getAt";
        stringArray[130] = "info";
        stringArray[131] = "execute";
        stringArray[132] = "plus";
        stringArray[133] = "plus";
        stringArray[134] = "execute";
        stringArray[135] = "plus";
        stringArray[136] = "plus";
        stringArray[137] = "plus";
        stringArray[138] = "plus";
        stringArray[139] = "plus";
        stringArray[140] = "plus";
        stringArray[141] = "info";
        stringArray[142] = "execute";
        stringArray[143] = "plus";
        stringArray[144] = "plus";
        stringArray[145] = "info";
        stringArray[146] = "execute";
        stringArray[147] = "execute";
        stringArray[148] = "execute";
        stringArray[149] = "execute";
        stringArray[150] = "plus";
        stringArray[151] = "plus";
        stringArray[152] = "plus";
        stringArray[153] = "toInteger";
        stringArray[154] = "getAt";
        stringArray[155] = "info";
        stringArray[156] = "execute";
        stringArray[157] = "plus";
        stringArray[158] = "plus";
        stringArray[159] = "execute";
        stringArray[160] = "plus";
        stringArray[161] = "plus";
        stringArray[162] = "plus";
        stringArray[163] = "plus";
        stringArray[164] = "info";
        stringArray[165] = "execute";
        stringArray[166] = "plus";
        stringArray[167] = "plus";
        stringArray[168] = "plus";
        stringArray[169] = "plus";
        stringArray[170] = "plus";
        stringArray[171] = "toInteger";
        stringArray[172] = "execute";
        stringArray[173] = "execute";
        stringArray[174] = "plus";
        stringArray[175] = "plus";
        stringArray[176] = "execute";
        stringArray[177] = "plus";
        stringArray[178] = "plus";
        stringArray[179] = "plus";
        stringArray[180] = "plus";
        stringArray[181] = "plus";
        stringArray[182] = "plus";
        stringArray[183] = "plus";
        stringArray[184] = "plus";
        stringArray[185] = "plus";
        stringArray[186] = "plus";
        stringArray[187] = "execute";
        stringArray[188] = "info";
        stringArray[189] = "execute";
        stringArray[190] = "plus";
        stringArray[191] = "plus";
        stringArray[192] = "plus";
        stringArray[193] = "plus";
        stringArray[194] = "plus";
        stringArray[195] = "plus";
        stringArray[196] = "execute";
        stringArray[197] = "execute";
        stringArray[198] = "execute";
        stringArray[199] = "execute";
        stringArray[200] = "execute";
        stringArray[201] = "plus";
        stringArray[202] = "plus";
        stringArray[203] = "info";
        stringArray[204] = "plus";
        stringArray[205] = "info";
        stringArray[206] = "getLength";
        stringArray[207] = "getCoordinates";
        stringArray[208] = "div";
        stringArray[209] = "minus";
        stringArray[210] = "length";
        stringArray[211] = "getAt";
        stringArray[212] = "getAt";
        stringArray[213] = "plus";
        stringArray[214] = "distance3D";
        stringArray[215] = "plus";
        stringArray[216] = "div";
        stringArray[217] = "minus";
        stringArray[218] = "<$constructor$>";
        stringArray[219] = "plus";
        stringArray[220] = "x";
        stringArray[221] = "multiply";
        stringArray[222] = "minus";
        stringArray[223] = "x";
        stringArray[224] = "x";
        stringArray[225] = "plus";
        stringArray[226] = "y";
        stringArray[227] = "multiply";
        stringArray[228] = "minus";
        stringArray[229] = "y";
        stringArray[230] = "y";
        stringArray[231] = "plus";
        stringArray[232] = "z";
        stringArray[233] = "multiply";
        stringArray[234] = "minus";
        stringArray[235] = "z";
        stringArray[236] = "z";
        stringArray[237] = "add";
        stringArray[238] = "plus";
        stringArray[239] = "next";
        stringArray[240] = "getLength";
        stringArray[241] = "div";
        stringArray[242] = "ceil";
        stringArray[243] = "div";
        stringArray[244] = "getCoordinates";
        stringArray[245] = "minus";
        stringArray[246] = "length";
        stringArray[247] = "getAt";
        stringArray[248] = "getAt";
        stringArray[249] = "plus";
        stringArray[250] = "distance3D";
        stringArray[251] = "isNaN";
        stringArray[252] = "distance";
        stringArray[253] = "plus";
        stringArray[254] = "div";
        stringArray[255] = "minus";
        stringArray[256] = "<$constructor$>";
        stringArray[257] = "plus";
        stringArray[258] = "x";
        stringArray[259] = "multiply";
        stringArray[260] = "minus";
        stringArray[261] = "x";
        stringArray[262] = "x";
        stringArray[263] = "plus";
        stringArray[264] = "y";
        stringArray[265] = "multiply";
        stringArray[266] = "minus";
        stringArray[267] = "y";
        stringArray[268] = "y";
        stringArray[269] = "plus";
        stringArray[270] = "z";
        stringArray[271] = "multiply";
        stringArray[272] = "minus";
        stringArray[273] = "z";
        stringArray[274] = "z";
        stringArray[275] = "plus";
        stringArray[276] = "div";
        stringArray[277] = "div";
        stringArray[278] = "minus";
        stringArray[279] = "div";
        stringArray[280] = "<$constructor$>";
        stringArray[281] = "plus";
        stringArray[282] = "x";
        stringArray[283] = "multiply";
        stringArray[284] = "minus";
        stringArray[285] = "x";
        stringArray[286] = "x";
        stringArray[287] = "plus";
        stringArray[288] = "y";
        stringArray[289] = "multiply";
        stringArray[290] = "minus";
        stringArray[291] = "y";
        stringArray[292] = "y";
        stringArray[293] = "plus";
        stringArray[294] = "z";
        stringArray[295] = "multiply";
        stringArray[296] = "minus";
        stringArray[297] = "z";
        stringArray[298] = "z";
        stringArray[299] = "add";
        stringArray[300] = "distance3D";
        stringArray[301] = "isNaN";
        stringArray[302] = "distance";
        stringArray[303] = "plus";
        stringArray[304] = "div";
        stringArray[305] = "div";
        stringArray[306] = "minus";
        stringArray[307] = "div";
        stringArray[308] = "<$constructor$>";
        stringArray[309] = "plus";
        stringArray[310] = "x";
        stringArray[311] = "multiply";
        stringArray[312] = "minus";
        stringArray[313] = "x";
        stringArray[314] = "x";
        stringArray[315] = "plus";
        stringArray[316] = "y";
        stringArray[317] = "multiply";
        stringArray[318] = "minus";
        stringArray[319] = "y";
        stringArray[320] = "y";
        stringArray[321] = "plus";
        stringArray[322] = "z";
        stringArray[323] = "multiply";
        stringArray[324] = "minus";
        stringArray[325] = "z";
        stringArray[326] = "z";
        stringArray[327] = "plus";
        stringArray[328] = "next";
        stringArray[329] = "add";
        stringArray[330] = "getCoordinates";
        stringArray[331] = "minus";
        stringArray[332] = "length";
        stringArray[333] = "distance3D";
        stringArray[334] = "<$constructor$>";
        stringArray[335] = "plus";
        stringArray[336] = "x";
        stringArray[337] = "multiply";
        stringArray[338] = "minus";
        stringArray[339] = "x";
        stringArray[340] = "x";
        stringArray[341] = "plus";
        stringArray[342] = "y";
        stringArray[343] = "multiply";
        stringArray[344] = "minus";
        stringArray[345] = "y";
        stringArray[346] = "y";
        stringArray[347] = "plus";
        stringArray[348] = "z";
        stringArray[349] = "multiply";
        stringArray[350] = "minus";
        stringArray[351] = "z";
        stringArray[352] = "z";
        stringArray[353] = "add";
        stringArray[354] = "getLength";
        stringArray[355] = "div";
        stringArray[356] = "ceil";
        stringArray[357] = "getCoordinates";
        stringArray[358] = "minus";
        stringArray[359] = "length";
        stringArray[360] = "distance3D";
        stringArray[361] = "isNaN";
        stringArray[362] = "distance";
        stringArray[363] = "<$constructor$>";
        stringArray[364] = "plus";
        stringArray[365] = "x";
        stringArray[366] = "multiply";
        stringArray[367] = "minus";
        stringArray[368] = "x";
        stringArray[369] = "x";
        stringArray[370] = "plus";
        stringArray[371] = "y";
        stringArray[372] = "multiply";
        stringArray[373] = "minus";
        stringArray[374] = "y";
        stringArray[375] = "y";
        stringArray[376] = "plus";
        stringArray[377] = "z";
        stringArray[378] = "multiply";
        stringArray[379] = "minus";
        stringArray[380] = "z";
        stringArray[381] = "z";
        stringArray[382] = "<$constructor$>";
        stringArray[383] = "plus";
        stringArray[384] = "x";
        stringArray[385] = "multiply";
        stringArray[386] = "minus";
        stringArray[387] = "x";
        stringArray[388] = "x";
        stringArray[389] = "plus";
        stringArray[390] = "y";
        stringArray[391] = "multiply";
        stringArray[392] = "minus";
        stringArray[393] = "y";
        stringArray[394] = "y";
        stringArray[395] = "plus";
        stringArray[396] = "z";
        stringArray[397] = "multiply";
        stringArray[398] = "minus";
        stringArray[399] = "z";
        stringArray[400] = "z";
        stringArray[401] = "add";
        stringArray[402] = "distance3D";
        stringArray[403] = "isNaN";
        stringArray[404] = "distance";
        stringArray[405] = "<$constructor$>";
        stringArray[406] = "plus";
        stringArray[407] = "x";
        stringArray[408] = "multiply";
        stringArray[409] = "minus";
        stringArray[410] = "x";
        stringArray[411] = "x";
        stringArray[412] = "plus";
        stringArray[413] = "y";
        stringArray[414] = "multiply";
        stringArray[415] = "minus";
        stringArray[416] = "y";
        stringArray[417] = "y";
        stringArray[418] = "plus";
        stringArray[419] = "z";
        stringArray[420] = "multiply";
        stringArray[421] = "minus";
        stringArray[422] = "z";
        stringArray[423] = "z";
        stringArray[424] = "add";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[425];
        Building_Grid3D.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Building_Grid3D.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Building_Grid3D.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

