/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.wps.Receivers;

import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.sql.Sql;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.h2gis.api.EmptyProgressVisitor;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.functions.spatial.crs.ST_SetSRID;
import org.h2gis.functions.spatial.crs.ST_Transform;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.wrapper.ConnectionWrapper;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.noise_planet.noisemodelling.jdbc.DelaunayReceiversMaker;
import org.noise_planet.noisemodelling.pathfinder.delaunay.LayerDelaunayError;
import org.noise_planet.noisemodelling.pathfinder.utils.profiler.RootProgressVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Delaunay_Grid
extends Script {
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ BigDecimal $const$1;
    private static /* synthetic */ BigDecimal $const$2;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Delaunay_Grid() {
        CallSite[] callSiteArray = Delaunay_Grid.$getCallSiteArray();
    }

    public Delaunay_Grid(Binding context) {
        CallSite[] callSiteArray = Delaunay_Grid.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = Delaunay_Grid.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, Delaunay_Grid.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = Delaunay_Grid.$getCallSiteArray();
        String string = "Delaunay Grid";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, Delaunay_Grid.class, (GroovyObject)this, (String)"title");
        Object object = callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call((Object)"&#10145;&#65039; Computes a <a href=\"https://en.wikipedia.org/wiki/Delaunay_triangulation\" target=\"_blank\">Delaunay</a> grid of receivers.</br>", (Object)"<hr>"), (Object)"The grid will be based on: <ul>"), (Object)"<li> the BUILDINGS table extent (option by default)</li>"), (Object)"<li> <b>OR</b> a single Geometry \"fence\" (Extent filter).</li></ul>"), (Object)"&#x2705; Two tables are returned:<ul>"), (Object)"<li> <b>RECEIVERS</b></li>"), (Object)"<li> <b>TRIANGLES</b></li>"), (Object)"<img src=\"/wps_images/delaunay_grid_output.png\" alt=\"Delaunay grid output\" width=\"95%\" align=\"center\">");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Delaunay_Grid.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"tableBuilding", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Buildings table name", "title", "Buildings table name", "description", callSiteArray[9].call(callSiteArray[10].call((Object)"Name of the Buildings table. </br><br>", (Object)"The table must contain: <ul>"), (Object)"<li> <b> THE_GEOM </b> : the 2D geometry of the building (POLYGON or MULTIPOLYGON)</li></ul>"), "type", String.class}), "fence", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Extent filter", "title", "Extent filter", "description", "Create receivers only in the provided polygon (fence)", "min", 0, "max", 1, "type", Geometry.class}), "sourcesTableName", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Sources table name", "title", "Sources table name", "description", callSiteArray[11].call((Object)"Name of the Road table.</br><br>", (Object)"Receivers will not be created on the specified road width"), "type", String.class}), "maxCellDist", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Maximum cell size", "title", "Maximum cell size", "description", callSiteArray[12].call(callSiteArray[13].call((Object)"Maximum distance used to split the domain into sub-domains (in meters) (FLOAT).</br><br>", (Object)"In a logic of optimization of processing times, it allows to limit the number of objects (buildings, roads, \u2026) stored in memory during the Delaunay triangulation.</br></br>"), (Object)"&#128736; Default value: <b>600 </b>"), "min", 0, "max", 1, "type", Double.class}), "roadWidth", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Road width", "title", "Road width", "description", callSiteArray[14].call(callSiteArray[15].call((Object)"Set Road Width (in meters) (FLOAT).</br> </br>", (Object)"No receivers closer than road width distance will be created.</br> </br>"), (Object)"&#128736; Default value: <b>2 </b>"), "min", 0, "max", 1, "type", Double.class}), "maxArea", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Maximum Area", "title", "Maximum Area", "description", callSiteArray[16].call(callSiteArray[17].call(callSiteArray[18].call((Object)"Set Maximum Area (in m2) (FLOAT).</br> </br>", (Object)"No triangles larger than provided area will be created.</br>"), (Object)"Smaller area will create more receivers.</br> </br> "), (Object)"&#128736; Default value: <b>2500 </b>"), "min", 0, "max", 1, "type", Double.class}), "height", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Height", "title", "Height", "description", callSiteArray[19].call((Object)"Receiver height relative to the ground (in meters) (FLOAT).</br> </br>", (Object)"&#128736; Default value: <b>4 </b>"), "min", 0, "max", 1, "type", Double.class}), "outputTableName", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "outputTableName", "title", "Name of output table", "description", callSiteArray[20].call(callSiteArray[21].call((Object)"Name of the output table.</br> </br>", (Object)"Do not write the name of a table that contains a space.</br> </br>"), (Object)"&#128736; Default value: <b>RECEIVERS </b>"), "min", 0, "max", 1, "type", String.class}), "isoSurfaceInBuildings", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Create IsoSurfaces over buildings", "title", "Create IsoSurfaces over buildings", "description", callSiteArray[22].call((Object)"If enabled, isosurfaces will be visible at the location of buildings </br></br>", (Object)"&#128736; Default value: <b>false </b>"), "min", 0, "max", 1, "type", Boolean.class}), "fenceNegativeBuffer", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Negative buffer", "title", "Negative buffer", "description", callSiteArray[23].call(callSiteArray[24].call((Object)"Reduce the fence(parameter, or sound sources and buildings extent)", (Object)" used to generate receivers positions. You should set here the maximum propagation distance (in meters) (FLOAT).</br> </br>"), (Object)"&#128736; Default value: <b>0 </b>"), "min", 0, "max", 1, "type", Double.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, Delaunay_Grid.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "This type of result does not allow the blocks to be linked together.", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, Delaunay_Grid.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = Delaunay_Grid.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[25].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[26].call(callSiteArray[27].call(callSiteArray[28].callGroovyObjectGetProperty(callSiteArray[29].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call(callSiteArray[31].callGroovyObjectGetProperty(callSiteArray[32].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].call(callSiteArray[34].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].call(callSiteArray[36].call((Object)jdbcDataStore)), Connection.class);
    }

    public Object run(Object input) {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure1(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = Delaunay_Grid.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[37].call(callSiteArray[38].callStatic(Delaunay_Grid.class, (Object)dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
        }
        return callSiteArray[39].call((Object)Delaunay_Grid.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
    }

    public Object exec(Connection connection, Object input) {
        CallSite[] callSiteArray = Delaunay_Grid.$getCallSiteArray();
        String resultString = null;
        Logger logger = (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[40].call(LoggerFactory.class, (Object)"org.noise_planet.noisemodelling"), Logger.class);
        callSiteArray[41].call((Object)logger, (Object)"Start : Delaunay grid");
        callSiteArray[42].call((Object)logger, (Object)"inputs {}", input);
        String receivers_table_name = "RECEIVERS";
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[43].call(input, (Object)"outputTableName"))) {
            receivers_table_name = ShortTypeHandling.castToString((Object)callSiteArray[44].call(input, (Object)"outputTableName"));
        }
        receivers_table_name = ShortTypeHandling.castToString((Object)callSiteArray[45].call((Object)receivers_table_name));
        String sources_table_name = "SOURCES";
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[46].call(input, (Object)"sourcesTableName"))) {
            return "Source table must be specified";
        }
        sources_table_name = ShortTypeHandling.castToString((Object)callSiteArray[47].call(input, (Object)"sourcesTableName"));
        sources_table_name = ShortTypeHandling.castToString((Object)callSiteArray[48].call((Object)sources_table_name));
        String building_table_name = "BUILDINGS";
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[49].call(input, (Object)"tableBuilding"))) {
            building_table_name = ShortTypeHandling.castToString((Object)callSiteArray[50].call(input, (Object)"tableBuilding"));
        }
        building_table_name = ShortTypeHandling.castToString((Object)callSiteArray[51].call((Object)building_table_name));
        boolean isoSurfaceInBuildings = false;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[52].call(input, (Object)"isoSurfaceInBuildings)"))) {
            isoSurfaceInBuildings = DefaultTypeTransformation.booleanUnbox((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[53].call(input, (Object)"isoSurfaceInBuildings"), Boolean.class)));
        }
        Double maxCellDist = (Double)ScriptBytecodeAdapter.castToType((Object)$const$0, Double.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[54].call(input, (Object)"maxCellDist"))) {
            maxCellDist = (Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[55].call(input, (Object)"maxCellDist"), Double.class);
        }
        Double height = (Double)ScriptBytecodeAdapter.castToType((Object)$const$1, Double.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[56].call(input, (Object)"height"))) {
            height = (Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[57].call(input, (Object)"height"), Double.class);
        }
        Double roadWidth = (Double)ScriptBytecodeAdapter.castToType((Object)$const$2, Double.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].call(input, (Object)"roadWidth"))) {
            roadWidth = (Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[59].call(input, (Object)"roadWidth"), Double.class);
        }
        Double maxArea = (Double)ScriptBytecodeAdapter.castToType((Object)2500, Double.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].call(input, (Object)"maxArea"))) {
            maxArea = (Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[61].call(input, (Object)"maxArea"), Double.class);
        }
        int srid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[62].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[63].call(TableLocation.class, (Object)building_table_name)));
        Geometry fence = null;
        WKTReader wktReader = (WKTReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].callConstructor(WKTReader.class), WKTReader.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[65].call(input, (Object)"fence"))) {
            fence = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[66].call((Object)wktReader, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[67].call(input, (Object)"fence"), String.class)), String.class)), Geometry.class);
        }
        Sql sql = (Sql)ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].callConstructor(Sql.class, (Object)connection), Sql.class);
        connection = (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].callConstructor(ConnectionWrapper.class, (Object)connection), Connection.class);
        RootProgressVisitor progressLogger = (RootProgressVisitor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].callConstructor(RootProgressVisitor.class, (Object)1, (Object)true, (Object)1), RootProgressVisitor.class);
        callSiteArray[71].call((Object)sql, callSiteArray[72].call(String.class, (Object)"DROP TABLE IF EXISTS %s", (Object)receivers_table_name));
        callSiteArray[73].call((Object)sql, (Object)"DROP TABLE IF EXISTS TRIANGLES");
        DelaunayReceiversMaker delaunayReceiversMaker = (DelaunayReceiversMaker)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].callConstructor(DelaunayReceiversMaker.class, (Object)building_table_name, (Object)sources_table_name), DelaunayReceiversMaker.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)fence, null)) {
            int targetSrid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[75].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[76].call(TableLocation.class, (Object)building_table_name)));
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (targetSrid == 0) {
                    targetSrid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[77].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[78].call(TableLocation.class, (Object)sources_table_name)));
                }
            } else if (targetSrid == 0) {
                targetSrid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[79].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[80].call(TableLocation.class, (Object)sources_table_name)));
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (targetSrid != 0) {
                    fence = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].call(ST_Transform.class, (Object)connection, callSiteArray[82].call(ST_SetSRID.class, (Object)fence, (Object)4326), (Object)targetSrid), Geometry.class);
                    callSiteArray[83].call((Object)delaunayReceiversMaker, callSiteArray[84].call((Object)fence));
                } else {
                    callSiteArray[85].call(callSiteArray[86].callGetProperty(System.class), (Object)"Unable to find buildings or sources SRID, ignore fence parameters");
                }
            } else if (targetSrid != 0) {
                fence = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[87].call(ST_Transform.class, (Object)connection, callSiteArray[88].call(ST_SetSRID.class, (Object)fence, (Object)4326), (Object)targetSrid), Geometry.class);
                callSiteArray[89].call((Object)delaunayReceiversMaker, callSiteArray[90].call((Object)fence));
            } else {
                callSiteArray[91].call(callSiteArray[92].callGetProperty(System.class), (Object)"Unable to find buildings or sources SRID, ignore fence parameters");
            }
        }
        callSiteArray[93].call((Object)delaunayReceiversMaker, (Object)maxCellDist);
        callSiteArray[94].call((Object)delaunayReceiversMaker, (Object)height);
        callSiteArray[95].call((Object)delaunayReceiversMaker, (Object)roadWidth);
        callSiteArray[96].call((Object)delaunayReceiversMaker, (Object)maxArea);
        callSiteArray[97].call((Object)delaunayReceiversMaker, (Object)isoSurfaceInBuildings);
        callSiteArray[98].call((Object)logger, (Object)"Delaunay initialize");
        callSiteArray[99].call((Object)delaunayReceiversMaker, (Object)connection, callSiteArray[100].callConstructor(EmptyProgressVisitor.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[101].call(input, (Object)"fenceNegativeBuffer"))) {
            double negativeBuffer = (Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[102].call(input, (Object)"fenceNegativeBuffer"), Double.class);
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigD() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (!(negativeBuffer <= 0.0)) {
                    Envelope envelope = (Envelope)ScriptBytecodeAdapter.castToType((Object)callSiteArray[103].call((Object)delaunayReceiversMaker), Envelope.class);
                    callSiteArray[104].call((Object)envelope, ScriptBytecodeAdapter.unaryMinus((Object)negativeBuffer));
                    callSiteArray[105].call((Object)delaunayReceiversMaker, (Object)envelope);
                }
            } else if (!(negativeBuffer <= 0.0)) {
                Envelope envelope = (Envelope)ScriptBytecodeAdapter.castToType((Object)callSiteArray[106].call((Object)delaunayReceiversMaker), Envelope.class);
                callSiteArray[107].call((Object)envelope, ScriptBytecodeAdapter.unaryMinus((Object)negativeBuffer));
                callSiteArray[108].call((Object)delaunayReceiversMaker, (Object)envelope);
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[109].call(input, (Object)"errorDumpFolder"))) {
            callSiteArray[110].call((Object)delaunayReceiversMaker, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[111].call(input, (Object)"errorDumpFolder"), String.class)), String.class));
        }
        AtomicInteger pk = (AtomicInteger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[112].callConstructor(AtomicInteger.class, (Object)0), AtomicInteger.class);
        ProgressVisitor progressVisitorNM = (ProgressVisitor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[113].call((Object)progressLogger, callSiteArray[114].call(callSiteArray[115].call((Object)delaunayReceiversMaker), callSiteArray[116].call((Object)delaunayReceiversMaker))), ProgressVisitor.class);
        try {
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                int i = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[117].call((Object)delaunayReceiversMaker))) {
                    int j = 0;
                    while (ScriptBytecodeAdapter.compareLessThan((Object)j, (Object)callSiteArray[118].call((Object)delaunayReceiversMaker))) {
                        callSiteArray[119].call((Object)logger, callSiteArray[120].call(callSiteArray[121].call(callSiteArray[122].call((Object)"Compute cell ", callSiteArray[123].call(callSiteArray[124].call(callSiteArray[125].call((Object)i, callSiteArray[126].call((Object)delaunayReceiversMaker)), (Object)j), (Object)1)), (Object)" of "), callSiteArray[127].call(callSiteArray[128].call((Object)delaunayReceiversMaker), callSiteArray[129].call((Object)delaunayReceiversMaker))));
                        callSiteArray[130].call((Object)delaunayReceiversMaker, ArrayUtil.createArray((Object)connection, (Object)i, (Object)j, (Object)receivers_table_name, (Object)"TRIANGLES", (Object)pk));
                        callSiteArray[131].call((Object)progressVisitorNM);
                        int n = j;
                        j = DefaultTypeTransformation.intUnbox((Object)callSiteArray[132].call((Object)n));
                    }
                    int n = i;
                    i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[133].call((Object)n));
                }
            } else {
                int i = 0;
                while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[134].call((Object)delaunayReceiversMaker))) {
                    int j = 0;
                    while (ScriptBytecodeAdapter.compareLessThan((Object)j, (Object)callSiteArray[135].call((Object)delaunayReceiversMaker))) {
                        callSiteArray[136].call((Object)logger, callSiteArray[137].call(callSiteArray[138].call(callSiteArray[139].call((Object)"Compute cell ", callSiteArray[140].call(callSiteArray[141].call(callSiteArray[142].call((Object)i, callSiteArray[143].call((Object)delaunayReceiversMaker)), (Object)j), (Object)1)), (Object)" of "), callSiteArray[144].call(callSiteArray[145].call((Object)delaunayReceiversMaker), callSiteArray[146].call((Object)delaunayReceiversMaker))));
                        callSiteArray[147].call((Object)delaunayReceiversMaker, ArrayUtil.createArray((Object)connection, (Object)i, (Object)j, (Object)receivers_table_name, (Object)"TRIANGLES", (Object)pk));
                        callSiteArray[148].call((Object)progressVisitorNM);
                        int n = j;
                        int cfr_ignored_0 = n + 1;
                    }
                    int n = i;
                    int cfr_ignored_1 = n + 1;
                }
            }
        }
        catch (LayerDelaunayError ex) {
            callSiteArray[149].call((Object)logger, callSiteArray[150].call((Object)"Got an error use the errorDumpFolder parameter with a folder path in order to save the ", (Object)"input geometries for debugging purpose"));
            throw (Throwable)ex;
        }
        callSiteArray[151].call((Object)logger, callSiteArray[152].call(callSiteArray[153].call((Object)"Create spatial index on ", (Object)receivers_table_name), (Object)" table"));
        callSiteArray[154].call((Object)sql, callSiteArray[155].call(callSiteArray[156].call((Object)"Create spatial index on ", (Object)receivers_table_name), (Object)"(the_geom);"));
        int nbReceivers = (Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[157].call(callSiteArray[158].call((Object)sql, callSiteArray[159].call((Object)"SELECT COUNT(*) FROM ", (Object)receivers_table_name)), (Object)0), Integer.class);
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[160].call(callSiteArray[161].call(callSiteArray[162].call(callSiteArray[163].call((Object)"Process done. ", (Object)receivers_table_name), (Object)" ("), (Object)nbReceivers), (Object)" receivers) and TRIANGLES tables created. "));
        callSiteArray[164].call((Object)logger, callSiteArray[165].call((Object)"Result : ", (Object)resultString));
        callSiteArray[166].call((Object)logger, (Object)"End : Delaunay grid");
        return resultString;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Delaunay_Grid.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3;
        CallSite[] callSiteArray = Delaunay_Grid.$getCallSiteArray();
        $callSiteArray = null;
        $const$0 = bigDecimal3 = new BigDecimal("600.0");
        $const$1 = bigDecimal2 = new BigDecimal("4.0");
        $const$2 = bigDecimal = new BigDecimal("2.0");
    }

    static {
        Delaunay_Grid.__$swapInit();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "plus";
        stringArray[12] = "plus";
        stringArray[13] = "plus";
        stringArray[14] = "plus";
        stringArray[15] = "plus";
        stringArray[16] = "plus";
        stringArray[17] = "plus";
        stringArray[18] = "plus";
        stringArray[19] = "plus";
        stringArray[20] = "plus";
        stringArray[21] = "plus";
        stringArray[22] = "plus";
        stringArray[23] = "plus";
        stringArray[24] = "plus";
        stringArray[25] = "isEmpty";
        stringArray[26] = "get";
        stringArray[27] = "getStoreNames";
        stringArray[28] = "catalog";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "getStore";
        stringArray[31] = "catalog";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "getDataStore";
        stringArray[34] = "getDataStoreInfo";
        stringArray[35] = "getConnection";
        stringArray[36] = "getDataSource";
        stringArray[37] = "withCloseable";
        stringArray[38] = "openGeoserverDataStoreConnection";
        stringArray[39] = "withCloseable";
        stringArray[40] = "getLogger";
        stringArray[41] = "info";
        stringArray[42] = "info";
        stringArray[43] = "getAt";
        stringArray[44] = "getAt";
        stringArray[45] = "toUpperCase";
        stringArray[46] = "getAt";
        stringArray[47] = "getAt";
        stringArray[48] = "toUpperCase";
        stringArray[49] = "getAt";
        stringArray[50] = "getAt";
        stringArray[51] = "toUpperCase";
        stringArray[52] = "getAt";
        stringArray[53] = "getAt";
        stringArray[54] = "getAt";
        stringArray[55] = "getAt";
        stringArray[56] = "getAt";
        stringArray[57] = "getAt";
        stringArray[58] = "getAt";
        stringArray[59] = "getAt";
        stringArray[60] = "containsKey";
        stringArray[61] = "getAt";
        stringArray[62] = "getSRID";
        stringArray[63] = "parse";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "getAt";
        stringArray[66] = "read";
        stringArray[67] = "getAt";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "<$constructor$>";
        stringArray[71] = "execute";
        stringArray[72] = "format";
        stringArray[73] = "execute";
        stringArray[74] = "<$constructor$>";
        stringArray[75] = "getSRID";
        stringArray[76] = "parse";
        stringArray[77] = "getSRID";
        stringArray[78] = "parse";
        stringArray[79] = "getSRID";
        stringArray[80] = "parse";
        stringArray[81] = "ST_Transform";
        stringArray[82] = "setSRID";
        stringArray[83] = "setMainEnvelope";
        stringArray[84] = "getEnvelopeInternal";
        stringArray[85] = "println";
        stringArray[86] = "err";
        stringArray[87] = "ST_Transform";
        stringArray[88] = "setSRID";
        stringArray[89] = "setMainEnvelope";
        stringArray[90] = "getEnvelopeInternal";
        stringArray[91] = "println";
        stringArray[92] = "err";
        stringArray[93] = "setMaximumPropagationDistance";
        stringArray[94] = "setReceiverHeight";
        stringArray[95] = "setRoadWidth";
        stringArray[96] = "setMaximumArea";
        stringArray[97] = "setIsoSurfaceInBuildings";
        stringArray[98] = "info";
        stringArray[99] = "initialize";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "containsKey";
        stringArray[102] = "getAt";
        stringArray[103] = "getMainEnvelope";
        stringArray[104] = "expandBy";
        stringArray[105] = "setMainEnvelope";
        stringArray[106] = "getMainEnvelope";
        stringArray[107] = "expandBy";
        stringArray[108] = "setMainEnvelope";
        stringArray[109] = "getAt";
        stringArray[110] = "setExceptionDumpFolder";
        stringArray[111] = "getAt";
        stringArray[112] = "<$constructor$>";
        stringArray[113] = "subProcess";
        stringArray[114] = "multiply";
        stringArray[115] = "getGridDim";
        stringArray[116] = "getGridDim";
        stringArray[117] = "getGridDim";
        stringArray[118] = "getGridDim";
        stringArray[119] = "info";
        stringArray[120] = "plus";
        stringArray[121] = "plus";
        stringArray[122] = "plus";
        stringArray[123] = "plus";
        stringArray[124] = "plus";
        stringArray[125] = "multiply";
        stringArray[126] = "getGridDim";
        stringArray[127] = "multiply";
        stringArray[128] = "getGridDim";
        stringArray[129] = "getGridDim";
        stringArray[130] = "generateReceivers";
        stringArray[131] = "endStep";
        stringArray[132] = "next";
        stringArray[133] = "next";
        stringArray[134] = "getGridDim";
        stringArray[135] = "getGridDim";
        stringArray[136] = "info";
        stringArray[137] = "plus";
        stringArray[138] = "plus";
        stringArray[139] = "plus";
        stringArray[140] = "plus";
        stringArray[141] = "plus";
        stringArray[142] = "multiply";
        stringArray[143] = "getGridDim";
        stringArray[144] = "multiply";
        stringArray[145] = "getGridDim";
        stringArray[146] = "getGridDim";
        stringArray[147] = "generateReceivers";
        stringArray[148] = "endStep";
        stringArray[149] = "error";
        stringArray[150] = "plus";
        stringArray[151] = "info";
        stringArray[152] = "plus";
        stringArray[153] = "plus";
        stringArray[154] = "execute";
        stringArray[155] = "plus";
        stringArray[156] = "plus";
        stringArray[157] = "getAt";
        stringArray[158] = "firstRow";
        stringArray[159] = "plus";
        stringArray[160] = "plus";
        stringArray[161] = "plus";
        stringArray[162] = "plus";
        stringArray[163] = "plus";
        stringArray[164] = "info";
        stringArray[165] = "plus";
        stringArray[166] = "info";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[167];
        Delaunay_Grid.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Delaunay_Grid.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Delaunay_Grid.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

