/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.wps.Receivers;

import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.sql.Sql;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.h2gis.functions.spatial.crs.ST_SetSRID;
import org.h2gis.functions.spatial.crs.ST_Transform;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.TableLocation;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Random_Grid
extends Script {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Random_Grid() {
        CallSite[] callSiteArray = Random_Grid.$getCallSiteArray();
    }

    public Random_Grid(Binding context) {
        CallSite[] callSiteArray = Random_Grid.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = Random_Grid.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, Random_Grid.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = Random_Grid.$getCallSiteArray();
        String string = "Random Grid";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, Random_Grid.class, (GroovyObject)this, (String)"title");
        Object object = callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call((Object)"&#10145;&#65039; Computes a random grid of receivers.</br>", (Object)"<hr>"), (Object)"&#x2705; The output table is called <b>RECEIVERS</b> </br></br>"), (Object)"<img src=\"/wps_images/receivers_random_output.png\" alt=\"Random grid output\" width=\"95%\" align=\"center\">");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Random_Grid.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"buildingTableName", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Buildings table name", "title", "Buildings table name", "description", callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call((Object)"Name of the Buildings table </br> </br>", (Object)"The table must contain: <ul>"), (Object)"<li> <b>THE_GEOM</b>: the 2D geometry of the building (POLYGON or MULTIPOLYGON)</li>"), (Object)"<li> <b>HEIGHT</b>: the height of the building (FLOAT)</li></ul>"), "type", String.class}), "sourcesTableName", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Sources table name", "title", "Sources table name", "description", callSiteArray[7].call(callSiteArray[8].call((Object)"Keep only receivers at least at 1 meters of provided sources geometries </br> </br>", (Object)"The table must contain : <ul>"), (Object)"<li> <b>THE_GEOM</b>: any geometry type. </li></ul>"), "type", String.class}), "nReceivers", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Number of receivers", "title", "Number of receivers", "description", callSiteArray[9].call(callSiteArray[10].call((Object)"Number of receivers to return </br> </br>", (Object)"&#128736; Default value: <b>100</b> </br> </br>"), (Object)"<img src=\"/wps_images/receivers_random_nReceivers.png\" alt=\"Number of receivers\" width=\"95%\" align=\"center\">"), "type", Integer.class}), "height", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Height", "title", "Height", "description", callSiteArray[11].call((Object)"Height of receivers (in meters) (FLOAT)</br> </br>", (Object)"&#128736; Default value: <b>4 </b> "), "min", 0, "max", 1, "type", Double.class}), "fence", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Fence geometry", "title", "Extent filter", "description", callSiteArray[12].call((Object)"Create receivers only in the provided polygon. </br> </br>", (Object)"Must be in the WGS84 (EPSG:4326) projection system"), "min", 0, "max", 1, "type", Geometry.class}), "fenceTableName", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Fence geometry from table", "title", "Filter using table bounding box", "description", callSiteArray[13].call(callSiteArray[14].call((Object)"Extract the bounding box of the specified table then create only receivers on the table bounding box. </br> </br>", (Object)"The table must contain : <ul>"), (Object)"<li> <b>THE_GEOM</b>: any geometry type. </li></ul>"), "min", 0, "max", 1, "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, Random_Grid.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "This type of result does not allow the blocks to be linked together.", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, Random_Grid.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = Random_Grid.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[16].call(callSiteArray[17].call(callSiteArray[18].callGroovyObjectGetProperty(callSiteArray[19].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].call(callSiteArray[21].callGroovyObjectGetProperty(callSiteArray[22].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].call(callSiteArray[24].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].call(callSiteArray[26].call((Object)jdbcDataStore)), Connection.class);
    }

    public Object run(Object input) {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure1(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = Random_Grid.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[27].call(callSiteArray[28].callStatic(Random_Grid.class, (Object)dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
        }
        return callSiteArray[29].call((Object)Random_Grid.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object exec(Connection connection, Object input) {
        CallSite[] callSiteArray = Random_Grid.$getCallSiteArray();
        String resultString = null;
        Logger logger = (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call(LoggerFactory.class, (Object)"org.noise_planet.noisemodelling"), Logger.class);
        callSiteArray[31].call((Object)logger, (Object)"Start : Random grid");
        callSiteArray[32].call((Object)logger, (Object)"inputs {}", input);
        String receivers_table_name = "RECEIVERS";
        Integer nReceivers = 100;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[33].call(input, (Object)"nReceivers"))) {
            nReceivers = (Integer)ScriptBytecodeAdapter.asType((Object)callSiteArray[34].call(input, (Object)"nReceivers"), Integer.class);
        }
        Double h = 4.0;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].call(input, (Object)"height"))) {
            h = (Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[36].call(input, (Object)"height"), Double.class);
        }
        String sources_table_name = "SOURCES";
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[37].call(input, (Object)"sourcesTableName"))) {
            sources_table_name = ShortTypeHandling.castToString((Object)callSiteArray[38].call(input, (Object)"sourcesTableName"));
        }
        sources_table_name = ShortTypeHandling.castToString((Object)callSiteArray[39].call((Object)sources_table_name));
        String building_table_name = ShortTypeHandling.castToString((Object)callSiteArray[40].call(input, (Object)"buildingTableName"));
        building_table_name = ShortTypeHandling.castToString((Object)callSiteArray[41].call((Object)building_table_name));
        Sql sql = (Sql)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].callConstructor(Sql.class, (Object)connection), Sql.class);
        int targetSrid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[43].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[44].call(TableLocation.class, (Object)building_table_name)));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (targetSrid == 0 && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[45].call(input, (Object)"sourcesTableName"))) {
                targetSrid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[46].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[47].call(TableLocation.class, (Object)sources_table_name)));
            }
        } else if (targetSrid == 0 && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].call(input, (Object)"sourcesTableName"))) {
            targetSrid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[49].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[50].call(TableLocation.class, (Object)sources_table_name)));
        }
        Geometry fenceGeom = null;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[51].call(input, (Object)"fence"))) {
                if (!(targetSrid != 0)) throw (Throwable)callSiteArray[58].callConstructor(Exception.class, (Object)"Unable to find buildings or sources SRID, ignore fence parameters");
                WKTReader wktReader = (WKTReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[52].callConstructor(WKTReader.class), WKTReader.class);
                Object object = callSiteArray[53].call((Object)wktReader, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[54].call(input, (Object)"fence"), String.class)), String.class));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Random_Grid.class, (GroovyObject)this, (String)"fence");
                fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].call(ST_Transform.class, (Object)connection, callSiteArray[56].call(ST_SetSRID.class, callSiteArray[57].callGroovyObjectGetProperty((Object)this), (Object)4326), (Object)targetSrid), Geometry.class);
            } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[59].call(input, (Object)"fenceTableName"))) {
                fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[61].call(TableLocation.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[62].call(input, (Object)"fenceTableName"), String.class)), String.class)), (Object)"THE_GEOM"), Geometry.class);
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[63].call(input, (Object)"fence"))) {
            if (!(targetSrid != 0)) throw (Throwable)callSiteArray[70].callConstructor(Exception.class, (Object)"Unable to find buildings or sources SRID, ignore fence parameters");
            WKTReader wktReader = (WKTReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].callConstructor(WKTReader.class), WKTReader.class);
            Object object = callSiteArray[65].call((Object)wktReader, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[66].call(input, (Object)"fence"), String.class)), String.class));
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Random_Grid.class, (GroovyObject)this, (String)"fence");
            fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[67].call(ST_Transform.class, (Object)connection, callSiteArray[68].call(ST_SetSRID.class, callSiteArray[69].callGroovyObjectGetProperty((Object)this), (Object)4326), (Object)targetSrid), Geometry.class);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[71].call(input, (Object)"fenceTableName"))) {
            fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[73].call(TableLocation.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[74].call(input, (Object)"fenceTableName"), String.class)), String.class)), (Object)"THE_GEOM"), Geometry.class);
        }
        callSiteArray[75].call((Object)sql, callSiteArray[76].call(String.class, (Object)"DROP TABLE IF EXISTS %s", (Object)receivers_table_name));
        String filter_geom_query = "";
        Envelope envelope = null;
        if (ScriptBytecodeAdapter.compareEqual(fenceGeom, null)) {
            envelope = (Envelope)ScriptBytecodeAdapter.castToType((Object)callSiteArray[77].call(callSiteArray[78].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[79].call(TableLocation.class, (Object)sources_table_name), (Object)"THE_GEOM")), Envelope.class);
            callSiteArray[80].call((Object)envelope, callSiteArray[81].call(callSiteArray[82].call(GeometryTableUtilities.class, (Object)connection, callSiteArray[83].call(TableLocation.class, (Object)building_table_name), (Object)"THE_GEOM")));
        } else {
            envelope = (Envelope)ScriptBytecodeAdapter.castToType((Object)callSiteArray[84].callGetProperty((Object)fenceGeom), Envelope.class);
        }
        callSiteArray[85].call((Object)sql, callSiteArray[86].call(callSiteArray[87].call(callSiteArray[88].call(callSiteArray[89].call(callSiteArray[90].call(callSiteArray[91].call(callSiteArray[92].call(callSiteArray[93].call(callSiteArray[94].call(callSiteArray[95].call(callSiteArray[96].call(callSiteArray[97].call(callSiteArray[98].call(callSiteArray[99].call(callSiteArray[100].call(callSiteArray[101].call(callSiteArray[102].call(callSiteArray[103].call(callSiteArray[104].call(callSiteArray[105].call((Object)"create table ", (Object)receivers_table_name), (Object)" as select ST_SetSRID(ST_MAKEPOINT(RAND()*("), callSiteArray[106].callGetProperty((Object)envelope)), (Object)" - "), callSiteArray[107].call(callSiteArray[108].callGetProperty((Object)envelope))), (Object)") + "), callSiteArray[109].call(callSiteArray[110].callGetProperty((Object)envelope))), (Object)", RAND()*("), callSiteArray[111].call(callSiteArray[112].callGetProperty((Object)envelope))), (Object)" - "), callSiteArray[113].call(callSiteArray[114].callGetProperty((Object)envelope))), (Object)") + "), callSiteArray[115].call(callSiteArray[116].callGetProperty((Object)envelope))), (Object)", "), (Object)h), (Object)"), "), callSiteArray[117].call((Object)targetSrid)), (Object)") as the_geom from system_range(0,"), callSiteArray[118].call((Object)nReceivers)), (Object)");"));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[119].call(input, (Object)"fence"))) {
            callSiteArray[120].call((Object)sql, callSiteArray[121].call(callSiteArray[122].call((Object)"DELETE FROM ", (Object)receivers_table_name), (Object)" WHERE NOT ST_Intersects(THE_GEOM, :geom)"), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"geom", fenceGeom}));
        }
        callSiteArray[123].call((Object)logger, callSiteArray[124].call((Object)"Create spatial index on ", (Object)receivers_table_name));
        callSiteArray[125].call((Object)sql, callSiteArray[126].call(callSiteArray[127].call((Object)"Create spatial index on ", (Object)receivers_table_name), (Object)"(the_geom);"));
        callSiteArray[128].call((Object)logger, (Object)"Delete receivers where buildings...");
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[129].call(input, (Object)"buildingTableName"))) {
            callSiteArray[130].call((Object)sql, callSiteArray[131].call(callSiteArray[132].call(callSiteArray[133].call(callSiteArray[134].call(callSiteArray[135].call(callSiteArray[136].call((Object)"delete from ", (Object)receivers_table_name), (Object)" g where exists (select 1 from "), (Object)building_table_name), (Object)" b where g.the_geom && b.the_geom and ST_distance(b.the_geom, g.the_geom) < 1 and b.height >= "), (Object)h), (Object)" limit 1);"));
        }
        callSiteArray[137].call((Object)logger, (Object)"Delete receivers where sound sources...");
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[138].call(input, (Object)"sourcesTableName"))) {
            callSiteArray[139].call((Object)sql, callSiteArray[140].call(callSiteArray[141].call(callSiteArray[142].call(callSiteArray[143].call((Object)"delete from ", (Object)receivers_table_name), (Object)" g where exists (select 1 from "), (Object)sources_table_name), (Object)" r where st_expand(g.the_geom, 1) && r.the_geom and st_distance(g.the_geom, r.the_geom) < 1 limit 1);"));
        }
        callSiteArray[144].call((Object)logger, (Object)"Add Primary Key column...");
        callSiteArray[145].call((Object)sql, callSiteArray[146].call(callSiteArray[147].call((Object)"ALTER TABLE ", (Object)receivers_table_name), (Object)" ADD pk INT AUTO_INCREMENT PRIMARY KEY;"));
        resultString = ShortTypeHandling.castToString((Object)callSiteArray[148].call(callSiteArray[149].call((Object)"Process done. Table of receivers ", (Object)receivers_table_name), (Object)" created !"));
        callSiteArray[150].call((Object)logger, callSiteArray[151].call((Object)"Result : ", (Object)resultString));
        callSiteArray[152].call((Object)logger, (Object)"End : Random grid");
        return resultString;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Random_Grid.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "plus";
        stringArray[12] = "plus";
        stringArray[13] = "plus";
        stringArray[14] = "plus";
        stringArray[15] = "isEmpty";
        stringArray[16] = "get";
        stringArray[17] = "getStoreNames";
        stringArray[18] = "catalog";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "getStore";
        stringArray[21] = "catalog";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "getDataStore";
        stringArray[24] = "getDataStoreInfo";
        stringArray[25] = "getConnection";
        stringArray[26] = "getDataSource";
        stringArray[27] = "withCloseable";
        stringArray[28] = "openGeoserverDataStoreConnection";
        stringArray[29] = "withCloseable";
        stringArray[30] = "getLogger";
        stringArray[31] = "info";
        stringArray[32] = "info";
        stringArray[33] = "getAt";
        stringArray[34] = "getAt";
        stringArray[35] = "getAt";
        stringArray[36] = "getAt";
        stringArray[37] = "getAt";
        stringArray[38] = "getAt";
        stringArray[39] = "toUpperCase";
        stringArray[40] = "getAt";
        stringArray[41] = "toUpperCase";
        stringArray[42] = "<$constructor$>";
        stringArray[43] = "getSRID";
        stringArray[44] = "parse";
        stringArray[45] = "getAt";
        stringArray[46] = "getSRID";
        stringArray[47] = "parse";
        stringArray[48] = "getAt";
        stringArray[49] = "getSRID";
        stringArray[50] = "parse";
        stringArray[51] = "getAt";
        stringArray[52] = "<$constructor$>";
        stringArray[53] = "read";
        stringArray[54] = "getAt";
        stringArray[55] = "ST_Transform";
        stringArray[56] = "setSRID";
        stringArray[57] = "fence";
        stringArray[58] = "<$constructor$>";
        stringArray[59] = "getAt";
        stringArray[60] = "getEnvelope";
        stringArray[61] = "parse";
        stringArray[62] = "getAt";
        stringArray[63] = "getAt";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "read";
        stringArray[66] = "getAt";
        stringArray[67] = "ST_Transform";
        stringArray[68] = "setSRID";
        stringArray[69] = "fence";
        stringArray[70] = "<$constructor$>";
        stringArray[71] = "getAt";
        stringArray[72] = "getEnvelope";
        stringArray[73] = "parse";
        stringArray[74] = "getAt";
        stringArray[75] = "execute";
        stringArray[76] = "format";
        stringArray[77] = "getEnvelopeInternal";
        stringArray[78] = "getEnvelope";
        stringArray[79] = "parse";
        stringArray[80] = "expandToInclude";
        stringArray[81] = "getEnvelopeInternal";
        stringArray[82] = "getEnvelope";
        stringArray[83] = "parse";
        stringArray[84] = "envelopeInternal";
        stringArray[85] = "execute";
        stringArray[86] = "plus";
        stringArray[87] = "plus";
        stringArray[88] = "plus";
        stringArray[89] = "plus";
        stringArray[90] = "plus";
        stringArray[91] = "plus";
        stringArray[92] = "plus";
        stringArray[93] = "plus";
        stringArray[94] = "plus";
        stringArray[95] = "plus";
        stringArray[96] = "plus";
        stringArray[97] = "plus";
        stringArray[98] = "plus";
        stringArray[99] = "plus";
        stringArray[100] = "plus";
        stringArray[101] = "plus";
        stringArray[102] = "plus";
        stringArray[103] = "plus";
        stringArray[104] = "plus";
        stringArray[105] = "plus";
        stringArray[106] = "maxX";
        stringArray[107] = "toString";
        stringArray[108] = "minX";
        stringArray[109] = "toString";
        stringArray[110] = "minX";
        stringArray[111] = "toString";
        stringArray[112] = "maxY";
        stringArray[113] = "toString";
        stringArray[114] = "minY";
        stringArray[115] = "toString";
        stringArray[116] = "minY";
        stringArray[117] = "toInteger";
        stringArray[118] = "toString";
        stringArray[119] = "getAt";
        stringArray[120] = "execute";
        stringArray[121] = "plus";
        stringArray[122] = "plus";
        stringArray[123] = "info";
        stringArray[124] = "plus";
        stringArray[125] = "execute";
        stringArray[126] = "plus";
        stringArray[127] = "plus";
        stringArray[128] = "info";
        stringArray[129] = "getAt";
        stringArray[130] = "execute";
        stringArray[131] = "plus";
        stringArray[132] = "plus";
        stringArray[133] = "plus";
        stringArray[134] = "plus";
        stringArray[135] = "plus";
        stringArray[136] = "plus";
        stringArray[137] = "info";
        stringArray[138] = "getAt";
        stringArray[139] = "execute";
        stringArray[140] = "plus";
        stringArray[141] = "plus";
        stringArray[142] = "plus";
        stringArray[143] = "plus";
        stringArray[144] = "info";
        stringArray[145] = "execute";
        stringArray[146] = "plus";
        stringArray[147] = "plus";
        stringArray[148] = "plus";
        stringArray[149] = "plus";
        stringArray[150] = "info";
        stringArray[151] = "plus";
        stringArray[152] = "info";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[153];
        Random_Grid.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Random_Grid.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Random_Grid.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

