/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.wps.Receivers;

import geoserver.GeoServer;
import geoserver.catalog.Store;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.sql.Sql;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.geotools.jdbc.JDBCDataStore;
import org.h2gis.functions.spatial.crs.ST_SetSRID;
import org.h2gis.functions.spatial.crs.ST_Transform;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.TableLocation;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Regular_Grid
extends Script {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public Regular_Grid() {
        CallSite[] callSiteArray = Regular_Grid.$getCallSiteArray();
    }

    public Regular_Grid(Binding context) {
        CallSite[] callSiteArray = Regular_Grid.$getCallSiteArray();
        super(context);
    }

    public static void main(String ... args) {
        CallSite[] callSiteArray = Regular_Grid.$getCallSiteArray();
        callSiteArray[0].callStatic(InvokerHelper.class, Regular_Grid.class, (Object)args);
    }

    public Object run() {
        CallSite[] callSiteArray = Regular_Grid.$getCallSiteArray();
        String string = "Regular Grid";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, Regular_Grid.class, (GroovyObject)this, (String)"title");
        Object object = callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call((Object)"&#10145;&#65039; Computes a regular grid of receivers. </br>", (Object)"<hr>"), (Object)"The receivers are spaced at a distance \"delta\" (Offset) in the Cartesian plane in meters. </br> </br>"), (Object)"The grid will be based on:<ul>"), (Object)"<li> the BUILDINGS table extent (option by default)</li>"), (Object)"<li> <b>OR</b> a single Geometry \"fence\" (see \"Extent filter\" parameter).</li></ul></br>"), (Object)"&#x2705; The output table is called <b>RECEIVERS</b> </br></br>"), (Object)"<img src=\"/wps_images/regular_grid_output.png\" alt=\"Regular grid output\" width=\"95%\" align=\"center\">");
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Regular_Grid.class, (GroovyObject)this, (String)"description");
        Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"buildingTableName", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Buildings table name", "title", "Buildings table name", "description", callSiteArray[8].call(callSiteArray[9].call((Object)"Name of the Buildings table. Receivers inside buildings will be removed.</br></br>", (Object)"The table must contain: <ul>"), (Object)"<li><b> THE_GEOM </b> : the 2D geometry of the building (POLYGON or MULTIPOLYGON)</li></ul>"), "min", 0, "max", 1, "type", String.class}), "fence", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Extent geometry", "title", "Extent filter", "description", "Create receivers only in the provided polygon (fence)", "min", 0, "max", 1, "type", Geometry.class}), "fenceTableName", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Table bounding box name", "title", "Table bounding box name", "description", callSiteArray[10].call(callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call((Object)"Using the bounding box of the given table name, define the envelope of the output grid: <ol>", (Object)"<li> Extract the bounding box of the specified table,</li>"), (Object)"<li> then create only receivers on the table bounding box.</li></ol>"), (Object)"The given table must contain: <ul>"), (Object)"<li> <b>THE_GEOM</b> : any geometry type with the appropriate SRID </li></ul>"), "type", String.class}), "sourcesTableName", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Sources table name", "title", "Sources table name", "description", callSiteArray[14].call(callSiteArray[15].call((Object)"Keep only receivers at least at 1 meters of provided sources geometries </br> </br>", (Object)"The given table must contain: <ul>"), (Object)"<li> <b>THE_GEOM</b> : any geometry type. </li></ul>"), "min", 0, "max", 1, "type", String.class}), "delta", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Offset", "title", "Offset", "description", callSiteArray[16].call((Object)"Offset in the Cartesian plane (in meters) </br> </br>", (Object)"&#128736; Default value: <b>10 </b>"), "min", 0, "max", 1, "type", Double.class}), "receiverstablename", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "receiverstablename", "title", "Name of receivers table", "description", callSiteArray[17].call(callSiteArray[18].call((Object)"Name of the output table.</br> </br>", (Object)"Do not write the name of a table that contains a space.</br> </br>"), (Object)"&#128736; Default value: <b>RECEIVERS </b>"), "min", 0, "max", 1, "type", String.class}), "height", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Height", "title", "Height", "description", callSiteArray[19].call((Object)"Height of receivers (in meter) (FLOAT) </br> </br>", (Object)"&#128736; Default value: <b>4</b>"), "min", 0, "max", 1, "type", Double.class}), "outputTriangleTable", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Output triangle table", "title", "Output triangle table", "description", "Output a triangle table in order to be used to generate iso contours with Create_Isosurface", "min", 0, "max", 1, "type", Boolean.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, Regular_Grid.class, (GroovyObject)this, (String)"inputs");
        Map map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", "Result output string", "title", "Result output string", "description", "This type of result does not allow the blocks to be linked together.", "type", String.class})});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map2, Regular_Grid.class, (GroovyObject)this, (String)"outputs");
        return map2;
    }

    public static Connection openGeoserverDataStoreConnection(String dbName) {
        CallSite[] callSiteArray = Regular_Grid.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)dbName, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].call((Object)dbName))) {
            dbName = ShortTypeHandling.castToString((Object)callSiteArray[21].call(callSiteArray[22].call(callSiteArray[23].callGroovyObjectGetProperty(callSiteArray[24].callConstructor(GeoServer.class))), (Object)0));
        }
        Store store = (Store)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].call(callSiteArray[26].callGroovyObjectGetProperty(callSiteArray[27].callConstructor(GeoServer.class)), (Object)dbName), Store.class);
        JDBCDataStore jdbcDataStore = (JDBCDataStore)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].call(callSiteArray[29].call((Object)store), null), JDBCDataStore.class);
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call(callSiteArray[31].call((Object)jdbcDataStore)), Connection.class);
    }

    public Object run(Object input) {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference input;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _run_closure1(Object _outerInstance, Object _thisObject, Reference input) {
                Reference reference;
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.input = reference = input;
            }

            public Object doCall(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"result", callSiteArray[0].callCurrent((GroovyObject)this, (Object)connection, this.input.get())});
            }

            @Generated
            public Object call(Connection connection) {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)connection);
            }

            @Generated
            public Object getInput() {
                CallSite[] callSiteArray = _run_closure1.$getCallSiteArray();
                return this.input.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "exec";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _run_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_run_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _run_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference input2 = new Reference(input);
        CallSite[] callSiteArray = Regular_Grid.$getCallSiteArray();
        String dbName = "h2gisdb";
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return callSiteArray[32].call(callSiteArray[33].callStatic(Regular_Grid.class, (Object)dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
        }
        return callSiteArray[34].call((Object)Regular_Grid.openGeoserverDataStoreConnection(dbName), (Object)new _run_closure1((Object)this, (Object)this, input2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object exec(Object connection, Map input) {
        CallSite[] callSiteArray = Regular_Grid.$getCallSiteArray();
        Sql sql = (Sql)ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].callConstructor(Sql.class, connection), Sql.class);
        Object resultString = null;
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[36].call((Object)input, (Object)"fenceTableName")) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[37].call((Object)input, (Object)"fence"))) {
                throw (Throwable)callSiteArray[38].callConstructor(SQLException.class, (Object)"Fence geometry or fence table name must be provided, could be the buildings table or source table.");
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[39].call((Object)input, (Object)"fenceTableName")) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[40].call((Object)input, (Object)"fence"))) {
            throw (Throwable)callSiteArray[41].callConstructor(SQLException.class, (Object)"Fence geometry or fence table name must be provided, could be the buildings table or source table.");
        }
        Logger logger = (Logger)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].call(LoggerFactory.class, (Object)"org.noise_planet.noisemodelling"), Logger.class);
        callSiteArray[43].call((Object)logger, (Object)"Start : Random grid");
        callSiteArray[44].call((Object)logger, (Object)"inputs {}", (Object)input);
        String receivers_table_name = "RECEIVERS";
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[45].call((Object)input, (Object)"receiverstablename"))) {
            receivers_table_name = ShortTypeHandling.castToString((Object)callSiteArray[46].call((Object)input, (Object)"receiverstablename"));
        }
        receivers_table_name = ShortTypeHandling.castToString((Object)callSiteArray[47].call((Object)receivers_table_name));
        Double delta = (Double)ScriptBytecodeAdapter.castToType((Object)10, Double.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[48].call((Object)input, (Object)"delta"))) {
            delta = (Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[49].call((Object)input, (Object)"delta"), Double.class);
        }
        Double h = (Double)ScriptBytecodeAdapter.castToType((Object)4, Double.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[50].call((Object)input, (Object)"height"))) {
            h = (Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[51].call((Object)input, (Object)"height"), Double.class);
        }
        boolean createTriangles = false;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[52].call((Object)input, (Object)"outputTriangleTable"))) {
            createTriangles = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[53].call(Boolean.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[54].call((Object)input, (Object)"outputTriangleTable"), String.class)), String.class)));
        }
        String sources_table_name = "";
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[55].call((Object)input, (Object)"sourcesTableName"))) {
            sources_table_name = ShortTypeHandling.castToString((Object)callSiteArray[56].call((Object)input, (Object)"sourcesTableName"));
        }
        sources_table_name = ShortTypeHandling.castToString((Object)callSiteArray[57].call((Object)sources_table_name));
        String building_table_name = "";
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].call((Object)input, (Object)"buildingTableName"))) {
            building_table_name = ShortTypeHandling.castToString((Object)callSiteArray[59].call((Object)input, (Object)"buildingTableName"));
        }
        building_table_name = ShortTypeHandling.castToString((Object)callSiteArray[60].call((Object)building_table_name));
        int srid = 0;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[61].call((Object)input, (Object)"fenceTableName"))) {
            srid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[62].call(GeometryTableUtilities.class, connection, callSiteArray[63].call(TableLocation.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[64].call((Object)input, (Object)"fenceTableName"), String.class)), String.class))));
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (srid == 0 && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[65].call((Object)input, (Object)"buildingTableName"))) {
                srid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[66].call(GeometryTableUtilities.class, connection, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[67].call(TableLocation.class, (Object)building_table_name), String.class)), String.class)));
            }
        } else if (srid == 0 && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[68].call((Object)input, (Object)"buildingTableName"))) {
            srid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[69].call(GeometryTableUtilities.class, connection, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[70].call(TableLocation.class, (Object)building_table_name), String.class)), String.class)));
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (srid == 0 && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[71].call((Object)input, (Object)"sourcesTableName"))) {
                srid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[72].call(GeometryTableUtilities.class, connection, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[73].call(TableLocation.class, (Object)sources_table_name), String.class)), String.class)));
            }
        } else if (srid == 0 && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[74].call((Object)input, (Object)"sourcesTableName"))) {
            srid = DefaultTypeTransformation.intUnbox((Object)callSiteArray[75].call(GeometryTableUtilities.class, connection, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[76].call(TableLocation.class, (Object)sources_table_name), String.class)), String.class)));
        }
        Geometry fenceGeom = null;
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[77].call((Object)input, (Object)"fence"))) {
                if (!(srid != 0)) throw (Throwable)callSiteArray[83].callConstructor(Exception.class, (Object)"Unable to find buildings or sources SRID, ignore fence parameters");
                WKTReader wktReader = (WKTReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].callConstructor(WKTReader.class), WKTReader.class);
                Object fence = callSiteArray[79].call((Object)wktReader, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[80].call((Object)input, (Object)"fence"), String.class)), String.class));
                fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].call(ST_Transform.class, connection, callSiteArray[82].call(ST_SetSRID.class, fence, (Object)4326), (Object)srid), Geometry.class);
            } else {
                fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[84].call(GeometryTableUtilities.class, connection, callSiteArray[85].call(TableLocation.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[86].call((Object)input, (Object)"fenceTableName"), String.class)), String.class)), (Object)"THE_GEOM"), Geometry.class);
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[87].call((Object)input, (Object)"fence"))) {
            if (!(srid != 0)) throw (Throwable)callSiteArray[93].callConstructor(Exception.class, (Object)"Unable to find buildings or sources SRID, ignore fence parameters");
            WKTReader wktReader = (WKTReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[88].callConstructor(WKTReader.class), WKTReader.class);
            Object fence = callSiteArray[89].call((Object)wktReader, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[90].call((Object)input, (Object)"fence"), String.class)), String.class));
            fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].call(ST_Transform.class, connection, callSiteArray[92].call(ST_SetSRID.class, fence, (Object)4326), (Object)srid), Geometry.class);
        } else {
            fenceGeom = (Geometry)ScriptBytecodeAdapter.castToType((Object)callSiteArray[94].call(GeometryTableUtilities.class, connection, callSiteArray[95].call(TableLocation.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((String)ScriptBytecodeAdapter.asType((Object)callSiteArray[96].call((Object)input, (Object)"fenceTableName"), String.class)), String.class)), (Object)"THE_GEOM"), Geometry.class);
        }
        callSiteArray[97].call((Object)sql, callSiteArray[98].call(String.class, (Object)"DROP TABLE IF EXISTS %s", (Object)receivers_table_name));
        callSiteArray[99].call((Object)sql, callSiteArray[100].call(callSiteArray[101].call(callSiteArray[102].call(callSiteArray[103].call(callSiteArray[104].call(callSiteArray[105].call(callSiteArray[106].call(callSiteArray[107].call(callSiteArray[108].call(callSiteArray[109].call(callSiteArray[110].call(callSiteArray[111].call((Object)"CREATE TABLE ", (Object)receivers_table_name), (Object)"(THE_GEOM GEOMETRY, ID_COL INTEGER, ID_ROW INTEGER) AS SELECT ST_SETSRID(ST_UPDATEZ(THE_GEOM, "), (Object)h), (Object)"), "), (Object)srid), (Object)") THE_GEOM, ID_COL, ID_ROW FROM ST_MakeGridPoints(ST_GeomFromText('"), (Object)fenceGeom), (Object)"'),"), (Object)delta), (Object)","), (Object)delta), (Object)");"));
        callSiteArray[112].call((Object)sql, callSiteArray[113].call(callSiteArray[114].call((Object)"ALTER TABLE ", (Object)receivers_table_name), (Object)" ADD COLUMN PK SERIAL PRIMARY KEY"));
        callSiteArray[115].call((Object)logger, callSiteArray[116].call((Object)"Create spatial index on ", (Object)receivers_table_name));
        callSiteArray[117].call((Object)sql, callSiteArray[118].call(callSiteArray[119].call((Object)"Create spatial index on ", (Object)receivers_table_name), (Object)"(the_geom);"));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[120].call((Object)input, (Object)"fence"))) {
            callSiteArray[121].call((Object)sql, callSiteArray[122].call(callSiteArray[123].call((Object)"DELETE FROM ", (Object)receivers_table_name), (Object)" WHERE NOT ST_Intersects(THE_GEOM, :geom)"), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"geom", fenceGeom}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[124].call((Object)input, (Object)"buildingTableName"))) {
            callSiteArray[125].call((Object)logger, (Object)"Delete receivers inside buildings");
            callSiteArray[126].call((Object)sql, callSiteArray[127].call(callSiteArray[128].call(callSiteArray[129].call(callSiteArray[130].call((Object)"delete from ", (Object)receivers_table_name), (Object)" g where exists (select 1 from "), (Object)building_table_name), (Object)" b where ST_Z(g.the_geom) < b.HEIGHT and g.the_geom && b.the_geom and ST_INTERSECTS(g.the_geom, b.the_geom) and ST_distance(b.the_geom, g.the_geom) < 1 limit 1);"));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[131].call((Object)input, (Object)"sourcesTableName"))) {
            callSiteArray[132].call((Object)logger, (Object)"Delete receivers near sources");
            callSiteArray[133].call((Object)sql, callSiteArray[134].call(callSiteArray[135].call(callSiteArray[136].call(callSiteArray[137].call((Object)"delete from ", (Object)receivers_table_name), (Object)" g where exists (select 1 from "), (Object)sources_table_name), (Object)" r where st_expand(g.the_geom, 1) && r.the_geom and st_distance(g.the_geom, r.the_geom) < 1 limit 1);"));
        }
        if (!createTriangles) return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"tableNameCreated", callSiteArray[167].call(callSiteArray[168].call((Object)"Process done. Table of receivers ", (Object)receivers_table_name), (Object)" created !")});
        callSiteArray[138].call((Object)sql, (Object)"DROP TABLE IF EXISTS TRIANGLES");
        callSiteArray[139].call((Object)sql, callSiteArray[140].call(callSiteArray[141].call(callSiteArray[142].call((Object)"CREATE TABLE TRIANGLES(pk serial NOT NULL, the_geom geometry(POLYGON Z, ", (Object)srid), (Object)"), PK_1 integer not null,"), (Object)" PK_2 integer not null, PK_3 integer not null, cell_id integer not null, PRIMARY KEY (PK))"));
        callSiteArray[143].call((Object)sql, callSiteArray[144].call(callSiteArray[145].call(callSiteArray[146].call(callSiteArray[147].call(callSiteArray[148].call(callSiteArray[149].call(callSiteArray[150].call(callSiteArray[151].call(callSiteArray[152].call(callSiteArray[153].call(callSiteArray[154].call((Object)"INSERT INTO TRIANGLES(THE_GEOM, PK_1, PK_2, PK_3, CELL_ID) ", (Object)"SELECT ST_ConvexHull(ST_UNION(A.THE_GEOM, ST_UNION(B.THE_GEOM, C.THE_GEOM))) THE_GEOM, "), (Object)"A.PK PK_1, B.PK PK_2, C.PK PK_3, 0"), (Object)"  FROM "), (Object)receivers_table_name), (Object)" A, "), (Object)receivers_table_name), (Object)" B, "), (Object)receivers_table_name), (Object)" C "), (Object)"WHERE A.ID_ROW = B.ID_ROW + 1 AND A.ID_COL  = B.ID_COL AND "), (Object)"A.ID_ROW = C.ID_ROW + 1 AND A.ID_COL = C.ID_COL + 1;"));
        callSiteArray[155].call((Object)sql, callSiteArray[156].call(callSiteArray[157].call(callSiteArray[158].call(callSiteArray[159].call(callSiteArray[160].call(callSiteArray[161].call(callSiteArray[162].call(callSiteArray[163].call(callSiteArray[164].call(callSiteArray[165].call(callSiteArray[166].call((Object)"INSERT INTO TRIANGLES(THE_GEOM, PK_1, PK_2, PK_3, CELL_ID) ", (Object)"SELECT ST_ConvexHull(ST_UNION(A.THE_GEOM, ST_UNION(B.THE_GEOM, C.THE_GEOM))) THE_GEOM, "), (Object)"A.PK PK_1, B.PK PK_2, C.PK PK_3, 0"), (Object)"  FROM "), (Object)receivers_table_name), (Object)" A, "), (Object)receivers_table_name), (Object)" B, "), (Object)receivers_table_name), (Object)" C "), (Object)"WHERE A.ID_ROW = B.ID_ROW + 1 AND A.ID_COL  = B.ID_COL + 1"), (Object)" AND A.ID_ROW = C.ID_ROW AND A.ID_COL = C.ID_COL + 1;"));
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"tableNameCreated", callSiteArray[167].call(callSiteArray[168].call((Object)"Process done. Table of receivers ", (Object)receivers_table_name), (Object)" created !")});
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != Regular_Grid.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "runScript";
        stringArray[1] = "plus";
        stringArray[2] = "plus";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "plus";
        stringArray[12] = "plus";
        stringArray[13] = "plus";
        stringArray[14] = "plus";
        stringArray[15] = "plus";
        stringArray[16] = "plus";
        stringArray[17] = "plus";
        stringArray[18] = "plus";
        stringArray[19] = "plus";
        stringArray[20] = "isEmpty";
        stringArray[21] = "get";
        stringArray[22] = "getStoreNames";
        stringArray[23] = "catalog";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "getStore";
        stringArray[26] = "catalog";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "getDataStore";
        stringArray[29] = "getDataStoreInfo";
        stringArray[30] = "getConnection";
        stringArray[31] = "getDataSource";
        stringArray[32] = "withCloseable";
        stringArray[33] = "openGeoserverDataStoreConnection";
        stringArray[34] = "withCloseable";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "containsKey";
        stringArray[37] = "containsKey";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "containsKey";
        stringArray[40] = "containsKey";
        stringArray[41] = "<$constructor$>";
        stringArray[42] = "getLogger";
        stringArray[43] = "info";
        stringArray[44] = "info";
        stringArray[45] = "getAt";
        stringArray[46] = "getAt";
        stringArray[47] = "toUpperCase";
        stringArray[48] = "getAt";
        stringArray[49] = "getAt";
        stringArray[50] = "getAt";
        stringArray[51] = "getAt";
        stringArray[52] = "getAt";
        stringArray[53] = "parseBoolean";
        stringArray[54] = "getAt";
        stringArray[55] = "getAt";
        stringArray[56] = "getAt";
        stringArray[57] = "toUpperCase";
        stringArray[58] = "getAt";
        stringArray[59] = "getAt";
        stringArray[60] = "toUpperCase";
        stringArray[61] = "getAt";
        stringArray[62] = "getSRID";
        stringArray[63] = "parse";
        stringArray[64] = "getAt";
        stringArray[65] = "getAt";
        stringArray[66] = "getSRID";
        stringArray[67] = "parse";
        stringArray[68] = "getAt";
        stringArray[69] = "getSRID";
        stringArray[70] = "parse";
        stringArray[71] = "getAt";
        stringArray[72] = "getSRID";
        stringArray[73] = "parse";
        stringArray[74] = "getAt";
        stringArray[75] = "getSRID";
        stringArray[76] = "parse";
        stringArray[77] = "getAt";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "read";
        stringArray[80] = "getAt";
        stringArray[81] = "ST_Transform";
        stringArray[82] = "setSRID";
        stringArray[83] = "<$constructor$>";
        stringArray[84] = "getEnvelope";
        stringArray[85] = "parse";
        stringArray[86] = "getAt";
        stringArray[87] = "getAt";
        stringArray[88] = "<$constructor$>";
        stringArray[89] = "read";
        stringArray[90] = "getAt";
        stringArray[91] = "ST_Transform";
        stringArray[92] = "setSRID";
        stringArray[93] = "<$constructor$>";
        stringArray[94] = "getEnvelope";
        stringArray[95] = "parse";
        stringArray[96] = "getAt";
        stringArray[97] = "execute";
        stringArray[98] = "format";
        stringArray[99] = "execute";
        stringArray[100] = "plus";
        stringArray[101] = "plus";
        stringArray[102] = "plus";
        stringArray[103] = "plus";
        stringArray[104] = "plus";
        stringArray[105] = "plus";
        stringArray[106] = "plus";
        stringArray[107] = "plus";
        stringArray[108] = "plus";
        stringArray[109] = "plus";
        stringArray[110] = "plus";
        stringArray[111] = "plus";
        stringArray[112] = "execute";
        stringArray[113] = "plus";
        stringArray[114] = "plus";
        stringArray[115] = "info";
        stringArray[116] = "plus";
        stringArray[117] = "execute";
        stringArray[118] = "plus";
        stringArray[119] = "plus";
        stringArray[120] = "getAt";
        stringArray[121] = "execute";
        stringArray[122] = "plus";
        stringArray[123] = "plus";
        stringArray[124] = "getAt";
        stringArray[125] = "info";
        stringArray[126] = "execute";
        stringArray[127] = "plus";
        stringArray[128] = "plus";
        stringArray[129] = "plus";
        stringArray[130] = "plus";
        stringArray[131] = "getAt";
        stringArray[132] = "info";
        stringArray[133] = "execute";
        stringArray[134] = "plus";
        stringArray[135] = "plus";
        stringArray[136] = "plus";
        stringArray[137] = "plus";
        stringArray[138] = "execute";
        stringArray[139] = "execute";
        stringArray[140] = "plus";
        stringArray[141] = "plus";
        stringArray[142] = "plus";
        stringArray[143] = "execute";
        stringArray[144] = "plus";
        stringArray[145] = "plus";
        stringArray[146] = "plus";
        stringArray[147] = "plus";
        stringArray[148] = "plus";
        stringArray[149] = "plus";
        stringArray[150] = "plus";
        stringArray[151] = "plus";
        stringArray[152] = "plus";
        stringArray[153] = "plus";
        stringArray[154] = "plus";
        stringArray[155] = "execute";
        stringArray[156] = "plus";
        stringArray[157] = "plus";
        stringArray[158] = "plus";
        stringArray[159] = "plus";
        stringArray[160] = "plus";
        stringArray[161] = "plus";
        stringArray[162] = "plus";
        stringArray[163] = "plus";
        stringArray[164] = "plus";
        stringArray[165] = "plus";
        stringArray[166] = "plus";
        stringArray[167] = "plus";
        stringArray[168] = "plus";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[169];
        Regular_Grid.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(Regular_Grid.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Regular_Grid.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

