/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.omanager.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ActionBundle
extends AbstractAction {
    private static final I18n I18N = I18nFactory.getI18n(ActionBundle.class);
    protected static Logger LOGGER = Logger.getLogger(ActionBundle.class);
    private ActionListener action;
    private final boolean isPlugin;
    private final Component frame;

    public ActionBundle(String label, String toolTipText, Icon icon, Component frame, boolean warnUser) {
        super(label);
        this.putValue("ShortDescription", toolTipText);
        this.putValue("SmallIcon", icon);
        this.isPlugin = warnUser;
        this.frame = frame;
    }

    public ActionBundle setActionListener(ActionListener action) {
        this.action = action;
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isPlugin) {
            this.doAction(actionEvent);
        } else {
            int result = JOptionPane.showConfirmDialog(this.frame, I18N.tr("You will do an action on a plugin used by the system.\nAfter that, OrbisGIS could be unstable.\nDo you confirm ?"), I18N.tr("Security message"), 0, 2);
            if (result == 0) {
                this.doAction(actionEvent);
            }
        }
    }

    private void doAction(ActionEvent actionEvent) {
        try {
            this.action.actionPerformed(actionEvent);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
        }
    }
}

