/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.omanager.ui;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.orbisgis.omanager.ui.ActionBundle;
import org.orbisgis.omanager.ui.ActionDeploy;
import org.orbisgis.omanager.ui.BundleItem;
import org.orbisgis.omanager.ui.MainPanel;
import org.osgi.framework.BundleContext;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ActionBundleFactory {
    private static final I18n I18N = I18nFactory.getI18n(ActionBundleFactory.class);
    private static final Logger LOGGER = Logger.getLogger((String)("gui." + ActionBundleFactory.class));
    private Map<String, ImageIcon> buttonIcons = new HashMap<String, ImageIcon>();
    private final boolean warnUser;
    private Component frame;
    private BundleContext bundleContext;

    private ImageIcon getIcon(String iconName) {
        ImageIcon icon = this.buttonIcons.get(iconName);
        if (icon == null) {
            try {
                icon = new ImageIcon(MainPanel.class.getResource(iconName + ".png"));
                this.buttonIcons.put(iconName, icon);
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Cannot retrieve icon " + iconName), (Throwable)ex);
                return new ImageIcon();
            }
        }
        return icon;
    }

    public ActionBundleFactory(BundleContext bundleContext, Component frame, boolean warnUser) {
        this.bundleContext = bundleContext;
        this.frame = frame;
        this.warnUser = warnUser;
    }

    public List<Action> create(BundleItem bundleItem) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (!bundleItem.isFragment()) {
            if (bundleItem.isStartReady()) {
                actions.add(new ActionBundle(I18N.tr("Start"), I18N.tr("Activate the selected plugin"), this.getIcon("execute"), this.frame, this.warnUser).setActionListener(EventHandler.create(ActionListener.class, bundleItem.getBundle(), "start")));
            }
            if (bundleItem.isStopReady()) {
                actions.add(new ActionBundle(I18N.tr("Stop"), I18N.tr("Deactivate the selected plugin"), this.getIcon("stop"), this.frame, this.warnUser).setActionListener(EventHandler.create(ActionListener.class, bundleItem.getBundle(), "stop")));
            }
            if (bundleItem.isUpdateReady()) {
                actions.add(new ActionBundle(I18N.tr("Update"), I18N.tr("Update the selected plugin"), this.getIcon("refresh"), this.frame, this.warnUser).setActionListener(EventHandler.create(ActionListener.class, bundleItem.getBundle(), "update")));
            }
        }
        if (bundleItem.isUninstallReady()) {
            actions.add(new ActionBundle(I18N.tr("Uninstall"), I18N.tr("Remove the selected plugin"), this.getIcon("uninstall"), this.frame, this.warnUser).setActionListener(EventHandler.create(ActionListener.class, bundleItem.getBundle(), "uninstall")));
        }
        if (bundleItem.isDeployReady()) {
            actions.add(new ActionDeploy(I18N.tr("Download"), I18N.tr("Download the selected plugin"), false, bundleItem.getObrResource(), this.bundleContext, this.frame, this.getIcon("download"), this.warnUser));
        }
        if (!bundleItem.isFragment() && bundleItem.isDeployAndStartReady()) {
            actions.add(new ActionDeploy(I18N.tr("Download & Start"), I18N.tr("Download the selected plugin and start it"), true, bundleItem.getObrResource(), this.bundleContext, this.frame, this.getIcon("download_and_start"), this.warnUser));
        }
        return actions;
    }
}

