/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.omanager.ui;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.orbisgis.omanager.ui.ActionBundle;
import org.orbisgis.omanager.ui.BundleItem;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Requirement;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ActionDeploy
extends ActionBundle {
    private static final I18n I18N = I18nFactory.getI18n(ActionDeploy.class);
    private boolean start;
    private Resource resource;
    private BundleContext bundleContext;
    private Component frame;

    public ActionDeploy(String label, String toolTipText, boolean start, Resource resource, BundleContext bundleContext, Component frame, Icon icon, boolean warnUser) {
        super(label, toolTipText, icon, frame, warnUser);
        this.start = start;
        this.resource = resource;
        this.bundleContext = bundleContext;
        this.frame = frame;
        this.setActionListener(EventHandler.create(ActionListener.class, this, "doWork"));
    }

    private void deployBundle(Resolver resolver) {
        long bytes = this.getSize(this.resource);
        StringBuilder resourcesNames = new StringBuilder();
        Resource[] resources = resolver.getRequiredResources();
        if (resources != null && resources.length > 0) {
            for (Resource dependency : resources) {
                resourcesNames.append(dependency.getPresentationName());
                resourcesNames.append(" (");
                resourcesNames.append(dependency.getVersion());
                resourcesNames.append(")\n");
                bytes += this.getSize(dependency);
            }
        }
        if ((resources = resolver.getOptionalResources()) != null && resources.length > 0) {
            for (Resource dependency : resources) {
                bytes += this.getSize(dependency);
                resourcesNames.append("Optional, ");
                resourcesNames.append(dependency.getPresentationName());
                resourcesNames.append(" (");
                resourcesNames.append(dependency.getVersion());
                resourcesNames.append(")\n");
            }
        }
        boolean deploy = true;
        if (resourcesNames.length() > 0) {
            resourcesNames.insert(0, ") ?\n");
            resourcesNames.insert(0, BundleItem.getHumanReadableBytes(bytes));
            resourcesNames.insert(0, "Do you want to download the following dependencies (Size : ");
            Object[] options = new String[]{I18N.tr("Yes"), I18N.tr("Cancel")};
            int n = JOptionPane.showOptionDialog(this.frame, resourcesNames.toString(), I18N.tr("Dependencies downloading"), 0, 3, null, options, options[1]);
            boolean bl = deploy = n == 0;
        }
        if (deploy) {
            try {
                resolver.deploy(this.start);
            }
            catch (IllegalStateException ex) {
                LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() {
        ServiceReference repositoryAdminServiceReference = this.bundleContext.getServiceReference(RepositoryAdmin.class);
        if (repositoryAdminServiceReference == null) {
            LOGGER.error((Object)I18N.tr("OSGi repository service is not available"));
            return;
        }
        RepositoryAdmin repositoryAdmin = (RepositoryAdmin)this.bundleContext.getService(repositoryAdminServiceReference);
        if (repositoryAdmin == null) {
            LOGGER.error((Object)I18N.tr("OSGi repository service is not available"));
            return;
        }
        try {
            Resolver resolver = repositoryAdmin.resolver();
            resolver.add(this.resource);
            if (resolver.getAddedResources() != null && resolver.getAddedResources().length > 0) {
                if (resolver.resolve()) {
                    this.deployBundle(resolver);
                } else {
                    Requirement[] requirements = resolver.getUnsatisfiedRequirements();
                    if (requirements != null && requirements.length > 0) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(I18N.trn("Unsatisfied requirement :\n", "Unsatisfied requirements :\n", (long)(requirements.length + 1)));
                        for (Requirement requirement : requirements) {
                            sb.append("\t");
                            sb.append(requirement.getFilter());
                            sb.append("\n");
                            for (Resource resource : resolver.getResources(requirement)) {
                                sb.append("\t");
                                sb.append(resource.getPresentationName());
                                sb.append(" (");
                                sb.append(resource.getVersion());
                                sb.append(")\n");
                            }
                        }
                        LOGGER.error((Object)sb.toString());
                    } else {
                        LOGGER.error((Object)I18N.tr("Could not resolve plugin dependencies for an unknown reason"));
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
        }
        finally {
            this.bundleContext.ungetService(repositoryAdminServiceReference);
        }
    }

    private long getSize(Resource resource) {
        Object depSize = resource.getProperties().get("size");
        if (depSize instanceof Long) {
            return (Long)depSize;
        }
        return 0L;
    }
}

