/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.omanager.ui;

import java.util.HashSet;
import java.util.Set;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class BundleDetailsTransformer {
    private static final I18n I18N = I18nFactory.getI18n(BundleDetailsTransformer.class);
    private static final String BUNDLE_KEYWORD = "Bundle-";
    private Set<String> excludeKeys = new HashSet<String>();

    public BundleDetailsTransformer() {
        this.excludeKeys.add("Bundle-ActivationPolicy");
        this.excludeKeys.add("Bundle-Activator");
        this.excludeKeys.add("Bundle-Category");
        this.excludeKeys.add("Bundle-ClassPath");
        I18n.marktr((String)"Bundle-ContactAddress");
        I18n.marktr((String)"Bundle-Copyright");
        this.excludeKeys.add(I18n.marktr((String)"Bundle-Description"));
        I18n.marktr((String)"Bundle-DocURL");
        this.excludeKeys.add("DynamicImport-Package");
        this.excludeKeys.add("Export-Package");
        this.excludeKeys.add("Export-Service");
        this.excludeKeys.add("Fragment-Host");
        this.excludeKeys.add("Bundle-Icon");
        this.excludeKeys.add("Import-Package");
        this.excludeKeys.add("Import-Service");
        I18n.marktr((String)"Bundle-License");
        I18n.marktr((String)"Bundle-Localization");
        this.excludeKeys.add("Main-Class");
        I18n.marktr((String)"Bundle-ManifestVersion");
        this.excludeKeys.add("Bundle-Name");
        I18n.marktr((String)"Bundle-NativeCode");
        this.excludeKeys.add("Provide-Capability");
        this.excludeKeys.add("Require-Bundle");
        this.excludeKeys.add("Require-Capability");
        I18n.marktr((String)"Bundle-RequiredExecutionEnvironment");
        I18n.marktr((String)"Service-Component");
        I18n.marktr((String)"Bundle-SymbolicName");
        I18n.marktr((String)"Bundle-UpdateLocation");
        I18n.marktr((String)"Bundle-Vendor");
        this.excludeKeys.add(I18n.marktr((String)"Bundle-Version"));
        I18n.marktr((String)"gui");
    }

    public String convert(String key) {
        if (!this.excludeKeys.contains(key)) {
            String convert = I18N.tr(key);
            if (convert.startsWith(BUNDLE_KEYWORD)) {
                return convert.substring(BUNDLE_KEYWORD.length());
            }
            return convert;
        }
        return "";
    }
}

